/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMAttr.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMAttrPrivate.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMAttr* kit(WebCore::Attr* obj)
{
    return WEBKIT_DOM_ATTR(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::Attr* core(WebKitDOMAttr* request)
{
    return request ? static_cast<WebCore::Attr*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMAttr* wrapAttr(WebCore::Attr* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_ATTR(g_object_new(WEBKIT_TYPE_DOM_ATTR, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMAttr, webkit_dom_attr, WEBKIT_TYPE_DOM_NODE)

enum {
    PROP_0,
    PROP_NAME,
    PROP_SPECIFIED,
    PROP_VALUE,
    PROP_OWNER_ELEMENT,
    PROP_IS_ID,
};

static void webkit_dom_attr_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMAttr* self = WEBKIT_DOM_ATTR(object);
    WebCore::Attr* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_VALUE: {
        WebCore::ExceptionCode ec = 0;
        coreSelf->setValue(WTF::String::fromUTF8(g_value_get_string(value)), ec);
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_attr_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMAttr* self = WEBKIT_DOM_ATTR(object);
    WebCore::Attr* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->name()));
        break;
    }
    case PROP_SPECIFIED: {
        g_value_set_boolean(value, coreSelf->specified());
        break;
    }
    case PROP_VALUE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->value()));
        break;
    }
    case PROP_OWNER_ELEMENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->ownerElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_IS_ID: {
        g_value_set_boolean(value, coreSelf->isId());
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_attr_class_init(WebKitDOMAttrClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_attr_set_property;
    gobjectClass->get_property = webkit_dom_attr_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "attr_name", /* short description */
                                                           "read-only  gchar* Attr.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SPECIFIED,
                                    g_param_spec_boolean("specified", /* name */
                                                           "attr_specified", /* short description */
                                                           "read-only  gboolean Attr.specified", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VALUE,
                                    g_param_spec_string("value", /* name */
                                                           "attr_value", /* short description */
                                                           "read-write  gchar* Attr.value", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_OWNER_ELEMENT,
                                    g_param_spec_object("owner-element", /* name */
                                                           "attr_owner-element", /* short description */
                                                           "read-only  WebKitDOMElement* Attr.owner-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_IS_ID,
                                    g_param_spec_boolean("is-id", /* name */
                                                           "attr_is-id", /* short description */
                                                           "read-only  gboolean Attr.is-id", /* longer - could do with some extra doc stuff here */
                                                           FALSE, /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_attr_init(WebKitDOMAttr* request)
{
}

gchar*
webkit_dom_attr_get_name(WebKitDOMAttr* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(self), 0);
    WebCore::Attr* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->name());
    return result;
}

gboolean
webkit_dom_attr_get_specified(WebKitDOMAttr* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(self), FALSE);
    WebCore::Attr* item = WebKit::core(self);
    gboolean result = item->specified();
    return result;
}

gchar*
webkit_dom_attr_get_value(WebKitDOMAttr* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(self), 0);
    WebCore::Attr* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->value());
    return result;
}

void
webkit_dom_attr_set_value(WebKitDOMAttr* self, const gchar* value, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_ATTR(self));
    g_return_if_fail(value);
    g_return_if_fail(!error || !*error);
    WebCore::Attr* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    WebCore::ExceptionCode ec = 0;
    item->setValue(convertedValue, ec);
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
}

WebKitDOMElement*
webkit_dom_attr_get_owner_element(WebKitDOMAttr* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(self), 0);
    WebCore::Attr* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->ownerElement());
    return WebKit::kit(gobjectResult.get());
}

gboolean
webkit_dom_attr_get_is_id(WebKitDOMAttr* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_ATTR(self), FALSE);
    WebCore::Attr* item = WebKit::core(self);
    gboolean result = item->isId();
    return result;
}

