/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLContextEvent.h"

#include "JSDictionary.h"
#include "KURL.h"
#include "WebGLContextEvent.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSWebGLContextEventTableValues[] =
{
    { "statusMessage", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextEventStatusMessage), (intptr_t)0, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsWebGLContextEventConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLContextEventTable = { 4, 3, JSWebGLContextEventTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSWebGLContextEventConstructorTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLContextEventConstructorTable = { 1, 0, JSWebGLContextEventConstructorTableValues, 0 };
EncodedJSValue JSC_HOST_CALL JSWebGLContextEventConstructor::constructJSWebGLContextEvent(ExecState* exec)
{
    JSWebGLContextEventConstructor* jsConstructor = jsCast<JSWebGLContextEventConstructor*>(exec->callee());

    ScriptExecutionContext* executionContext = jsConstructor->scriptExecutionContext();
    if (!executionContext)
        return throwVMError(exec, createReferenceError(exec, "Constructor associated execution context is unavailable"));

    AtomicString eventType = exec->argument(0).toString(exec)->value(exec);
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    WebGLContextEventInit eventInit;

    JSValue initializerValue = exec->argument(1);
    if (!initializerValue.isUndefinedOrNull()) {
        // Given the above test, this will always yield an object.
        JSObject* initializerObject = initializerValue.toObject(exec);

        // Create the dictionary wrapper from the initializer object.
        JSDictionary dictionary(exec, initializerObject);

        // Attempt to fill in the EventInit.
        if (!fillWebGLContextEventInit(eventInit, dictionary))
            return JSValue::encode(jsUndefined());
    }

    RefPtr<WebGLContextEvent> event = WebGLContextEvent::create(eventType, eventInit);
    return JSValue::encode(toJS(exec, jsConstructor->globalObject(), event.get()));
}

bool fillWebGLContextEventInit(WebGLContextEventInit& eventInit, JSDictionary& dictionary)
{
    if (!fillEventInit(eventInit, dictionary))
        return false;

    if (!dictionary.tryGetProperty("statusMessage", eventInit.statusMessage))
        return false;
    return true;
}

const ClassInfo JSWebGLContextEventConstructor::s_info = { "WebGLContextEventConstructor", &Base::s_info, &JSWebGLContextEventConstructorTable, 0, CREATE_METHOD_TABLE(JSWebGLContextEventConstructor) };

JSWebGLContextEventConstructor::JSWebGLContextEventConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSWebGLContextEventConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSWebGLContextEventPrototype::self(exec, globalObject), DontDelete | ReadOnly);
    putDirect(exec->globalData(), exec->propertyNames().length, jsNumber(2), ReadOnly | DontDelete | DontEnum);
}

bool JSWebGLContextEventConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSWebGLContextEventConstructor, JSDOMWrapper>(exec, &JSWebGLContextEventConstructorTable, jsCast<JSWebGLContextEventConstructor*>(cell), propertyName, slot);
}

bool JSWebGLContextEventConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSWebGLContextEventConstructor, JSDOMWrapper>(exec, &JSWebGLContextEventConstructorTable, jsCast<JSWebGLContextEventConstructor*>(object), propertyName, descriptor);
}

ConstructType JSWebGLContextEventConstructor::getConstructData(JSCell*, ConstructData& constructData)
{
    constructData.native.function = constructJSWebGLContextEvent;
    return ConstructTypeHost;
}

/* Hash table for prototype */

static const HashTableValue JSWebGLContextEventPrototypeTableValues[] =
{
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSWebGLContextEventPrototypeTable = { 1, 0, JSWebGLContextEventPrototypeTableValues, 0 };
const ClassInfo JSWebGLContextEventPrototype::s_info = { "WebGLContextEventPrototype", &Base::s_info, &JSWebGLContextEventPrototypeTable, 0, CREATE_METHOD_TABLE(JSWebGLContextEventPrototype) };

JSObject* JSWebGLContextEventPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSWebGLContextEvent>(exec, globalObject);
}

const ClassInfo JSWebGLContextEvent::s_info = { "WebGLContextEvent", &Base::s_info, &JSWebGLContextEventTable, 0 , CREATE_METHOD_TABLE(JSWebGLContextEvent) };

JSWebGLContextEvent::JSWebGLContextEvent(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<WebGLContextEvent> impl)
    : JSEvent(structure, globalObject, impl)
{
}

void JSWebGLContextEvent::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSWebGLContextEvent::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSWebGLContextEventPrototype::create(exec->globalData(), globalObject, JSWebGLContextEventPrototype::createStructure(exec->globalData(), globalObject, JSEventPrototype::self(exec, globalObject)));
}

bool JSWebGLContextEvent::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSWebGLContextEvent* thisObject = jsCast<JSWebGLContextEvent*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSWebGLContextEvent, Base>(exec, &JSWebGLContextEventTable, thisObject, propertyName, slot);
}

bool JSWebGLContextEvent::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSWebGLContextEvent* thisObject = jsCast<JSWebGLContextEvent*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSWebGLContextEvent, Base>(exec, &JSWebGLContextEventTable, thisObject, propertyName, descriptor);
}

JSValue jsWebGLContextEventStatusMessage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextEvent* castedThis = jsCast<JSWebGLContextEvent*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    WebGLContextEvent* impl = static_cast<WebGLContextEvent*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->statusMessage());
    return result;
}


JSValue jsWebGLContextEventConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSWebGLContextEvent* domObject = jsCast<JSWebGLContextEvent*>(asObject(slotBase));
    return JSWebGLContextEvent::getConstructor(exec, domObject->globalObject());
}

JSValue JSWebGLContextEvent::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSWebGLContextEventConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}


}

#endif // ENABLE(WEBGL)
