/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSNavigator.h"

#include "DOMMimeTypeArray.h"
#include "DOMPluginArray.h"
#include "Dictionary.h"
#include "ExceptionCode.h"
#include "GamepadList.h"
#include "JSDOMBinding.h"
#include "JSDOMMimeTypeArray.h"
#include "JSDOMPluginArray.h"
#include "JSNavigatorUserMediaErrorCallback.h"
#include "JSNavigatorUserMediaSuccessCallback.h"
#include "KURL.h"
#include "Navigator.h"
#include "NavigatorContentUtils.h"
#include "NavigatorGamepad.h"
#include "NavigatorGeolocation.h"
#include "NavigatorMediaStream.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

#if ENABLE(GAMEPAD)
#include "JSGamepadList.h"
#endif

#if ENABLE(GEOLOCATION)
#include "Geolocation.h"
#include "JSGeolocation.h"
#endif

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSNavigatorTableValues[] =
{
    { "appCodeName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorAppCodeName), (intptr_t)0, NoIntrinsic },
    { "appName", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorAppName), (intptr_t)0, NoIntrinsic },
    { "appVersion", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorAppVersion), (intptr_t)0, NoIntrinsic },
    { "language", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorLanguage), (intptr_t)0, NoIntrinsic },
    { "userAgent", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorUserAgent), (intptr_t)0, NoIntrinsic },
    { "platform", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorPlatform), (intptr_t)0, NoIntrinsic },
    { "plugins", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorPlugins), (intptr_t)0, NoIntrinsic },
    { "mimeTypes", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorMimeTypes), (intptr_t)0, NoIntrinsic },
    { "product", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorProduct), (intptr_t)0, NoIntrinsic },
    { "productSub", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorProductSub), (intptr_t)0, NoIntrinsic },
    { "vendor", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorVendor), (intptr_t)0, NoIntrinsic },
    { "vendorSub", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorVendorSub), (intptr_t)0, NoIntrinsic },
    { "cookieEnabled", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorCookieEnabled), (intptr_t)0, NoIntrinsic },
    { "onLine", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorOnLine), (intptr_t)0, NoIntrinsic },
#if ENABLE(GEOLOCATION)
    { "geolocation", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsNavigatorGeolocation), (intptr_t)0, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNavigatorTable = { 36, 31, JSNavigatorTableValues, 0 };
/* Hash table for prototype */

static const HashTableValue JSNavigatorPrototypeTableValues[] =
{
    { "javaEnabled", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionJavaEnabled), (intptr_t)0, NoIntrinsic },
    { "getStorageUpdates", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionGetStorageUpdates), (intptr_t)0, NoIntrinsic },
#if ENABLE(GAMEPAD)
    { "webkitGetGamepads", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionWebkitGetGamepads), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(NAVIGATOR_CONTENT_UTILS)
    { "registerProtocolHandler", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionRegisterProtocolHandler), (intptr_t)3, NoIntrinsic },
#endif
#if ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS)
    { "isProtocolHandlerRegistered", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionIsProtocolHandlerRegistered), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS)
    { "unregisterProtocolHandler", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionUnregisterProtocolHandler), (intptr_t)2, NoIntrinsic },
#endif
#if ENABLE(MEDIA_STREAM)
    { "webkitGetUserMedia", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsNavigatorPrototypeFunctionWebkitGetUserMedia), (intptr_t)3, NoIntrinsic },
#endif
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSNavigatorPrototypeTable = { 17, 15, JSNavigatorPrototypeTableValues, 0 };
const ClassInfo JSNavigatorPrototype::s_info = { "NavigatorPrototype", &Base::s_info, &JSNavigatorPrototypeTable, 0, CREATE_METHOD_TABLE(JSNavigatorPrototype) };

JSObject* JSNavigatorPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSNavigator>(exec, globalObject);
}

bool JSNavigatorPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNavigatorPrototype* thisObject = jsCast<JSNavigatorPrototype*>(cell);
    return getStaticFunctionSlot<JSObject>(exec, &JSNavigatorPrototypeTable, thisObject, propertyName, slot);
}

bool JSNavigatorPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNavigatorPrototype* thisObject = jsCast<JSNavigatorPrototype*>(object);
    return getStaticFunctionDescriptor<JSObject>(exec, &JSNavigatorPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSNavigator::s_info = { "Navigator", &Base::s_info, &JSNavigatorTable, 0 , CREATE_METHOD_TABLE(JSNavigator) };

JSNavigator::JSNavigator(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<Navigator> impl)
    : JSDOMWrapper(structure, globalObject)
    , m_impl(impl.leakRef())
{
}

void JSNavigator::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSNavigator::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSNavigatorPrototype::create(exec->globalData(), globalObject, JSNavigatorPrototype::createStructure(globalObject->globalData(), globalObject, globalObject->objectPrototype()));
}

void JSNavigator::destroy(JSC::JSCell* cell)
{
    JSNavigator* thisObject = static_cast<JSNavigator*>(cell);
    thisObject->JSNavigator::~JSNavigator();
}

JSNavigator::~JSNavigator()
{
    releaseImplIfNotNull();
}

bool JSNavigator::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSNavigator* thisObject = jsCast<JSNavigator*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSNavigator, Base>(exec, &JSNavigatorTable, thisObject, propertyName, slot);
}

bool JSNavigator::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSNavigator* thisObject = jsCast<JSNavigator*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSNavigator, Base>(exec, &JSNavigatorTable, thisObject, propertyName, descriptor);
}

JSValue jsNavigatorAppCodeName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appCodeName());
    return result;
}


JSValue jsNavigatorAppName(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appName());
    return result;
}


JSValue jsNavigatorAppVersion(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->appVersion());
    return result;
}


JSValue jsNavigatorLanguage(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->language());
    return result;
}


JSValue jsNavigatorUserAgent(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->userAgent());
    return result;
}


JSValue jsNavigatorPlatform(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->platform());
    return result;
}


JSValue jsNavigatorPlugins(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->plugins()));
    return result;
}


JSValue jsNavigatorMimeTypes(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->mimeTypes()));
    return result;
}


JSValue jsNavigatorProduct(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->product());
    return result;
}


JSValue jsNavigatorProductSub(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->productSub());
    return result;
}


JSValue jsNavigatorVendor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->vendor());
    return result;
}


JSValue jsNavigatorVendorSub(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->vendorSub());
    return result;
}


JSValue jsNavigatorCookieEnabled(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsBoolean(impl->cookieEnabled());
    return result;
}


JSValue jsNavigatorOnLine(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = jsBoolean(impl->onLine());
    return result;
}


#if ENABLE(GEOLOCATION)
JSValue jsNavigatorGeolocation(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(NavigatorGeolocation::geolocation(impl)));
    return result;
}

#endif

EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionJavaEnabled(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());

    JSC::JSValue result = jsBoolean(impl->javaEnabled());
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionGetStorageUpdates(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    impl->getStorageUpdates();
    return JSValue::encode(jsUndefined());
}

#if ENABLE(GAMEPAD)
EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionWebkitGetGamepads(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());

    JSC::JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(NavigatorGamepad::webkitGetGamepads(impl)));
    return JSValue::encode(result);
}

#endif

#if ENABLE(NAVIGATOR_CONTENT_UTILS)
EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionRegisterProtocolHandler(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    if (exec->argumentCount() < 3)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& scheme(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& url(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& title(exec->argument(2).isEmpty() ? String() : exec->argument(2).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    NavigatorContentUtils::registerProtocolHandler(impl, scheme, url, title, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS)
EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionIsProtocolHandlerRegistered(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& scheme(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& url(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, NavigatorContentUtils::isProtocolHandlerRegistered(impl, scheme, url, ec));
    setDOMException(exec, ec);
    return JSValue::encode(result);
}

#endif

#if ENABLE(CUSTOM_SCHEME_HANDLER) && ENABLE(NAVIGATOR_CONTENT_UTILS)
EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionUnregisterProtocolHandler(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    const String& scheme(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    const String& url(exec->argument(1).isEmpty() ? String() : exec->argument(1).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    NavigatorContentUtils::unregisterProtocolHandler(impl, scheme, url, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

#if ENABLE(MEDIA_STREAM)
EncodedJSValue JSC_HOST_CALL jsNavigatorPrototypeFunctionWebkitGetUserMedia(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSNavigator::s_info))
        return throwVMTypeError(exec);
    JSNavigator* castedThis = jsCast<JSNavigator*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSNavigator::s_info);
    Navigator* impl = static_cast<Navigator*>(castedThis->impl());
    if (exec->argumentCount() < 2)
        return throwVMError(exec, createNotEnoughArgumentsError(exec));
    ExceptionCode ec = 0;
    Dictionary options(exec, exec->argument(0));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());
    if (exec->argumentCount() <= 1 || !exec->argument(1).isFunction())
        return throwVMTypeError(exec);
    RefPtr<NavigatorUserMediaSuccessCallback> successCallback = JSNavigatorUserMediaSuccessCallback::create(asObject(exec->argument(1)), castedThis->globalObject());
    RefPtr<NavigatorUserMediaErrorCallback> errorCallback;
    if (exec->argumentCount() > 2 && !exec->argument(2).isUndefinedOrNull()) {
        if (!exec->argument(2).isFunction())
            return throwVMTypeError(exec);
        errorCallback = JSNavigatorUserMediaErrorCallback::create(asObject(exec->argument(2)), castedThis->globalObject());
    }
    NavigatorMediaStream::webkitGetUserMedia(impl, options, successCallback, errorCallback, ec);
    setDOMException(exec, ec);
    return JSValue::encode(jsUndefined());
}

#endif

static inline bool isObservable(JSNavigator* jsNavigator)
{
    if (jsNavigator->hasCustomProperties())
        return true;
    return false;
}

bool JSNavigatorOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, SlotVisitor& visitor)
{
    JSNavigator* jsNavigator = jsCast<JSNavigator*>(handle.get().asCell());
    if (!isObservable(jsNavigator))
        return false;
    Frame* root = jsNavigator->impl()->frame();
    if (!root)
        return false;
    return visitor.containsOpaqueRoot(root);
}

void JSNavigatorOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    JSNavigator* jsNavigator = jsCast<JSNavigator*>(handle.get().asCell());
    DOMWrapperWorld* world = static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsNavigator->impl(), jsNavigator);
    jsNavigator->releaseImpl();
}

JSC::JSValue toJS(JSC::ExecState* exec, JSDOMGlobalObject* globalObject, Navigator* impl)
{
    return wrap<JSNavigator>(exec, globalObject, impl);
}

Navigator* toNavigator(JSC::JSValue value)
{
    return value.inherits(&JSNavigator::s_info) ? jsCast<JSNavigator*>(asObject(value))->impl() : 0;
}

}
