/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(VIDEO)

#include "JSHTMLMediaElement.h"

#include "EventListener.h"
#include "ExceptionCode.h"
#include "HTMLMediaElement.h"
#include "HTMLNames.h"
#include "JSDOMBinding.h"
#include "JSEventListener.h"
#include "JSMediaController.h"
#include "JSMediaError.h"
#include "JSTimeRanges.h"
#include "KURL.h"
#include "MediaController.h"
#include "MediaError.h"
#include "TimeRanges.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

/* Hash table */

static const HashTableValue JSHTMLMediaElementTableValues[] =
{
    { "error", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementError), (intptr_t)0, NoIntrinsic },
    { "src", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSrc), (intptr_t)setJSHTMLMediaElementSrc, NoIntrinsic },
    { "currentSrc", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementCurrentSrc), (intptr_t)0, NoIntrinsic },
    { "networkState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNetworkState), (intptr_t)0, NoIntrinsic },
    { "preload", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPreload), (intptr_t)setJSHTMLMediaElementPreload, NoIntrinsic },
    { "buffered", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementBuffered), (intptr_t)0, NoIntrinsic },
    { "readyState", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementReadyState), (intptr_t)0, NoIntrinsic },
    { "seeking", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSeeking), (intptr_t)0, NoIntrinsic },
    { "currentTime", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementCurrentTime), (intptr_t)setJSHTMLMediaElementCurrentTime, NoIntrinsic },
    { "initialTime", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementInitialTime), (intptr_t)0, NoIntrinsic },
    { "startTime", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementStartTime), (intptr_t)0, NoIntrinsic },
    { "duration", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDuration), (intptr_t)0, NoIntrinsic },
    { "paused", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPaused), (intptr_t)0, NoIntrinsic },
    { "defaultPlaybackRate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDefaultPlaybackRate), (intptr_t)setJSHTMLMediaElementDefaultPlaybackRate, NoIntrinsic },
    { "playbackRate", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPlaybackRate), (intptr_t)setJSHTMLMediaElementPlaybackRate, NoIntrinsic },
    { "played", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementPlayed), (intptr_t)0, NoIntrinsic },
    { "seekable", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementSeekable), (intptr_t)0, NoIntrinsic },
    { "ended", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementEnded), (intptr_t)0, NoIntrinsic },
    { "autoplay", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementAutoplay), (intptr_t)setJSHTMLMediaElementAutoplay, NoIntrinsic },
    { "loop", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementLoop), (intptr_t)setJSHTMLMediaElementLoop, NoIntrinsic },
    { "controls", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementControls), (intptr_t)setJSHTMLMediaElementControls, NoIntrinsic },
    { "volume", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementVolume), (intptr_t)setJSHTMLMediaElementVolume, NoIntrinsic },
    { "muted", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementMuted), (intptr_t)setJSHTMLMediaElementMuted, NoIntrinsic },
    { "defaultMuted", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementDefaultMuted), (intptr_t)setJSHTMLMediaElementDefaultMuted, NoIntrinsic },
    { "webkitPreservesPitch", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitPreservesPitch), (intptr_t)setJSHTMLMediaElementWebkitPreservesPitch, NoIntrinsic },
    { "webkitHasClosedCaptions", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitHasClosedCaptions), (intptr_t)0, NoIntrinsic },
    { "webkitClosedCaptionsVisible", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitClosedCaptionsVisible), (intptr_t)setJSHTMLMediaElementWebkitClosedCaptionsVisible, NoIntrinsic },
#if ENABLE(MEDIA_STATISTICS)
    { "webkitAudioDecodedByteCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitAudioDecodedByteCount), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(MEDIA_STATISTICS)
    { "webkitVideoDecodedByteCount", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementWebkitVideoDecodedByteCount), (intptr_t)0, NoIntrinsic },
#endif
#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
    { "onwebkitneedkey", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementOnwebkitneedkey), (intptr_t)setJSHTMLMediaElementOnwebkitneedkey, NoIntrinsic },
#endif
    { "mediaGroup", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementMediaGroup), (intptr_t)setJSHTMLMediaElementMediaGroup, NoIntrinsic },
    { "controller", DontDelete, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementController), (intptr_t)setJSHTMLMediaElementController, NoIntrinsic },
    { "constructor", DontEnum | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementConstructor), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMediaElementTable = { 130, 127, JSHTMLMediaElementTableValues, 0 };
/* Hash table for constructor */

static const HashTableValue JSHTMLMediaElementConstructorTableValues[] =
{
    { "NETWORK_EMPTY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_EMPTY), (intptr_t)0, NoIntrinsic },
    { "NETWORK_IDLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_IDLE), (intptr_t)0, NoIntrinsic },
    { "NETWORK_LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_LOADING), (intptr_t)0, NoIntrinsic },
    { "NETWORK_NO_SOURCE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_NO_SOURCE), (intptr_t)0, NoIntrinsic },
    { "HAVE_NOTHING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_NOTHING), (intptr_t)0, NoIntrinsic },
    { "HAVE_METADATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_METADATA), (intptr_t)0, NoIntrinsic },
    { "HAVE_CURRENT_DATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_CURRENT_DATA), (intptr_t)0, NoIntrinsic },
    { "HAVE_FUTURE_DATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_FUTURE_DATA), (intptr_t)0, NoIntrinsic },
    { "HAVE_ENOUGH_DATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_ENOUGH_DATA), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMediaElementConstructorTable = { 32, 31, JSHTMLMediaElementConstructorTableValues, 0 };

COMPILE_ASSERT(0 == HTMLMediaElement::NETWORK_EMPTY, HTMLMediaElementEnumNETWORK_EMPTYIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == HTMLMediaElement::NETWORK_IDLE, HTMLMediaElementEnumNETWORK_IDLEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == HTMLMediaElement::NETWORK_LOADING, HTMLMediaElementEnumNETWORK_LOADINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == HTMLMediaElement::NETWORK_NO_SOURCE, HTMLMediaElementEnumNETWORK_NO_SOURCEIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(0 == HTMLMediaElement::HAVE_NOTHING, HTMLMediaElementEnumHAVE_NOTHINGIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(1 == HTMLMediaElement::HAVE_METADATA, HTMLMediaElementEnumHAVE_METADATAIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(2 == HTMLMediaElement::HAVE_CURRENT_DATA, HTMLMediaElementEnumHAVE_CURRENT_DATAIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(3 == HTMLMediaElement::HAVE_FUTURE_DATA, HTMLMediaElementEnumHAVE_FUTURE_DATAIsWrongUseDoNotCheckConstants);
COMPILE_ASSERT(4 == HTMLMediaElement::HAVE_ENOUGH_DATA, HTMLMediaElementEnumHAVE_ENOUGH_DATAIsWrongUseDoNotCheckConstants);

const ClassInfo JSHTMLMediaElementConstructor::s_info = { "HTMLMediaElementConstructor", &Base::s_info, &JSHTMLMediaElementConstructorTable, 0, CREATE_METHOD_TABLE(JSHTMLMediaElementConstructor) };

JSHTMLMediaElementConstructor::JSHTMLMediaElementConstructor(Structure* structure, JSDOMGlobalObject* globalObject)
    : DOMConstructorObject(structure, globalObject)
{
}

void JSHTMLMediaElementConstructor::finishCreation(ExecState* exec, JSDOMGlobalObject* globalObject)
{
    Base::finishCreation(exec->globalData());
    ASSERT(inherits(&s_info));
    putDirect(exec->globalData(), exec->propertyNames().prototype, JSHTMLMediaElementPrototype::self(exec, globalObject), DontDelete | ReadOnly);
}

bool JSHTMLMediaElementConstructor::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSHTMLMediaElementConstructor, JSDOMWrapper>(exec, &JSHTMLMediaElementConstructorTable, jsCast<JSHTMLMediaElementConstructor*>(cell), propertyName, slot);
}

bool JSHTMLMediaElementConstructor::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSHTMLMediaElementConstructor, JSDOMWrapper>(exec, &JSHTMLMediaElementConstructorTable, jsCast<JSHTMLMediaElementConstructor*>(object), propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSHTMLMediaElementPrototypeTableValues[] =
{
    { "NETWORK_EMPTY", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_EMPTY), (intptr_t)0, NoIntrinsic },
    { "NETWORK_IDLE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_IDLE), (intptr_t)0, NoIntrinsic },
    { "NETWORK_LOADING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_LOADING), (intptr_t)0, NoIntrinsic },
    { "NETWORK_NO_SOURCE", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementNETWORK_NO_SOURCE), (intptr_t)0, NoIntrinsic },
    { "HAVE_NOTHING", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_NOTHING), (intptr_t)0, NoIntrinsic },
    { "HAVE_METADATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_METADATA), (intptr_t)0, NoIntrinsic },
    { "HAVE_CURRENT_DATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_CURRENT_DATA), (intptr_t)0, NoIntrinsic },
    { "HAVE_FUTURE_DATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_FUTURE_DATA), (intptr_t)0, NoIntrinsic },
    { "HAVE_ENOUGH_DATA", DontDelete | ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsHTMLMediaElementHAVE_ENOUGH_DATA), (intptr_t)0, NoIntrinsic },
    { "load", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionLoad), (intptr_t)0, NoIntrinsic },
    { "canPlayType", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionCanPlayType), (intptr_t)1, NoIntrinsic },
    { "play", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionPlay), (intptr_t)0, NoIntrinsic },
    { "pause", DontDelete | JSC::Function, (intptr_t)static_cast<NativeFunction>(jsHTMLMediaElementPrototypeFunctionPause), (intptr_t)0, NoIntrinsic },
    { 0, 0, 0, 0, NoIntrinsic }
};

static const HashTable JSHTMLMediaElementPrototypeTable = { 32, 31, JSHTMLMediaElementPrototypeTableValues, 0 };
const ClassInfo JSHTMLMediaElementPrototype::s_info = { "HTMLMediaElementPrototype", &Base::s_info, &JSHTMLMediaElementPrototypeTable, 0, CREATE_METHOD_TABLE(JSHTMLMediaElementPrototype) };

JSObject* JSHTMLMediaElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSHTMLMediaElement>(exec, globalObject);
}

bool JSHTMLMediaElementPrototype::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLMediaElementPrototype* thisObject = jsCast<JSHTMLMediaElementPrototype*>(cell);
    return getStaticPropertySlot<JSHTMLMediaElementPrototype, JSObject>(exec, &JSHTMLMediaElementPrototypeTable, thisObject, propertyName, slot);
}

bool JSHTMLMediaElementPrototype::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLMediaElementPrototype* thisObject = jsCast<JSHTMLMediaElementPrototype*>(object);
    return getStaticPropertyDescriptor<JSHTMLMediaElementPrototype, JSObject>(exec, &JSHTMLMediaElementPrototypeTable, thisObject, propertyName, descriptor);
}

const ClassInfo JSHTMLMediaElement::s_info = { "HTMLMediaElement", &Base::s_info, &JSHTMLMediaElementTable, 0 , CREATE_METHOD_TABLE(JSHTMLMediaElement) };

JSHTMLMediaElement::JSHTMLMediaElement(Structure* structure, JSDOMGlobalObject* globalObject, PassRefPtr<HTMLMediaElement> impl)
    : JSHTMLElement(structure, globalObject, impl)
{
}

void JSHTMLMediaElement::finishCreation(JSGlobalData& globalData)
{
    Base::finishCreation(globalData);
    ASSERT(inherits(&s_info));
}

JSObject* JSHTMLMediaElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return JSHTMLMediaElementPrototype::create(exec->globalData(), globalObject, JSHTMLMediaElementPrototype::createStructure(exec->globalData(), globalObject, JSHTMLElementPrototype::self(exec, globalObject)));
}

bool JSHTMLMediaElement::getOwnPropertySlot(JSCell* cell, ExecState* exec, PropertyName propertyName, PropertySlot& slot)
{
    JSHTMLMediaElement* thisObject = jsCast<JSHTMLMediaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueSlot<JSHTMLMediaElement, Base>(exec, &JSHTMLMediaElementTable, thisObject, propertyName, slot);
}

bool JSHTMLMediaElement::getOwnPropertyDescriptor(JSObject* object, ExecState* exec, PropertyName propertyName, PropertyDescriptor& descriptor)
{
    JSHTMLMediaElement* thisObject = jsCast<JSHTMLMediaElement*>(object);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    return getStaticValueDescriptor<JSHTMLMediaElement, Base>(exec, &JSHTMLMediaElementTable, thisObject, propertyName, descriptor);
}

JSValue jsHTMLMediaElementError(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->error()));
    return result;
}


JSValue jsHTMLMediaElementSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->getURLAttribute(WebCore::HTMLNames::srcAttr));
    return result;
}


JSValue jsHTMLMediaElementCurrentSrc(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->currentSrc());
    return result;
}


JSValue jsHTMLMediaElementNetworkState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->networkState());
    return result;
}


JSValue jsHTMLMediaElementPreload(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->preload());
    return result;
}


JSValue jsHTMLMediaElementBuffered(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->buffered()));
    return result;
}


JSValue jsHTMLMediaElementReadyState(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->readyState());
    return result;
}


JSValue jsHTMLMediaElementSeeking(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->seeking());
    return result;
}


JSValue jsHTMLMediaElementCurrentTime(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->currentTime());
    return result;
}


JSValue jsHTMLMediaElementInitialTime(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->initialTime());
    return result;
}


JSValue jsHTMLMediaElementStartTime(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->startTime());
    return result;
}


JSValue jsHTMLMediaElementDuration(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->duration());
    return result;
}


JSValue jsHTMLMediaElementPaused(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->paused());
    return result;
}


JSValue jsHTMLMediaElementDefaultPlaybackRate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->defaultPlaybackRate());
    return result;
}


JSValue jsHTMLMediaElementPlaybackRate(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->playbackRate());
    return result;
}


JSValue jsHTMLMediaElementPlayed(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->played()));
    return result;
}


JSValue jsHTMLMediaElementSeekable(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->seekable()));
    return result;
}


JSValue jsHTMLMediaElementEnded(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->ended());
    return result;
}


JSValue jsHTMLMediaElementAutoplay(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::autoplayAttr));
    return result;
}


JSValue jsHTMLMediaElementLoop(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::loopAttr));
    return result;
}


JSValue jsHTMLMediaElementControls(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->controls());
    return result;
}


JSValue jsHTMLMediaElementVolume(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->volume());
    return result;
}


JSValue jsHTMLMediaElementMuted(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->muted());
    return result;
}


JSValue jsHTMLMediaElementDefaultMuted(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->fastHasAttribute(WebCore::HTMLNames::mutedAttr));
    return result;
}


JSValue jsHTMLMediaElementWebkitPreservesPitch(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->webkitPreservesPitch());
    return result;
}


JSValue jsHTMLMediaElementWebkitHasClosedCaptions(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->webkitHasClosedCaptions());
    return result;
}


JSValue jsHTMLMediaElementWebkitClosedCaptionsVisible(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsBoolean(impl->webkitClosedCaptionsVisible());
    return result;
}


#if ENABLE(MEDIA_STATISTICS)
JSValue jsHTMLMediaElementWebkitAudioDecodedByteCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitAudioDecodedByteCount());
    return result;
}

#endif

#if ENABLE(MEDIA_STATISTICS)
JSValue jsHTMLMediaElementWebkitVideoDecodedByteCount(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsNumber(impl->webkitVideoDecodedByteCount());
    return result;
}

#endif

#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
JSValue jsHTMLMediaElementOnwebkitneedkey(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    if (EventListener* listener = impl->onwebkitneedkey()) {
        if (const JSEventListener* jsListener = JSEventListener::cast(listener)) {
            if (JSObject* jsFunction = jsListener->jsFunction(impl->scriptExecutionContext()))
                return jsFunction;
        }
    }
    return jsNull();
}

#endif

JSValue jsHTMLMediaElementMediaGroup(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = jsStringWithCache(exec, impl->fastGetAttribute(WebCore::HTMLNames::mediagroupAttr));
    return result;
}


JSValue jsHTMLMediaElementController(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(impl->controller()));
    return result;
}


JSValue jsHTMLMediaElementConstructor(ExecState* exec, JSValue slotBase, PropertyName)
{
    JSHTMLMediaElement* domObject = jsCast<JSHTMLMediaElement*>(asObject(slotBase));
    return JSHTMLMediaElement::getConstructor(exec, domObject->globalObject());
}

void JSHTMLMediaElement::put(JSCell* cell, ExecState* exec, PropertyName propertyName, JSValue value, PutPropertySlot& slot)
{
    JSHTMLMediaElement* thisObject = jsCast<JSHTMLMediaElement*>(cell);
    ASSERT_GC_OBJECT_INHERITS(thisObject, &s_info);
    lookupPut<JSHTMLMediaElement, Base>(exec, propertyName, value, &JSHTMLMediaElementTable, thisObject, slot);
}

void setJSHTMLMediaElementSrc(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::srcAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLMediaElementPreload(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setPreload(value.isEmpty() ? String() : value.toString(exec)->value(exec));
}


void setJSHTMLMediaElementCurrentTime(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setCurrentTime(value.toFloat(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLMediaElementDefaultPlaybackRate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setDefaultPlaybackRate(value.toFloat(exec));
}


void setJSHTMLMediaElementPlaybackRate(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setPlaybackRate(value.toFloat(exec));
}


void setJSHTMLMediaElementAutoplay(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::autoplayAttr, value.toBoolean(exec));
}


void setJSHTMLMediaElementLoop(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::loopAttr, value.toBoolean(exec));
}


void setJSHTMLMediaElementControls(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setControls(value.toBoolean(exec));
}


void setJSHTMLMediaElementVolume(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    ExceptionCode ec = 0;
    impl->setVolume(value.toFloat(exec), ec);
    setDOMException(exec, ec);
}


void setJSHTMLMediaElementMuted(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setMuted(value.toBoolean(exec));
}


void setJSHTMLMediaElementDefaultMuted(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setBooleanAttribute(WebCore::HTMLNames::mutedAttr, value.toBoolean(exec));
}


void setJSHTMLMediaElementWebkitPreservesPitch(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setWebkitPreservesPitch(value.toBoolean(exec));
}


void setJSHTMLMediaElementWebkitClosedCaptionsVisible(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setWebkitClosedCaptionsVisible(value.toBoolean(exec));
}


#if ENABLE(ENCRYPTED_MEDIA) || ENABLE(ENCRYPTED_MEDIA_V2)
void setJSHTMLMediaElementOnwebkitneedkey(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setOnwebkitneedkey(createJSAttributeEventListener(exec, value, thisObject));
}

#endif

void setJSHTMLMediaElementMediaGroup(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(thisObject);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->setAttribute(WebCore::HTMLNames::mediagroupAttr, valueToStringWithNullCheck(exec, value));
}


void setJSHTMLMediaElementController(ExecState* exec, JSObject* thisObject, JSValue value)
{
    UNUSED_PARAM(exec);
    jsCast<JSHTMLMediaElement*>(thisObject)->setController(exec, value);
}


JSValue JSHTMLMediaElement::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSHTMLMediaElementConstructor>(exec, jsCast<JSDOMGlobalObject*>(globalObject));
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionLoad(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLMediaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLMediaElement::s_info);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->load();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionCanPlayType(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLMediaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLMediaElement::s_info);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    const String& type(exec->argument(0).isEmpty() ? String() : exec->argument(0).toString(exec)->value(exec));
    if (exec->hadException())
        return JSValue::encode(jsUndefined());

    JSC::JSValue result = jsStringWithCache(exec, impl->canPlayType(type));
    return JSValue::encode(result);
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPlay(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLMediaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLMediaElement::s_info);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->play();
    return JSValue::encode(jsUndefined());
}

EncodedJSValue JSC_HOST_CALL jsHTMLMediaElementPrototypeFunctionPause(ExecState* exec)
{
    JSValue thisValue = exec->hostThisValue();
    if (!thisValue.inherits(&JSHTMLMediaElement::s_info))
        return throwVMTypeError(exec);
    JSHTMLMediaElement* castedThis = jsCast<JSHTMLMediaElement*>(asObject(thisValue));
    ASSERT_GC_OBJECT_INHERITS(castedThis, &JSHTMLMediaElement::s_info);
    HTMLMediaElement* impl = static_cast<HTMLMediaElement*>(castedThis->impl());
    impl->pause();
    return JSValue::encode(jsUndefined());
}

// Constant getters

JSValue jsHTMLMediaElementNETWORK_EMPTY(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsHTMLMediaElementNETWORK_IDLE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsHTMLMediaElementNETWORK_LOADING(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsHTMLMediaElementNETWORK_NO_SOURCE(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsHTMLMediaElementHAVE_NOTHING(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(0));
}

JSValue jsHTMLMediaElementHAVE_METADATA(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(1));
}

JSValue jsHTMLMediaElementHAVE_CURRENT_DATA(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(2));
}

JSValue jsHTMLMediaElementHAVE_FUTURE_DATA(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(3));
}

JSValue jsHTMLMediaElementHAVE_ENOUGH_DATA(ExecState* exec, JSValue, PropertyName)
{
    UNUSED_PARAM(exec);
    return jsNumber(static_cast<int>(4));
}

HTMLMediaElement* toHTMLMediaElement(JSC::JSValue value)
{
    return value.inherits(&JSHTMLMediaElement::s_info) ? jsCast<JSHTMLMediaElement*>(asObject(value))->impl() : 0;
}

}

#endif // ENABLE(VIDEO)
