/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMText.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "WebKitDOMTextPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMText* kit(WebCore::Text* obj)
{
    return WEBKIT_DOM_TEXT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::Text* core(WebKitDOMText* request)
{
    return request ? static_cast<WebCore::Text*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMText* wrapText(WebCore::Text* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_TEXT(g_object_new(WEBKIT_TYPE_DOM_TEXT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMText, webkit_dom_text, WEBKIT_TYPE_DOM_CHARACTER_DATA)

enum {
    PROP_0,
    PROP_WHOLE_TEXT,
};

static void webkit_dom_text_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMText* self = WEBKIT_DOM_TEXT(object);
    WebCore::Text* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_WHOLE_TEXT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->wholeText()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_text_class_init(WebKitDOMTextClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->get_property = webkit_dom_text_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_WHOLE_TEXT,
                                    g_param_spec_string("whole-text", /* name */
                                                           "text_whole-text", /* short description */
                                                           "read-only  gchar* Text.whole-text", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
}

static void webkit_dom_text_init(WebKitDOMText* request)
{
}

WebKitDOMText*
webkit_dom_text_split_text(WebKitDOMText* self, gulong offset, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT(self), 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Text* item = WebKit::core(self);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Text> gobjectResult = WTF::getPtr(item->splitText(offset, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMText*
webkit_dom_text_replace_whole_text(WebKitDOMText* self, const gchar* content, GError** error)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT(self), 0);
    g_return_val_if_fail(content, 0);
    g_return_val_if_fail(!error || !*error, 0);
    WebCore::Text* item = WebKit::core(self);
    WTF::String convertedContent = WTF::String::fromUTF8(content);
    WebCore::ExceptionCode ec = 0;
    RefPtr<WebCore::Text> gobjectResult = WTF::getPtr(item->replaceWholeText(convertedContent, ec));
    if (ec) {
        WebCore::ExceptionCodeDescription ecdesc(ec);
        g_set_error_literal(error, g_quark_from_string("WEBKIT_DOM"), ecdesc.code, ecdesc.name);
    }
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_text_get_whole_text(WebKitDOMText* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_TEXT(self), 0);
    WebCore::Text* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->wholeText());
    return result;
}

