/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMMicroDataItemValue.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMMicroDataItemValuePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

#define WEBKIT_DOM_MICRO_DATA_ITEM_VALUE_GET_PRIVATE(obj) G_TYPE_INSTANCE_GET_PRIVATE(obj, WEBKIT_TYPE_DOM_MICRO_DATA_ITEM_VALUE, WebKitDOMMicroDataItemValuePrivate)

typedef struct _WebKitDOMMicroDataItemValuePrivate {
#if ENABLE(MICRODATA)
    RefPtr<WebCore::MicroDataItemValue> coreObject;
#endif // ENABLE(MICRODATA)
} WebKitDOMMicroDataItemValuePrivate;

#if ENABLE(MICRODATA)

namespace WebKit {

WebKitDOMMicroDataItemValue* kit(WebCore::MicroDataItemValue* obj)
{
    if (!obj)
        return 0;

    if (gpointer ret = DOMObjectCache::get(obj))
        return WEBKIT_DOM_MICRO_DATA_ITEM_VALUE(ret);

    return wrapMicroDataItemValue(obj);
}

WebCore::MicroDataItemValue* core(WebKitDOMMicroDataItemValue* request)
{
    return request ? static_cast<WebCore::MicroDataItemValue*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMMicroDataItemValue* wrapMicroDataItemValue(WebCore::MicroDataItemValue* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_MICRO_DATA_ITEM_VALUE(g_object_new(WEBKIT_TYPE_DOM_MICRO_DATA_ITEM_VALUE, "core-object", coreObject, NULL));
}

} // namespace WebKit

#endif // ENABLE(MICRODATA)

G_DEFINE_TYPE(WebKitDOMMicroDataItemValue, webkit_dom_micro_data_item_value, WEBKIT_TYPE_DOM_OBJECT)

static void webkit_dom_micro_data_item_value_finalize(GObject* object)
{
    WebKitDOMMicroDataItemValuePrivate* priv = WEBKIT_DOM_MICRO_DATA_ITEM_VALUE_GET_PRIVATE(object);
#if ENABLE(MICRODATA)
    WebKit::DOMObjectCache::forget(priv->coreObject.get());
#endif // ENABLE(MICRODATA)
    priv->~WebKitDOMMicroDataItemValuePrivate();
    G_OBJECT_CLASS(webkit_dom_micro_data_item_value_parent_class)->finalize(object);
}

static GObject* webkit_dom_micro_data_item_value_constructor(GType type, guint constructPropertiesCount, GObjectConstructParam* constructProperties)
{
    GObject* object = G_OBJECT_CLASS(webkit_dom_micro_data_item_value_parent_class)->constructor(type, constructPropertiesCount, constructProperties);
#if ENABLE(MICRODATA)
    WebKitDOMMicroDataItemValuePrivate* priv = WEBKIT_DOM_MICRO_DATA_ITEM_VALUE_GET_PRIVATE(object);
    priv->coreObject = static_cast<WebCore::MicroDataItemValue*>(WEBKIT_DOM_OBJECT(object)->coreObject);
    WebKit::DOMObjectCache::put(priv->coreObject.get(), object);
#endif // ENABLE(MICRODATA)
    return object;
}

static void webkit_dom_micro_data_item_value_class_init(WebKitDOMMicroDataItemValueClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    g_type_class_add_private(gobjectClass, sizeof(WebKitDOMMicroDataItemValuePrivate));
    gobjectClass->constructor = webkit_dom_micro_data_item_value_constructor;
    gobjectClass->finalize = webkit_dom_micro_data_item_value_finalize;
}

static void webkit_dom_micro_data_item_value_init(WebKitDOMMicroDataItemValue* request)
{
    WebKitDOMMicroDataItemValuePrivate* priv = WEBKIT_DOM_MICRO_DATA_ITEM_VALUE_GET_PRIVATE(request);
    new (priv) WebKitDOMMicroDataItemValuePrivate();
}

