/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLMetaElement.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "HTMLNames.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMHTMLMetaElementPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLMetaElement* kit(WebCore::HTMLMetaElement* obj)
{
    return WEBKIT_DOM_HTML_META_ELEMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLMetaElement* core(WebKitDOMHTMLMetaElement* request)
{
    return request ? static_cast<WebCore::HTMLMetaElement*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLMetaElement* wrapHTMLMetaElement(WebCore::HTMLMetaElement* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_META_ELEMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_META_ELEMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLMetaElement, webkit_dom_html_meta_element, WEBKIT_TYPE_DOM_HTML_ELEMENT)

enum {
    PROP_0,
    PROP_CONTENT,
    PROP_HTTP_EQUIV,
    PROP_NAME,
    PROP_SCHEME,
};

static void webkit_dom_html_meta_element_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLMetaElement* self = WEBKIT_DOM_HTML_META_ELEMENT(object);
    WebCore::HTMLMetaElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CONTENT: {
        coreSelf->setAttribute(WebCore::HTMLNames::contentAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_HTTP_EQUIV: {
        coreSelf->setAttribute(WebCore::HTMLNames::http_equivAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_NAME: {
        coreSelf->setAttribute(WebCore::HTMLNames::nameAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_SCHEME: {
        coreSelf->setAttribute(WebCore::HTMLNames::schemeAttr, WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_meta_element_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLMetaElement* self = WEBKIT_DOM_HTML_META_ELEMENT(object);
    WebCore::HTMLMetaElement* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_CONTENT: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::contentAttr)));
        break;
    }
    case PROP_HTTP_EQUIV: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::http_equivAttr)));
        break;
    }
    case PROP_NAME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->getNameAttribute()));
        break;
    }
    case PROP_SCHEME: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fastGetAttribute(WebCore::HTMLNames::schemeAttr)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_meta_element_class_init(WebKitDOMHTMLMetaElementClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_meta_element_set_property;
    gobjectClass->get_property = webkit_dom_html_meta_element_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_CONTENT,
                                    g_param_spec_string("content", /* name */
                                                           "html_meta_element_content", /* short description */
                                                           "read-write  gchar* HTMLMetaElement.content", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HTTP_EQUIV,
                                    g_param_spec_string("http-equiv", /* name */
                                                           "html_meta_element_http-equiv", /* short description */
                                                           "read-write  gchar* HTMLMetaElement.http-equiv", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_NAME,
                                    g_param_spec_string("name", /* name */
                                                           "html_meta_element_name", /* short description */
                                                           "read-write  gchar* HTMLMetaElement.name", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCHEME,
                                    g_param_spec_string("scheme", /* name */
                                                           "html_meta_element_scheme", /* short description */
                                                           "read-write  gchar* HTMLMetaElement.scheme", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_meta_element_init(WebKitDOMHTMLMetaElement* request)
{
}

gchar*
webkit_dom_html_meta_element_get_content(WebKitDOMHTMLMetaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self), 0);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::contentAttr));
    return result;
}

void
webkit_dom_html_meta_element_set_content(WebKitDOMHTMLMetaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::contentAttr, convertedValue);
}

gchar*
webkit_dom_html_meta_element_get_http_equiv(WebKitDOMHTMLMetaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self), 0);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::http_equivAttr));
    return result;
}

void
webkit_dom_html_meta_element_set_http_equiv(WebKitDOMHTMLMetaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::http_equivAttr, convertedValue);
}

gchar*
webkit_dom_html_meta_element_get_name(WebKitDOMHTMLMetaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self), 0);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->getNameAttribute());
    return result;
}

void
webkit_dom_html_meta_element_set_name(WebKitDOMHTMLMetaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::nameAttr, convertedValue);
}

gchar*
webkit_dom_html_meta_element_get_scheme(WebKitDOMHTMLMetaElement* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self), 0);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fastGetAttribute(WebCore::HTMLNames::schemeAttr));
    return result;
}

void
webkit_dom_html_meta_element_set_scheme(WebKitDOMHTMLMetaElement* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_META_ELEMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLMetaElement* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAttribute(WebCore::HTMLNames::schemeAttr, convertedValue);
}

