/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "WebKitDOMHTMLDocument.h"

#include "DOMObjectCache.h"
#include "ExceptionCode.h"
#include "JSMainThreadExecState.h"
#include "WebKitDOMElementPrivate.h"
#include "WebKitDOMHTMLCollectionPrivate.h"
#include "WebKitDOMHTMLDocumentPrivate.h"
#include "WebKitDOMNodePrivate.h"
#include "WebKitDOMPrivate.h"
#include "gobject/ConvertToUTF8String.h"
#include <wtf/GetPtr.h>
#include <wtf/RefPtr.h>

namespace WebKit {

WebKitDOMHTMLDocument* kit(WebCore::HTMLDocument* obj)
{
    return WEBKIT_DOM_HTML_DOCUMENT(kit(static_cast<WebCore::Node*>(obj)));
}

WebCore::HTMLDocument* core(WebKitDOMHTMLDocument* request)
{
    return request ? static_cast<WebCore::HTMLDocument*>(WEBKIT_DOM_OBJECT(request)->coreObject) : 0;
}

WebKitDOMHTMLDocument* wrapHTMLDocument(WebCore::HTMLDocument* coreObject)
{
    ASSERT(coreObject);
    return WEBKIT_DOM_HTML_DOCUMENT(g_object_new(WEBKIT_TYPE_DOM_HTML_DOCUMENT, "core-object", coreObject, NULL));
}

} // namespace WebKit

G_DEFINE_TYPE(WebKitDOMHTMLDocument, webkit_dom_html_document, WEBKIT_TYPE_DOM_DOCUMENT)

enum {
    PROP_0,
    PROP_EMBEDS,
    PROP_PLUGINS,
    PROP_SCRIPTS,
    PROP_WIDTH,
    PROP_HEIGHT,
    PROP_DIR,
    PROP_DESIGN_MODE,
    PROP_COMPAT_MODE,
    PROP_ACTIVE_ELEMENT,
    PROP_BG_COLOR,
    PROP_FG_COLOR,
    PROP_ALINK_COLOR,
    PROP_LINK_COLOR,
    PROP_VLINK_COLOR,
};

static void webkit_dom_html_document_set_property(GObject* object, guint propertyId, const GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLDocument* self = WEBKIT_DOM_HTML_DOCUMENT(object);
    WebCore::HTMLDocument* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_DIR: {
        coreSelf->setDir(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_DESIGN_MODE: {
        coreSelf->setDesignMode(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_BG_COLOR: {
        coreSelf->setBgColor(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_FG_COLOR: {
        coreSelf->setFgColor(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_ALINK_COLOR: {
        coreSelf->setAlinkColor(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_LINK_COLOR: {
        coreSelf->setLinkColor(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    case PROP_VLINK_COLOR: {
        coreSelf->setVlinkColor(WTF::String::fromUTF8(g_value_get_string(value)));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_document_get_property(GObject* object, guint propertyId, GValue* value, GParamSpec* pspec)
{
    WebCore::JSMainThreadNullState state;

    WebKitDOMHTMLDocument* self = WEBKIT_DOM_HTML_DOCUMENT(object);
    WebCore::HTMLDocument* coreSelf = WebKit::core(self);

    switch (propertyId) {
    case PROP_EMBEDS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->embeds();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_PLUGINS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->plugins();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_SCRIPTS: {
        RefPtr<WebCore::HTMLCollection> ptr = coreSelf->scripts();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_WIDTH: {
        g_value_set_long(value, coreSelf->width());
        break;
    }
    case PROP_HEIGHT: {
        g_value_set_long(value, coreSelf->height());
        break;
    }
    case PROP_DIR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->dir()));
        break;
    }
    case PROP_DESIGN_MODE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->designMode()));
        break;
    }
    case PROP_COMPAT_MODE: {
        g_value_take_string(value, convertToUTF8String(coreSelf->compatMode()));
        break;
    }
    case PROP_ACTIVE_ELEMENT: {
        RefPtr<WebCore::Element> ptr = coreSelf->activeElement();
        g_value_set_object(value, WebKit::kit(ptr.get()));
        break;
    }
    case PROP_BG_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->bgColor()));
        break;
    }
    case PROP_FG_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->fgColor()));
        break;
    }
    case PROP_ALINK_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->alinkColor()));
        break;
    }
    case PROP_LINK_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->linkColor()));
        break;
    }
    case PROP_VLINK_COLOR: {
        g_value_take_string(value, convertToUTF8String(coreSelf->vlinkColor()));
        break;
    }
    default:
        G_OBJECT_WARN_INVALID_PROPERTY_ID(object, propertyId, pspec);
        break;
    }
}

static void webkit_dom_html_document_class_init(WebKitDOMHTMLDocumentClass* requestClass)
{
    GObjectClass* gobjectClass = G_OBJECT_CLASS(requestClass);
    gobjectClass->set_property = webkit_dom_html_document_set_property;
    gobjectClass->get_property = webkit_dom_html_document_get_property;

    g_object_class_install_property(gobjectClass,
                                    PROP_EMBEDS,
                                    g_param_spec_object("embeds", /* name */
                                                           "html_document_embeds", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLDocument.embeds", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_PLUGINS,
                                    g_param_spec_object("plugins", /* name */
                                                           "html_document_plugins", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLDocument.plugins", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_SCRIPTS,
                                    g_param_spec_object("scripts", /* name */
                                                           "html_document_scripts", /* short description */
                                                           "read-only  WebKitDOMHTMLCollection* HTMLDocument.scripts", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_HTML_COLLECTION, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_WIDTH,
                                    g_param_spec_long("width", /* name */
                                                           "html_document_width", /* short description */
                                                           "read-only  glong HTMLDocument.width", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_HEIGHT,
                                    g_param_spec_long("height", /* name */
                                                           "html_document_height", /* short description */
                                                           "read-only  glong HTMLDocument.height", /* longer - could do with some extra doc stuff here */
                                                           G_MINLONG, /* min */
G_MAXLONG, /* max */
0, /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DIR,
                                    g_param_spec_string("dir", /* name */
                                                           "html_document_dir", /* short description */
                                                           "read-write  gchar* HTMLDocument.dir", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_DESIGN_MODE,
                                    g_param_spec_string("design-mode", /* name */
                                                           "html_document_design-mode", /* short description */
                                                           "read-write  gchar* HTMLDocument.design-mode", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_COMPAT_MODE,
                                    g_param_spec_string("compat-mode", /* name */
                                                           "html_document_compat-mode", /* short description */
                                                           "read-only  gchar* HTMLDocument.compat-mode", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ACTIVE_ELEMENT,
                                    g_param_spec_object("active-element", /* name */
                                                           "html_document_active-element", /* short description */
                                                           "read-only  WebKitDOMElement* HTMLDocument.active-element", /* longer - could do with some extra doc stuff here */
                                                           WEBKIT_TYPE_DOM_ELEMENT, /* gobject type */
                                                           WEBKIT_PARAM_READABLE));
    g_object_class_install_property(gobjectClass,
                                    PROP_BG_COLOR,
                                    g_param_spec_string("bg-color", /* name */
                                                           "html_document_bg-color", /* short description */
                                                           "read-write  gchar* HTMLDocument.bg-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_FG_COLOR,
                                    g_param_spec_string("fg-color", /* name */
                                                           "html_document_fg-color", /* short description */
                                                           "read-write  gchar* HTMLDocument.fg-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_ALINK_COLOR,
                                    g_param_spec_string("alink-color", /* name */
                                                           "html_document_alink-color", /* short description */
                                                           "read-write  gchar* HTMLDocument.alink-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_LINK_COLOR,
                                    g_param_spec_string("link-color", /* name */
                                                           "html_document_link-color", /* short description */
                                                           "read-write  gchar* HTMLDocument.link-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
    g_object_class_install_property(gobjectClass,
                                    PROP_VLINK_COLOR,
                                    g_param_spec_string("vlink-color", /* name */
                                                           "html_document_vlink-color", /* short description */
                                                           "read-write  gchar* HTMLDocument.vlink-color", /* longer - could do with some extra doc stuff here */
                                                           "", /* default */
                                                           WEBKIT_PARAM_READWRITE));
}

static void webkit_dom_html_document_init(WebKitDOMHTMLDocument* request)
{
}

void
webkit_dom_html_document_open(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    WebCore::HTMLDocument* item = WebKit::core(self);
    item->open();
}

void
webkit_dom_html_document_close(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    WebCore::HTMLDocument* item = WebKit::core(self);
    item->close();
}

void
webkit_dom_html_document_clear(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    WebCore::HTMLDocument* item = WebKit::core(self);
    item->clear();
}

void
webkit_dom_html_document_capture_events(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    WebCore::HTMLDocument* item = WebKit::core(self);
    item->captureEvents();
}

void
webkit_dom_html_document_release_events(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    WebCore::HTMLDocument* item = WebKit::core(self);
    item->releaseEvents();
}

gboolean
webkit_dom_html_document_has_focus(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), FALSE);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gboolean result = item->hasFocus();
    return result;
}

WebKitDOMHTMLCollection*
webkit_dom_html_document_get_embeds(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->embeds());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_html_document_get_plugins(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->plugins());
    return WebKit::kit(gobjectResult.get());
}

WebKitDOMHTMLCollection*
webkit_dom_html_document_get_scripts(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    RefPtr<WebCore::HTMLCollection> gobjectResult = WTF::getPtr(item->scripts());
    return WebKit::kit(gobjectResult.get());
}

glong
webkit_dom_html_document_get_width(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    glong result = item->width();
    return result;
}

glong
webkit_dom_html_document_get_height(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    glong result = item->height();
    return result;
}

gchar*
webkit_dom_html_document_get_dir(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->dir());
    return result;
}

void
webkit_dom_html_document_set_dir(WebKitDOMHTMLDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLDocument* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setDir(convertedValue);
}

gchar*
webkit_dom_html_document_get_design_mode(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->designMode());
    return result;
}

void
webkit_dom_html_document_set_design_mode(WebKitDOMHTMLDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLDocument* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setDesignMode(convertedValue);
}

gchar*
webkit_dom_html_document_get_compat_mode(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->compatMode());
    return result;
}

WebKitDOMElement*
webkit_dom_html_document_get_active_element(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    RefPtr<WebCore::Element> gobjectResult = WTF::getPtr(item->activeElement());
    return WebKit::kit(gobjectResult.get());
}

gchar*
webkit_dom_html_document_get_bg_color(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->bgColor());
    return result;
}

void
webkit_dom_html_document_set_bg_color(WebKitDOMHTMLDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLDocument* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setBgColor(convertedValue);
}

gchar*
webkit_dom_html_document_get_fg_color(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->fgColor());
    return result;
}

void
webkit_dom_html_document_set_fg_color(WebKitDOMHTMLDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLDocument* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setFgColor(convertedValue);
}

gchar*
webkit_dom_html_document_get_alink_color(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->alinkColor());
    return result;
}

void
webkit_dom_html_document_set_alink_color(WebKitDOMHTMLDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLDocument* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setAlinkColor(convertedValue);
}

gchar*
webkit_dom_html_document_get_link_color(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->linkColor());
    return result;
}

void
webkit_dom_html_document_set_link_color(WebKitDOMHTMLDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLDocument* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setLinkColor(convertedValue);
}

gchar*
webkit_dom_html_document_get_vlink_color(WebKitDOMHTMLDocument* self)
{
    WebCore::JSMainThreadNullState state;
    g_return_val_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self), 0);
    WebCore::HTMLDocument* item = WebKit::core(self);
    gchar* result = convertToUTF8String(item->vlinkColor());
    return result;
}

void
webkit_dom_html_document_set_vlink_color(WebKitDOMHTMLDocument* self, const gchar* value)
{
    WebCore::JSMainThreadNullState state;
    g_return_if_fail(WEBKIT_DOM_IS_HTML_DOCUMENT(self));
    g_return_if_fail(value);
    WebCore::HTMLDocument* item = WebKit::core(self);
    WTF::String convertedValue = WTF::String::fromUTF8(value);
    item->setVlinkColor(convertedValue);
}

