/* i386-win32.pe.h
   created from i386-win32.pe.bin, 28258 (0x6e62) bytes

   This file is part of the UPX executable compressor.

   Copyright (C) 1996-2025 Markus Franz Xaver Johannes Oberhumer
   Copyright (C) 1996-2025 Laszlo Molnar
   Copyright (C) 2000-2025 John F. Reiser
   All Rights Reserved.

   UPX and the UCL library are free software; you can redistribute them
   and/or modify them under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2 of
   the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; see the file COPYING.
   If not, write to the Free Software Foundation, Inc.,
   59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

   Markus F.X.J. Oberhumer              Laszlo Molnar
   <markus@oberhumer.com>               <ezerotven+github@gmail.com>

   John F. Reiser
   <jreiser@users.sourceforge.net>
 */

/* clang-format off */

#define STUB_I386_WIN32_PE_SIZE    28258
#define STUB_I386_WIN32_PE_ADLER32 0xb4a54285
#define STUB_I386_WIN32_PE_CRC32   0x7db147dd

unsigned char stub_i386_win32_pe[28258] = {
/* 0x0000 */ 127, 69, 76, 70,  1,  1,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0010 */   1,  0,  3,  0,  1,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x0020 */  64, 34,  0,  0,  0,  0,  0,  0, 52,  0,  0,  0,  0,  0, 40,  0,
/* 0x0030 */   0,  0,  0,  0,128,124, 36,  8,  1, 15,133,252,255,255,255, 96,
/* 0x0040 */ 190,  0,  0,  0,  0,232,  0,  0,  0,  0, 88,141,176,  3,  0,  0,
/* 0x0050 */   0,141,190,  0,  0,  0,  0,102,255,135,  0,  0,  0,  0,102,129,
/* 0x0060 */ 135,  0,  0,  0,  0,  0,  0,141,135,  0,  0,  0,  0,255, 48,199,
/* 0x0070 */   0,  0,  0,  0,  0, 80, 87,131,205,255,235,  3,164,235,  3,138,
/* 0x0080 */   6, 70,136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0090 */ 114,  1, 49,192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,
/* 0x00a0 */ 139, 30,131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,
/* 0x00b0 */ 238,252, 17,219,115,255,  1,219,115,255,117,  9,139, 30,131,238,
/* 0x00c0 */ 252, 17,219,115,255, 49,201,131,232,  3,114, 13,193,224,  8,138,
/* 0x00d0 */   6, 70,131,240,255,116,255,137,197,  1,219,117,  7,139, 30,131,
/* 0x00e0 */ 238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x00f0 */ 219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x0100 */ 219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 48,
/* 0x0110 */   1,219,115, 48,117,  9,139, 30,131,238,252, 17,219,115, 48, 65,
/* 0x0120 */  65,131,193,  2,129,253,  0,243,255,255,131,209,  1,137,242,141,
/* 0x0130 */  52, 47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,253,
/* 0x0140 */ 252,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,
/* 0x0150 */ 255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,
/* 0x0160 */   1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,136,
/* 0x0170 */   7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1, 49,
/* 0x0180 */ 192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,131,
/* 0x0190 */ 238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252, 17,
/* 0x01a0 */ 219,114, 15,  1,219,115, 11,117, 15,139, 30,131,238,252, 17,219,
/* 0x01b0 */ 114, 15, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,192,
/* 0x01c0 */ 235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,
/* 0x01d0 */ 240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,
/* 0x01e0 */ 131,238,252, 17,219, 17,201,  1,219,117,  7,139, 30,131,238,252,
/* 0x01f0 */  17,219, 17,201,117,255, 65,  1,219,117,  7,139, 30,131,238,252,
/* 0x0200 */  17,219, 17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115,
/* 0x0210 */  68,  1,219,115, 68,117,  9,139, 30,131,238,252, 17,219,115, 68,
/* 0x0220 */  65, 65,131,193,  2,129,253,  0,251,255,255,131,209,  1,137,242,
/* 0x0230 */ 141, 52, 47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,
/* 0x0240 */ 253,252,118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,
/* 0x0250 */ 255,255,139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,
/* 0x0260 */ 241,  1,207,233,252,255,255,255,235,  3,164,235,  3,138,  6, 70,
/* 0x0270 */ 136,  7, 71,  1,219,117,  7,139, 30,131,238,252, 17,219,114,  1,
/* 0x0280 */  49,192, 64,114,255,184,  1,  0,  0,  0,  1,219,117,  7,139, 30,
/* 0x0290 */ 131,238,252, 17,219, 17,192,  1,219,117,  7,139, 30,131,238,252,
/* 0x02a0 */  17,219,114, 30,  1,219,115, 11,117, 30,139, 30,131,238,252, 17,
/* 0x02b0 */ 219,114, 30, 72,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,
/* 0x02c0 */ 192,235,255,  1,219,117,  7,139, 30,131,238,252, 17,219, 17,201,
/* 0x02d0 */ 235,255, 49,201,131,232,  3,114, 17,193,224,  8,138,  6, 70,131,
/* 0x02e0 */ 240,255,116,255,209,248,137,197,235, 11,  1,219,117,  7,139, 30,
/* 0x02f0 */ 131,238,252, 17,219,114,204, 65,  1,219,117,  7,139, 30,131,238,
/* 0x0300 */ 252, 17,219,114,190,  1,219,117,  7,139, 30,131,238,252, 17,219,
/* 0x0310 */  17,201,  1,219,117,  7,139, 30,131,238,252, 17,219,115, 81,  1,
/* 0x0320 */ 219,115, 81,117,  9,139, 30,131,238,252, 17,219,115, 81, 65, 65,
/* 0x0330 */ 131,193,  2,129,253,  0,251,255,255,131,209,  2,137,242,141, 52,
/* 0x0340 */  47,243,164,137,214,233,252,255,255,255,141, 20, 47,131,253,252,
/* 0x0350 */ 118,255,138,  2, 66,136,  7, 71, 73,117,247,233,252,255,255,255,
/* 0x0360 */ 139,  2,131,194,  4,137,  7,131,199,  4,131,233,  4,119,241,  1,
/* 0x0370 */ 207,233,252,255,255,255,137,229,141,156, 36,  0,  0,  0,  0, 49,
/* 0x0380 */ 192, 80, 57,220,117,251, 70, 70, 83,104,  0,  0,  0,  0, 87,131,
/* 0x0390 */ 195,  4, 83,104,  0,  0,  0,  0, 86,131,195,  4, 83, 80,199,  3,
/* 0x03a0 */   0,  0,  0,  0,137,229,139, 85,  0,172, 74,136,193, 36,  7,192,
/* 0x03b0 */ 233,  3,187,  0,253,255,255,211,227,141,164, 92,144,241,255,255,
/* 0x03c0 */ 131,228,224,106,  0,106,  0,137,227, 83,131,195,  4,139, 77,  0,
/* 0x03d0 */ 255, 49, 87, 83,131,195,  4,136, 67,  2,172, 74,136,193, 36, 15,
/* 0x03e0 */ 136,  3,192,233,  4,136, 75,  1, 82, 86, 83, 80, 85, 87,191,  0,
/* 0x03f0 */   0,  0,  0, 86, 83,131,236,100,139, 84, 36,120,199, 68, 36, 92,
/* 0x0400 */   0,  0,  0,  0,141, 66,  4,137, 68, 36, 96,184,  1,  0,  0,  0,
/* 0x0410 */  15,182, 74,  2,137,195,211,227,137,217, 73,137, 76, 36, 88, 15,
/* 0x0420 */ 182, 74,  1,211,224,139,140, 36,144,  0,  0,  0, 72,137, 68, 36,
/* 0x0430 */  84,139,132, 36,132,  0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,
/* 0x0440 */   0,  0,  0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,199, 68,
/* 0x0450 */  36, 72,  1,  0,  0,  0,137,116, 36, 80,199, 68, 36, 68,  1,  0,
/* 0x0460 */   0,  0,199, 68, 36, 64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,
/* 0x0470 */   0,  0,199,  1,  0,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,
/* 0x0480 */ 141,136, 54,  7,  0,  0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,
/* 0x0490 */ 102,199,  0,  0,  4,131,192,  2,226,246,139,108, 36,124,199, 68,
/* 0x04a0 */  36, 48,  0,  0,  0,  0,199, 68, 36, 52,255,255,255,255,186,  0,
/* 0x04b0 */   0,  0,  0,137,235,  3,156, 36,128,  0,  0,  0,137, 92, 36, 56,
/* 0x04c0 */  59,108, 36, 56, 15,132,128,  8,  0,  0,193,100, 36, 48,  8, 66,
/* 0x04d0 */  15,182, 69,  0, 69,  9, 68, 36, 48,131,250,  4,126,226,139,180,
/* 0x04e0 */  36,140,  0,  0,  0, 57,116, 36, 92, 15,131,226,  1,  0,  0,139,
/* 0x04f0 */ 132, 36,136,  0,  0,  0,137, 68, 36, 24,139, 84, 36, 92, 35, 84,
/* 0x0500 */  36, 88,139, 68, 36, 76,139, 76, 36, 96,193,224,  4,137, 84, 36,
/* 0x0510 */  44,  1,208,129,124, 36, 52,255,255,255,  0,141, 52, 65,119, 29,
/* 0x0520 */  59,108, 36, 56, 15,132, 32,  8,  0,  0,193,100, 36, 48,  8,193,
/* 0x0530 */ 100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36,
/* 0x0540 */  52,102,139, 22,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x0550 */  48, 15,131, 80,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x0560 */  41,200,138, 76, 36, 80,193,248,  5,187,  1,  0,  0,  0,141,  4,
/* 0x0570 */   2,102,137,  6,139, 68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,
/* 0x0580 */ 211,224,137,249, 15,182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,
/* 0x0590 */ 211,250,  1,208,105,192,  0,  6,  0,  0,131,124, 36, 76,  6,141,
/* 0x05a0 */ 132, 48,108, 14,  0,  0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,
/* 0x05b0 */ 139, 68, 36, 92, 43, 68, 36, 72,139,148, 36,136,  0,  0,  0, 15,
/* 0x05c0 */ 182,  4, 16,137, 68, 36, 40,235, 46,137, 68, 36, 52,184,  0,  8,
/* 0x05d0 */   0,  0, 41,216,137,251,193,248,  5,133,210,141,  4,  1,102,137,
/* 0x05e0 */ 134,  0,  2,  0,  0, 15,133,106,  1,  0,  0,129,251,255,  0,  0,
/* 0x05f0 */   0, 15,143,143,  0,  0,  0,209,100, 36, 40,139, 84, 36, 40,141,
/* 0x0600 */  60, 27,139, 76, 36, 20,129,226,  0,  1,  0,  0,129,124, 36, 52,
/* 0x0610 */ 255,255,255,  0,141,  4, 81,141, 52, 56,119, 29, 59,108, 36, 56,
/* 0x0620 */  15,132, 36,  7,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x0630 */  15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,142,
/* 0x0640 */   0,  2,  0,  0,193,232, 11, 15,183,217, 15,175,195, 57, 68, 36,
/* 0x0650 */  48, 15,130,114,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,
/* 0x0660 */ 200,102,193,232,  5,141, 95,  1,102, 41,193,133,210,102,137,142,
/* 0x0670 */   0,  2,  0,  0, 15,132,219,  0,  0,  0,129,251,255,  0,  0,  0,
/* 0x0680 */  15,142,113,255,255,255,139, 84, 36, 24,137,223,136, 26, 66,255,
/* 0x0690 */  68, 36, 92,131,124, 36, 76,  3,137, 84, 36, 24, 15,143,215,  0,
/* 0x06a0 */   0,  0,199, 68, 36, 76,  0,  0,  0,  0,139,132, 36,140,  0,  0,
/* 0x06b0 */   0, 57, 68, 36, 92, 15,130, 63,254,255,255,129,124, 36, 52,255,
/* 0x06c0 */ 255,255,  0,119, 12, 59,108, 36, 56,184,  1,  0,  0,  0,116, 32,
/* 0x06d0 */  69, 43,108, 36,124,184,  0,  0,  0,  0,139,148, 36,132,  0,  0,
/* 0x06e0 */   0,139, 92, 36, 92,139,140, 36,144,  0,  0,  0,137, 42,137, 25,
/* 0x06f0 */ 131,196,100,233, 46,  8,  0,  0,129,124, 36, 52,255,255,255,  0,
/* 0x0700 */ 141, 52, 27,139, 68, 36, 20,141, 28,  6,119, 29, 59,108, 36, 56,
/* 0x0710 */  15,132, 52,  6,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8,
/* 0x0720 */  15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 11,
/* 0x0730 */ 193,232, 11, 15,183,209, 15,175,194, 57, 68, 36, 48,115, 79,137,
/* 0x0740 */  68, 36, 52,184,  0,  8,  0,  0, 41,208,193,248,  5,141,  4,  1,
/* 0x0750 */ 102,137,  3,137,243,129,251,255,  0,  0,  0,126,155,139, 84, 36,
/* 0x0760 */  24,137,223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137,
/* 0x0770 */  84, 36, 24, 15,142, 41,255,255,255,131,124, 36, 76,  9, 15,143,
/* 0x0780 */ 107,  6,  0,  0,131,108, 36, 76,  3,233, 28,255,255,255, 41, 68,
/* 0x0790 */  36, 52, 41, 68, 36, 48,137,200,102,193,232,  5,102, 41,193,102,
/* 0x07a0 */ 137, 11,141, 94,  1,235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,
/* 0x07b0 */ 195,137,208,102,193,232,  5,139, 76, 36, 76,102, 41,194,129,251,
/* 0x07c0 */ 255,255,255,  0,102,137, 22,139,116, 36, 96,141, 60, 78,119, 27,
/* 0x07d0 */  59,108, 36, 56, 15,132,112,  5,  0,  0,193,100, 36, 48,  8, 15,
/* 0x07e0 */ 182, 69,  0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,128,  1,
/* 0x07f0 */   0,  0,137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36,
/* 0x0800 */  48, 15,131,228,  2,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,
/* 0x0810 */ 139, 92, 36, 96,193,248,  5,131,124, 36, 76,  6,141,  4,  2,139,
/* 0x0820 */  76, 36, 72,139, 84, 36, 68,102,137,135,128,  1,  0,  0,139, 68,
/* 0x0830 */  36, 64,137, 76, 36, 68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,
/* 0x0840 */ 159,192,137, 84, 36, 64,141,  4, 64,129,195,100,  6,  0,  0,137,
/* 0x0850 */  68, 36, 76,129,254,255,255,255,  0,119, 27, 59,108, 36, 56, 15,
/* 0x0860 */ 132,229,  4,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,
/* 0x0870 */   8,  9, 68, 36, 48, 69,102,139, 19,137,240,193,232, 11, 15,183,
/* 0x0880 */ 202, 15,175,193, 57, 68, 36, 48, 15,131,102,  3,  0,  0,137, 68,
/* 0x0890 */  36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,
/* 0x08a0 */   5,139, 76, 36, 44,141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,
/* 0x08b0 */ 102,137,  3,141, 92, 25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,
/* 0x08c0 */   0,  0,  0,139,124, 36, 36,186,  1,  0,  0,  0,235, 25,137, 68,
/* 0x08d0 */  36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,
/* 0x08e0 */ 137,242,102,137,  3,116, 97,129,124, 36, 52,255,255,255,  0,141,
/* 0x08f0 */  52, 18,139, 68, 36, 16,141, 28,  6,119, 29, 59,108, 36, 56, 15,
/* 0x0900 */ 132, 69,  4,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,
/* 0x0910 */ 182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,
/* 0x0920 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68,
/* 0x0930 */  36, 52, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,
/* 0x0940 */ 102,137, 19,141, 86,  1,117,159,138, 76, 36, 36,184,  1,  0,  0,
/* 0x0950 */   0,211,224, 41,194,  3, 84, 36, 32,131,124, 36, 76,  3,137, 84,
/* 0x0960 */  36, 12, 15,143,254,  3,  0,  0,131, 68, 36, 76,  7,131,250,  3,
/* 0x0970 */ 137,208,126,  5,184,  3,  0,  0,  0,139, 92, 36, 96,193,224,  7,
/* 0x0980 */ 191,  6,  0,  0,  0,141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,
/* 0x0990 */ 184,  1,  0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x09a0 */  41,200,193,248,  5, 79,141,  4,  2,102,137,  3,137,240,116, 97,
/* 0x09b0 */ 129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 68, 36,  8,141,
/* 0x09c0 */  28,  6,119, 29, 59,108, 36, 56, 15,132,124,  3,  0,  0,193,100,
/* 0x09d0 */  36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36,
/* 0x09e0 */  48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,
/* 0x09f0 */ 193, 57, 68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,
/* 0x0a00 */ 208,102,193,232,  5,102, 41,194, 79,102,137, 19,141, 70,  1,117,
/* 0x0a10 */ 159,141, 80,192,131,250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,
/* 0x0a20 */   0,137,211,137,208,131,227,  1,209,248,131,203,  2,131,250, 13,
/* 0x0a30 */ 141,120,255, 15,143, 66,  4,  0,  0,137,249,139,116, 36, 96,211,
/* 0x0a40 */ 227,  1,210,141,  4, 94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,
/* 0x0a50 */   0,137,  4, 36,184,  1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,
/* 0x0a60 */   0,235, 33,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,
/* 0x0a70 */   5,141,  4,  2,102,137,  3,137,240,209,100, 36, 28, 79, 15,132,
/* 0x0a80 */ 211,  2,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52,  0,139,
/* 0x0a90 */  12, 36,141, 28, 14,119, 29, 59,108, 36, 56, 15,132,169,  2,  0,
/* 0x0aa0 */   0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,
/* 0x0ab0 */   9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,
/* 0x0ac0 */ 202, 15,175,193, 57, 68, 36, 48,114,153, 41, 68, 36, 52, 41, 68,
/* 0x0ad0 */  36, 48,137,208,102,193,232,  5,102, 41,194,141, 70,  1,102,137,
/* 0x0ae0 */  19,139, 92, 36, 28,  9, 92, 36,  4,235,142, 41,195, 41, 68, 36,
/* 0x0af0 */  48,137,208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,
/* 0x0b00 */ 102,137,151,128,  1,  0,  0, 15,134,107,  1,  0,  0,102,139,143,
/* 0x0b10 */ 152,  1,  0,  0,137,218,193,234, 11, 15,183,193, 15,175,208, 57,
/* 0x0b20 */  84, 36, 48, 15,131,134,  1,  0,  0,190,  0,  8,  0,  0,137,211,
/* 0x0b30 */  41,198,137,240,193,248,  5,141,  4,  1,139, 76, 36, 44,102,137,
/* 0x0b40 */ 135,152,  1,  0,  0,139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,
/* 0x0b50 */ 129,250,255,255,255,  0,141, 60, 72,119, 27, 59,108, 36, 56, 15,
/* 0x0b60 */ 132,229,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,
/* 0x0b70 */   8,  9, 68, 36, 48, 69,102,139,151,224,  1,  0,  0,137,216,193,
/* 0x0b80 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,103,  2,
/* 0x0b90 */   0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x0ba0 */ 141,  4,  2,102,137,135,224,  1,  0,  0,139, 68, 36, 92,133,192,
/* 0x0bb0 */  15,132,148,  1,  0,  0,131,124, 36, 76,  6,184,  0,  0,  0,  0,
/* 0x0bc0 */ 139,156, 36,136,  0,  0,  0,139, 84, 36, 24, 15,159,192,141, 68,
/* 0x0bd0 */   0,  9,137, 68, 36, 76,139, 68, 36, 92, 43, 68, 36, 72, 15,182,
/* 0x0be0 */  60, 24,137,248,136,  2, 66,255, 68, 36, 92,137, 84, 36, 24,233,
/* 0x0bf0 */ 182,250,255,255, 41,198, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x0c00 */ 102, 41,194,129,254,255,255,255,  0,102,137, 19,119, 27, 59,108,
/* 0x0c10 */  36, 56, 15,132, 50,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x0c20 */   0,193,230,  8,  9, 68, 36, 48, 69,102,139, 83,  2,137,240,193,
/* 0x0c30 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,119,  1,
/* 0x0c40 */   0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36,
/* 0x0c50 */  44,  4,193,248,  5,139,116, 36, 44,141,  4,  2,199, 68, 36, 32,
/* 0x0c60 */   8,  0,  0,  0,102,137, 67,  2,141,156, 30,  4,  1,  0,  0,137,
/* 0x0c70 */  92, 36, 16,233, 67,252,255,255, 59,108, 36, 56, 15,132,200,  0,
/* 0x0c80 */   0,  0,193,100, 36, 48,  8,193,227,  8,102,139,143,152,  1,  0,
/* 0x0c90 */   0, 15,182, 69,  0,137,218,  9, 68, 36, 48,193,234, 11, 15,183,
/* 0x0ca0 */ 193, 69, 15,175,208, 57, 84, 36, 48, 15,130,122,254,255,255,137,
/* 0x0cb0 */ 200, 41,211,102,193,232,  5, 41, 84, 36, 48,102, 41,193,129,251,
/* 0x0cc0 */ 255,255,255,  0,102,137,143,152,  1,  0,  0,119, 23, 59,108, 36,
/* 0x0cd0 */  56,116,119,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9,
/* 0x0ce0 */  68, 36, 48, 69,102,139,151,176,  1,  0,  0,137,216,193,232, 11,
/* 0x0cf0 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,
/* 0x0d00 */ 137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,
/* 0x0d10 */ 137,135,176,  1,  0,  0,139, 68, 36, 68,139, 84, 36, 72,137, 68,
/* 0x0d20 */  36, 72,137, 84, 36, 68,131,124, 36, 76,  6,184,  0,  0,  0,  0,
/* 0x0d30 */ 139, 92, 36, 96, 15,159,192,129,195,104, 10,  0,  0,141, 68, 64,
/* 0x0d40 */   8,137, 68, 36, 76,233,  9,251,255,255,131,196,100,184,  1,  0,
/* 0x0d50 */   0,  0,233,207,  1,  0,  0,139,116, 36,  4, 70,137,116, 36, 72,
/* 0x0d60 */  15,132, 85,249,255,255,139, 76, 36, 12,139, 68, 36, 92,131,193,
/* 0x0d70 */   2, 57, 68, 36, 72,119,211,137,194,139,132, 36,136,  0,  0,  0,
/* 0x0d80 */  43, 68, 36, 72,  3,148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,
/* 0x0d90 */ 182, 56, 64,137,251,136, 26, 66,255, 68, 36, 92,255, 68, 36, 24,
/* 0x0da0 */  73, 15,132,  3,249,255,255,139,180, 36,140,  0,  0,  0, 57,116,
/* 0x0db0 */  36, 92,114,219,233,  2,249,255,255, 41,198, 41, 68, 36, 48,137,
/* 0x0dc0 */ 208,137,116, 36, 52,102,193,232,  5,199, 68, 36, 32, 16,  0,  0,
/* 0x0dd0 */   0,102, 41,194,199, 68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,
/* 0x0de0 */ 129,195,  4,  2,  0,  0,137, 92, 36, 16,233,212,250,255,255,131,
/* 0x0df0 */ 108, 36, 76,  6,233,177,248,255,255,137,222, 41, 68, 36, 48, 41,
/* 0x0e00 */ 198,137,208,102,193,232,  5,102, 41,194,102,137,151,224,  1,  0,
/* 0x0e10 */   0,233, 16,255,255,255, 41,195, 41, 68, 36, 48,137,208,102,193,
/* 0x0e20 */ 232,  5,102, 41,194,129,251,255,255,255,  0,102,137,151,176,  1,
/* 0x0e30 */   0,  0, 15,134,165,  0,  0,  0,102,139,151,200,  1,  0,  0,137,
/* 0x0e40 */ 216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,
/* 0x0e50 */ 169,  0,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,
/* 0x0e60 */ 141,  4,  2,102,137,135,200,  1,  0,  0,139, 68, 36, 64,139, 92,
/* 0x0e70 */  36, 68,137, 92, 36, 64,233,159,254,255,255,141, 80,251,129,124,
/* 0x0e80 */  36, 52,255,255,255,  0,119, 29, 59,108, 36, 56, 15,132,184,254,
/* 0x0e90 */ 255,255,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0,
/* 0x0ea0 */  69,  9, 68, 36, 48,209,108, 36, 52,  1,219,139, 68, 36, 52, 57,
/* 0x0eb0 */  68, 36, 48,114,  7, 41, 68, 36, 48,131,203,  1, 74,117,191,139,
/* 0x0ec0 */  84, 36, 96,193,227,  4,191,  4,  0,  0,  0,137, 92, 36,  4,129,
/* 0x0ed0 */ 194, 68,  6,  0,  0,137, 20, 36,233,119,251,255,255, 59,108, 36,
/* 0x0ee0 */  56, 15,132, 99,254,255,255,193,100, 36, 48,  8, 15,182, 69,  0,
/* 0x0ef0 */ 193,227,  8,  9, 68, 36, 48, 69,233, 59,255,255,255,137,222, 41,
/* 0x0f00 */  68, 36, 48, 41,198,137,208,102,193,232,  5,139, 76, 36, 64,102,
/* 0x0f10 */  41,194,139, 68, 36, 60,102,137,151,200,  1,  0,  0,137, 76, 36,
/* 0x0f20 */  60,233, 72,255,255,255, 91, 94, 95, 93, 85, 87,191,  0,  0,  0,
/* 0x0f30 */   0, 86, 83,131,236,100,139, 84, 36,120,199, 68, 36, 92,  0,  0,
/* 0x0f40 */   0,  0,141, 66,  4,137, 68, 36, 96,184,  1,  0,  0,  0, 15,182,
/* 0x0f50 */  74,  2,137,195,211,227,137,217, 73,137, 76, 36, 88, 15,182, 74,
/* 0x0f60 */   1,211,224,139,140, 36,144,  0,  0,  0, 72,137, 68, 36, 84,139,
/* 0x0f70 */ 132, 36,132,  0,  0,  0, 15,182, 50,199, 68, 36, 76,  0,  0,  0,
/* 0x0f80 */   0,199,  0,  0,  0,  0,  0,184,  0,  3,  0,  0,199, 68, 36, 72,
/* 0x0f90 */   1,  0,  0,  0,137,116, 36, 80,199, 68, 36, 68,  1,  0,  0,  0,
/* 0x0fa0 */ 199, 68, 36, 64,  1,  0,  0,  0,199, 68, 36, 60,  1,  0,  0,  0,
/* 0x0fb0 */ 199,  1,  0,  0,  0,  0, 15,182, 74,  1,  1,241,211,224,141,136,
/* 0x0fc0 */  54,  7,  0,  0, 57, 76, 36, 92,115, 14,139, 68, 36, 96,102,199,
/* 0x0fd0 */   0,  0,  4,131,192,  2,226,246,139,108, 36,124,199, 68, 36, 48,
/* 0x0fe0 */   0,  0,  0,  0,199, 68, 36, 52,255,255,255,255,186,  0,  0,  0,
/* 0x0ff0 */   0,137,235,  3,156, 36,128,  0,  0,  0,137, 92, 36, 56, 59,108,
/* 0x1000 */  36, 56, 15,132,128,  8,  0,  0,193,100, 36, 48,  8, 66, 15,182,
/* 0x1010 */  69,  0, 69,  9, 68, 36, 48,131,250,  4,126,226,139,180, 36,140,
/* 0x1020 */   0,  0,  0, 57,116, 36, 92, 15,131,226,  1,  0,  0,139,132, 36,
/* 0x1030 */ 136,  0,  0,  0,137, 68, 36, 24,139, 84, 36, 92, 35, 84, 36, 88,
/* 0x1040 */ 139, 68, 36, 76,139, 76, 36, 96,193,224,  4,137, 84, 36, 44,  1,
/* 0x1050 */ 208,129,124, 36, 52,255,255,255,  0,141, 52, 65,119, 29, 59,108,
/* 0x1060 */  36, 56, 15,132, 32,  8,  0,  0,193,100, 36, 48,  8,193,100, 36,
/* 0x1070 */  52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,
/* 0x1080 */ 139, 22,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x1090 */ 131, 80,  2,  0,  0,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x10a0 */ 138, 76, 36, 80,193,248,  5,187,  1,  0,  0,  0,141,  4,  2,102,
/* 0x10b0 */ 137,  6,139, 68, 36, 92, 35, 68, 36, 84,139,116, 36, 96,211,224,
/* 0x10c0 */ 137,249, 15,182,209,185,  8,  0,  0,  0, 43, 76, 36, 80,211,250,
/* 0x10d0 */   1,208,105,192,  0,  6,  0,  0,131,124, 36, 76,  6,141,132, 48,
/* 0x10e0 */ 108, 14,  0,  0,137, 68, 36, 20, 15,142, 72,  1,  0,  0,139, 68,
/* 0x10f0 */  36, 92, 43, 68, 36, 72,139,148, 36,136,  0,  0,  0, 15,182,  4,
/* 0x1100 */  16,137, 68, 36, 40,235, 46,137, 68, 36, 52,184,  0,  8,  0,  0,
/* 0x1110 */  41,216,137,251,193,248,  5,133,210,141,  4,  1,102,137,134,  0,
/* 0x1120 */   2,  0,  0, 15,133,106,  1,  0,  0,129,251,255,  0,  0,  0, 15,
/* 0x1130 */ 143,143,  0,  0,  0,209,100, 36, 40,139, 84, 36, 40,141, 60, 27,
/* 0x1140 */ 139, 76, 36, 20,129,226,  0,  1,  0,  0,129,124, 36, 52,255,255,
/* 0x1150 */ 255,  0,141,  4, 81,141, 52, 56,119, 29, 59,108, 36, 56, 15,132,
/* 0x1160 */  36,  7,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x1170 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139,142,  0,  2,
/* 0x1180 */   0,  0,193,232, 11, 15,183,217, 15,175,195, 57, 68, 36, 48, 15,
/* 0x1190 */ 130,114,255,255,255, 41, 68, 36, 52, 41, 68, 36, 48,137,200,102,
/* 0x11a0 */ 193,232,  5,141, 95,  1,102, 41,193,133,210,102,137,142,  0,  2,
/* 0x11b0 */   0,  0, 15,132,219,  0,  0,  0,129,251,255,  0,  0,  0, 15,142,
/* 0x11c0 */ 113,255,255,255,139, 84, 36, 24,137,223,136, 26, 66,255, 68, 36,
/* 0x11d0 */  92,131,124, 36, 76,  3,137, 84, 36, 24, 15,143,215,  0,  0,  0,
/* 0x11e0 */ 199, 68, 36, 76,  0,  0,  0,  0,139,132, 36,140,  0,  0,  0, 57,
/* 0x11f0 */  68, 36, 92, 15,130, 63,254,255,255,129,124, 36, 52,255,255,255,
/* 0x1200 */   0,119, 12, 59,108, 36, 56,184,  1,  0,  0,  0,116, 32, 69, 43,
/* 0x1210 */ 108, 36,124,184,  0,  0,  0,  0,139,148, 36,132,  0,  0,  0,139,
/* 0x1220 */  92, 36, 92,139,140, 36,144,  0,  0,  0,137, 42,137, 25,131,196,
/* 0x1230 */ 100,233, 46,  8,  0,  0,129,124, 36, 52,255,255,255,  0,141, 52,
/* 0x1240 */  27,139, 68, 36, 20,141, 28,  6,119, 29, 59,108, 36, 56, 15,132,
/* 0x1250 */  52,  6,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182,
/* 0x1260 */  69,  0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 11,193,232,
/* 0x1270 */  11, 15,183,209, 15,175,194, 57, 68, 36, 48,115, 79,137, 68, 36,
/* 0x1280 */  52,184,  0,  8,  0,  0, 41,208,193,248,  5,141,  4,  1,102,137,
/* 0x1290 */   3,137,243,129,251,255,  0,  0,  0,126,155,139, 84, 36, 24,137,
/* 0x12a0 */ 223,136, 26, 66,255, 68, 36, 92,131,124, 36, 76,  3,137, 84, 36,
/* 0x12b0 */  24, 15,142, 41,255,255,255,131,124, 36, 76,  9, 15,143,107,  6,
/* 0x12c0 */   0,  0,131,108, 36, 76,  3,233, 28,255,255,255, 41, 68, 36, 52,
/* 0x12d0 */  41, 68, 36, 48,137,200,102,193,232,  5,102, 41,193,102,137, 11,
/* 0x12e0 */ 141, 94,  1,235,174,139, 92, 36, 52, 41, 68, 36, 48, 41,195,137,
/* 0x12f0 */ 208,102,193,232,  5,139, 76, 36, 76,102, 41,194,129,251,255,255,
/* 0x1300 */ 255,  0,102,137, 22,139,116, 36, 96,141, 60, 78,119, 27, 59,108,
/* 0x1310 */  36, 56, 15,132,112,  5,  0,  0,193,100, 36, 48,  8, 15,182, 69,
/* 0x1320 */   0,193,227,  8,  9, 68, 36, 48, 69,102,139,151,128,  1,  0,  0,
/* 0x1330 */ 137,216,193,232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,
/* 0x1340 */ 131,228,  2,  0,  0,137,198,184,  0,  8,  0,  0, 41,200,139, 92,
/* 0x1350 */  36, 96,193,248,  5,131,124, 36, 76,  6,141,  4,  2,139, 76, 36,
/* 0x1360 */  72,139, 84, 36, 68,102,137,135,128,  1,  0,  0,139, 68, 36, 64,
/* 0x1370 */ 137, 76, 36, 68,137, 68, 36, 60,184,  0,  0,  0,  0, 15,159,192,
/* 0x1380 */ 137, 84, 36, 64,141,  4, 64,129,195,100,  6,  0,  0,137, 68, 36,
/* 0x1390 */  76,129,254,255,255,255,  0,119, 27, 59,108, 36, 56, 15,132,229,
/* 0x13a0 */   4,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,230,  8,  9,
/* 0x13b0 */  68, 36, 48, 69,102,139, 19,137,240,193,232, 11, 15,183,202, 15,
/* 0x13c0 */ 175,193, 57, 68, 36, 48, 15,131,102,  3,  0,  0,137, 68, 36, 52,
/* 0x13d0 */ 184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,193,248,  5,139,
/* 0x13e0 */  76, 36, 44,141,  4,  2,199, 68, 36, 32,  0,  0,  0,  0,102,137,
/* 0x13f0 */   3,141, 92, 25,  4,137, 92, 36, 16,199, 68, 36, 36,  3,  0,  0,
/* 0x1400 */   0,139,124, 36, 36,186,  1,  0,  0,  0,235, 25,137, 68, 36, 52,
/* 0x1410 */ 184,  0,  8,  0,  0, 41,200,193,248,  5, 79,141,  4,  2,137,242,
/* 0x1420 */ 102,137,  3,116, 97,129,124, 36, 52,255,255,255,  0,141, 52, 18,
/* 0x1430 */ 139, 68, 36, 16,141, 28,  6,119, 29, 59,108, 36, 56, 15,132, 69,
/* 0x1440 */   4,  0,  0,193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,
/* 0x1450 */   0, 69,  9, 68, 36, 48,139, 68, 36, 52,102,139, 19,193,232, 11,
/* 0x1460 */  15,183,202, 15,175,193, 57, 68, 36, 48,114,160, 41, 68, 36, 52,
/* 0x1470 */  41, 68, 36, 48,137,208,102,193,232,  5,102, 41,194, 79,102,137,
/* 0x1480 */  19,141, 86,  1,117,159,138, 76, 36, 36,184,  1,  0,  0,  0,211,
/* 0x1490 */ 224, 41,194,  3, 84, 36, 32,131,124, 36, 76,  3,137, 84, 36, 12,
/* 0x14a0 */  15,143,254,  3,  0,  0,131, 68, 36, 76,  7,131,250,  3,137,208,
/* 0x14b0 */ 126,  5,184,  3,  0,  0,  0,139, 92, 36, 96,193,224,  7,191,  6,
/* 0x14c0 */   0,  0,  0,141,132, 24, 96,  3,  0,  0,137, 68, 36,  8,184,  1,
/* 0x14d0 */   0,  0,  0,235, 25,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,
/* 0x14e0 */ 193,248,  5, 79,141,  4,  2,102,137,  3,137,240,116, 97,129,124,
/* 0x14f0 */  36, 52,255,255,255,  0,141, 52,  0,139, 68, 36,  8,141, 28,  6,
/* 0x1500 */ 119, 29, 59,108, 36, 56, 15,132,124,  3,  0,  0,193,100, 36, 48,
/* 0x1510 */   8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68, 36, 48,139,
/* 0x1520 */  68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,175,193, 57,
/* 0x1530 */  68, 36, 48,114,160, 41, 68, 36, 52, 41, 68, 36, 48,137,208,102,
/* 0x1540 */ 193,232,  5,102, 41,194, 79,102,137, 19,141, 70,  1,117,159,141,
/* 0x1550 */  80,192,131,250,  3,137, 84, 36,  4, 15,142, 54,  3,  0,  0,137,
/* 0x1560 */ 211,137,208,131,227,  1,209,248,131,203,  2,131,250, 13,141,120,
/* 0x1570 */ 255, 15,143, 66,  4,  0,  0,137,249,139,116, 36, 96,211,227,  1,
/* 0x1580 */ 210,141,  4, 94,137, 92, 36,  4, 41,208,  5, 94,  5,  0,  0,137,
/* 0x1590 */   4, 36,184,  1,  0,  0,  0,199, 68, 36, 28,  1,  0,  0,  0,235,
/* 0x15a0 */  33,137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,
/* 0x15b0 */   4,  2,102,137,  3,137,240,209,100, 36, 28, 79, 15,132,211,  2,
/* 0x15c0 */   0,  0,129,124, 36, 52,255,255,255,  0,141, 52,  0,139, 12, 36,
/* 0x15d0 */ 141, 28, 14,119, 29, 59,108, 36, 56, 15,132,169,  2,  0,  0,193,
/* 0x15e0 */ 100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9, 68,
/* 0x15f0 */  36, 48,139, 68, 36, 52,102,139, 19,193,232, 11, 15,183,202, 15,
/* 0x1600 */ 175,193, 57, 68, 36, 48,114,153, 41, 68, 36, 52, 41, 68, 36, 48,
/* 0x1610 */ 137,208,102,193,232,  5,102, 41,194,141, 70,  1,102,137, 19,139,
/* 0x1620 */  92, 36, 28,  9, 92, 36,  4,235,142, 41,195, 41, 68, 36, 48,137,
/* 0x1630 */ 208,102,193,232,  5,102, 41,194,129,251,255,255,255,  0,102,137,
/* 0x1640 */ 151,128,  1,  0,  0, 15,134,107,  1,  0,  0,102,139,143,152,  1,
/* 0x1650 */   0,  0,137,218,193,234, 11, 15,183,193, 15,175,208, 57, 84, 36,
/* 0x1660 */  48, 15,131,134,  1,  0,  0,190,  0,  8,  0,  0,137,211, 41,198,
/* 0x1670 */ 137,240,193,248,  5,141,  4,  1,139, 76, 36, 44,102,137,135,152,
/* 0x1680 */   1,  0,  0,139, 68, 36, 76,193,224,  5,  3, 68, 36, 96,129,250,
/* 0x1690 */ 255,255,255,  0,141, 60, 72,119, 27, 59,108, 36, 56, 15,132,229,
/* 0x16a0 */   1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9,
/* 0x16b0 */  68, 36, 48, 69,102,139,151,224,  1,  0,  0,137,216,193,232, 11,
/* 0x16c0 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,103,  2,  0,  0,
/* 0x16d0 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x16e0 */   2,102,137,135,224,  1,  0,  0,139, 68, 36, 92,133,192, 15,132,
/* 0x16f0 */ 148,  1,  0,  0,131,124, 36, 76,  6,184,  0,  0,  0,  0,139,156,
/* 0x1700 */  36,136,  0,  0,  0,139, 84, 36, 24, 15,159,192,141, 68,  0,  9,
/* 0x1710 */ 137, 68, 36, 76,139, 68, 36, 92, 43, 68, 36, 72, 15,182, 60, 24,
/* 0x1720 */ 137,248,136,  2, 66,255, 68, 36, 92,137, 84, 36, 24,233,182,250,
/* 0x1730 */ 255,255, 41,198, 41, 68, 36, 48,137,208,102,193,232,  5,102, 41,
/* 0x1740 */ 194,129,254,255,255,255,  0,102,137, 19,119, 27, 59,108, 36, 56,
/* 0x1750 */  15,132, 50,  1,  0,  0,193,100, 36, 48,  8, 15,182, 69,  0,193,
/* 0x1760 */ 230,  8,  9, 68, 36, 48, 69,102,139, 83,  2,137,240,193,232, 11,
/* 0x1770 */  15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,119,  1,  0,  0,
/* 0x1780 */ 137, 68, 36, 52,184,  0,  8,  0,  0, 41,200,193,100, 36, 44,  4,
/* 0x1790 */ 193,248,  5,139,116, 36, 44,141,  4,  2,199, 68, 36, 32,  8,  0,
/* 0x17a0 */   0,  0,102,137, 67,  2,141,156, 30,  4,  1,  0,  0,137, 92, 36,
/* 0x17b0 */  16,233, 67,252,255,255, 59,108, 36, 56, 15,132,200,  0,  0,  0,
/* 0x17c0 */ 193,100, 36, 48,  8,193,227,  8,102,139,143,152,  1,  0,  0, 15,
/* 0x17d0 */ 182, 69,  0,137,218,  9, 68, 36, 48,193,234, 11, 15,183,193, 69,
/* 0x17e0 */  15,175,208, 57, 84, 36, 48, 15,130,122,254,255,255,137,200, 41,
/* 0x17f0 */ 211,102,193,232,  5, 41, 84, 36, 48,102, 41,193,129,251,255,255,
/* 0x1800 */ 255,  0,102,137,143,152,  1,  0,  0,119, 23, 59,108, 36, 56,116,
/* 0x1810 */ 119,193,100, 36, 48,  8, 15,182, 69,  0,193,227,  8,  9, 68, 36,
/* 0x1820 */  48, 69,102,139,151,176,  1,  0,  0,137,216,193,232, 11, 15,183,
/* 0x1830 */ 202, 15,175,193, 57, 68, 36, 48, 15,131, 22,  1,  0,  0,137,198,
/* 0x1840 */ 184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,  2,102,137,135,
/* 0x1850 */ 176,  1,  0,  0,139, 68, 36, 68,139, 84, 36, 72,137, 68, 36, 72,
/* 0x1860 */ 137, 84, 36, 68,131,124, 36, 76,  6,184,  0,  0,  0,  0,139, 92,
/* 0x1870 */  36, 96, 15,159,192,129,195,104, 10,  0,  0,141, 68, 64,  8,137,
/* 0x1880 */  68, 36, 76,233,  9,251,255,255,131,196,100,184,  1,  0,  0,  0,
/* 0x1890 */ 233,207,  1,  0,  0,139,116, 36,  4, 70,137,116, 36, 72, 15,132,
/* 0x18a0 */  85,249,255,255,139, 76, 36, 12,139, 68, 36, 92,131,193,  2, 57,
/* 0x18b0 */  68, 36, 72,119,211,137,194,139,132, 36,136,  0,  0,  0, 43, 68,
/* 0x18c0 */  36, 72,  3,148, 36,136,  0,  0,  0,  3, 68, 36, 92, 15,182, 56,
/* 0x18d0 */  64,137,251,136, 26, 66,255, 68, 36, 92,255, 68, 36, 24, 73, 15,
/* 0x18e0 */ 132,  3,249,255,255,139,180, 36,140,  0,  0,  0, 57,116, 36, 92,
/* 0x18f0 */ 114,219,233,  2,249,255,255, 41,198, 41, 68, 36, 48,137,208,137,
/* 0x1900 */ 116, 36, 52,102,193,232,  5,199, 68, 36, 32, 16,  0,  0,  0,102,
/* 0x1910 */  41,194,199, 68, 36, 36,  8,  0,  0,  0,102,137, 83,  2,129,195,
/* 0x1920 */   4,  2,  0,  0,137, 92, 36, 16,233,212,250,255,255,131,108, 36,
/* 0x1930 */  76,  6,233,177,248,255,255,137,222, 41, 68, 36, 48, 41,198,137,
/* 0x1940 */ 208,102,193,232,  5,102, 41,194,102,137,151,224,  1,  0,  0,233,
/* 0x1950 */  16,255,255,255, 41,195, 41, 68, 36, 48,137,208,102,193,232,  5,
/* 0x1960 */ 102, 41,194,129,251,255,255,255,  0,102,137,151,176,  1,  0,  0,
/* 0x1970 */  15,134,165,  0,  0,  0,102,139,151,200,  1,  0,  0,137,216,193,
/* 0x1980 */ 232, 11, 15,183,202, 15,175,193, 57, 68, 36, 48, 15,131,169,  0,
/* 0x1990 */   0,  0,137,198,184,  0,  8,  0,  0, 41,200,193,248,  5,141,  4,
/* 0x19a0 */   2,102,137,135,200,  1,  0,  0,139, 68, 36, 64,139, 92, 36, 68,
/* 0x19b0 */ 137, 92, 36, 64,233,159,254,255,255,141, 80,251,129,124, 36, 52,
/* 0x19c0 */ 255,255,255,  0,119, 29, 59,108, 36, 56, 15,132,184,254,255,255,
/* 0x19d0 */ 193,100, 36, 48,  8,193,100, 36, 52,  8, 15,182, 69,  0, 69,  9,
/* 0x19e0 */  68, 36, 48,209,108, 36, 52,  1,219,139, 68, 36, 52, 57, 68, 36,
/* 0x19f0 */  48,114,  7, 41, 68, 36, 48,131,203,  1, 74,117,191,139, 84, 36,
/* 0x1a00 */  96,193,227,  4,191,  4,  0,  0,  0,137, 92, 36,  4,129,194, 68,
/* 0x1a10 */   6,  0,  0,137, 20, 36,233,119,251,255,255, 59,108, 36, 56, 15,
/* 0x1a20 */ 132, 99,254,255,255,193,100, 36, 48,  8, 15,182, 69,  0,193,227,
/* 0x1a30 */   8,  9, 68, 36, 48, 69,233, 59,255,255,255,137,222, 41, 68, 36,
/* 0x1a40 */  48, 41,198,137,208,102,193,232,  5,139, 76, 36, 64,102, 41,194,
/* 0x1a50 */ 139, 68, 36, 60,102,137,151,200,  1,  0,  0,137, 76, 36, 60,233,
/* 0x1a60 */  72,255,255,255, 91, 94, 95, 93,  3,115,252,  3,123,248, 49,192,
/* 0x1a70 */ 141,140, 36,  0,255,255,255,137,236, 80, 57,204,117,251,137,236,
/* 0x1a80 */  49,201, 94, 95, 88,137,  7,141,190,  0,  0,  0,  0,137,247,185,
/* 0x1a90 */   0,  0,  0,  0,138,  7, 71, 44,232, 60,  1,119,247,128, 63,  0,
/* 0x1aa0 */ 117,  4,139,  7,138, 95,  4,102,193,232,  8,134,196,193,192, 16,
/* 0x1ab0 */ 134,196, 41,248,128,235,232,  1,240,137,  7,131,199,  5,136,216,
/* 0x1ac0 */ 226,  9,185,  0,  0,  0,  0,176,232,176,233,242,174,117,  6,128,
/* 0x1ad0 */  63,  0,117,255,139,  7,102,193,232,  8,134,196,193,192, 16,134,
/* 0x1ae0 */ 196, 41,248,  1,240,171,235,  4,185,  0,  0,  0,  0,235, 31,138,
/* 0x1af0 */   7, 71, 60,128,114, 10, 60,143,119,  6,128,127,254, 15,116,  5,
/* 0x1b00 */  44,232, 60,  1,119,255,131,249,  4,114,  4,139,  7, 44,  0,117,
/* 0x1b10 */ 255,134,196,193,192, 16,134,196, 41,248,  1,240,131,233,  4,171,
/* 0x1b20 */ 131,233,  1,114,  4,138,  7, 71,235, 13,131,233,  1,115,  6,141,
/* 0x1b30 */ 190,  0,  0,  0,  0,139,  7,  9,192,116,255,139, 95,  4,141,132,
/* 0x1b40 */  48,  0,  0,  0,  0,  1,243, 80,131,199,  8,255,150,  0,  0,  0,
/* 0x1b50 */   0,149,138,  7, 71,  8,192,116,220,137,249,121,  6,122, 14,139,
/* 0x1b60 */   7,131,199,  4,139,132, 48,  0,  0,  0,  0,235, 14, 15,183,  7,
/* 0x1b70 */  71, 80, 71,185, 87, 72,242,174, 85,255,150,  0,  0,  0,  0,  9,
/* 0x1b80 */ 192,116,  7,137,  3,131,195,  4,235, 34, 97, 49,192,194, 12,  0,
/* 0x1b90 */ 255,150,  0,  0,  0,  0,141,190,  0,  0,  0,  0,131,199,  4,141,
/* 0x1ba0 */  94,252, 49,192,138,  7, 71,  9,192,116,  1, 60,239,119, 17,  1,
/* 0x1bb0 */ 195,139,  3,134,196,193,192, 16,134,196,  1,240,137,  3,235,226,
/* 0x1bc0 */  36, 15,193,224, 16,102,139,  7,131,199,  2,  9,192,117, 12,139,
/* 0x1bd0 */   7,131,199,  4,235, 12,135,247,141,143,  0,  0,  0,  0,169,102,
/* 0x1be0 */   1, 12,  7,173,  9,192,117,247,193,233, 16,169,102,  1, 12,  7,
/* 0x1bf0 */ 173,  9,192,117,247,139,174,  0,  0,  0,  0,141,190,  0,  0,  0,
/* 0x1c00 */   0,187,  0,  0,  0,  0, 80, 84,106,  4, 83, 87,255,213,141,135,
/* 0x1c10 */   0,  0,  0,  0,128, 32,127,128, 96, 40,127, 88, 80, 84, 80, 83,
/* 0x1c20 */  87,255,213, 88,141,158,  0,  0,  0,  0,141,187,  1,  0,  0,  0,
/* 0x1c30 */  87, 49,192,170, 89, 73, 80,106,  1, 83,255,209, 97,141, 68, 36,
/* 0x1c40 */ 128,106,  0, 57,196,117,250,131,236,128, 49,192, 64,194, 12,  0,
/* 0x1c50 */ 233,252,255,255,255,235, 26, 86,190,  0,  0,  0,  0,252,173,133,
/* 0x1c60 */ 192,116, 13,106,  3, 89,255,116, 36, 16,226,250,255,208,235,238,
/* 0x1c70 */  94,194, 12,  0, 85, 80, 88, 33,161,216,208,213,  0,  0,  0,  0,
/* 0x1c80 */   0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
/* 0x1c90 */   0,  0,  0, 45,102,105,108,101, 32,102,111,114,109, 97,116, 32,
/* 0x1ca0 */ 101,108,102, 51, 50, 45,105, 51, 56, 54, 10, 10, 83,101, 99,116,
/* 0x1cb0 */ 105,111,110,115, 58, 10, 73,100,120, 32, 78, 97,109,101, 32, 32,
/* 0x1cc0 */  32, 32, 32, 32, 32, 32, 32, 32, 83,105,122,101, 32, 32, 32, 32,
/* 0x1cd0 */  32, 32, 86, 77, 65, 32, 32, 32, 32, 32, 32, 32, 76, 77, 65, 32,
/* 0x1ce0 */  32, 32, 32, 32, 32, 32, 70,105,108,101, 32,111,102,102, 32, 32,
/* 0x1cf0 */  65,108,103,110, 32, 32, 70,108, 97,103,115, 10, 32, 32, 48, 32,
/* 0x1d00 */  80, 69, 73, 83, 68, 76, 76, 49, 32, 32, 32, 32, 32, 32, 48, 98,
/* 0x1d10 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 32, 32, 50, 42, 42,
/* 0x1d20 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 49, 32,
/* 0x1d30 */  80, 69, 77, 65, 73, 78, 48, 49, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x1d40 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51,102, 32, 32, 50, 42, 42,
/* 0x1d50 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 50, 32,
/* 0x1d60 */  80, 69, 83, 79, 67, 82, 69, 76, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x1d70 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 48, 32, 32, 50, 42, 42,
/* 0x1d80 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 51, 32,
/* 0x1d90 */  80, 69, 83, 79, 67, 80, 73, 67, 32, 32, 32, 32, 32, 32, 48, 99,
/* 0x1da0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 52, 53, 32, 32, 50, 42, 42,
/* 0x1db0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 52, 32,
/* 0x1dc0 */  80, 69, 83, 79, 85, 78, 67, 48, 32, 32, 32, 32, 32, 32, 48, 54,
/* 0x1dd0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 49, 32, 32, 50, 42, 42,
/* 0x1de0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 53, 32,
/* 0x1df0 */  80, 69, 73, 67, 79, 78, 83, 49, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x1e00 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53, 55, 32, 32, 50, 42, 42,
/* 0x1e10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 54, 32,
/* 0x1e20 */  80, 69, 73, 67, 79, 78, 83, 50, 32, 32, 32, 32, 32, 32, 48, 57,
/* 0x1e30 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 53,101, 32, 32, 50, 42, 42,
/* 0x1e40 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 55, 32,
/* 0x1e50 */  80, 69, 84, 76, 83, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x1e60 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 54, 55, 32, 32, 50, 42, 42,
/* 0x1e70 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 56, 32,
/* 0x1e80 */  80, 69, 77, 65, 73, 78, 48, 50, 32, 32, 32, 32, 32, 32, 48, 49,
/* 0x1e90 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 54, 32, 32, 50, 42, 42,
/* 0x1ea0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 32, 57, 32,
/* 0x1eb0 */  80, 69, 77, 65, 73, 78, 48, 51, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1ec0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 55, 32, 32, 50, 42, 42,
/* 0x1ed0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 48, 32,
/* 0x1ee0 */  78, 50, 66, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x1ef0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55, 97, 32, 32, 50, 42, 42,
/* 0x1f00 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 49, 32,
/* 0x1f10 */  78, 50, 66, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x1f20 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55,100, 32, 32, 50, 42, 42,
/* 0x1f30 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 50, 32,
/* 0x1f40 */  78, 50, 66, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54,
/* 0x1f50 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 55,102, 32, 32, 50, 42, 42,
/* 0x1f60 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 51, 32,
/* 0x1f70 */  78, 50, 66, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98,
/* 0x1f80 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 56, 53, 32, 32, 50, 42, 42,
/* 0x1f90 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 52, 32,
/* 0x1fa0 */  78, 50, 66, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53,
/* 0x1fb0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 48, 32, 32, 50, 42, 42,
/* 0x1fc0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 53, 32,
/* 0x1fd0 */  78, 50, 66, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x1fe0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 53, 32, 32, 50, 42, 42,
/* 0x1ff0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 54, 32,
/* 0x2000 */  78, 50, 66, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x2010 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 57, 99, 32, 32, 50, 42, 42,
/* 0x2020 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 55, 32,
/* 0x2030 */  78, 50, 66, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32, 48,100,
/* 0x2040 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 97, 57, 32, 32, 50, 42, 42,
/* 0x2050 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 56, 32,
/* 0x2060 */  78, 50, 66, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32, 32, 48,102,
/* 0x2070 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 98, 54, 32, 32, 50, 42, 42,
/* 0x2080 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 49, 57, 32,
/* 0x2090 */  78, 50, 66, 68, 69, 67, 51, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x20a0 */ 101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 99, 53, 32, 32, 50, 42,
/* 0x20b0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50, 48,
/* 0x20c0 */  32, 78, 50, 66, 83, 77, 65, 52, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x20d0 */ 100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 48, 51, 32, 32, 50,
/* 0x20e0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 50,
/* 0x20f0 */  49, 32, 78, 50, 66, 70, 65, 83, 52, 48, 32, 32, 32, 32, 32, 32,
/* 0x2100 */  48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49, 48, 32, 32,
/* 0x2110 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2120 */  50, 50, 32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 32, 32, 32, 32,
/* 0x2130 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 49,102, 32,
/* 0x2140 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2150 */  32, 50, 51, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 32, 32, 32,
/* 0x2160 */  32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50, 49,
/* 0x2170 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2180 */  10, 32, 50, 52, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32, 32, 32,
/* 0x2190 */  32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 50,
/* 0x21a0 */  52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x21b0 */  83, 10, 32, 50, 53, 32, 78, 50, 66, 83, 77, 65, 54, 48, 32, 32,
/* 0x21c0 */  32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x21d0 */  50,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x21e0 */  84, 83, 10, 32, 50, 54, 32, 78, 50, 66, 70, 65, 83, 54, 48, 32,
/* 0x21f0 */  32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2200 */  48, 49, 51, 98, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2210 */  69, 78, 84, 83, 10, 32, 50, 55, 32, 78, 50, 66, 70, 65, 83, 54,
/* 0x2220 */  49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48, 32, 32, 48,
/* 0x2230 */  32, 32, 48, 49, 53, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2240 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 56, 32, 78, 50, 66, 68, 69,
/* 0x2250 */  67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2260 */  32, 32, 48, 49, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2270 */  78, 84, 69, 78, 84, 83, 10, 32, 50, 57, 32, 78, 50, 68, 83, 77,
/* 0x2280 */  65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32,
/* 0x2290 */  48, 32, 32, 48, 49, 54, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x22a0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 48, 32, 78, 50, 68, 70,
/* 0x22b0 */  65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32,
/* 0x22c0 */  32, 48, 32, 32, 48, 49, 54, 97, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x22d0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 49, 32, 78, 50, 68,
/* 0x22e0 */  70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48,
/* 0x22f0 */  32, 32, 48, 32, 32, 48, 49, 54, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x2300 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 50, 32, 78, 50,
/* 0x2310 */  68, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32, 32, 48, 98, 32, 32,
/* 0x2320 */  48, 32, 32, 48, 32, 32, 48, 49, 55, 50, 32, 32, 50, 42, 42, 48,
/* 0x2330 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 51, 32, 78,
/* 0x2340 */  50, 68, 83, 77, 65, 50, 48, 32, 32, 32, 32, 32, 32, 48, 53, 32,
/* 0x2350 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 55,100, 32, 32, 50, 42, 42,
/* 0x2360 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 52, 32,
/* 0x2370 */  78, 50, 68, 70, 65, 83, 50, 48, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x2380 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 50, 32, 32, 50, 42,
/* 0x2390 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51, 53,
/* 0x23a0 */  32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x23b0 */ 100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 56, 57, 32, 32, 50,
/* 0x23c0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 51,
/* 0x23d0 */  54, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 32, 32, 32, 32, 32,
/* 0x23e0 */  48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 57, 54, 32, 32,
/* 0x23f0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2400 */  51, 55, 32, 78, 50, 68, 70, 65, 83, 51, 48, 32, 32, 32, 32, 32,
/* 0x2410 */  32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 51, 32,
/* 0x2420 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2430 */  32, 51, 56, 32, 78, 50, 68, 68, 69, 67, 51, 48, 32, 32, 32, 32,
/* 0x2440 */  32, 32, 48, 53, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x2450 */  50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2460 */  83, 10, 32, 51, 57, 32, 78, 50, 68, 83, 77, 65, 52, 48, 32, 32,
/* 0x2470 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2480 */  48, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2490 */  84, 83, 10, 32, 52, 48, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32,
/* 0x24a0 */  32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x24b0 */  50, 49, 49, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x24c0 */  78, 84, 83, 10, 32, 52, 49, 32, 78, 50, 68, 83, 77, 65, 53, 48,
/* 0x24d0 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x24e0 */  48, 50, 50, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x24f0 */  69, 78, 84, 83, 10, 32, 52, 50, 32, 78, 50, 68, 70, 65, 83, 53,
/* 0x2500 */  48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32, 32, 48, 32,
/* 0x2510 */  32, 48, 50, 50, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2520 */  84, 69, 78, 84, 83, 10, 32, 52, 51, 32, 78, 50, 68, 68, 69, 67,
/* 0x2530 */  53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32, 32, 48, 32, 32, 48,
/* 0x2540 */  32, 32, 48, 50, 50, 53, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2550 */  78, 84, 69, 78, 84, 83, 10, 32, 52, 52, 32, 78, 50, 68, 83, 77,
/* 0x2560 */  65, 54, 48, 32, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32,
/* 0x2570 */  48, 32, 32, 48, 50, 50,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2580 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 53, 32, 78, 50, 68, 70,
/* 0x2590 */  65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32, 32, 48,
/* 0x25a0 */  32, 32, 48, 32, 32, 48, 50, 51, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x25b0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 54, 32, 78, 50,
/* 0x25c0 */  68, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32, 32, 48, 49, 54, 32,
/* 0x25d0 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 53, 50, 32, 32, 50, 42, 42,
/* 0x25e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 55, 32,
/* 0x25f0 */  78, 50, 68, 68, 69, 67, 54, 48, 32, 32, 32, 32, 32, 32, 48, 32,
/* 0x2600 */  32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 56, 32, 32, 50, 42, 42,
/* 0x2610 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 56, 32,
/* 0x2620 */  78, 50, 69, 83, 77, 65, 49, 48, 32, 32, 32, 32, 32, 32, 48, 51,
/* 0x2630 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 56, 32, 32, 50, 42,
/* 0x2640 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 52, 57,
/* 0x2650 */  32, 78, 50, 69, 70, 65, 83, 49, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2660 */  50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54, 98, 32, 32, 50,
/* 0x2670 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 53,
/* 0x2680 */  48, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 32, 32, 32, 32, 32,
/* 0x2690 */  48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 54,100, 32, 32,
/* 0x26a0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x26b0 */  53, 49, 32, 78, 50, 69, 68, 69, 67, 49, 48, 32, 32, 32, 32, 32,
/* 0x26c0 */  32, 48, 98, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55, 51, 32,
/* 0x26d0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x26e0 */  32, 53, 50, 32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 32, 32, 32,
/* 0x26f0 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 55,101,
/* 0x2700 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2710 */  10, 32, 53, 51, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 32, 32,
/* 0x2720 */  32, 32, 32, 48, 55, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50, 56,
/* 0x2730 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2740 */  83, 10, 32, 53, 52, 32, 78, 50, 69, 68, 69, 67, 50, 48, 32, 32,
/* 0x2750 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 50,
/* 0x2760 */  56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2770 */  84, 83, 10, 32, 53, 53, 32, 78, 50, 69, 83, 77, 65, 51, 48, 32,
/* 0x2780 */  32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2790 */  50, 57, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x27a0 */  78, 84, 83, 10, 32, 53, 54, 32, 78, 50, 69, 70, 65, 83, 51, 48,
/* 0x27b0 */  32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x27c0 */  48, 50, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x27d0 */  69, 78, 84, 83, 10, 32, 53, 55, 32, 78, 50, 69, 68, 69, 67, 51,
/* 0x27e0 */  48, 32, 32, 32, 32, 32, 32, 48, 53,102, 32, 32, 48, 32, 32, 48,
/* 0x27f0 */  32, 32, 48, 50, 98, 51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2800 */  78, 84, 69, 78, 84, 83, 10, 32, 53, 56, 32, 78, 50, 69, 83, 77,
/* 0x2810 */  65, 52, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32,
/* 0x2820 */  48, 32, 32, 48, 51, 49, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2830 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 53, 57, 32, 78, 50, 69, 70,
/* 0x2840 */  65, 83, 52, 48, 32, 32, 32, 32, 32, 32, 48,102, 32, 32, 48, 32,
/* 0x2850 */  32, 48, 32, 32, 48, 51, 49,102, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2860 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 48, 32, 78, 50, 69,
/* 0x2870 */  83, 77, 65, 53, 48, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2880 */  32, 32, 48, 32, 32, 48, 51, 50,101, 32, 32, 50, 42, 42, 48, 32,
/* 0x2890 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 49, 32, 78, 50,
/* 0x28a0 */  69, 70, 65, 83, 53, 48, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x28b0 */  48, 32, 32, 48, 32, 32, 48, 51, 51, 48, 32, 32, 50, 42, 42, 48,
/* 0x28c0 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 50, 32, 78,
/* 0x28d0 */  50, 69, 68, 69, 67, 53, 48, 32, 32, 32, 32, 32, 32, 48, 57, 32,
/* 0x28e0 */  32, 48, 32, 32, 48, 32, 32, 48, 51, 51, 51, 32, 32, 50, 42, 42,
/* 0x28f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 51, 32,
/* 0x2900 */  78, 50, 69, 83, 77, 65, 54, 48, 32, 32, 32, 32, 32, 32, 48,101,
/* 0x2910 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 51, 99, 32, 32, 50, 42,
/* 0x2920 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 54, 52,
/* 0x2930 */  32, 78, 50, 69, 70, 65, 83, 54, 48, 32, 32, 32, 32, 32, 32, 48,
/* 0x2940 */  49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 52, 97, 32, 32,
/* 0x2950 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2960 */  54, 53, 32, 78, 50, 69, 70, 65, 83, 54, 49, 32, 32, 32, 32, 32,
/* 0x2970 */  32, 48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 54, 48,
/* 0x2980 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2990 */  10, 32, 54, 54, 32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 32, 32,
/* 0x29a0 */  32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51, 55, 54,
/* 0x29b0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x29c0 */  10, 32, 54, 55, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32,
/* 0x29d0 */  32, 32, 32, 48, 50,101, 32, 32, 48, 32, 32, 48, 32, 32, 48, 51,
/* 0x29e0 */  55, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x29f0 */  84, 83, 10, 32, 54, 56, 32, 76, 90, 77, 65, 95, 69, 76, 70, 48,
/* 0x2a00 */  48, 32, 32, 32, 32, 48, 52, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2a10 */  48, 51, 97, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2a20 */  69, 78, 84, 83, 10, 32, 54, 57, 32, 76, 90, 77, 65, 95, 68, 69,
/* 0x2a30 */  67, 49, 48, 32, 32, 32, 32, 48, 98, 51,101, 32, 32, 48, 32, 32,
/* 0x2a40 */  48, 32, 32, 48, 51,101, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2a50 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 48, 32, 76, 90, 77, 65,
/* 0x2a60 */  95, 68, 69, 67, 50, 48, 32, 32, 32, 32, 48, 98, 51,101, 32, 32,
/* 0x2a70 */  48, 32, 32, 48, 32, 32, 48,102, 50, 97, 32, 32, 50, 42, 42, 48,
/* 0x2a80 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 49, 32, 76,
/* 0x2a90 */  90, 77, 65, 95, 68, 69, 67, 51, 48, 32, 32, 32, 32, 48, 49, 97,
/* 0x2aa0 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 54, 56, 32, 32, 50,
/* 0x2ab0 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55,
/* 0x2ac0 */  50, 32, 80, 69, 77, 65, 73, 78, 49, 48, 32, 32, 32, 32, 32, 32,
/* 0x2ad0 */  48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 56, 50, 32,
/* 0x2ae0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2af0 */  32, 55, 51, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 32, 32, 32,
/* 0x2b00 */  32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 56,
/* 0x2b10 */  51, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2b20 */  83, 10, 32, 55, 52, 32, 80, 69, 67, 84, 84, 80, 79, 83, 32, 32,
/* 0x2b30 */  32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2b40 */  97, 56, 55, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2b50 */  78, 84, 83, 10, 32, 55, 53, 32, 80, 69, 67, 84, 84, 78, 85, 76,
/* 0x2b60 */  32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x2b70 */  48, 49, 97, 56,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x2b80 */  84, 69, 78, 84, 83, 10, 32, 55, 54, 32, 67, 65, 76, 76, 84, 82,
/* 0x2b90 */  48, 48, 32, 32, 32, 32, 32, 32, 48,101, 32, 32, 48, 32, 32, 48,
/* 0x2ba0 */  32, 32, 48, 49, 97, 56,102, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x2bb0 */  79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 55, 32, 67, 84, 67, 76,
/* 0x2bc0 */  69, 86, 69, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32,
/* 0x2bd0 */  32, 48, 32, 32, 48, 49, 97, 57,100, 32, 32, 50, 42, 42, 48, 32,
/* 0x2be0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 56, 32, 67, 65,
/* 0x2bf0 */  76, 76, 84, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32,
/* 0x2c00 */  48, 32, 32, 48, 32, 32, 48, 49, 97, 97, 50, 32, 32, 50, 42, 42,
/* 0x2c10 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 55, 57, 32,
/* 0x2c20 */  67, 84, 66, 83, 72, 82, 48, 49, 32, 32, 32, 32, 32, 32, 48, 52,
/* 0x2c30 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 97, 55, 32, 32, 50,
/* 0x2c40 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56,
/* 0x2c50 */  48, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 32, 32, 32, 32, 32,
/* 0x2c60 */  48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 97, 98, 32,
/* 0x2c70 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2c80 */  32, 56, 49, 32, 67, 84, 66, 83, 87, 65, 48, 49, 32, 32, 32, 32,
/* 0x2c90 */  32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 97,
/* 0x2ca0 */ 100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2cb0 */  83, 10, 32, 56, 50, 32, 67, 65, 76, 76, 84, 82, 48, 50, 32, 32,
/* 0x2cc0 */  32, 32, 32, 32, 48, 49, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2cd0 */  49, 97, 98, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2ce0 */  69, 78, 84, 83, 10, 32, 56, 51, 32, 67, 65, 76, 76, 84, 82, 49,
/* 0x2cf0 */  48, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x2d00 */  32, 48, 49, 97, 99, 50, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2d10 */  78, 84, 69, 78, 84, 83, 10, 32, 56, 52, 32, 67, 65, 76, 76, 84,
/* 0x2d20 */  82, 69, 56, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x2d30 */  48, 32, 32, 48, 49, 97, 99, 55, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2d40 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 53, 32, 67, 65, 76,
/* 0x2d50 */  76, 84, 82, 69, 57, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48,
/* 0x2d60 */  32, 32, 48, 32, 32, 48, 49, 97, 99, 57, 32, 32, 50, 42, 42, 48,
/* 0x2d70 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 54, 32, 67,
/* 0x2d80 */  65, 76, 76, 84, 82, 49, 49, 32, 32, 32, 32, 32, 32, 48, 52, 32,
/* 0x2d90 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99, 98, 32, 32, 50, 42,
/* 0x2da0 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 56, 55,
/* 0x2db0 */  32, 67, 84, 67, 76, 69, 86, 69, 50, 32, 32, 32, 32, 32, 32, 48,
/* 0x2dc0 */  53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97, 99,102, 32, 32,
/* 0x2dd0 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32,
/* 0x2de0 */  56, 56, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 32, 32, 32, 32,
/* 0x2df0 */  32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,100, 52,
/* 0x2e00 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x2e10 */  10, 32, 56, 57, 32, 67, 84, 66, 83, 72, 82, 49, 49, 32, 32, 32,
/* 0x2e20 */  32, 32, 32, 48, 52, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 97,
/* 0x2e30 */ 100, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x2e40 */  84, 83, 10, 32, 57, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49, 32,
/* 0x2e50 */  32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x2e60 */  49, 97,100, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x2e70 */  69, 78, 84, 83, 10, 32, 57, 49, 32, 67, 84, 66, 83, 87, 65, 49,
/* 0x2e80 */  49, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32,
/* 0x2e90 */  32, 48, 49, 97,100, 99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x2ea0 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 50, 32, 67, 65, 76, 76, 84,
/* 0x2eb0 */  82, 49, 51, 32, 32, 32, 32, 32, 32, 48, 55, 32, 32, 48, 32, 32,
/* 0x2ec0 */  48, 32, 32, 48, 49, 97,101, 49, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x2ed0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 51, 32, 99,116,111,
/* 0x2ee0 */ 107, 51, 50, 46, 48, 48, 32, 32, 32, 32, 32, 48, 97, 32, 32, 48,
/* 0x2ef0 */  32, 32, 48, 32, 32, 48, 49, 97,101, 56, 32, 32, 50, 42, 42, 48,
/* 0x2f00 */  32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 52, 32, 99,
/* 0x2f10 */ 116,111,107, 51, 50, 46, 49, 48, 32, 32, 32, 32, 32, 48,101, 32,
/* 0x2f20 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 97,102, 50, 32, 32, 50, 42,
/* 0x2f30 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 32, 57, 53,
/* 0x2f40 */  32, 99,116,111,107, 51, 50, 46, 50, 48, 32, 32, 32, 32, 32, 48,
/* 0x2f50 */  50, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 48, 48, 32,
/* 0x2f60 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x2f70 */  32, 57, 54, 32, 99,116,111,107, 51, 50, 46, 51, 48, 32, 32, 32,
/* 0x2f80 */  32, 32, 48, 97, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 50,
/* 0x2f90 */  48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x2fa0 */  83, 10, 32, 57, 55, 32, 99,116,111,107, 51, 50, 46, 52, 48, 32,
/* 0x2fb0 */  32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x2fc0 */  98, 50, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x2fd0 */  78, 84, 83, 10, 32, 57, 56, 32, 80, 69, 73, 77, 80, 79, 82, 84,
/* 0x2fe0 */  32, 32, 32, 32, 32, 32, 48, 50, 99, 32, 32, 48, 32, 32, 48, 32,
/* 0x2ff0 */  32, 48, 49, 98, 50,102, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3000 */  78, 84, 69, 78, 84, 83, 10, 32, 57, 57, 32, 80, 69, 73, 66, 89,
/* 0x3010 */  79, 82, 68, 32, 32, 32, 32, 32, 32, 48, 50, 32, 32, 48, 32, 32,
/* 0x3020 */  48, 32, 32, 48, 49, 98, 53, 98, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x3030 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 48, 32, 80, 69, 75,
/* 0x3040 */  51, 50, 79, 82, 68, 32, 32, 32, 32, 32, 32, 48, 49, 48, 32, 32,
/* 0x3050 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 53,100, 32, 32, 50, 42, 42,
/* 0x3060 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 49, 32,
/* 0x3070 */  80, 69, 73, 77, 79, 82, 68, 49, 32, 32, 32, 32, 32, 32, 48, 55,
/* 0x3080 */  32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 54,100, 32, 32, 50,
/* 0x3090 */  42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48,
/* 0x30a0 */  50, 32, 80, 69, 73, 77, 80, 79, 82, 50, 32, 32, 32, 32, 32, 32,
/* 0x30b0 */  48, 49, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 55, 52,
/* 0x30c0 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x30d0 */  10, 49, 48, 51, 32, 80, 69, 73, 69, 82, 68, 76, 76, 32, 32, 32,
/* 0x30e0 */  32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x30f0 */  56, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3100 */  84, 83, 10, 49, 48, 52, 32, 80, 69, 73, 69, 82, 69, 88, 69, 32,
/* 0x3110 */  32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3120 */  49, 98, 57, 48, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3130 */  69, 78, 84, 83, 10, 49, 48, 53, 32, 80, 69, 73, 77, 68, 79, 78,
/* 0x3140 */  69, 32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x3150 */  48, 49, 98, 57, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x3160 */  84, 69, 78, 84, 83, 10, 49, 48, 54, 32, 80, 69, 82, 69, 76, 79,
/* 0x3170 */  67, 49, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48,
/* 0x3180 */  32, 32, 48, 49, 98, 57, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3190 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 55, 32, 80, 69, 82, 69,
/* 0x31a0 */  76, 79, 67, 50, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32, 48, 32,
/* 0x31b0 */  32, 48, 32, 32, 48, 49, 98, 57, 99, 32, 32, 50, 42, 42, 48, 32,
/* 0x31c0 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 56, 32, 80, 69,
/* 0x31d0 */  82, 69, 76, 79, 67, 51, 32, 32, 32, 32, 32, 32, 48, 51, 32, 32,
/* 0x31e0 */  48, 32, 32, 48, 32, 32, 48, 49, 98, 57,102, 32, 32, 50, 42, 42,
/* 0x31f0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 48, 57, 32,
/* 0x3200 */  82, 69, 76, 79, 67, 51, 50, 48, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x3210 */  57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 97, 50, 32, 32,
/* 0x3220 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49,
/* 0x3230 */  49, 48, 32, 82, 69, 76, 51, 50, 66, 73, 71, 32, 32, 32, 32, 32,
/* 0x3240 */  32, 48, 57, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98, 99, 98,
/* 0x3250 */  32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83,
/* 0x3260 */  10, 49, 49, 49, 32, 82, 69, 76, 79, 67, 51, 50, 74, 32, 32, 32,
/* 0x3270 */  32, 32, 32, 48, 50, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 98,
/* 0x3280 */ 100, 52, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78,
/* 0x3290 */  84, 83, 10, 49, 49, 50, 32, 82, 69, 76, 51, 50, 69, 78, 68, 32,
/* 0x32a0 */  32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x32b0 */  98,100, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x32c0 */  78, 84, 83, 10, 49, 49, 51, 32, 80, 69, 82, 76, 79, 72, 73, 48,
/* 0x32d0 */  32, 32, 32, 32, 32, 32, 48, 56, 32, 32, 48, 32, 32, 48, 32, 32,
/* 0x32e0 */  48, 49, 98,100, 54, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78,
/* 0x32f0 */  84, 69, 78, 84, 83, 10, 49, 49, 52, 32, 80, 69, 82, 69, 76, 76,
/* 0x3300 */  79, 48, 32, 32, 32, 32, 32, 32, 48, 97, 32, 32, 48, 32, 32, 48,
/* 0x3310 */  32, 32, 48, 49, 98,100,101, 32, 32, 50, 42, 42, 48, 32, 32, 67,
/* 0x3320 */  79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 53, 32, 80, 69, 82, 69,
/* 0x3330 */  76, 72, 73, 48, 32, 32, 32, 32, 32, 32, 48,100, 32, 32, 48, 32,
/* 0x3340 */  32, 48, 32, 32, 48, 49, 98,101, 56, 32, 32, 50, 42, 42, 48, 32,
/* 0x3350 */  32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 54, 32, 80, 69,
/* 0x3360 */  68, 69, 80, 72, 65, 75, 32, 32, 32, 32, 32, 32, 48, 50,102, 32,
/* 0x3370 */  32, 48, 32, 32, 48, 32, 32, 48, 49, 98,102, 53, 32, 32, 50, 42,
/* 0x3380 */  42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 49, 55,
/* 0x3390 */  32, 80, 69, 84, 76, 83, 67, 32, 32, 32, 32, 32, 32, 32, 32, 48,
/* 0x33a0 */  49, 56, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 50, 52, 32,
/* 0x33b0 */  32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10,
/* 0x33c0 */  49, 49, 56, 32, 80, 69, 77, 65, 73, 78, 50, 48, 32, 32, 32, 32,
/* 0x33d0 */  32, 32, 48, 49, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 51,
/* 0x33e0 */  99, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84,
/* 0x33f0 */  83, 10, 49, 49, 57, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75,
/* 0x3400 */  32, 32, 32, 32, 48,100, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49,
/* 0x3410 */  99, 51,100, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69,
/* 0x3420 */  78, 84, 83, 10, 49, 50, 48, 32, 80, 69, 77, 65, 73, 78, 50, 49,
/* 0x3430 */  32, 32, 32, 32, 32, 32, 48, 32, 32, 48, 32, 32, 48, 32, 32, 48,
/* 0x3440 */  49, 99, 52, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79, 78, 84,
/* 0x3450 */  69, 78, 84, 83, 10, 49, 50, 49, 32, 80, 69, 82, 69, 84, 85, 82,
/* 0x3460 */  78, 32, 32, 32, 32, 32, 32, 48, 54, 32, 32, 48, 32, 32, 48, 32,
/* 0x3470 */  32, 48, 49, 99, 52, 97, 32, 32, 50, 42, 42, 48, 32, 32, 67, 79,
/* 0x3480 */  78, 84, 69, 78, 84, 83, 10, 49, 50, 50, 32, 80, 69, 68, 79, 74,
/* 0x3490 */  85, 77, 80, 32, 32, 32, 32, 32, 32, 48, 53, 32, 32, 48, 32, 32,
/* 0x34a0 */  48, 32, 32, 48, 49, 99, 53, 48, 32, 32, 50, 42, 42, 48, 32, 32,
/* 0x34b0 */  67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 51, 32, 80, 69, 84,
/* 0x34c0 */  76, 83, 67, 50, 32, 32, 32, 32, 32, 32, 32, 48, 49,102, 32, 32,
/* 0x34d0 */  48, 32, 32, 48, 32, 32, 48, 49, 99, 53, 53, 32, 32, 50, 42, 42,
/* 0x34e0 */  48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 49, 50, 52, 32,
/* 0x34f0 */  85, 80, 88, 49, 72, 69, 65, 68, 32, 32, 32, 32, 32, 32, 48, 50,
/* 0x3500 */  48, 32, 32, 48, 32, 32, 48, 32, 32, 48, 49, 99, 55, 52, 32, 32,
/* 0x3510 */  50, 42, 42, 48, 32, 32, 67, 79, 78, 84, 69, 78, 84, 83, 10, 83,
/* 0x3520 */  89, 77, 66, 79, 76, 32, 84, 65, 66, 76, 69, 58, 10, 48, 48, 48,
/* 0x3530 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3540 */  66, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 49,
/* 0x3550 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3560 */ 100, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50,
/* 0x3570 */  66, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3580 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x3590 */  32, 48, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x35a0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x35b0 */  68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 66, 68, 69, 67, 50, 48,
/* 0x35c0 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x35d0 */  32, 32, 78, 50, 66, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 66,
/* 0x35e0 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x35f0 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 32,
/* 0x3600 */  48, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x3610 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x3620 */  65, 83, 54, 49, 32, 48, 32, 78, 50, 66, 70, 65, 83, 54, 49, 10,
/* 0x3630 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3640 */  32, 78, 50, 66, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 66, 68,
/* 0x3650 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3660 */  32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 32, 48,
/* 0x3670 */  32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3680 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65,
/* 0x3690 */  83, 49, 49, 32, 48, 32, 78, 50, 68, 70, 65, 83, 49, 49, 10, 48,
/* 0x36a0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x36b0 */  78, 50, 68, 68, 69, 67, 49, 48, 32, 48, 32, 78, 50, 68, 68, 69,
/* 0x36c0 */  67, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x36d0 */  32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 50, 48, 32, 48, 32,
/* 0x36e0 */  78, 50, 68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x36f0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67,
/* 0x3700 */  51, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48,
/* 0x3710 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3720 */  50, 68, 68, 69, 67, 53, 48, 32, 48, 32, 78, 50, 68, 68, 69, 67,
/* 0x3730 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3740 */  32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 49, 32, 48, 32, 78,
/* 0x3750 */  50, 68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3760 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 68, 69, 67, 54,
/* 0x3770 */  48, 32, 48, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48,
/* 0x3780 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3790 */  69, 83, 77, 65, 49, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 49,
/* 0x37a0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x37b0 */ 100, 32, 32, 78, 50, 69, 70, 65, 83, 49, 49, 32, 48, 32, 78, 50,
/* 0x37c0 */  69, 70, 65, 83, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x37d0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48,
/* 0x37e0 */  32, 48, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 48, 48, 48, 48,
/* 0x37f0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69,
/* 0x3800 */  68, 69, 67, 50, 48, 32, 48, 32, 78, 50, 69, 68, 69, 67, 50, 48,
/* 0x3810 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3820 */  32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 32, 48, 32, 78, 50, 69,
/* 0x3830 */  68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3840 */  32, 32, 32, 32,100, 32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 32,
/* 0x3850 */  48, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x3860 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3870 */  65, 83, 54, 49, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54, 49, 10,
/* 0x3880 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3890 */  32, 78, 50, 69, 68, 69, 67, 54, 48, 32, 48, 32, 78, 50, 69, 68,
/* 0x38a0 */  69, 67, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x38b0 */  32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 32, 48,
/* 0x38c0 */  32, 67, 65, 76, 76, 84, 82, 48, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x38d0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x38e0 */  82, 49, 48, 32, 48, 32, 67, 65, 76, 76, 84, 82, 49, 48, 10, 48,
/* 0x38f0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3900 */  67, 65, 76, 76, 84, 82, 49, 49, 32, 48, 32, 67, 65, 76, 76, 84,
/* 0x3910 */  82, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3920 */  32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51, 32, 48, 32,
/* 0x3930 */  67, 65, 76, 76, 84, 82, 49, 51, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3940 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50,
/* 0x3950 */  46, 48, 48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10,
/* 0x3960 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3970 */  32, 99,116,111,107, 51, 50, 46, 49, 48, 32, 48, 32, 99,116,111,
/* 0x3980 */ 107, 51, 50, 46, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3990 */ 108, 32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 50,
/* 0x39a0 */  48, 32, 48, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 48, 48,
/* 0x39b0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 99,
/* 0x39c0 */ 116,111,107, 51, 50, 46, 52, 48, 32, 48, 32, 99,116,111,107, 51,
/* 0x39d0 */  50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x39e0 */  32, 32, 32,100, 32, 32, 80, 69, 73, 77, 80, 79, 82, 84, 32, 48,
/* 0x39f0 */  32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 48, 48, 48, 48, 48, 48,
/* 0x3a00 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 77, 79,
/* 0x3a10 */  82, 68, 49, 32, 48, 32, 80, 69, 73, 77, 79, 82, 68, 49, 10, 48,
/* 0x3a20 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3a30 */  80, 69, 73, 77, 80, 79, 82, 50, 32, 48, 32, 80, 69, 73, 77, 80,
/* 0x3a40 */  79, 82, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3a50 */  32, 32,100, 32, 32, 80, 69, 73, 77, 68, 79, 78, 69, 32, 48, 32,
/* 0x3a60 */  80, 69, 73, 77, 68, 79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3a70 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 82, 69, 76, 79, 67, 51,
/* 0x3a80 */  50, 48, 32, 48, 32, 82, 69, 76, 79, 67, 51, 50, 48, 10, 48, 48,
/* 0x3a90 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 82,
/* 0x3aa0 */  69, 76, 79, 67, 51, 50, 74, 32, 48, 32, 82, 69, 76, 79, 67, 51,
/* 0x3ab0 */  50, 74, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3ac0 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 50, 49, 32, 48, 32, 80,
/* 0x3ad0 */  69, 77, 65, 73, 78, 50, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ae0 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 84, 76, 83, 67, 50,
/* 0x3af0 */  32, 48, 32, 80, 69, 84, 76, 83, 67, 50, 10, 48, 48, 48, 48, 48,
/* 0x3b00 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 83,
/* 0x3b10 */  68, 76, 76, 49, 32, 48, 32, 80, 69, 73, 83, 68, 76, 76, 49, 10,
/* 0x3b20 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3b30 */  32, 80, 69, 77, 65, 73, 78, 48, 49, 32, 48, 32, 80, 69, 77, 65,
/* 0x3b40 */  73, 78, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3b50 */  32, 32, 32,100, 32, 32, 80, 69, 83, 79, 67, 82, 69, 76, 32, 48,
/* 0x3b60 */  32, 80, 69, 83, 79, 67, 82, 69, 76, 10, 48, 48, 48, 48, 48, 48,
/* 0x3b70 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 83, 79, 67,
/* 0x3b80 */  80, 73, 67, 32, 48, 32, 80, 69, 83, 79, 67, 80, 73, 67, 10, 48,
/* 0x3b90 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3ba0 */  80, 69, 83, 79, 85, 78, 67, 48, 32, 48, 32, 80, 69, 83, 79, 85,
/* 0x3bb0 */  78, 67, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3bc0 */  32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78, 83, 49, 32, 48, 32,
/* 0x3bd0 */  80, 69, 73, 67, 79, 78, 83, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3be0 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 67, 79, 78,
/* 0x3bf0 */  83, 50, 32, 48, 32, 80, 69, 73, 67, 79, 78, 83, 50, 10, 48, 48,
/* 0x3c00 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x3c10 */  69, 84, 76, 83, 72, 65, 75, 32, 48, 32, 80, 69, 84, 76, 83, 72,
/* 0x3c20 */  65, 75, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3c30 */  32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48, 50, 32, 48, 32, 80,
/* 0x3c40 */  69, 77, 65, 73, 78, 48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3c50 */  32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 77, 65, 73, 78, 48,
/* 0x3c60 */  51, 32, 48, 32, 80, 69, 77, 65, 73, 78, 48, 51, 10, 48, 48, 48,
/* 0x3c70 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3c80 */  66, 70, 65, 83, 49, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 49,
/* 0x3c90 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3ca0 */ 100, 32, 32, 78, 50, 66, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50,
/* 0x3cb0 */  66, 83, 77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3cc0 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 50, 48,
/* 0x3cd0 */  32, 48, 32, 78, 50, 66, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48,
/* 0x3ce0 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66,
/* 0x3cf0 */  83, 77, 65, 51, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 51, 48,
/* 0x3d00 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3d10 */  32, 32, 78, 50, 66, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 66,
/* 0x3d20 */  70, 65, 83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3d30 */  32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77, 65, 52, 48, 32,
/* 0x3d40 */  48, 32, 78, 50, 66, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48,
/* 0x3d50 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 70,
/* 0x3d60 */  65, 83, 52, 48, 32, 48, 32, 78, 50, 66, 70, 65, 83, 52, 48, 10,
/* 0x3d70 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3d80 */  32, 78, 50, 66, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 66, 83,
/* 0x3d90 */  77, 65, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3da0 */  32, 32, 32,100, 32, 32, 78, 50, 66, 70, 65, 83, 53, 48, 32, 48,
/* 0x3db0 */  32, 78, 50, 66, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x3dc0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 66, 83, 77,
/* 0x3dd0 */  65, 54, 48, 32, 48, 32, 78, 50, 66, 83, 77, 65, 54, 48, 10, 48,
/* 0x3de0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x3df0 */  78, 50, 66, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 66, 70, 65,
/* 0x3e00 */  83, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x3e10 */  32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 49, 48, 32, 48, 32,
/* 0x3e20 */  78, 50, 68, 70, 65, 83, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x3e30 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65,
/* 0x3e40 */  50, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 50, 48, 10, 48, 48,
/* 0x3e50 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x3e60 */  50, 68, 70, 65, 83, 50, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83,
/* 0x3e70 */  50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x3e80 */  32,100, 32, 32, 78, 50, 68, 83, 77, 65, 51, 48, 32, 48, 32, 78,
/* 0x3e90 */  50, 68, 83, 77, 65, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x3ea0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 51,
/* 0x3eb0 */  48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 51, 48, 10, 48, 48, 48,
/* 0x3ec0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x3ed0 */  68, 83, 77, 65, 52, 48, 32, 48, 32, 78, 50, 68, 83, 77, 65, 52,
/* 0x3ee0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x3ef0 */ 100, 32, 32, 78, 50, 68, 70, 65, 83, 52, 48, 32, 48, 32, 78, 50,
/* 0x3f00 */  68, 70, 65, 83, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x3f10 */ 108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68, 83, 77, 65, 53, 48,
/* 0x3f20 */  32, 48, 32, 78, 50, 68, 83, 77, 65, 53, 48, 10, 48, 48, 48, 48,
/* 0x3f30 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 68,
/* 0x3f40 */  70, 65, 83, 53, 48, 32, 48, 32, 78, 50, 68, 70, 65, 83, 53, 48,
/* 0x3f50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x3f60 */  32, 32, 78, 50, 68, 83, 77, 65, 54, 48, 32, 48, 32, 78, 50, 68,
/* 0x3f70 */  83, 77, 65, 54, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x3f80 */  32, 32, 32, 32,100, 32, 32, 78, 50, 68, 70, 65, 83, 54, 48, 32,
/* 0x3f90 */  48, 32, 78, 50, 68, 70, 65, 83, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x3fa0 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70,
/* 0x3fb0 */  65, 83, 49, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 49, 48, 10,
/* 0x3fc0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x3fd0 */  32, 78, 50, 69, 83, 77, 65, 50, 48, 32, 48, 32, 78, 50, 69, 83,
/* 0x3fe0 */  77, 65, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x3ff0 */  32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83, 50, 48, 32, 48,
/* 0x4000 */  32, 78, 50, 69, 70, 65, 83, 50, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x4010 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77,
/* 0x4020 */  65, 51, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 51, 48, 10, 48,
/* 0x4030 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4040 */  78, 50, 69, 70, 65, 83, 51, 48, 32, 48, 32, 78, 50, 69, 70, 65,
/* 0x4050 */  83, 51, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4060 */  32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 52, 48, 32, 48, 32,
/* 0x4070 */  78, 50, 69, 83, 77, 65, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4080 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 70, 65, 83,
/* 0x4090 */  52, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 52, 48, 10, 48, 48,
/* 0x40a0 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78,
/* 0x40b0 */  50, 69, 83, 77, 65, 53, 48, 32, 48, 32, 78, 50, 69, 83, 77, 65,
/* 0x40c0 */  53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x40d0 */  32,100, 32, 32, 78, 50, 69, 70, 65, 83, 53, 48, 32, 48, 32, 78,
/* 0x40e0 */  50, 69, 70, 65, 83, 53, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x40f0 */  32,108, 32, 32, 32, 32,100, 32, 32, 78, 50, 69, 83, 77, 65, 54,
/* 0x4100 */  48, 32, 48, 32, 78, 50, 69, 83, 77, 65, 54, 48, 10, 48, 48, 48,
/* 0x4110 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 78, 50,
/* 0x4120 */  69, 70, 65, 83, 54, 48, 32, 48, 32, 78, 50, 69, 70, 65, 83, 54,
/* 0x4130 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4140 */ 100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 32, 48, 32,
/* 0x4150 */  76, 90, 77, 65, 95, 68, 69, 67, 48, 48, 10, 48, 48, 48, 48, 48,
/* 0x4160 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65,
/* 0x4170 */  95, 69, 76, 70, 48, 48, 32, 48, 32, 76, 90, 77, 65, 95, 69, 76,
/* 0x4180 */  70, 48, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4190 */  32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 32,
/* 0x41a0 */  48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 49, 48, 10, 48, 48, 48,
/* 0x41b0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 76, 90,
/* 0x41c0 */  77, 65, 95, 68, 69, 67, 50, 48, 32, 48, 32, 76, 90, 77, 65, 95,
/* 0x41d0 */  68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x41e0 */  32, 32, 32, 32,100, 32, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51,
/* 0x41f0 */  48, 32, 48, 32, 76, 90, 77, 65, 95, 68, 69, 67, 51, 48, 10, 48,
/* 0x4200 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4210 */  80, 69, 77, 65, 73, 78, 49, 48, 32, 48, 32, 80, 69, 77, 65, 73,
/* 0x4220 */  78, 49, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4230 */  32, 32,100, 32, 32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 32, 48,
/* 0x4240 */  32, 80, 69, 84, 76, 83, 72, 65, 75, 50, 10, 48, 48, 48, 48, 48,
/* 0x4250 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 67, 84,
/* 0x4260 */  84, 80, 79, 83, 32, 48, 32, 80, 69, 67, 84, 84, 80, 79, 83, 10,
/* 0x4270 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x4280 */  32, 80, 69, 67, 84, 84, 78, 85, 76, 32, 48, 32, 80, 69, 67, 84,
/* 0x4290 */  84, 78, 85, 76, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x42a0 */  32, 32, 32,100, 32, 32, 67, 84, 67, 76, 69, 86, 69, 49, 32, 48,
/* 0x42b0 */  32, 67, 84, 67, 76, 69, 86, 69, 49, 10, 48, 48, 48, 48, 48, 48,
/* 0x42c0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84,
/* 0x42d0 */  82, 48, 49, 32, 48, 32, 67, 65, 76, 76, 84, 82, 48, 49, 10, 48,
/* 0x42e0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x42f0 */  67, 84, 66, 83, 72, 82, 48, 49, 32, 48, 32, 67, 84, 66, 83, 72,
/* 0x4300 */  82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4310 */  32, 32,100, 32, 32, 67, 84, 66, 82, 79, 82, 48, 49, 32, 48, 32,
/* 0x4320 */  67, 84, 66, 82, 79, 82, 48, 49, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4330 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 87, 65,
/* 0x4340 */  48, 49, 32, 48, 32, 67, 84, 66, 83, 87, 65, 48, 49, 10, 48, 48,
/* 0x4350 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67,
/* 0x4360 */  65, 76, 76, 84, 82, 48, 50, 32, 48, 32, 67, 65, 76, 76, 84, 82,
/* 0x4370 */  48, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32,
/* 0x4380 */  32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69, 56, 32, 48, 32, 67,
/* 0x4390 */  65, 76, 76, 84, 82, 69, 56, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x43a0 */  32,108, 32, 32, 32, 32,100, 32, 32, 67, 65, 76, 76, 84, 82, 69,
/* 0x43b0 */  57, 32, 48, 32, 67, 65, 76, 76, 84, 82, 69, 57, 10, 48, 48, 48,
/* 0x43c0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84,
/* 0x43d0 */  67, 76, 69, 86, 69, 50, 32, 48, 32, 67, 84, 67, 76, 69, 86, 69,
/* 0x43e0 */  50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x43f0 */ 100, 32, 32, 67, 65, 76, 76, 84, 82, 49, 50, 32, 48, 32, 67, 65,
/* 0x4400 */  76, 76, 84, 82, 49, 50, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4410 */ 108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66, 83, 72, 82, 49, 49,
/* 0x4420 */  32, 48, 32, 67, 84, 66, 83, 72, 82, 49, 49, 10, 48, 48, 48, 48,
/* 0x4430 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 67, 84, 66,
/* 0x4440 */  82, 79, 82, 49, 49, 32, 48, 32, 67, 84, 66, 82, 79, 82, 49, 49,
/* 0x4450 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4460 */  32, 32, 67, 84, 66, 83, 87, 65, 49, 49, 32, 48, 32, 67, 84, 66,
/* 0x4470 */  83, 87, 65, 49, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4480 */  32, 32, 32, 32,100, 32, 32, 99,116,111,107, 51, 50, 46, 51, 48,
/* 0x4490 */  32, 48, 32, 99,116,111,107, 51, 50, 46, 51, 48, 10, 48, 48, 48,
/* 0x44a0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x44b0 */  73, 66, 89, 79, 82, 68, 32, 48, 32, 80, 69, 73, 66, 89, 79, 82,
/* 0x44c0 */  68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x44d0 */ 100, 32, 32, 80, 69, 75, 51, 50, 79, 82, 68, 32, 48, 32, 80, 69,
/* 0x44e0 */  75, 51, 50, 79, 82, 68, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x44f0 */ 108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73, 69, 82, 68, 76, 76,
/* 0x4500 */  32, 48, 32, 80, 69, 73, 69, 82, 68, 76, 76, 10, 48, 48, 48, 48,
/* 0x4510 */  48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 73,
/* 0x4520 */  69, 82, 69, 88, 69, 32, 48, 32, 80, 69, 73, 69, 82, 69, 88, 69,
/* 0x4530 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100,
/* 0x4540 */  32, 32, 80, 69, 82, 69, 76, 79, 67, 49, 32, 48, 32, 80, 69, 82,
/* 0x4550 */  69, 76, 79, 67, 49, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108,
/* 0x4560 */  32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69, 76, 79, 67, 50, 32,
/* 0x4570 */  48, 32, 80, 69, 82, 69, 76, 79, 67, 50, 10, 48, 48, 48, 48, 48,
/* 0x4580 */  48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 69,
/* 0x4590 */  76, 79, 67, 51, 32, 48, 32, 80, 69, 82, 69, 76, 79, 67, 51, 10,
/* 0x45a0 */  48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32,
/* 0x45b0 */  32, 82, 69, 76, 51, 50, 66, 73, 71, 32, 48, 32, 82, 69, 76, 51,
/* 0x45c0 */  50, 66, 73, 71, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32,
/* 0x45d0 */  32, 32, 32,100, 32, 32, 82, 69, 76, 51, 50, 69, 78, 68, 32, 48,
/* 0x45e0 */  32, 82, 69, 76, 51, 50, 69, 78, 68, 10, 48, 48, 48, 48, 48, 48,
/* 0x45f0 */  48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 82, 76, 79,
/* 0x4600 */  72, 73, 48, 32, 48, 32, 80, 69, 82, 76, 79, 72, 73, 48, 10, 48,
/* 0x4610 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x4620 */  80, 69, 82, 69, 76, 76, 79, 48, 32, 48, 32, 80, 69, 82, 69, 76,
/* 0x4630 */  76, 79, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x4640 */  32, 32,100, 32, 32, 80, 69, 82, 69, 76, 72, 73, 48, 32, 48, 32,
/* 0x4650 */  80, 69, 82, 69, 76, 72, 73, 48, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4660 */  48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69, 68, 69, 80, 72,
/* 0x4670 */  65, 75, 32, 48, 32, 80, 69, 68, 69, 80, 72, 65, 75, 10, 48, 48,
/* 0x4680 */  48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80,
/* 0x4690 */  69, 84, 76, 83, 67, 32, 48, 32, 80, 69, 84, 76, 83, 67, 10, 48,
/* 0x46a0 */  48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32,
/* 0x46b0 */  80, 69, 77, 65, 73, 78, 50, 48, 32, 48, 32, 80, 69, 77, 65, 73,
/* 0x46c0 */  78, 50, 48, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32,
/* 0x46d0 */  32, 32,100, 32, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 32,
/* 0x46e0 */  48, 32, 67, 76, 69, 65, 82, 83, 84, 65, 67, 75, 10, 48, 48, 48,
/* 0x46f0 */  48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,100, 32, 32, 80, 69,
/* 0x4700 */  82, 69, 84, 85, 82, 78, 32, 48, 32, 80, 69, 82, 69, 84, 85, 82,
/* 0x4710 */  78, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,108, 32, 32, 32, 32,
/* 0x4720 */ 100, 32, 32, 80, 69, 68, 79, 74, 85, 77, 80, 32, 48, 32, 80, 69,
/* 0x4730 */  68, 79, 74, 85, 77, 80, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4740 */ 108, 32, 32, 32, 32,100, 32, 32, 85, 80, 88, 49, 72, 69, 65, 68,
/* 0x4750 */  32, 48, 32, 85, 80, 88, 49, 72, 69, 65, 68, 10, 48, 48, 48, 48,
/* 0x4760 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4770 */  68, 42, 32, 48, 32,115,116, 97,114,116, 95,111,102, 95, 99,111,
/* 0x4780 */ 109,112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4790 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x47a0 */  48, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,109,
/* 0x47b0 */ 112,114,101,115,115,101,100, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x47c0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x47d0 */  32,105, 99,111,110, 95,111,102,102,115,101,116, 10, 48, 48, 48,
/* 0x47e0 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x47f0 */  78, 68, 42, 32, 48, 32,105, 99,111,110, 95,100,101,108,116, 97,
/* 0x4800 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x4810 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,116,108,115, 95, 97,100,
/* 0x4820 */ 100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4830 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,116,
/* 0x4840 */ 108,115, 95,118, 97,108,117,101, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4850 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x4860 */  48, 32,108,122,109, 97, 95,115,116, 97, 99,107, 95, 97,100,106,
/* 0x4870 */ 117,115,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x4880 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,108,122,109,
/* 0x4890 */  97, 95,117, 95,108,101,110, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x48a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x48b0 */  32,108,122,109, 97, 95, 99, 95,108,101,110, 10, 48, 48, 48, 48,
/* 0x48c0 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x48d0 */  68, 42, 32, 48, 32,108,122,109, 97, 95,112,114,111,112,101,114,
/* 0x48e0 */ 116,105,101,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32,
/* 0x48f0 */  32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,
/* 0x4900 */ 108,116,101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,114,
/* 0x4910 */ 116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32,
/* 0x4920 */  32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,102,105,108,116,101,
/* 0x4930 */ 114, 95,108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4940 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x4950 */  48, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,
/* 0x4960 */  48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85,
/* 0x4970 */  78, 68, 42, 32, 48, 32, 99,111,109,112,114,101,115,115,101,100,
/* 0x4980 */  95,105,109,112,111,114,116,115, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x4990 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x49a0 */  48, 32,115,116, 97,114,116, 95,111,102, 95,105,109,112,111,114,
/* 0x49b0 */ 116,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32,
/* 0x49c0 */  32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 76,111, 97,100,
/* 0x49d0 */  76,105, 98,114, 97,114,121, 65, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x49e0 */  48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32,
/* 0x49f0 */  48, 32,107,101,114,110,101,108, 51, 50, 95,111,114,100,105,110,
/* 0x4a00 */  97,108,115, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32,
/* 0x4a10 */  32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32, 71,101,116,
/* 0x4a20 */  80,114,111, 99, 65,100,100,114,101,115,115, 10, 48, 48, 48, 48,
/* 0x4a30 */  48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78,
/* 0x4a40 */  68, 42, 32, 48, 32, 69,120,105,116, 80,114,111, 99,101,115,115,
/* 0x4a50 */  10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32,
/* 0x4a60 */  32, 32, 42, 85, 78, 68, 42, 32, 48, 32,115,116, 97,114,116, 95,
/* 0x4a70 */ 111,102, 95,114,101,108,111, 99,115, 10, 48, 48, 48, 48, 48, 48,
/* 0x4a80 */  48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42,
/* 0x4a90 */  32, 48, 32,114,101,108,111, 99, 95,100,101,108,116, 10, 48, 48,
/* 0x4aa0 */  48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32, 42,
/* 0x4ab0 */  85, 78, 68, 42, 32, 48, 32, 86,105,114,116,117, 97,108, 80,114,
/* 0x4ac0 */ 111,116,101, 99,116, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4ad0 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,118,
/* 0x4ae0 */ 112, 95, 98, 97,115,101, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4af0 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x4b00 */ 118,112, 95,115,105,122,101, 10, 48, 48, 48, 48, 48, 48, 48, 48,
/* 0x4b10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48,
/* 0x4b20 */  32,115,119,114,105, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32, 32,
/* 0x4b30 */  32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,116,
/* 0x4b40 */ 108,115, 95,109,111,100,117,108,101, 95, 98, 97,115,101, 10, 48,
/* 0x4b50 */  48, 48, 48, 48, 48, 48, 48, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4b60 */  42, 85, 78, 68, 42, 32, 48, 32,111,114,105,103,105,110, 97,108,
/* 0x4b70 */  95,101,110,116,114,121, 10, 48, 48, 48, 48, 48, 48, 48, 48, 32,
/* 0x4b80 */  32, 32, 32, 32, 32, 32, 32, 32, 42, 85, 78, 68, 42, 32, 48, 32,
/* 0x4b90 */ 116,108,115, 95, 99, 97,108,108, 98, 97, 99,107,115, 95,112,116,
/* 0x4ba0 */ 114, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x4bb0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 73, 83, 68,
/* 0x4bc0 */  76, 76, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x4bd0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4be0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32,
/* 0x4bf0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x4c00 */  32, 32, 80, 69, 77, 65, 73, 78, 50, 49, 10, 10, 82, 69, 76, 79,
/* 0x4c10 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x4c20 */  79, 82, 32, 91, 80, 69, 83, 79, 67, 82, 69, 76, 93, 58, 10, 79,
/* 0x4c30 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x4c40 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x4c50 */  48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x4c60 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,116, 97,114,116,
/* 0x4c70 */  95,111,102, 95, 99,111,109,112,114,101,115,115,101,100, 10, 10,
/* 0x4c80 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x4c90 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 83, 79, 67, 80, 73, 67,
/* 0x4ca0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x4cb0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x4cc0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51,
/* 0x4cd0 */  56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32,115,
/* 0x4ce0 */ 116, 97,114,116, 95,111,102, 95, 99,111,109,112,114,101,115,115,
/* 0x4cf0 */ 101,100, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x4d00 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 83, 79,
/* 0x4d10 */  85, 78, 67, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x4d20 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d30 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50,
/* 0x4d40 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x4d50 */  32, 32, 32,115,116, 97,114,116, 95,111,102, 95,117,110, 99,111,
/* 0x4d60 */ 109,112,114,101,115,115,101,100, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x4d70 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x4d80 */  32, 91, 80, 69, 73, 67, 79, 78, 83, 49, 93, 58, 10, 79, 70, 70,
/* 0x4d90 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x4da0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x4db0 */  48, 48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x4dc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,105, 99,111,110, 95,111,102,
/* 0x4dd0 */ 102,115,101,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x4de0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69,
/* 0x4df0 */  73, 67, 79, 78, 83, 50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x4e00 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4e10 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x4e20 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32,
/* 0x4e30 */  32, 32, 32, 32, 32,105, 99,111,110, 95,111,102,102,115,101,116,
/* 0x4e40 */  10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95,
/* 0x4e50 */  49, 54, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,105, 99,111,110,
/* 0x4e60 */  95,100,101,108,116, 97, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x4e70 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x4e80 */  80, 69, 84, 76, 83, 72, 65, 75, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x4e90 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4ea0 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x4eb0 */  48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x4ec0 */  32, 32, 32, 32, 32, 32, 32,116,108,115, 95, 97,100,100,114,101,
/* 0x4ed0 */ 115,115, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56,
/* 0x4ee0 */  54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,116,108,
/* 0x4ef0 */ 115, 95,118, 97,108,117,101, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x4f00 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x4f10 */  91, 78, 50, 66, 83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x4f20 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x4f30 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x4f40 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x4f50 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48,
/* 0x4f60 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x4f70 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83,
/* 0x4f80 */  49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x4f90 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fa0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82,
/* 0x4fb0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x4fc0 */  32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67,
/* 0x4fd0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x4fe0 */  82, 32, 91, 78, 50, 66, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70,
/* 0x4ff0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x5000 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x5010 */  48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67,
/* 0x5020 */  56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 83, 77, 65,
/* 0x5030 */  49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x5040 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70,
/* 0x5050 */  65, 83, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x5060 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5070 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x5080 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x5090 */  32, 32, 32, 78, 50, 66, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76,
/* 0x50a0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x50b0 */  70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 51, 48, 93, 58, 10,
/* 0x50c0 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x50d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x50e0 */  10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95,
/* 0x50f0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x5100 */  69, 67, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5110 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5120 */  66, 70, 65, 83, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5130 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5140 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5150 */  48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5160 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50, 48, 10, 48, 48,
/* 0x5170 */  48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56,
/* 0x5180 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 50,
/* 0x5190 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x51a0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 68, 69,
/* 0x51b0 */  67, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x51c0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x51d0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 49, 49, 32,
/* 0x51e0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x51f0 */  32, 32, 78, 50, 66, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x5200 */  48, 50,102, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5210 */  32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 53, 48, 10, 10,
/* 0x5220 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5230 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 83, 77, 65, 52, 48,
/* 0x5240 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5250 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5260 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x5270 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5280 */  50, 66, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5290 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x52a0 */  91, 78, 50, 66, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x52b0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x52c0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x52d0 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x52e0 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 51, 48,
/* 0x52f0 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x5300 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68,
/* 0x5310 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5320 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5330 */  66, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5340 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5350 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5360 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5370 */  32, 32, 32, 32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x5380 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5390 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 48, 93,
/* 0x53a0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x53b0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x53c0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56,
/* 0x53d0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x53e0 */  66, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x53f0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5400 */  32, 32, 78, 50, 66, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5410 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5420 */  79, 82, 32, 91, 78, 50, 66, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x5430 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5440 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5450 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5460 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 66, 68, 69,
/* 0x5470 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5480 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68,
/* 0x5490 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x54a0 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x54b0 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x54c0 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x54d0 */  32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x54e0 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x54f0 */  32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 49, 48, 93, 58,
/* 0x5500 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5510 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5520 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5530 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68,
/* 0x5540 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5550 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5560 */  50, 68, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5570 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5580 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5590 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x55a0 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 83, 77, 65, 49, 48, 10, 10,
/* 0x55b0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x55c0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 50, 48,
/* 0x55d0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x55e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x55f0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5600 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5610 */  50, 68, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5620 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5630 */  91, 78, 50, 68, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5640 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5650 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5660 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5670 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x5680 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5690 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83,
/* 0x56a0 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x56b0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56c0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82,
/* 0x56d0 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x56e0 */  32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x56f0 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5700 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48, 10, 10, 82,
/* 0x5710 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5720 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 68, 69, 67, 51, 48, 93,
/* 0x5730 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5740 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5750 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x5760 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5770 */  68, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 50, 49, 32,
/* 0x5780 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5790 */  32, 32, 78, 50, 68, 68, 69, 67, 54, 48, 10, 48, 48, 48, 48, 48,
/* 0x57a0 */  48, 52, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x57b0 */  32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 53, 48, 10, 10,
/* 0x57c0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x57d0 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 83, 77, 65, 52, 48,
/* 0x57e0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x57f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5800 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x5810 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5820 */  50, 68, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5830 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5840 */  91, 78, 50, 68, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5850 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5860 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5870 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5880 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 51, 48,
/* 0x5890 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x58a0 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68,
/* 0x58b0 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x58c0 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x58d0 */  68, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x58e0 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x58f0 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5900 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5910 */  32, 32, 32, 32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x5920 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5930 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 48, 93,
/* 0x5940 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5950 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5960 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56,
/* 0x5970 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5980 */  68, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x5990 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x59a0 */  32, 32, 78, 50, 68, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x59b0 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x59c0 */  79, 82, 32, 91, 78, 50, 68, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x59d0 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x59e0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x59f0 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5a00 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 68, 68, 69,
/* 0x5a10 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5a20 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69,
/* 0x5a30 */  83, 77, 65, 49, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32,
/* 0x5a40 */  32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5a50 */  32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,
/* 0x5a60 */  49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32,
/* 0x5a70 */  32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69,
/* 0x5a80 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x5a90 */  32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 49, 48, 93, 58,
/* 0x5aa0 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x5ab0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x5ac0 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54,
/* 0x5ad0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69,
/* 0x5ae0 */  68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x5af0 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78,
/* 0x5b00 */  50, 69, 83, 77, 65, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5b10 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5b20 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x5b30 */  48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5b40 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 83, 77, 65, 49, 48, 10, 10,
/* 0x5b50 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5b60 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 50, 48,
/* 0x5b70 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5b80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5b90 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32, 82, 95, 51,
/* 0x5ba0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5bb0 */  50, 69, 70, 65, 83, 49, 49, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5bc0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5bd0 */  91, 78, 50, 69, 83, 77, 65, 51, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5be0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5bf0 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5c00 */  48, 48, 48, 48, 99, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5c10 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x5c20 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x5c30 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83,
/* 0x5c40 */  51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x5c50 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c60 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 53, 32, 82,
/* 0x5c70 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5c80 */  32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 48, 48, 48, 48, 48, 48,
/* 0x5c90 */  48,101, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32,
/* 0x5ca0 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48, 10, 10, 82,
/* 0x5cb0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5cc0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 68, 69, 67, 51, 48, 93,
/* 0x5cd0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5ce0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5cf0 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x5d00 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5d10 */  69, 68, 69, 67, 50, 48, 10, 48, 48, 48, 48, 48, 48, 49,101, 32,
/* 0x5d20 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x5d30 */  32, 32, 78, 50, 69, 68, 69, 67, 53, 48, 10, 48, 48, 48, 48, 48,
/* 0x5d40 */  48, 51, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x5d50 */  32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 54, 48, 10, 10,
/* 0x5d60 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x5d70 */  68, 83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 83, 77, 65, 52, 48,
/* 0x5d80 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x5d90 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x5da0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 99, 32, 82, 95, 51,
/* 0x5db0 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78,
/* 0x5dc0 */  50, 69, 68, 69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x5dd0 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x5de0 */  91, 78, 50, 69, 70, 65, 83, 52, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x5df0 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e00 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x5e10 */  48, 48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x5e20 */  32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 51, 48,
/* 0x5e30 */  10, 48, 48, 48, 48, 48, 48, 48,101, 32, 82, 95, 51, 56, 54, 95,
/* 0x5e40 */  80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68,
/* 0x5e50 */  69, 67, 51, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78,
/* 0x5e60 */  32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 78, 50,
/* 0x5e70 */  69, 83, 77, 65, 54, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32,
/* 0x5e80 */  32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5e90 */  32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48,
/* 0x5ea0 */  48, 97, 32, 82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32,
/* 0x5eb0 */  32, 32, 32, 32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82,
/* 0x5ec0 */  69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68,
/* 0x5ed0 */  83, 32, 70, 79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 48, 93,
/* 0x5ee0 */  58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32,
/* 0x5ef0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76,
/* 0x5f00 */  85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 55, 32, 82, 95, 51, 56,
/* 0x5f10 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50,
/* 0x5f20 */  69, 70, 65, 83, 54, 49, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32,
/* 0x5f30 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x5f40 */  32, 32, 78, 50, 69, 68, 69, 67, 49, 48, 10, 10, 82, 69, 76, 79,
/* 0x5f50 */  67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70,
/* 0x5f60 */  79, 82, 32, 91, 78, 50, 69, 70, 65, 83, 54, 49, 93, 58, 10, 79,
/* 0x5f70 */  70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32,
/* 0x5f80 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10,
/* 0x5f90 */  48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x5fa0 */  67, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 78, 50, 69, 68, 69,
/* 0x5fb0 */  67, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32,
/* 0x5fc0 */  82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 76, 90, 77,
/* 0x5fd0 */  65, 95, 68, 69, 67, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x5fe0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x5ff0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6000 */  48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x6010 */  32, 32, 32, 32, 32, 32,108,122,109, 97, 95,115,116, 97, 99,107,
/* 0x6020 */  95, 97,100,106,117,115,116, 10, 48, 48, 48, 48, 48, 48, 49, 52,
/* 0x6030 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6040 */  32, 32, 32,108,122,109, 97, 95,117, 95,108,101,110, 10, 48, 48,
/* 0x6050 */  48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x6060 */  32, 32, 32, 32, 32, 32, 32, 32, 32,108,122,109, 97, 95, 99, 95,
/* 0x6070 */ 108,101,110, 10, 48, 48, 48, 48, 48, 48, 50, 97, 32, 82, 95, 51,
/* 0x6080 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,108,
/* 0x6090 */ 122,109, 97, 95,112,114,111,112,101,114,116,105,101,115, 10, 10,
/* 0x60a0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x60b0 */  68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 67, 84, 84, 80, 79, 83,
/* 0x60c0 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x60d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x60e0 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x60f0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,102,
/* 0x6100 */ 105,108,116,101,114, 95, 98,117,102,102,101,114, 95,115,116, 97,
/* 0x6110 */ 114,116, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82,
/* 0x6120 */  69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76,
/* 0x6130 */  84, 82, 48, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6140 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6150 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49,
/* 0x6160 */  32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32,
/* 0x6170 */  32, 32, 32,102,105,108,116,101,114, 95,108,101,110,103,116,104,
/* 0x6180 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6190 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86,
/* 0x61a0 */  69, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x61b0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61c0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82,
/* 0x61d0 */  95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x61e0 */  32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48,
/* 0x61f0 */  48, 48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6200 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 48, 48, 10,
/* 0x6210 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6220 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 48,
/* 0x6230 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6240 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6250 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95,
/* 0x6260 */  51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6270 */  67, 65, 76, 76, 84, 82, 48, 48, 10, 10, 82, 69, 76, 79, 67, 65,
/* 0x6280 */  84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82,
/* 0x6290 */  32, 91, 67, 65, 76, 76, 84, 82, 49, 48, 93, 58, 10, 79, 70, 70,
/* 0x62a0 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x62b0 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x62c0 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x62d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x62e0 */ 108,101,110,103,116,104, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x62f0 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6300 */  67, 65, 76, 76, 84, 82, 49, 49, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6310 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6320 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6330 */  48, 48, 48, 51, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32,
/* 0x6340 */  32, 32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 51, 10,
/* 0x6350 */  10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79,
/* 0x6360 */  82, 68, 83, 32, 70, 79, 82, 32, 91, 67, 84, 67, 76, 69, 86, 69,
/* 0x6370 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6380 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6390 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95,
/* 0x63a0 */  51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x63b0 */ 102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48, 48, 48,
/* 0x63c0 */  48, 48, 52, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x63d0 */  32, 32, 32, 32, 32, 32, 67, 65, 76, 76, 84, 82, 49, 49, 10, 10,
/* 0x63e0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x63f0 */  68, 83, 32, 70, 79, 82, 32, 91, 67, 65, 76, 76, 84, 82, 49, 51,
/* 0x6400 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6410 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6420 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32, 82, 95, 51,
/* 0x6430 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 67,
/* 0x6440 */  65, 76, 76, 84, 82, 49, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6450 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6460 */  91, 99,116,111,107, 51, 50, 46, 48, 48, 93, 58, 10, 79, 70, 70,
/* 0x6470 */  83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32,
/* 0x6480 */  32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48,
/* 0x6490 */  48, 48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x64a0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,102,105,108,116,101,114, 95,
/* 0x64b0 */ 108,101,110,103,116,104, 10, 48, 48, 48, 48, 48, 48, 48, 54, 32,
/* 0x64c0 */  82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32,
/* 0x64d0 */  32, 32, 99,116,111,107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76,
/* 0x64e0 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x64f0 */  70, 79, 82, 32, 91, 99,116,111,107, 51, 50, 46, 49, 48, 93, 58,
/* 0x6500 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6510 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6520 */  69, 10, 48, 48, 48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54,
/* 0x6530 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x6540 */ 107, 51, 50, 46, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6550 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6560 */  99,116,111,107, 51, 50, 46, 50, 48, 93, 58, 10, 79, 70, 70, 83,
/* 0x6570 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6580 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6590 */  48, 48, 48, 48, 53, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x65a0 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x65b0 */  48, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82, 95, 51, 56, 54,
/* 0x65c0 */  95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,
/* 0x65d0 */ 107, 51, 50, 46, 52, 48, 10, 48, 48, 48, 48, 48, 48, 48,101, 32,
/* 0x65e0 */  82, 95, 51, 56, 54, 95, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x65f0 */  32, 32,102,105,108,116,101,114, 95, 99,116,111, 10, 48, 48, 48,
/* 0x6600 */  48, 48, 48, 49, 48, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6610 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 52,
/* 0x6620 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6630 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x6640 */  50, 46, 51, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x6650 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6660 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x6670 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6680 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 52, 48, 10, 48, 48, 48,
/* 0x6690 */  48, 48, 48, 48, 57, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x66a0 */  32, 32, 32, 32, 32, 32, 32, 32, 99,116,111,107, 51, 50, 46, 49,
/* 0x66b0 */  48, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x66c0 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 99,116,111,107, 51,
/* 0x66d0 */  50, 46, 52, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32,
/* 0x66e0 */  84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x66f0 */  32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52,
/* 0x6700 */  32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32,
/* 0x6710 */  32, 32, 32, 99,116,111,107, 51, 50, 46, 48, 48, 10, 10, 82, 69,
/* 0x6720 */  76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83,
/* 0x6730 */  32, 70, 79, 82, 32, 91, 80, 69, 73, 77, 80, 79, 82, 84, 93, 58,
/* 0x6740 */  10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32,
/* 0x6750 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85,
/* 0x6760 */  69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54,
/* 0x6770 */  95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 99,111,109,
/* 0x6780 */ 112,114,101,115,115,101,100, 95,105,109,112,111,114,116,115, 10,
/* 0x6790 */  48, 48, 48, 48, 48, 48, 48, 98, 32, 82, 95, 51, 56, 54, 95, 80,
/* 0x67a0 */  67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 68,
/* 0x67b0 */  79, 78, 69, 10, 48, 48, 48, 48, 48, 48, 49, 50, 32, 82, 95, 51,
/* 0x67c0 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,
/* 0x67d0 */ 116, 97,114,116, 95,111,102, 95,105,109,112,111,114,116,115, 10,
/* 0x67e0 */  48, 48, 48, 48, 48, 48, 49,101, 32, 82, 95, 51, 56, 54, 95, 51,
/* 0x67f0 */  50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 76,111, 97,100, 76,
/* 0x6800 */ 105, 98,114, 97,114,121, 65, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6810 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6820 */  91, 80, 69, 73, 66, 89, 79, 82, 68, 93, 58, 10, 79, 70, 70, 83,
/* 0x6830 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6840 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6850 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6860 */  32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 73, 77, 79, 82, 68, 49,
/* 0x6870 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6880 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 75, 51, 50, 79,
/* 0x6890 */  82, 68, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x68a0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x68b0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 97, 32, 82,
/* 0x68c0 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x68d0 */  32,107,101,114,110,101,108, 51, 50, 95,111,114,100,105,110, 97,
/* 0x68e0 */ 108,115, 10, 48, 48, 48, 48, 48, 48, 48,102, 32, 82, 95, 51, 56,
/* 0x68f0 */  54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69,
/* 0x6900 */  73, 77, 80, 79, 82, 50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73,
/* 0x6910 */  79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91,
/* 0x6920 */  80, 69, 73, 77, 80, 79, 82, 50, 93, 58, 10, 79, 70, 70, 83, 69,
/* 0x6930 */  84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6940 */  32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48,
/* 0x6950 */  48, 48, 48, 55, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32,
/* 0x6960 */  32, 32, 32, 32, 32, 32, 32, 71,101,116, 80,114,111, 99, 65,100,
/* 0x6970 */ 100,114,101,115,115, 10, 48, 48, 48, 48, 48, 48, 49, 53, 32, 82,
/* 0x6980 */  95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6990 */  32, 80, 69, 73, 77, 80, 79, 82, 84, 10, 10, 82, 69, 76, 79, 67,
/* 0x69a0 */  65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79,
/* 0x69b0 */  82, 32, 91, 80, 69, 73, 69, 82, 69, 88, 69, 93, 58, 10, 79, 70,
/* 0x69c0 */  70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32,
/* 0x69d0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48,
/* 0x69e0 */  48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x69f0 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 69,120,105,116, 80,114,
/* 0x6a00 */ 111, 99,101,115,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6a10 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80,
/* 0x6a20 */  69, 82, 69, 76, 79, 67, 49, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6a30 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6a40 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6a50 */  48, 48, 50, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x6a60 */  32, 32, 32, 32, 32, 32,115,116, 97,114,116, 95,111,102, 95,114,
/* 0x6a70 */ 101,108,111, 99,115, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79,
/* 0x6a80 */  78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 82,
/* 0x6a90 */  69, 76, 79, 67, 51, 50, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84,
/* 0x6aa0 */  32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6ab0 */  32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48,
/* 0x6ac0 */  48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32, 32, 32,
/* 0x6ad0 */  32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50, 74, 10, 10,
/* 0x6ae0 */  82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82,
/* 0x6af0 */  68, 83, 32, 70, 79, 82, 32, 91, 82, 69, 76, 51, 50, 66, 73, 71,
/* 0x6b00 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6b10 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6b20 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 51, 32, 82, 95, 51,
/* 0x6b30 */  56, 54, 95, 80, 67, 56, 32, 32, 32, 32, 32, 32, 32, 32, 32, 82,
/* 0x6b40 */  69, 76, 79, 67, 51, 50, 48, 10, 10, 82, 69, 76, 79, 67, 65, 84,
/* 0x6b50 */  73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32, 70, 79, 82, 32,
/* 0x6b60 */  91, 82, 69, 76, 79, 67, 51, 50, 74, 93, 58, 10, 79, 70, 70, 83,
/* 0x6b70 */  69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32, 32, 32, 32, 32,
/* 0x6b80 */  32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69, 10, 48, 48, 48,
/* 0x6b90 */  48, 48, 48, 48, 49, 32, 82, 95, 51, 56, 54, 95, 80, 67, 56, 32,
/* 0x6ba0 */  32, 32, 32, 32, 32, 32, 32, 32, 82, 69, 76, 79, 67, 51, 50, 48,
/* 0x6bb0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6bc0 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 82, 76, 79, 72,
/* 0x6bd0 */  73, 48, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89,
/* 0x6be0 */  80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6bf0 */  86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82,
/* 0x6c00 */  95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6c10 */  32,114,101,108,111, 99, 95,100,101,108,116, 10, 10, 82, 69, 76,
/* 0x6c20 */  79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67, 79, 82, 68, 83, 32,
/* 0x6c30 */  70, 79, 82, 32, 91, 80, 69, 68, 69, 80, 72, 65, 75, 93, 58, 10,
/* 0x6c40 */  79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69, 32, 32, 32,
/* 0x6c50 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65, 76, 85, 69,
/* 0x6c60 */  10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51, 56, 54, 95,
/* 0x6c70 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,105,114,116,
/* 0x6c80 */ 117, 97,108, 80,114,111,116,101, 99,116, 10, 48, 48, 48, 48, 48,
/* 0x6c90 */  48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32, 32, 32, 32,
/* 0x6ca0 */  32, 32, 32, 32, 32, 32,118,112, 95, 98, 97,115,101, 10, 48, 48,
/* 0x6cb0 */  48, 48, 48, 48, 48,100, 32, 82, 95, 51, 56, 54, 95, 51, 50, 32,
/* 0x6cc0 */  32, 32, 32, 32, 32, 32, 32, 32, 32,118,112, 95,115,105,122,101,
/* 0x6cd0 */  10, 48, 48, 48, 48, 48, 48, 49, 98, 32, 82, 95, 51, 56, 54, 95,
/* 0x6ce0 */  51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,115,119,114,105,
/* 0x6cf0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6d00 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 67,
/* 0x6d10 */  93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80, 69,
/* 0x6d20 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86, 65,
/* 0x6d30 */  76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 50, 32, 82, 95, 51,
/* 0x6d40 */  56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,116,
/* 0x6d50 */ 108,115, 95,109,111,100,117,108,101, 95, 98, 97,115,101, 10, 48,
/* 0x6d60 */  48, 48, 48, 48, 48, 48, 56, 32, 82, 95, 51, 56, 54, 95, 51, 50,
/* 0x6d70 */  32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 80, 69, 84, 76, 83, 67,
/* 0x6d80 */  50, 10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69,
/* 0x6d90 */  67, 79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 68, 79, 74,
/* 0x6da0 */  85, 77, 80, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84,
/* 0x6db0 */  89, 80, 69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6dc0 */  32, 86, 65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 49, 32,
/* 0x6dd0 */  82, 95, 51, 56, 54, 95, 80, 67, 51, 50, 32, 32, 32, 32, 32, 32,
/* 0x6de0 */  32, 32,111,114,105,103,105,110, 97,108, 95,101,110,116,114,121,
/* 0x6df0 */  10, 10, 82, 69, 76, 79, 67, 65, 84, 73, 79, 78, 32, 82, 69, 67,
/* 0x6e00 */  79, 82, 68, 83, 32, 70, 79, 82, 32, 91, 80, 69, 84, 76, 83, 67,
/* 0x6e10 */  50, 93, 58, 10, 79, 70, 70, 83, 69, 84, 32, 32, 32, 84, 89, 80,
/* 0x6e20 */  69, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32, 86,
/* 0x6e30 */  65, 76, 85, 69, 10, 48, 48, 48, 48, 48, 48, 48, 52, 32, 82, 95,
/* 0x6e40 */  51, 56, 54, 95, 51, 50, 32, 32, 32, 32, 32, 32, 32, 32, 32, 32,
/* 0x6e50 */ 116,108,115, 95, 99, 97,108,108, 98, 97, 99,107,115, 95,112,116,
/* 0x6e60 */ 114, 10
};
