/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of TreeView.xs. Do not edit this file, edit TreeView.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "TreeView.xs"
    /*
    ###########################################################################
    # (@)PACKAGE:Win32::GUI::TreeView
    #
    # $Id: TreeView.xs,v 1.11 2010/04/08 21:26:48 jwgui Exp $
    #
    ###########################################################################
    */

#include "GUI.h"

void 
TreeView_onPreCreate(NOTXSPROC LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    perlcs->cs.lpszClass = WC_TREEVIEW;
    perlcs->cs.style = WS_VISIBLE | WS_CHILD | WS_BORDER | TVS_SHOWSELALWAYS;
    perlcs->cs.dwExStyle = WS_EX_CLIENTEDGE;
}

BOOL
TreeView_onParseOption(NOTXSPROC char *option, SV* value, LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    BOOL retval = TRUE;
    
    if(strcmp(option, "-imagelist") == 0) {
        perlcs->hImageList = (HIMAGELIST) handle_From(NOTXSCALL value);
    } else if(strcmp(option, "-tooltip") == 0) {
        perlcs->hTooltip = (HWND) handle_From(NOTXSCALL value);
        SwitchBit(perlcs->cs.style, TVS_NOTOOLTIPS, 0);        
    } else if BitmaskOptionValue("-lines",           perlcs->cs.style, TVS_HASLINES)
    } else if BitmaskOptionValue("-rootlines",       perlcs->cs.style, TVS_LINESATROOT)
    } else if BitmaskOptionValue("-buttons",         perlcs->cs.style, TVS_HASBUTTONS)
    } else if BitmaskOptionValue("-showselalways",   perlcs->cs.style, TVS_SHOWSELALWAYS)
    } else if BitmaskOptionValue("-checkboxes",      perlcs->cs.style, TVS_CHECKBOXES)
    } else if BitmaskOptionValue("-trackselect",     perlcs->cs.style, TVS_TRACKSELECT)
    } else if BitmaskOptionValue("-disabledragdrop", perlcs->cs.style, TVS_DISABLEDRAGDROP)
    } else if BitmaskOptionValue("-editlabels",      perlcs->cs.style, TVS_EDITLABELS)
    } else if BitmaskOptionValue("-fullrowselect",   perlcs->cs.style, TVS_FULLROWSELECT)
    } else if BitmaskOptionValue("-nonevenheight",   perlcs->cs.style, TVS_NONEVENHEIGHT)
    } else if BitmaskOptionValue("-noscroll",        perlcs->cs.style, TVS_NOSCROLL)
    } else if BitmaskOptionValue("-notooltips",      perlcs->cs.style, TVS_NOTOOLTIPS)
    } else if BitmaskOptionValue("-rtlreading",      perlcs->cs.style, TVS_RTLREADING)
    } else if BitmaskOptionValue("-singleexpand",    perlcs->cs.style, TVS_SINGLEEXPAND)
    } else retval = FALSE;

    return retval;
}

void
TreeView_onPostCreate(NOTXSPROC HWND myhandle, LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    if(perlcs->hImageList != NULL)
        TreeView_SetImageList(myhandle, perlcs->hImageList, TVSIL_NORMAL);
   
    if (perlcs->hTooltip != NULL) 
        TreeView_SetToolTips (myhandle, perlcs->hTooltip);

    if(perlcs->clrForeground != CLR_INVALID) {
        TreeView_SetTextColor (myhandle, perlcs->clrForeground);
        perlcs->clrForeground = CLR_INVALID;  // Don't Store
    }

    if(perlcs->clrBackground != CLR_INVALID) {
        TreeView_SetBkColor (myhandle, perlcs->clrBackground);
        perlcs->clrBackground = CLR_INVALID;  // Don't Store
    }
}

BOOL
TreeView_onParseEvent(NOTXSPROC char *name, int* eventID) {

    BOOL retval = TRUE;

         if Parse_Event("NodeClick",      PERLWIN32GUI_NEM_CONTROL1)
    else if Parse_Event("Collapse",       PERLWIN32GUI_NEM_CONTROL2)
    else if Parse_Event("Expand",         PERLWIN32GUI_NEM_CONTROL3)
    else if Parse_Event("Collapsing",     PERLWIN32GUI_NEM_CONTROL4)
    else if Parse_Event("Expanding",      PERLWIN32GUI_NEM_CONTROL5)
    else if Parse_Event("BeginLabelEdit", PERLWIN32GUI_NEM_CONTROL6)
    else if Parse_Event("EndLabelEdit",   PERLWIN32GUI_NEM_CONTROL7)
    else if Parse_Event("KeyDown",        PERLWIN32GUI_NEM_KEYDOWN)
    else retval = FALSE;

    return retval;
}

int
TreeView_onEvent (NOTXSPROC LPPERLWIN32GUI_USERDATA perlud, UINT uMsg, WPARAM wParam, LPARAM lParam) {

    int PerlResult = 1;
    TV_ITEM *pItem;
    
    if ( uMsg == WM_NOTIFY ) {

        LPNM_TREEVIEW tv_notify = (LPNM_TREEVIEW) lParam;
        switch(tv_notify->hdr.code) {
        
        case TVN_BEGINLABELEDIT:
           /*
            * (@)EVENT:BeginLabelEdit(NODE)
            * Sent when the user is about to edit the specified NODE of the TreeView
            * The event should return 0 to prevent the  action, 1 to allow it.
            *
            * For a treeview to receive this event, -editlabels need to be set to true.
            * (@)APPLIES_TO:TreeView
            */        
           pItem = &((TV_DISPINFO*)lParam)->item;
           PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL6, "BeginLabelEdit",
                PERLWIN32GUI_ARGTYPE_LONG, (IV) pItem->hItem,
                -1);
           
           // Force result if event is handle
           if (perlud->dwPlStyle & PERLWIN32GUI_EVENTHANDLING) {
               perlud->forceResult = (PerlResult == 0 ? TRUE : FALSE);
               PerlResult = 0; // MsgLoop return ForceResult
           }
           break;

        case TVN_ENDLABELEDIT: 
            /*
             * (@)EVENT:EndLabelEdit(NODE,TEXT)
             * Sent when the user has finished editing a label in the TreeView control.
             * You have explicitly set the text of the node to reflect the new changes. 
             * If the user cancels the edit, the text is undef.
             * (@)APPLIES_TO:TreeView
             */
           pItem = &((TV_DISPINFO*)lParam)->item;
           if ( pItem->pszText != NULL) {
             PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL7, "EndLabelEdit",
                PERLWIN32GUI_ARGTYPE_LONG, (IV) pItem->hItem,PERLWIN32GUI_ARGTYPE_STRING,pItem->pszText,
                -1);
             }
           else {
             //user has canceled the edit
             PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL7, "EndLabelEdit",
                PERLWIN32GUI_ARGTYPE_LONG, (IV) pItem->hItem,
                -1);           
           }
           
           break;
            
        case TVN_SELCHANGED:
            /*
             * (@)EVENT:NodeClick(NODE)
             * Sent when the user clicks on the specified NODE of the TreeView.
             * (@)APPLIES_TO:TreeView
             */
            PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL1, "NodeClick",
                PERLWIN32GUI_ARGTYPE_LONG, (IV) tv_notify->itemNew.hItem,
                -1);
            break;

        case TVN_ITEMEXPANDED:
            if(tv_notify->action == TVE_COLLAPSE) {
                /*
                 * (@)EVENT:Collapse(NODE)
                 * Sent when the user closes the specified NODE of the TreeView.
                 * (@)APPLIES_TO:TreeView
                 */
                PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL2, "Collapse",
                    PERLWIN32GUI_ARGTYPE_LONG, (IV) tv_notify->itemNew.hItem,
                    -1);
            } else {
                /*
                 * (@)EVENT:Expand(NODE)
                 * Sent when the user opens the specified NODE of the TreeView.
                 * (@)APPLIES_TO:TreeView
                 */
                PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL3, "Expand",
                    PERLWIN32GUI_ARGTYPE_LONG, (IV) tv_notify->itemNew.hItem,
                    -1);
            }
            break;

        case TVN_ITEMEXPANDING:

            if(tv_notify->action == TVE_COLLAPSE) {
                /*
                 * (@)EVENT:Collapsing(NODE)
                 * Sent when the user is about to close the
                 * specified NODE of the TreeView.
                 * The event should return 0 to prevent the
                 * action, 1 to allow it.
                 * (@)APPLIES_TO:TreeView
                 */
                PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL4, "Collapsing",
                    PERLWIN32GUI_ARGTYPE_LONG, (IV) tv_notify->itemNew.hItem,
                    -1);
            } else {
                /*
                 * (@)EVENT:Expanding(NODE)
                 * Sent when the user is about to open the
                 * specified NODE of the TreeView
                 * The event should return 0 to prevent the
                 * action, 1 to allow it.
                 * (@)APPLIES_TO:TreeView
                 */
                PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL5, "Expanding",
                    PERLWIN32GUI_ARGTYPE_LONG, (IV) tv_notify->itemNew.hItem,
                    -1);
            }

            // Force result if event is handle
            if (perlud->dwPlStyle & PERLWIN32GUI_EVENTHANDLING) {
                perlud->forceResult = (PerlResult == 0 ? TRUE : FALSE);
                PerlResult = 0; // MsgLoop return ForceResult 
            }
            break;

        case TVN_KEYDOWN:

            /*
             * (@)EVENT:KeyDown(KEY)
             * Sent when the user presses a key while the TreeView
             * control has focus; KEY is the ASCII code of the
             * key being pressed.
             * (@)APPLIES_TO:TreeView
             */
            TV_KEYDOWN FAR * tv_keydown = (TV_KEYDOWN FAR *) lParam;
            PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL1, "KeyDown",
                PERLWIN32GUI_ARGTYPE_LONG, (LONG) tv_keydown->wVKey,
                -1);

            break;
        } 
    }

    return PerlResult;
}

#line 241 "TreeView.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 385 "TreeView.c"
#pragma message( "*** PACKAGE Win32::GUI::TreeView..." )

XS_EUPXS(XS_Win32__GUI__TreeView_CreateDragImage); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_CreateDragImage)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, hitem");
    {
	HWND	handle;
	HTREEITEM	hitem = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	HIMAGELIST	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 247 "TreeView.xs"
    RETVAL = TreeView_CreateDragImage(handle, hitem);
#line 412 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_DeleteAllItems); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_DeleteAllItems)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 261 "TreeView.xs"
    RETVAL = TreeView_DeleteAllItems(handle);
#line 443 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_DeleteItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_DeleteItem)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 273 "TreeView.xs"
    RETVAL = TreeView_DeleteItem(handle,item);
#line 475 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_EditLabel); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_EditLabel)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	HWND	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 285 "TreeView.xs"
    RETVAL = TreeView_EditLabel(handle,item);
#line 507 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_EndEditLabelNow); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_EndEditLabelNow)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, flag=TRUE");
    {
	HWND	handle;
	BOOL	flag;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    flag = TRUE;
	else {
	    flag = (BOOL)SvIV(ST(1))
;
	}
#line 297 "TreeView.xs"
    RETVAL = TreeView_EndEditLabelNow(handle,flag);
#line 545 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_EnsureVisible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_EnsureVisible)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 309 "TreeView.xs"
    RETVAL = TreeView_EnsureVisible(handle, item);
#line 577 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_Expand); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_Expand)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, item, flag=TVE_EXPAND");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	UINT	flag;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    flag = TVE_EXPAND;
	else {
	    flag = (UINT)SvUV(ST(2))
;
	}
#line 322 "TreeView.xs"
    RETVAL = TreeView_Expand(handle, item, flag);
#line 617 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetBkColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetBkColor)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 333 "TreeView.xs"
    RETVAL = TreeView_GetBkColor(handle);
#line 647 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetChild); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetChild)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 345 "TreeView.xs"
    RETVAL = TreeView_GetChild(handle, item);
#line 679 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetCount)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	UINT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 359 "TreeView.xs"
    RETVAL = TreeView_GetCount(handle);
#line 710 "TreeView.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetDropHilight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetDropHilight)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 370 "TreeView.xs"
    RETVAL = TreeView_GetDropHilight(handle);
#line 740 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetEditControl); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetEditControl)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HWND	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 381 "TreeView.xs"
    RETVAL = TreeView_GetEditControl(handle);
#line 770 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetFirstVisible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetFirstVisible)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 392 "TreeView.xs"
    RETVAL = TreeView_GetFirstVisible(handle);
#line 800 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetImageList); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetImageList)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, type=TVSIL_NORMAL");
    {
	HWND	handle;
	int	type;
	HIMAGELIST	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    type = TVSIL_NORMAL;
	else {
	    type = (int)SvIV(ST(1))
;
	}
#line 405 "TreeView.xs"
    RETVAL = TreeView_GetImageList(handle,type);
#line 838 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetIndent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetIndent)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	UINT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 416 "TreeView.xs"
    RETVAL = TreeView_GetIndent(handle);
#line 868 "TreeView.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetInsertMarkColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetInsertMarkColor)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 427 "TreeView.xs"
    RETVAL = TreeView_GetInsertMarkColor(handle);
#line 898 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetISearchString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetISearchString)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, lpsz");
    {
	HWND	handle;
	LPTSTR	lpsz = (LPTSTR)SvPV_nolen(ST(1))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 439 "TreeView.xs"
    RETVAL = TreeView_GetISearchString(handle,lpsz);
#line 930 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetItem)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
#line 460 "TreeView.xs"
    TV_ITEM tv_item;
    char pszText[1024];
#line 954 "TreeView.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 463 "TreeView.xs"
    ZeroMemory(&tv_item, sizeof(TV_ITEM));
    tv_item.hItem = item;
    tv_item.mask = TVIF_CHILDREN | TVIF_HANDLE | TVIF_IMAGE
                 | TVIF_PARAM | TVIF_SELECTEDIMAGE
                 | TVIF_TEXT | TVIF_STATE;
    tv_item.pszText = pszText;
    tv_item.cchTextMax = 1024;
    if(TreeView_GetItem(handle, &tv_item)) {
        EXTEND(SP, 12);
        XST_mPV(0, "-text");
        XST_mPV(1, tv_item.pszText);
        XST_mPV(2, "-image");
        XST_mIV(3, tv_item.iImage);
        XST_mPV(4, "-selectedimage");
        XST_mIV(5, tv_item.iSelectedImage);
        XST_mPV(6, "-children");
        XST_mIV(7, tv_item.cChildren);
        XST_mPV(8, "-parent");
        XST_mIV(9, (IV) TreeView_GetParent(handle, item));
        XST_mPV(10, "-state");
        XST_mIV(11, tv_item.state);
        XSRETURN(12);
    } else {
        XSRETURN_EMPTY;
    }
#line 991 "TreeView.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetItemHeight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetItemHeight)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 496 "TreeView.xs"
    RETVAL = TreeView_GetItemHeight(handle);
#line 1020 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetItemRect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetItemRect)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, item, flag=FALSE");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	flag;
#line 510 "TreeView.xs"
    RECT    myRect;
#line 1043 "TreeView.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    flag = FALSE;
	else {
	    flag = (BOOL)SvIV(ST(2))
;
	}
#line 512 "TreeView.xs"
    if (TreeView_GetItemRect (handle, item, &myRect, flag)) {
        EXTEND(SP, 4);
        XST_mIV(0, myRect.left);
        XST_mIV(1, myRect.top);
        XST_mIV(2, myRect.right);
        XST_mIV(3, myRect.bottom);
        XSRETURN(4);
    }
    else
        XSRETURN_UNDEF;
#line 1072 "TreeView.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetLastVisible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetLastVisible)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 530 "TreeView.xs"
    RETVAL = TreeView_GetLastVisible(handle);
#line 1101 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetNextItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetNextItem)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, item, flag");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	UINT	flag = (UINT)SvUV(ST(2))
;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 556 "TreeView.xs"
    RETVAL = TreeView_GetNextItem(handle,item,flag);
#line 1135 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetNextSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetNextSibling)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 568 "TreeView.xs"
    RETVAL = TreeView_GetNextSibling(handle, item);
#line 1167 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetNextVisible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetNextVisible)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 580 "TreeView.xs"
    RETVAL = TreeView_GetNextVisible(handle, item);
#line 1199 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetParent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetParent)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, item = NULL");
    {
	HWND	handle;
	HTREEITEM	item;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    item = NULL;
	else {
	    item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	}
#line 596 "TreeView.xs"
    if(items == 1) { /* NOTE this is the XS defined 'items' var, not 'item' */
        SV   *SvParent;
        HWND parentHandle = GetParent(handle);

        if (parentHandle && (SvParent = SV_SELF_FROM_WINDOW(parentHandle)) && SvROK(SvParent)) {
            XPUSHs(SvParent);
            XSRETURN(1);
        }
        else {
            XSRETURN_UNDEF;
        }
    }
    else {
        RETVAL = TreeView_GetParent(handle, item);
    }
#line 1251 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetPrevSibling); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetPrevSibling)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 622 "TreeView.xs"
    RETVAL = TreeView_GetPrevSibling(handle, item);
#line 1283 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetPrevVisible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetPrevVisible)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 634 "TreeView.xs"
    RETVAL = TreeView_GetPrevVisible(handle, item);
#line 1315 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetRoot); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetRoot)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 645 "TreeView.xs"
    RETVAL = TreeView_GetRoot(handle);
#line 1345 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetScrollTime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetScrollTime)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	UINT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 656 "TreeView.xs"
    RETVAL = TreeView_GetScrollTime(handle);
#line 1375 "TreeView.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetSelection); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetSelection)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 670 "TreeView.xs"
    RETVAL = TreeView_GetSelection(handle);
#line 1406 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetTextColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetTextColor)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 681 "TreeView.xs"
    RETVAL = TreeView_GetTextColor(handle);
#line 1436 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetToolTips); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetToolTips)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HWND	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 692 "TreeView.xs"
    RETVAL = TreeView_GetToolTips(handle);
#line 1466 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetUnicodeFormat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetUnicodeFormat)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 703 "TreeView.xs"
    RETVAL = TreeView_GetUnicodeFormat(handle);
#line 1496 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_GetVisibleCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_GetVisibleCount)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	UINT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 717 "TreeView.xs"
    RETVAL = TreeView_GetVisibleCount(handle);
#line 1527 "TreeView.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_HitTest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_HitTest)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, x, y");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	LONG	x = (LONG)SvIV(ST(1))
;
	LONG	y = (LONG)SvIV(ST(2))
;
#line 730 "TreeView.xs"
    TV_HITTESTINFO ht;
#line 1551 "TreeView.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 732 "TreeView.xs"
    ht.pt.x = x;
    ht.pt.y = y;
    TreeView_HitTest(handle, &ht);
    if(GIMME == G_ARRAY) {
        EXTEND(SP, 2);
        XST_mIV(0, (IV) ht.hItem);
        XST_mIV(1, ht.flags);
        XSRETURN(2);
    } else {
        XSRETURN_IV((IV) ht.hItem);
    }
#line 1574 "TreeView.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TreeView_InsertItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_InsertItem)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "handle, ...");
    {
	HWND	handle;
#line 770 "TreeView.xs"
    TV_ITEM Item;
    TV_INSERTSTRUCT Insert;
    unsigned int tlen;
    int i, next_i;
    int imageSeen, selectedImageSeen;
    LPSTR pszText;
    char * option;
#line 1597 "TreeView.c"
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 778 "TreeView.xs"
    ZeroMemory(&Item, sizeof(TV_ITEM));
    ZeroMemory(&Insert, sizeof(TV_INSERTSTRUCT));
    Insert.hParent = NULL;
    Insert.hInsertAfter = TVI_LAST;

    imageSeen = 0;
    selectedImageSeen = 0;
    pszText = NULL;

    next_i = -1;
    for(i = 1; i < items; i++) {
        if(next_i == -1) {
            option = SvPV_nolen(ST(i));
            if(strcmp(option, "-text") == 0) {
                next_i = i + 1;
                tlen = SvCUR(ST(next_i));
                pszText = (LPSTR) safemalloc(tlen + 1);
                strcpy(pszText, SvPV_nolen(ST(next_i)));
                Item.pszText = pszText;
                Item.cchTextMax = tlen;
                SwitchBit(Item.mask, TVIF_TEXT, 1);
            } else if(strcmp(option, "-image") == 0) {
                next_i = i + 1;
                imageSeen = 1;
                Item.iImage = (int)SvIV(ST(next_i));
                SwitchBit(Item.mask, TVIF_IMAGE, 1);
            } else if(strcmp(option, "-selectedimage") == 0) {
                next_i = i + 1;
                selectedImageSeen = 1;
                Item.iSelectedImage = (int)SvIV(ST(next_i));
                SwitchBit(Item.mask, TVIF_SELECTEDIMAGE, 1);
            } else if(strcmp(option, "-parent") == 0) {
                next_i = i + 1;
                Insert.hParent = (HTREEITEM) handle_From(NOTXSCALL ST(next_i));
            } else if(strcmp(option, "-item") == 0
                   || strcmp(option, "-index") == 0) {
                next_i = i + 1;
                Insert.hInsertAfter = (HTREEITEM) handle_From(NOTXSCALL ST(next_i));
            } else if(strcmp(option, "-bold") == 0) {
                next_i = i + 1;
                SwitchBit(Item.state, TVIS_BOLD, SvIV(ST(next_i)));
                SwitchBit(Item.stateMask, TVIS_BOLD, 1);
                SwitchBit(Item.mask, TVIF_STATE, 1);
            } else if(strcmp(option, "-selected") == 0) {
                next_i = i + 1;
                SwitchBit(Item.state, TVIS_SELECTED, SvIV(ST(next_i)));
                SwitchBit(Item.stateMask, TVIS_SELECTED, 1);
                SwitchBit(Item.mask, TVIF_STATE, 1);
            }
        } else {
            next_i = -1;
        }
    }
    if(selectedImageSeen == 0 && imageSeen != 0) {
        Item.iSelectedImage = Item.iImage;
        SwitchBit(Item.mask, TVIF_SELECTEDIMAGE, 1);
    }
    Insert.item = Item;
    RETVAL = TreeView_InsertItem(handle, &Insert);
    if (pszText) safefree(pszText);
#line 1671 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_Select); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_Select)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, item, flag=TVGN_CARET");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	WPARAM	flag;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    flag = TVGN_CARET;
	else {
	    flag = (WPARAM)SvUV(ST(2))
;
	}
#line 856 "TreeView.xs"
    RETVAL = (BOOL) TreeView_Select(handle, item, flag);
#line 1711 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SelectDropTarget); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SelectDropTarget)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 868 "TreeView.xs"
    RETVAL = TreeView_SelectDropTarget(handle, item);
#line 1743 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SelectItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SelectItem)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 880 "TreeView.xs"
    RETVAL = TreeView_SelectItem(handle, item);
#line 1775 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetBkColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetBkColor)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, color");
    {
	HWND	handle;
	COLORREF    color = SvCOLORREF(NOTXSCALL ST(1))
;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 892 "TreeView.xs"
    RETVAL = TreeView_SetBkColor(handle, color);
#line 1807 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SelectSetFirstVisible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SelectSetFirstVisible)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 904 "TreeView.xs"
    RETVAL= TreeView_SelectSetFirstVisible(handle, item);
#line 1839 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetImageList); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetImageList)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, imagelist, type=TVSIL_NORMAL");
    {
	HWND	handle;
	HIMAGELIST	imagelist;
	WPARAM	type;
	HIMAGELIST	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

    if(SvROK(ST(1))) {
        SV** out=hv_fetch((HV*)SvRV(ST(1)), "-handle", 7, 0);
        if(out != NULL)
            imagelist = INT2PTR(HIMAGELIST,SvIV(*out));
        else
            imagelist = NULL;
    } else
       imagelist = INT2PTR(HIMAGELIST,SvIV(ST(1)))
;

	if (items < 3)
	    type = TVSIL_NORMAL;
	else {
	    type = (WPARAM)SvUV(ST(2))
;
	}
#line 917 "TreeView.xs"
    RETVAL = TreeView_SetImageList(handle, imagelist, type);
#line 1888 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetIndent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetIndent)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, value");
    {
	HWND	handle;
	UINT	value = (UINT)SvUV(ST(1))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 929 "TreeView.xs"
    RETVAL = TreeView_SetIndent(handle, value);
#line 1920 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetInsertMark); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetInsertMark)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, item, flag=FALSE");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	flag;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    flag = FALSE;
	else {
	    flag = (BOOL)SvIV(ST(2))
;
	}
#line 942 "TreeView.xs"
    RETVAL = TreeView_SetInsertMark(handle,item,flag);
#line 1960 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetInsertMarkColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetInsertMarkColor)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, color");
    {
	HWND	handle;
	COLORREF    color = SvCOLORREF(NOTXSCALL ST(1))
;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 954 "TreeView.xs"
    RETVAL = TreeView_SetInsertMarkColor(handle, color);
#line 1992 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetItem)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "handle, item, ...");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
#line 975 "TreeView.xs"
    int i, next_i, imageSeen, selectedImageSeen;
    STRLEN tlen;
    TV_ITEM Item;
    char * option;
#line 2016 "TreeView.c"
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 980 "TreeView.xs"
    ZeroMemory(&Item, sizeof(TV_ITEM));
    Item.hItem = item;
    imageSeen = 0;
    selectedImageSeen = 0;
    next_i = -1;
    for(i = 2; i < items; i++) {
        if(next_i == -1) {
            option = SvPV_nolen(ST(i));
            if(strcmp(option, "-text") == 0) {
                next_i = i + 1;
                Item.pszText = SvPV(ST(next_i), tlen);
                Item.cchTextMax = tlen;
                SwitchBit(Item.mask, TVIF_TEXT, 1);
            } else if(strcmp(option, "-image") == 0) {
                next_i = i + 1;
                imageSeen = 1;
                Item.iImage = (int)SvIV(ST(next_i));
                SwitchBit(Item.mask, TVIF_IMAGE, 1);
            } else if(strcmp(option, "-selectedimage") == 0) {
                next_i = i + 1;
                selectedImageSeen = 1;
                Item.iSelectedImage = (int)SvIV(ST(next_i));
                SwitchBit(Item.mask, TVIF_SELECTEDIMAGE, 1);
            } else if(strcmp(option, "-bold") == 0) {
                next_i = i + 1;
                SwitchBit(Item.state, TVIS_BOLD, SvIV(ST(next_i)));
                SwitchBit(Item.stateMask, TVIS_BOLD, 1);
                SwitchBit(Item.mask, TVIF_STATE, 1);
            } else if(strcmp(option, "-selected") == 0) {
                next_i = i + 1;
                SwitchBit(Item.state, TVIS_SELECTED, SvIV(ST(next_i)));
                SwitchBit(Item.stateMask, TVIS_SELECTED, 1);
                SwitchBit(Item.mask, TVIF_STATE, 1);
            }
        } else {
            next_i = -1;
        }
    }
    if(selectedImageSeen == 0 && imageSeen != 0) {
        Item.iSelectedImage = Item.iImage;
        SwitchBit(Item.mask, TVIF_SELECTEDIMAGE, 1);
    }
    RETVAL = TreeView_SetItem(handle, &Item);
#line 2073 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetItemHeight); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetItemHeight)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, cy");
    {
	HWND	handle;
	short	cy = (short)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1034 "TreeView.xs"
    RETVAL = TreeView_SetItemHeight(handle, cy);
#line 2105 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetScrollTime); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetScrollTime)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, time");
    {
	HWND	handle;
	UINT	time = (UINT)SvUV(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1046 "TreeView.xs"
    RETVAL = TreeView_SetScrollTime(handle, time);
#line 2137 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetTextColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetTextColor)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, color");
    {
	HWND	handle;
	COLORREF    color = SvCOLORREF(NOTXSCALL ST(1))
;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1058 "TreeView.xs"
    RETVAL = TreeView_SetTextColor(handle, color);
#line 2169 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetToolTips); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetToolTips)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, tooltip");
    {
	HWND	handle;
	HWND	tooltip;
	HWND	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

    if(SvROK(ST(1))) {
        SV** out=hv_fetch((HV*)SvRV(ST(1)), "-handle", 7, 0);
        if(out != NULL)
            tooltip = INT2PTR(HWND,SvIV(*out));
        else
            tooltip = NULL;
    } else
       tooltip = INT2PTR(HWND,SvIV(ST(1)))
;
#line 1070 "TreeView.xs"
    RETVAL = TreeView_SetToolTips(handle, tooltip);
#line 2210 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SetUnicodeFormat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SetUnicodeFormat)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, flag");
    {
	HWND	handle;
	BOOL	flag = (BOOL)SvIV(ST(1))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1082 "TreeView.xs"
    RETVAL = TreeView_SetUnicodeFormat(handle, flag);
#line 2242 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_SortChildren); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_SortChildren)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1097 "TreeView.xs"
    RETVAL = TreeView_SortChildren(handle, item, 0);
#line 2275 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_Clear); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_Clear)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "handle, ...");
    {
	HWND	handle;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1115 "TreeView.xs"
    if(items != 1 && items != 2)
        croak("Usage: Clear(handle, [item]);\n");
    if(items == 1)
        RETVAL = TreeView_DeleteAllItems(handle);
    else
        RETVAL = TreeView_Expand(handle,
                                 INT2PTR(HTREEITEM,SvIV(ST(1))),
                                 TVE_COLLAPSE | TVE_COLLAPSERESET);
#line 2312 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_Collapse); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_Collapse)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 1134 "TreeView.xs"
    RETVAL = TreeView_Expand(handle, item, TVE_COLLAPSE);
#line 2344 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_Indent); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_Indent)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, value=(UINT) -1");
    {
	HWND	handle;
	UINT	value;
	UINT	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    value = (UINT) -1;
	else {
	    value = (UINT)SvUV(ST(1))
;
	}
#line 1146 "TreeView.xs"
    if(items == 2)
        RETVAL = TreeView_SetIndent(handle, value);
    else
        RETVAL = TreeView_GetIndent(handle);
#line 2385 "TreeView.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_FirstVisible); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_FirstVisible)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, item=0");
    {
	HWND	handle;
	HTREEITEM	item;
	HTREEITEM	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    item = 0;
	else {
	    item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	}
#line 1161 "TreeView.xs"
    RETVAL = TreeView_GetFirstVisible(handle);
    if(items == 2)
        TreeView_SelectSetFirstVisible(handle, item);
#line 2425 "TreeView.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_ItemCheck); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_ItemCheck)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, item, value=FALSE");
    {
	HWND	handle;
	HTREEITEM	item = INT2PTR(HTREEITEM,SvIV(ST(1)))
;
	BOOL	value;
#line 1176 "TreeView.xs"
    TVITEM tvitem;
#line 2446 "TreeView.c"
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    value = FALSE;
	else {
	    value = (BOOL)SvIV(ST(2))
;
	}
#line 1178 "TreeView.xs"
    if(items == 3) {
        tvitem.mask = TVIF_HANDLE | TVIF_STATE;
        tvitem.hItem = item;
        tvitem.stateMask = TVIS_STATEIMAGEMASK;
        tvitem.state = INDEXTOSTATEIMAGEMASK((value ? 2 : 1));
        RETVAL = TreeView_SetItem(handle, &tvitem);
    } else {
        tvitem.mask = TVIF_HANDLE | TVIF_STATE;
        tvitem.hItem = item;
        tvitem.stateMask = TVIS_STATEIMAGEMASK;
        TreeView_GetItem(handle, &tvitem);
        RETVAL = ((BOOL)(tvitem.state >> 12) -1);
    }
#line 2480 "TreeView.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_TextColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_TextColor)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, color=(COLORREF) -1");
    {
	HWND	handle;
	COLORREF	color;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    color = (COLORREF) -1;
	else {
    color = SvCOLORREF(NOTXSCALL ST(1))
;
	}
#line 1202 "TreeView.xs"
    if(items == 2) {
        if(TreeView_SetTextColor(handle, color))
            RETVAL = TreeView_GetTextColor(handle);
        else
            RETVAL = (COLORREF) -1;
    } else
        RETVAL = TreeView_GetTextColor(handle);
#line 2524 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TreeView_BackColor); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TreeView_BackColor)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, color=(COLORREF) -1");
    {
	HWND	handle;
	COLORREF	color;
	COLORREF	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    color = (COLORREF) -1;
	else {
    color = SvCOLORREF(NOTXSCALL ST(1))
;
	}
#line 1220 "TreeView.xs"
    if(items == 2) {
        if(TreeView_SetBkColor(handle, color))
            RETVAL = TreeView_GetBkColor(handle);
        else
            RETVAL = (COLORREF) -1;
    } else
        RETVAL = TreeView_GetBkColor(handle);
#line 2568 "TreeView.c"
	XSprePUSH;
	PUSHi((IV) RETVAL);
    }
    XSRETURN(1);
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Win32__GUI__TreeView); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Win32__GUI__TreeView)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Win32::GUI::TreeView::CreateDragImage", XS_Win32__GUI__TreeView_CreateDragImage);
        cv = newXS_deffile("Win32::GUI::TreeView::DeleteAllItems", XS_Win32__GUI__TreeView_DeleteAllItems);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TreeView::Reset", XS_Win32__GUI__TreeView_DeleteAllItems);
        XSANY.any_i32 = 1;
        newXS_deffile("Win32::GUI::TreeView::DeleteItem", XS_Win32__GUI__TreeView_DeleteItem);
        newXS_deffile("Win32::GUI::TreeView::EditLabel", XS_Win32__GUI__TreeView_EditLabel);
        newXS_deffile("Win32::GUI::TreeView::EndEditLabelNow", XS_Win32__GUI__TreeView_EndEditLabelNow);
        newXS_deffile("Win32::GUI::TreeView::EnsureVisible", XS_Win32__GUI__TreeView_EnsureVisible);
        newXS_deffile("Win32::GUI::TreeView::Expand", XS_Win32__GUI__TreeView_Expand);
        newXS_deffile("Win32::GUI::TreeView::GetBkColor", XS_Win32__GUI__TreeView_GetBkColor);
        newXS_deffile("Win32::GUI::TreeView::GetChild", XS_Win32__GUI__TreeView_GetChild);
        cv = newXS_deffile("Win32::GUI::TreeView::Count", XS_Win32__GUI__TreeView_GetCount);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TreeView::GetCount", XS_Win32__GUI__TreeView_GetCount);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::TreeView::GetDropHilight", XS_Win32__GUI__TreeView_GetDropHilight);
        newXS_deffile("Win32::GUI::TreeView::GetEditControl", XS_Win32__GUI__TreeView_GetEditControl);
        newXS_deffile("Win32::GUI::TreeView::GetFirstVisible", XS_Win32__GUI__TreeView_GetFirstVisible);
        newXS_deffile("Win32::GUI::TreeView::GetImageList", XS_Win32__GUI__TreeView_GetImageList);
        newXS_deffile("Win32::GUI::TreeView::GetIndent", XS_Win32__GUI__TreeView_GetIndent);
        newXS_deffile("Win32::GUI::TreeView::GetInsertMarkColor", XS_Win32__GUI__TreeView_GetInsertMarkColor);
        newXS_deffile("Win32::GUI::TreeView::GetISearchString", XS_Win32__GUI__TreeView_GetISearchString);
        cv = newXS_deffile("Win32::GUI::TreeView::GetItem", XS_Win32__GUI__TreeView_GetItem);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TreeView::ItemInfo", XS_Win32__GUI__TreeView_GetItem);
        XSANY.any_i32 = 1;
        newXS_deffile("Win32::GUI::TreeView::GetItemHeight", XS_Win32__GUI__TreeView_GetItemHeight);
        newXS_deffile("Win32::GUI::TreeView::GetItemRect", XS_Win32__GUI__TreeView_GetItemRect);
        newXS_deffile("Win32::GUI::TreeView::GetLastVisible", XS_Win32__GUI__TreeView_GetLastVisible);
        newXS_deffile("Win32::GUI::TreeView::GetNextItem", XS_Win32__GUI__TreeView_GetNextItem);
        newXS_deffile("Win32::GUI::TreeView::GetNextSibling", XS_Win32__GUI__TreeView_GetNextSibling);
        newXS_deffile("Win32::GUI::TreeView::GetNextVisible", XS_Win32__GUI__TreeView_GetNextVisible);
        newXS_deffile("Win32::GUI::TreeView::GetParent", XS_Win32__GUI__TreeView_GetParent);
        newXS_deffile("Win32::GUI::TreeView::GetPrevSibling", XS_Win32__GUI__TreeView_GetPrevSibling);
        newXS_deffile("Win32::GUI::TreeView::GetPrevVisible", XS_Win32__GUI__TreeView_GetPrevVisible);
        newXS_deffile("Win32::GUI::TreeView::GetRoot", XS_Win32__GUI__TreeView_GetRoot);
        newXS_deffile("Win32::GUI::TreeView::GetScrollTime", XS_Win32__GUI__TreeView_GetScrollTime);
        cv = newXS_deffile("Win32::GUI::TreeView::GetSelection", XS_Win32__GUI__TreeView_GetSelection);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TreeView::SelectedItem", XS_Win32__GUI__TreeView_GetSelection);
        XSANY.any_i32 = 1;
        newXS_deffile("Win32::GUI::TreeView::GetTextColor", XS_Win32__GUI__TreeView_GetTextColor);
        newXS_deffile("Win32::GUI::TreeView::GetToolTips", XS_Win32__GUI__TreeView_GetToolTips);
        newXS_deffile("Win32::GUI::TreeView::GetUnicodeFormat", XS_Win32__GUI__TreeView_GetUnicodeFormat);
        cv = newXS_deffile("Win32::GUI::TreeView::GetVisibleCount", XS_Win32__GUI__TreeView_GetVisibleCount);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TreeView::VisibleCount", XS_Win32__GUI__TreeView_GetVisibleCount);
        XSANY.any_i32 = 1;
        newXS_deffile("Win32::GUI::TreeView::HitTest", XS_Win32__GUI__TreeView_HitTest);
        newXS_deffile("Win32::GUI::TreeView::InsertItem", XS_Win32__GUI__TreeView_InsertItem);
        newXS_deffile("Win32::GUI::TreeView::Select", XS_Win32__GUI__TreeView_Select);
        newXS_deffile("Win32::GUI::TreeView::SelectDropTarget", XS_Win32__GUI__TreeView_SelectDropTarget);
        newXS_deffile("Win32::GUI::TreeView::SelectItem", XS_Win32__GUI__TreeView_SelectItem);
        newXS_deffile("Win32::GUI::TreeView::SetBkColor", XS_Win32__GUI__TreeView_SetBkColor);
        newXS_deffile("Win32::GUI::TreeView::SelectSetFirstVisible", XS_Win32__GUI__TreeView_SelectSetFirstVisible);
        newXS_deffile("Win32::GUI::TreeView::SetImageList", XS_Win32__GUI__TreeView_SetImageList);
        newXS_deffile("Win32::GUI::TreeView::SetIndent", XS_Win32__GUI__TreeView_SetIndent);
        newXS_deffile("Win32::GUI::TreeView::SetInsertMark", XS_Win32__GUI__TreeView_SetInsertMark);
        newXS_deffile("Win32::GUI::TreeView::SetInsertMarkColor", XS_Win32__GUI__TreeView_SetInsertMarkColor);
        cv = newXS_deffile("Win32::GUI::TreeView::ChangeItem", XS_Win32__GUI__TreeView_SetItem);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TreeView::SetItem", XS_Win32__GUI__TreeView_SetItem);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::TreeView::SetItemHeight", XS_Win32__GUI__TreeView_SetItemHeight);
        newXS_deffile("Win32::GUI::TreeView::SetScrollTime", XS_Win32__GUI__TreeView_SetScrollTime);
        newXS_deffile("Win32::GUI::TreeView::SetTextColor", XS_Win32__GUI__TreeView_SetTextColor);
        newXS_deffile("Win32::GUI::TreeView::SetToolTips", XS_Win32__GUI__TreeView_SetToolTips);
        newXS_deffile("Win32::GUI::TreeView::SetUnicodeFormat", XS_Win32__GUI__TreeView_SetUnicodeFormat);
        cv = newXS_deffile("Win32::GUI::TreeView::Sort", XS_Win32__GUI__TreeView_SortChildren);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TreeView::SortChildren", XS_Win32__GUI__TreeView_SortChildren);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::TreeView::Clear", XS_Win32__GUI__TreeView_Clear);
        newXS_deffile("Win32::GUI::TreeView::Collapse", XS_Win32__GUI__TreeView_Collapse);
        newXS_deffile("Win32::GUI::TreeView::Indent", XS_Win32__GUI__TreeView_Indent);
        newXS_deffile("Win32::GUI::TreeView::FirstVisible", XS_Win32__GUI__TreeView_FirstVisible);
        newXS_deffile("Win32::GUI::TreeView::ItemCheck", XS_Win32__GUI__TreeView_ItemCheck);
        newXS_deffile("Win32::GUI::TreeView::TextColor", XS_Win32__GUI__TreeView_TextColor);
        newXS_deffile("Win32::GUI::TreeView::BackColor", XS_Win32__GUI__TreeView_BackColor);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
