/*
 * This file was generated automatically by ExtUtils::ParseXS version 3.51 from the
 * contents of TabStrip.xs. Do not edit this file, edit TabStrip.xs instead.
 *
 *    ANY CHANGES MADE HERE WILL BE LOST!
 *
 */

#line 1 "TabStrip.xs"
    /*
    ###########################################################################
    # (@)PACKAGE:Win32::GUI::TabStrip
    #
    # $Id: TabStrip.xs,v 1.4 2010/04/08 21:26:48 jwgui Exp $
    #
    ###########################################################################
    */

#include "GUI.h"

void 
TabStrip_onPreCreate(NOTXSPROC LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    perlcs->cs.lpszClass = WC_TABCONTROL;
    perlcs->cs.style = WS_VISIBLE | WS_CHILD;
}

BOOL
TabStrip_onParseOption(NOTXSPROC char *option, SV* value, LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    BOOL retval = TRUE;

    if(strcmp(option, "-imagelist") == 0) {
        perlcs->hImageList = (HIMAGELIST) handle_From(NOTXSCALL value);
    } else if(strcmp(option, "-tooltip") == 0) {
        perlcs->hTooltip = (HWND) handle_From(NOTXSCALL value);
        SwitchBit(perlcs->cs.style, TCS_TOOLTIPS, 1);        
    } else if(strcmp(option, "-vertical") == 0) {
        SwitchBit(perlcs->cs.style, TCS_VERTICAL, SvIV(value));
        SwitchBit(perlcs->cs.style, TCS_MULTILINE, SvIV(value));
    } else if BitmaskOptionValue("-multiline",       perlcs->cs.style, TCS_MULTILINE)
    } else if BitmaskOptionValue("-bottom",          perlcs->cs.style, TCS_BOTTOM)
    } else if BitmaskOptionValue("-alignright",      perlcs->cs.style, TCS_RIGHT) 
    } else if BitmaskOptionValue("-hottrack",        perlcs->cs.style, TCS_HOTTRACK)
    } else if BitmaskOptionValue("-buttons",         perlcs->cs.style, TCS_BUTTONS)
    } else if BitmaskOptionValue("-flat",            perlcs->cs.style, TCS_FLATBUTTONS)
    } else if BitmaskOptionValue("-multiselect",     perlcs->cs.style, TCS_MULTISELECT)
    } else if BitmaskOptionValue("-forceiconleft",   perlcs->cs.style, TCS_FORCEICONLEFT)
    } else if BitmaskOptionValue("-forcelabelleft",  perlcs->cs.style, TCS_FORCELABELLEFT)
    } else if BitmaskOptionValue("-fixedwidth",      perlcs->cs.style, TCS_FIXEDWIDTH)
    } else if BitmaskOptionValue("-raggedright",     perlcs->cs.style, TCS_RAGGEDRIGHT)
    } else if BitmaskOptionValue("-focusbottondown", perlcs->cs.style, TCS_FOCUSONBUTTONDOWN)
    } else if BitmaskOptionValue("-focusnever",      perlcs->cs.style, TCS_FOCUSNEVER)
    } else if BitmaskOptionValueMask("-flatseparator",   perlcs->dwFlags,  TCS_EX_FLATSEPARATORS)
    } else retval = FALSE;

    return retval;
}

void
TabStrip_onPostCreate(NOTXSPROC HWND myhandle, LPPERLWIN32GUI_CREATESTRUCT perlcs) {

    if (perlcs->dwFlagsMask != 0)
        TabCtrl_SetExtendedStyle(myhandle, perlcs->dwFlags);

    if(perlcs->hImageList != NULL)
        TabCtrl_SetImageList(myhandle, perlcs->hImageList);

    if (perlcs->hTooltip != NULL) 
        TabCtrl_SetToolTips (myhandle, perlcs->hTooltip);
}

BOOL
TabStrip_onParseEvent(NOTXSPROC char *name, int* eventID) {

    BOOL retval = TRUE;

         if Parse_Event("Changing",    PERLWIN32GUI_NEM_CONTROL1)
    else if Parse_Event("Change",      PERLWIN32GUI_NEM_CONTROL2)
    else retval = FALSE;

    return retval;
}

int
TabStrip_onEvent (NOTXSPROC LPPERLWIN32GUI_USERDATA perlud, UINT uMsg, WPARAM wParam, LPARAM lParam) {

    int PerlResult = 1;
    
    if ( uMsg == WM_NOTIFY ) {

        LPNMHDR notify = (LPNMHDR) lParam;
        switch(notify->code) {

        case TCN_SELCHANGING:

            /*
             * (@)EVENT:Changing()
             * Sent before the current selection changes.
             * Use SelectedItem() to determine the
             * current selection.
             * The event should return 0 to prevent
             * the selection changing, 1 to allow it.
             * (@)APPLIES_TO:TabStrip
             */

            PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL1, "Changing", -1);

            // Force result if event is handle
            if (perlud->dwPlStyle & PERLWIN32GUI_EVENTHANDLING) {
                perlud->forceResult = (PerlResult == 0 ? TRUE : FALSE);
                PerlResult = 0; // MsgLoop return ForceResult 
            }
            break;

        case TCN_SELCHANGE:
            /*
             * (@)EVENT:Change()
             * Sent when the current
             * selection has changed. Use SelectedItem()
             * to determine the current selection.
             * (@)APPLIES_TO:TabStrip
             */
            PerlResult = DoEvent(NOTXSCALL perlud, PERLWIN32GUI_NEM_CONTROL2, "Change", -1);
            break;
        } 
    }
    return PerlResult;
}

#line 132 "TabStrip.c"
#ifndef PERL_UNUSED_VAR
#  define PERL_UNUSED_VAR(var) if (0) var = var
#endif

#ifndef dVAR
#  define dVAR		dNOOP
#endif


/* This stuff is not part of the API! You have been warned. */
#ifndef PERL_VERSION_DECIMAL
#  define PERL_VERSION_DECIMAL(r,v,s) (r*1000000 + v*1000 + s)
#endif
#ifndef PERL_DECIMAL_VERSION
#  define PERL_DECIMAL_VERSION \
	  PERL_VERSION_DECIMAL(PERL_REVISION,PERL_VERSION,PERL_SUBVERSION)
#endif
#ifndef PERL_VERSION_GE
#  define PERL_VERSION_GE(r,v,s) \
	  (PERL_DECIMAL_VERSION >= PERL_VERSION_DECIMAL(r,v,s))
#endif
#ifndef PERL_VERSION_LE
#  define PERL_VERSION_LE(r,v,s) \
	  (PERL_DECIMAL_VERSION <= PERL_VERSION_DECIMAL(r,v,s))
#endif

/* XS_INTERNAL is the explicit static-linkage variant of the default
 * XS macro.
 *
 * XS_EXTERNAL is the same as XS_INTERNAL except it does not include
 * "STATIC", ie. it exports XSUB symbols. You probably don't want that
 * for anything but the BOOT XSUB.
 *
 * See XSUB.h in core!
 */


/* TODO: This might be compatible further back than 5.10.0. */
#if PERL_VERSION_GE(5, 10, 0) && PERL_VERSION_LE(5, 15, 1)
#  undef XS_EXTERNAL
#  undef XS_INTERNAL
#  if defined(__CYGWIN__) && defined(USE_DYNAMIC_LOADING)
#    define XS_EXTERNAL(name) __declspec(dllexport) XSPROTO(name)
#    define XS_INTERNAL(name) STATIC XSPROTO(name)
#  endif
#  if defined(__SYMBIAN32__)
#    define XS_EXTERNAL(name) EXPORT_C XSPROTO(name)
#    define XS_INTERNAL(name) EXPORT_C STATIC XSPROTO(name)
#  endif
#  ifndef XS_EXTERNAL
#    if defined(HASATTRIBUTE_UNUSED) && !defined(__cplusplus)
#      define XS_EXTERNAL(name) void name(pTHX_ CV* cv __attribute__unused__)
#      define XS_INTERNAL(name) STATIC void name(pTHX_ CV* cv __attribute__unused__)
#    else
#      ifdef __cplusplus
#        define XS_EXTERNAL(name) extern "C" XSPROTO(name)
#        define XS_INTERNAL(name) static XSPROTO(name)
#      else
#        define XS_EXTERNAL(name) XSPROTO(name)
#        define XS_INTERNAL(name) STATIC XSPROTO(name)
#      endif
#    endif
#  endif
#endif

/* perl >= 5.10.0 && perl <= 5.15.1 */


/* The XS_EXTERNAL macro is used for functions that must not be static
 * like the boot XSUB of a module. If perl didn't have an XS_EXTERNAL
 * macro defined, the best we can do is assume XS is the same.
 * Dito for XS_INTERNAL.
 */
#ifndef XS_EXTERNAL
#  define XS_EXTERNAL(name) XS(name)
#endif
#ifndef XS_INTERNAL
#  define XS_INTERNAL(name) XS(name)
#endif

/* Now, finally, after all this mess, we want an ExtUtils::ParseXS
 * internal macro that we're free to redefine for varying linkage due
 * to the EXPORT_XSUB_SYMBOLS XS keyword. This is internal, use
 * XS_EXTERNAL(name) or XS_INTERNAL(name) in your code if you need to!
 */

#undef XS_EUPXS
#if defined(PERL_EUPXS_ALWAYS_EXPORT)
#  define XS_EUPXS(name) XS_EXTERNAL(name)
#else
   /* default to internal */
#  define XS_EUPXS(name) XS_INTERNAL(name)
#endif

#ifndef PERL_ARGS_ASSERT_CROAK_XS_USAGE
#define PERL_ARGS_ASSERT_CROAK_XS_USAGE assert(cv); assert(params)

/* prototype to pass -Wmissing-prototypes */
STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params);

STATIC void
S_croak_xs_usage(const CV *const cv, const char *const params)
{
    const GV *const gv = CvGV(cv);

    PERL_ARGS_ASSERT_CROAK_XS_USAGE;

    if (gv) {
        const char *const gvname = GvNAME(gv);
        const HV *const stash = GvSTASH(gv);
        const char *const hvname = stash ? HvNAME(stash) : NULL;

        if (hvname)
	    Perl_croak_nocontext("Usage: %s::%s(%s)", hvname, gvname, params);
        else
	    Perl_croak_nocontext("Usage: %s(%s)", gvname, params);
    } else {
        /* Pants. I don't think that it should be possible to get here. */
	Perl_croak_nocontext("Usage: CODE(0x%" UVxf ")(%s)", PTR2UV(cv), params);
    }
}
#undef  PERL_ARGS_ASSERT_CROAK_XS_USAGE

#define croak_xs_usage        S_croak_xs_usage

#endif

/* NOTE: the prototype of newXSproto() is different in versions of perls,
 * so we define a portable version of newXSproto()
 */
#ifdef newXS_flags
#define newXSproto_portable(name, c_impl, file, proto) newXS_flags(name, c_impl, file, proto, 0)
#else
#define newXSproto_portable(name, c_impl, file, proto) (PL_Sv=(SV*)newXS(name, c_impl, file), sv_setpv(PL_Sv, proto), (CV*)PL_Sv)
#endif /* !defined(newXS_flags) */

#if PERL_VERSION_LE(5, 21, 5)
#  define newXS_deffile(a,b) Perl_newXS(aTHX_ a,b,file)
#else
#  define newXS_deffile(a,b) Perl_newXS_deffile(aTHX_ a,b)
#endif

#line 276 "TabStrip.c"
#pragma message( "*** PACKAGE Win32::GUI::TabStrip..." )

XS_EUPXS(XS_Win32__GUI__TabStrip_AdjustRect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_AdjustRect)
{
    dVAR; dXSARGS;
    if (items < 5 || items > 6)
       croak_xs_usage(cv,  "handle, left, top, right, bottom, flag=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	int	left = (int)SvIV(ST(1))
;
	int	top = (int)SvIV(ST(2))
;
	int	right = (int)SvIV(ST(3))
;
	int	bottom = (int)SvIV(ST(4))
;
	BOOL	flag;
#line 142 "TabStrip.xs"
    RECT myRect;
#line 300 "TabStrip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 6)
	    flag = 0;
	else {
	    flag = (BOOL)SvIV(ST(5))
;
	}
#line 144 "TabStrip.xs"
    myRect.left   = left;
    myRect.top    = top;
    myRect.right  = right;
    myRect.bottom = bottom;
    TabCtrl_AdjustRect(handle, flag, &myRect);
    EXTEND(SP, 4);
    XST_mIV(0, myRect.left);
    XST_mIV(1, myRect.top);
    XST_mIV(2, myRect.right);
    XST_mIV(3, myRect.bottom);
    XSRETURN(4);
#line 330 "TabStrip.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TabStrip_DeleteAllItems); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_DeleteAllItems)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 166 "TabStrip.xs"
    RETVAL = TabCtrl_DeleteAllItems(handle);
#line 360 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_DeleteItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_DeleteItem)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    {
	HWND	handle;
	int	item = (int)SvIV(ST(1))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 178 "TabStrip.xs"
    RETVAL = TabCtrl_DeleteItem(handle, item);
#line 392 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_DeselectAll); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_DeselectAll)
{
    dVAR; dXSARGS;
    if (items < 1 || items > 2)
       croak_xs_usage(cv,  "handle, ExcludeFocus=0");
    {
	HWND	handle;
	int	ExcludeFocus;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 2)
	    ExcludeFocus = 0;
	else {
	    ExcludeFocus = (int)SvIV(ST(1))
;
	}
#line 192 "TabStrip.xs"
    TabCtrl_DeselectAll(handle, ExcludeFocus);
#line 428 "TabStrip.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetCurFocus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetCurFocus)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 201 "TabStrip.xs"
    RETVAL = TabCtrl_GetCurFocus(handle);
#line 456 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetCurSel); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetCurSel)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 215 "TabStrip.xs"
    RETVAL = TabCtrl_GetCurSel(handle);
#line 487 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetExtendedStyle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetExtendedStyle)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	DWORD	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 226 "TabStrip.xs"
    RETVAL = TabCtrl_GetExtendedStyle(handle);
#line 517 "TabStrip.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetImageList); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetImageList)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HIMAGELIST	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 237 "TabStrip.xs"
    RETVAL = TabCtrl_GetImageList(handle);
#line 547 "TabStrip.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetItem)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	int	item = (int)SvIV(ST(1))
;
#line 249 "TabStrip.xs"
    char szString [1024];
    TC_ITEM tcItem;
#line 570 "TabStrip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 252 "TabStrip.xs"
    ZeroMemory(&tcItem, sizeof(TC_ITEM));
    tcItem.pszText = szString;
    tcItem.cchTextMax = 1024;
    tcItem.mask = TCIF_TEXT | TCIF_STATE | TCIF_IMAGE;
    if(TabCtrl_GetItem(handle, item, &tcItem)) {
        EXTEND(SP, 6);
        XST_mPV(0, "-text");
        XST_mPV(1, tcItem.pszText);
        XST_mPV(2, "-image");
        XST_mIV(3, tcItem.iImage);
        XST_mPV(4, "-state");
        XST_mIV(5, tcItem.dwState);
        XSRETURN(6);
    } else {
        XSRETURN_UNDEF;
    }
#line 598 "TabStrip.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetItemCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetItemCount)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 279 "TabStrip.xs"
    RETVAL = TabCtrl_GetItemCount(handle);
#line 628 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetItemRect); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetItemRect)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, index");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	int	index = (int)SvIV(ST(1))
;
#line 291 "TabStrip.xs"
    RECT myRect;
#line 650 "TabStrip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 293 "TabStrip.xs"
    ZeroMemory(&myRect, sizeof(RECT));
    if(TabCtrl_GetItemRect(handle, index, &myRect)) {
        EXTEND(SP, 4);
        XST_mIV(0, myRect.left);
        XST_mIV(1, myRect.top);
        XST_mIV(2, myRect.right);
        XST_mIV(3, myRect.bottom);
        XSRETURN(4);
    } else {
        XSRETURN_UNDEF;
    }
#line 673 "TabStrip.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetRowCount); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetRowCount)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 315 "TabStrip.xs"
    RETVAL = TabCtrl_GetRowCount(handle);
#line 703 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetToolTips); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetToolTips)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	HWND	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 326 "TabStrip.xs"
    RETVAL = TabCtrl_GetToolTips(handle);
#line 733 "TabStrip.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetUnicodeFormat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetUnicodeFormat)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    {
	HWND	handle;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 337 "TabStrip.xs"
    RETVAL = TabCtrl_GetUnicodeFormat(handle);
#line 763 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_HighlightItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_HighlightItem)
{
    dVAR; dXSARGS;
    if (items < 2 || items > 3)
       croak_xs_usage(cv,  "handle, index, fHighlight=1");
    {
	HWND	handle;
	int	index = (int)SvIV(ST(1))
;
	int	fHighlight;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

	if (items < 3)
	    fHighlight = 1;
	else {
	    fHighlight = (int)SvIV(ST(2))
;
	}
#line 351 "TabStrip.xs"
    RETVAL = TabCtrl_HighlightItem(handle, index, (WORD) fHighlight);
#line 803 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_HitTest); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_HitTest)
{
    dVAR; dXSARGS;
    if (items < 3 || items > 4)
       croak_xs_usage(cv,  "handle, x, y, flags=0");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
#line 364 "TabStrip.xs"
    TCHITTESTINFO ht;
    int index;
#line 828 "TabStrip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 367 "TabStrip.xs"
    ZeroMemory(&ht, sizeof(TCHITTESTINFO));
    ht.pt.x = x;
    ht.pt.y = y;
    index = TabCtrl_HitTest(handle, &ht);
    if(GIMME == G_ARRAY) {
        EXTEND(SP, 2);
        XST_mIV(0, index);
        XST_mIV(1, ht.flags);
        XSRETURN(2);
    } else {
        XSRETURN_IV(index);
    }
#line 852 "TabStrip.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TabStrip_InsertItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_InsertItem)
{
    dVAR; dXSARGS;
    if (items < 1)
       croak_xs_usage(cv,  "handle, ...");
    {
	HWND	handle;
#line 395 "TabStrip.xs"
    TC_ITEM Item;
    int iIndex;
    STRLEN chText;
    int i, next_i;
#line 872 "TabStrip.c"
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 400 "TabStrip.xs"
    ZeroMemory(&Item, sizeof(TC_ITEM));
    iIndex = TabCtrl_GetItemCount(handle)+1;
    next_i = -1;
    for(i = 1; i < items; i++) {
        if(next_i == -1) {
            if(strcmp(SvPV_nolen(ST(i)), "-image") == 0) {
                next_i = i + 1;
                Item.iImage = (int)SvIV(ST(next_i));
                Item.mask |= TCIF_IMAGE;
            }
            else if(strcmp(SvPV_nolen(ST(i)), "-index") == 0) {
                next_i = i + 1;
                iIndex = (int) SvIV(ST(next_i));
            }
            else if(strcmp(SvPV_nolen(ST(i)), "-text") == 0) {
                next_i = i + 1;
                Item.pszText = SvPV(ST(next_i), chText);
                Item.cchTextMax = (int) chText;
                Item.mask |=  TCIF_TEXT;
            }
        } else {
            next_i = -1;
        }
    }
    RETVAL = TabCtrl_InsertItem(handle, iIndex, &Item);
#line 911 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_RemoveImage); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_RemoveImage)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, iImage");
    {
	HWND	handle;
	int	iImage = (int)SvIV(ST(1))
;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 439 "TabStrip.xs"
    TabCtrl_RemoveImage(handle, iImage);
#line 941 "TabStrip.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetCurFocus); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetCurFocus)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, index");
    {
	HWND	handle;
	int	index = (int)SvIV(ST(1))
;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 450 "TabStrip.xs"
    TabCtrl_SetCurFocus(handle, index);
#line 969 "TabStrip.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetCurSel); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetCurSel)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "handle, index");
    {
	HWND	handle;
	int	index = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 464 "TabStrip.xs"
    RETVAL = TabCtrl_SetCurSel(handle, index);
#line 1000 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetExtendedStyle); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetExtendedStyle)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, style");
    {
	HWND	handle;
	DWORD	style = (DWORD)SvUV(ST(1))
;
	DWORD	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 476 "TabStrip.xs"
    RETVAL = TabCtrl_SetExtendedStyle(handle, style);
#line 1032 "TabStrip.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetImageList); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetImageList)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, imagelist");
    {
	HWND	handle;
	HIMAGELIST	imagelist;
	HIMAGELIST	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

    if(SvROK(ST(1))) {
        SV** out=hv_fetch((HV*)SvRV(ST(1)), "-handle", 7, 0);
        if(out != NULL)
            imagelist = INT2PTR(HIMAGELIST,SvIV(*out));
        else
            imagelist = NULL;
    } else
       imagelist = INT2PTR(HIMAGELIST,SvIV(ST(1)))
;
#line 489 "TabStrip.xs"
    RETVAL = TabCtrl_SetImageList(handle, imagelist);
#line 1073 "TabStrip.c"
	XSprePUSH;
	PUSHi(PTR2IV(RETVAL));
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetItem); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetItem)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items < 2)
       croak_xs_usage(cv,  "handle, item, ...");
    {
	HWND	handle;
	int	item = (int)SvIV(ST(1))
;
#line 508 "TabStrip.xs"
    TC_ITEM Item;
    STRLEN chText;
    int i, next_i;
#line 1096 "TabStrip.c"
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 512 "TabStrip.xs"
    ZeroMemory(&Item, sizeof(TC_ITEM));
    next_i = -1;
    for(i = 2; i < items; i++) {
        if(next_i == -1) {
            if(strcmp(SvPV_nolen(ST(i)), "-image") == 0) {
                next_i = i + 1;
                Item.mask = Item.mask | TCIF_IMAGE;
                Item.iImage = (int)SvIV(ST(next_i));
            }
            if(strcmp(SvPV_nolen(ST(i)), "-text") == 0) {
                next_i = i + 1;
                Item.pszText = SvPV(ST(next_i), chText);
                Item.cchTextMax = (int) chText;
                Item.mask = Item.mask | TCIF_TEXT;
            }
        } else {
            next_i = -1;
        }
    }
    RETVAL = TabCtrl_SetItem(handle, item, &Item);
#line 1130 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetItemSize); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetItemSize)
{
    dVAR; dXSARGS;
    if (items != 3)
       croak_xs_usage(cv,  "handle, x, y");
    {
	HWND	handle;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;
	DWORD	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 546 "TabStrip.xs"
    RETVAL = TabCtrl_SetItemSize(handle, x, y);
#line 1164 "TabStrip.c"
	XSprePUSH;
	PUSHu((UV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetMinTabWidth); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetMinTabWidth)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 2)
       croak_xs_usage(cv,  "handle, width");
    {
	HWND	handle;
	int	width = (int)SvIV(ST(1))
;
	int	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 561 "TabStrip.xs"
    RETVAL = TabCtrl_SetMinTabWidth(handle, width);
#line 1197 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetPadding); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetPadding)
{
    dVAR; dXSARGS;
    dXSI32;
    if (items != 3)
       croak_xs_usage(cv,  "handle, x, y");
    {
	HWND	handle;
	int	x = (int)SvIV(ST(1))
;
	int	y = (int)SvIV(ST(2))
;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 577 "TabStrip.xs"
    TabCtrl_SetPadding(handle, x, y);
#line 1230 "TabStrip.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetToolTips); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetToolTips)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, tooltip");
    {
	HWND	handle;
	HWND	tooltip;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;

    if(SvROK(ST(1))) {
        SV** out=hv_fetch((HV*)SvRV(ST(1)), "-handle", 7, 0);
        if(out != NULL)
            tooltip = INT2PTR(HWND,SvIV(*out));
        else
            tooltip = NULL;
    } else
       tooltip = INT2PTR(HWND,SvIV(ST(1)))
;
#line 587 "TabStrip.xs"
    TabCtrl_SetToolTips(handle,tooltip);
#line 1267 "TabStrip.c"
    }
    XSRETURN_EMPTY;
}


XS_EUPXS(XS_Win32__GUI__TabStrip_SetUnicodeFormat); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_SetUnicodeFormat)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, flag");
    {
	HWND	handle;
	BOOL	flag = (BOOL)SvIV(ST(1))
;
	BOOL	RETVAL;
	dXSTARG;

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 597 "TabStrip.xs"
    RETVAL = TabCtrl_SetUnicodeFormat(handle, flag);
#line 1297 "TabStrip.c"
	XSprePUSH;
	PUSHi((IV)RETVAL);
    }
    XSRETURN(1);
}


XS_EUPXS(XS_Win32__GUI__TabStrip_GetString); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_GetString)
{
    dVAR; dXSARGS;
    if (items != 2)
       croak_xs_usage(cv,  "handle, item");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
	int	item = (int)SvIV(ST(1))
;
#line 613 "TabStrip.xs"
    char *szString;
    TC_ITEM tcItem;
#line 1320 "TabStrip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 616 "TabStrip.xs"
    szString = (char *) safemalloc(1024);
    tcItem.pszText = szString;
    tcItem.cchTextMax = 1024;
    tcItem.mask = TCIF_TEXT;
    if(TabCtrl_GetItem(handle, item, &tcItem)) {
        EXTEND(SP, 1);
        XST_mPV(0, szString);
        safefree(szString);
        XSRETURN(1);
    } else {
        safefree(szString);
        XSRETURN_UNDEF;
    }
#line 1345 "TabStrip.c"
	PUTBACK;
	return;
    }
}


XS_EUPXS(XS_Win32__GUI__TabStrip_DisplayArea); /* prototype to pass -Wmissing-prototypes */
XS_EUPXS(XS_Win32__GUI__TabStrip_DisplayArea)
{
    dVAR; dXSARGS;
    if (items != 1)
       croak_xs_usage(cv,  "handle");
    PERL_UNUSED_VAR(ax); /* -Wall */
    SP -= items;
    {
	HWND	handle;
#line 638 "TabStrip.xs"
    RECT    myRect;
#line 1364 "TabStrip.c"

    if(SvROK(ST(0))) {
        SV** out=hv_fetch((HV*)SvRV(ST(0)), "-handle", 7, 0);
        if(out != NULL)
            handle = INT2PTR(HWND,SvIV(*out));
        else
            handle = NULL;
    } else
       handle = INT2PTR(HWND,SvIV(ST(0)))
;
#line 640 "TabStrip.xs"
    GetClientRect (handle, &myRect);
    TabCtrl_AdjustRect(handle, 0, &myRect);
    EXTEND(SP, 4);
    XST_mIV(0, myRect.left);
    XST_mIV(1, myRect.top);
    XST_mIV(2, myRect.right  - myRect.left);
    XST_mIV(3, myRect.bottom - myRect.top);
    XSRETURN(4);
#line 1384 "TabStrip.c"
	PUTBACK;
	return;
    }
}

#ifdef __cplusplus
extern "C" {
#endif
XS_EXTERNAL(boot_Win32__GUI__TabStrip); /* prototype to pass -Wmissing-prototypes */
XS_EXTERNAL(boot_Win32__GUI__TabStrip)
{
#if PERL_VERSION_LE(5, 21, 5)
    dVAR; dXSARGS;
#else
    dVAR; dXSBOOTARGSXSAPIVERCHK;
#endif
#if PERL_VERSION_LE(5, 8, 999) /* PERL_VERSION_LT is 5.33+ */
    char* file = __FILE__;
#else
    const char* file = __FILE__;
#endif

    PERL_UNUSED_VAR(file);

    PERL_UNUSED_VAR(cv); /* -W */
    PERL_UNUSED_VAR(items); /* -W */
#if PERL_VERSION_LE(5, 21, 5)
    XS_VERSION_BOOTCHECK;
#  ifdef XS_APIVERSION_BOOTCHECK
    XS_APIVERSION_BOOTCHECK;
#  endif
#endif

        newXS_deffile("Win32::GUI::TabStrip::AdjustRect", XS_Win32__GUI__TabStrip_AdjustRect);
        cv = newXS_deffile("Win32::GUI::TabStrip::DeleteAllItems", XS_Win32__GUI__TabStrip_DeleteAllItems);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TabStrip::Reset", XS_Win32__GUI__TabStrip_DeleteAllItems);
        XSANY.any_i32 = 1;
        newXS_deffile("Win32::GUI::TabStrip::DeleteItem", XS_Win32__GUI__TabStrip_DeleteItem);
        newXS_deffile("Win32::GUI::TabStrip::DeselectAll", XS_Win32__GUI__TabStrip_DeselectAll);
        newXS_deffile("Win32::GUI::TabStrip::GetCurFocus", XS_Win32__GUI__TabStrip_GetCurFocus);
        cv = newXS_deffile("Win32::GUI::TabStrip::GetCurSel", XS_Win32__GUI__TabStrip_GetCurSel);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TabStrip::SelectedItem", XS_Win32__GUI__TabStrip_GetCurSel);
        XSANY.any_i32 = 1;
        newXS_deffile("Win32::GUI::TabStrip::GetExtendedStyle", XS_Win32__GUI__TabStrip_GetExtendedStyle);
        newXS_deffile("Win32::GUI::TabStrip::GetImageList", XS_Win32__GUI__TabStrip_GetImageList);
        newXS_deffile("Win32::GUI::TabStrip::GetItem", XS_Win32__GUI__TabStrip_GetItem);
        cv = newXS_deffile("Win32::GUI::TabStrip::Count", XS_Win32__GUI__TabStrip_GetItemCount);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TabStrip::GetItemCount", XS_Win32__GUI__TabStrip_GetItemCount);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::TabStrip::GetItemRect", XS_Win32__GUI__TabStrip_GetItemRect);
        cv = newXS_deffile("Win32::GUI::TabStrip::GetRowCount", XS_Win32__GUI__TabStrip_GetRowCount);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TabStrip::RowCount", XS_Win32__GUI__TabStrip_GetRowCount);
        XSANY.any_i32 = 1;
        newXS_deffile("Win32::GUI::TabStrip::GetToolTips", XS_Win32__GUI__TabStrip_GetToolTips);
        newXS_deffile("Win32::GUI::TabStrip::GetUnicodeFormat", XS_Win32__GUI__TabStrip_GetUnicodeFormat);
        newXS_deffile("Win32::GUI::TabStrip::HighlightItem", XS_Win32__GUI__TabStrip_HighlightItem);
        newXS_deffile("Win32::GUI::TabStrip::HitTest", XS_Win32__GUI__TabStrip_HitTest);
        newXS_deffile("Win32::GUI::TabStrip::InsertItem", XS_Win32__GUI__TabStrip_InsertItem);
        newXS_deffile("Win32::GUI::TabStrip::RemoveImage", XS_Win32__GUI__TabStrip_RemoveImage);
        newXS_deffile("Win32::GUI::TabStrip::SetCurFocus", XS_Win32__GUI__TabStrip_SetCurFocus);
        cv = newXS_deffile("Win32::GUI::TabStrip::Select", XS_Win32__GUI__TabStrip_SetCurSel);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TabStrip::SetCurSel", XS_Win32__GUI__TabStrip_SetCurSel);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::TabStrip::SetExtendedStyle", XS_Win32__GUI__TabStrip_SetExtendedStyle);
        newXS_deffile("Win32::GUI::TabStrip::SetImageList", XS_Win32__GUI__TabStrip_SetImageList);
        cv = newXS_deffile("Win32::GUI::TabStrip::ChangeItem", XS_Win32__GUI__TabStrip_SetItem);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TabStrip::SetItem", XS_Win32__GUI__TabStrip_SetItem);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::TabStrip::SetItemSize", XS_Win32__GUI__TabStrip_SetItemSize);
        cv = newXS_deffile("Win32::GUI::TabStrip::MinTabWidth", XS_Win32__GUI__TabStrip_SetMinTabWidth);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TabStrip::SetMinTabWidth", XS_Win32__GUI__TabStrip_SetMinTabWidth);
        XSANY.any_i32 = 0;
        cv = newXS_deffile("Win32::GUI::TabStrip::Padding", XS_Win32__GUI__TabStrip_SetPadding);
        XSANY.any_i32 = 1;
        cv = newXS_deffile("Win32::GUI::TabStrip::SetPadding", XS_Win32__GUI__TabStrip_SetPadding);
        XSANY.any_i32 = 0;
        newXS_deffile("Win32::GUI::TabStrip::SetToolTips", XS_Win32__GUI__TabStrip_SetToolTips);
        newXS_deffile("Win32::GUI::TabStrip::SetUnicodeFormat", XS_Win32__GUI__TabStrip_SetUnicodeFormat);
        newXS_deffile("Win32::GUI::TabStrip::GetString", XS_Win32__GUI__TabStrip_GetString);
        newXS_deffile("Win32::GUI::TabStrip::DisplayArea", XS_Win32__GUI__TabStrip_DisplayArea);
#if PERL_VERSION_LE(5, 21, 5)
#  if PERL_VERSION_GE(5, 9, 0)
    if (PL_unitcheckav)
        call_list(PL_scopestack_ix, PL_unitcheckav);
#  endif
    XSRETURN_YES;
#else
    Perl_xs_boot_epilog(aTHX_ ax);
#endif
}

#ifdef __cplusplus
}
#endif
