.\" $NCDId: @(#)AuMElExM.man,v 1.1 1994/09/27 00:31:43 greg Exp $
.\" copyright 1994 Steven King
.\"
.\" portions are
.\" * Copyright 1993 Network Computing Devices, Inc.
.\" *
.\" * Permission to use, copy, modify, distribute, and sell this software and its
.\" * documentation for any purpose is hereby granted without fee, provided that
.\" * the above copyright notice appear in all copies and that both that
.\" * copyright notice and this permission notice appear in supporting
.\" * documentation, and that the name Network Computing Devices, Inc. not be
.\" * used in advertising or publicity pertaining to distribution of this
.\" * software without specific, written prior permission.
.\" * 
.\" * THIS SOFTWARE IS PROVIDED 'AS-IS'.  NETWORK COMPUTING DEVICES, INC.,
.\" * DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING WITHOUT
.\" * LIMITATION ALL IMPLIED WARRANTIES OF MERCHANTABILITY, FITNESS FOR A
.\" * PARTICULAR PURPOSE, OR NONINFRINGEMENT.  IN NO EVENT SHALL NETWORK
.\" * COMPUTING DEVICES, INC., BE LIABLE FOR ANY DAMAGES WHATSOEVER, INCLUDING
.\" * SPECIAL, INCIDENTAL OR CONSEQUENTIAL DAMAGES, INCLUDING LOSS OF USE, DATA,
.\" * OR PROFITS, EVEN IF ADVISED OF THE POSSIBILITY THEREOF, AND REGARDLESS OF
.\" * WHETHER IN AN ACTION IN CONTRACT, TORT OR NEGLIGENCE, ARISING OUT OF OR IN
.\" * CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
.\"
.\" $Id: AuMElExM.man 5 1999-05-08 18:47:16Z jon $
.TH AuMakeElementExportMonitor 3 "1.2" "audiolib - element initialization"
.SH \fBName\fP
\fBAuMakeElementExportMonitor\fP \- initialize an ExportMonitor element
.SH \fBSynopsis\fP
#include <audio/audiolib.h>
.sp 1
\fBAuMakeElementExportMonitor\fP(\fIelement\fP, \fIinput\fP, \fIevent_rate\fP, \fIformat\fP, \fInum_tracks\fP)
.br
    \fBAuElement\fP *\fIelement\fP; /* \fBRETURN\fP */
.br
    unsigned short \fIinput\fP;
.br
    unsigned short \fIevent_rate\fP;
.br
    unsigned char \fIformat\fP;
.br
    unsigned char \fInum_tracks\fP;
.SH \fBArguments\fP
.IP \fIelement\fP 1i
Returns the initialized element.
.IP \fIinput\fP 1i
Specifies the index of the element to supply the audio data to monitor.
.IP \fIevent_rate\fP 1i
Specifies the event rate for the monitor.
.IP \fIformat\fP 1i
Specifies the format of the audio data.
Currently, the following formats are defined: \fBAuFormatULAW8\fP, \fBAuFormatLinearUnsigned8\fP, \fBAuFormatLinearSigned8\fP, \fBAuFormatLinearSigned16MSB\fP, \fBAuFormatLinearUnsigned16MSB\fP, \fBAuFormatSignedLinear16LSB\fP, and \fBAuFormatLinearUnsigned16LSB\fP.
.IP \fInum_tracks\fP 1i
Specifies the number of tracks in the audio data.
.SH \fBDescription\fP
\fBAuMakeElementExportMonitor\fP sets the \fItype\fP member of \fIelement\fP to \fBAuElementTypeExportMonitor\fP and initializes the \fIexportmonitor\fP member of \fIelement\fP with the remaining arguments.
.LP
\fBAuMakeElementExportMonitor\fP is implemented as a macro.
.SH \fBSee Also\fP
\fBAuMakeElementAddConstant\fP,
\fBAuMakeElementBundle\fP,
\fBAuMakeElementExportBucket\fP,
\fBAuMakeElementExportClient\fP,
\fBAuMakeElementExportDevice\fP,
\fBAuMakeElementImportBucket\fP,
\fBAuMakeElementImportClient\fP,
\fBAuMakeElementImportDevice\fP,
\fBAuMakeElementImportWaveForm\fP,
\fBAuMakeElementMultiplyConstant\fP,
\fBAuMakeElementSum\fP.
.sp 1
audiolib \- \fBNetwork Audio System\fP C Language Interface
