/*
 * Interface wrapper code.
 *
 * Generated by SIP 4.19.24
 *
 *     Copyright: (c) 2020 by Total Control Software
 *     License:   wxWindows License
 */

#include "sipAPI_richtext.h"

        #include <wx/richtext/richtextbuffer.h>

        #include <wx/richtext/richtextbuffer.h>
        #include <wx/richtext/richtextbuffer.h>


PyDoc_STRVAR(doc_wxRichTextObjectAddress_Init, "Init()");

extern "C" {static PyObject *meth_wxRichTextObjectAddress_Init(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectAddress_Init(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextObjectAddress *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextObjectAddress, &sipCpp))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Init();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectAddress, sipName_Init, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextObjectAddress_Copy, "Copy(address)\n"
"\n"
"Copies the address.");

extern "C" {static PyObject *meth_wxRichTextObjectAddress_Copy(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectAddress_Copy(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxRichTextObjectAddress* address;
         ::wxRichTextObjectAddress *sipCpp;

        static const char *sipKwdList[] = {
            sipName_address,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ9", &sipSelf, sipType_wxRichTextObjectAddress, &sipCpp, sipType_wxRichTextObjectAddress, &address))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->Copy(*address);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectAddress, sipName_Copy, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextObjectAddress_GetObject, "GetObject(topLevelContainer) -> RichTextObject\n"
"\n"
"Returns the object specified by the address, given a top level\n"
"container.");

extern "C" {static PyObject *meth_wxRichTextObjectAddress_GetObject(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectAddress_GetObject(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextParagraphLayoutBox* topLevelContainer;
        const  ::wxRichTextObjectAddress *sipCpp;

        static const char *sipKwdList[] = {
            sipName_topLevelContainer,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8", &sipSelf, sipType_wxRichTextObjectAddress, &sipCpp, sipType_wxRichTextParagraphLayoutBox, &topLevelContainer))
        {
             ::wxRichTextObject*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->GetObject(topLevelContainer);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxRichTextObject,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectAddress, sipName_GetObject, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextObjectAddress_Create, "Create(topLevelContainer, obj) -> bool\n"
"\n"
"Creates the address given a container and an object.");

extern "C" {static PyObject *meth_wxRichTextObjectAddress_Create(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectAddress_Create(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextParagraphLayoutBox* topLevelContainer;
         ::wxRichTextObject* obj;
         ::wxRichTextObjectAddress *sipCpp;

        static const char *sipKwdList[] = {
            sipName_topLevelContainer,
            sipName_obj,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ8J8", &sipSelf, sipType_wxRichTextObjectAddress, &sipCpp, sipType_wxRichTextParagraphLayoutBox, &topLevelContainer, sipType_wxRichTextObject, &obj))
        {
            bool sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = sipCpp->Create(topLevelContainer,obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return PyBool_FromLong(sipRes);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectAddress, sipName_Create, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextObjectAddress_GetAddress, "GetAddress() -> ArrayInt\n"
"\n"
"Returns the array of integers representing the object address.");

extern "C" {static PyObject *meth_wxRichTextObjectAddress_GetAddress(PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectAddress_GetAddress(PyObject *sipSelf, PyObject *sipArgs)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
         ::wxRichTextObjectAddress *sipCpp;

        if (sipParseArgs(&sipParseErr, sipArgs, "B", &sipSelf, sipType_wxRichTextObjectAddress, &sipCpp))
        {
             ::wxArrayInt*sipRes;

            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipRes = &sipCpp->GetAddress();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
                return 0;

            return sipConvertFromType(sipRes,sipType_wxArrayInt,SIP_NULLPTR);
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectAddress, sipName_GetAddress, SIP_NULLPTR);

    return SIP_NULLPTR;
}


PyDoc_STRVAR(doc_wxRichTextObjectAddress_SetAddress, "SetAddress(address)\n"
"\n"
"Sets the address from an array of integers.");

extern "C" {static PyObject *meth_wxRichTextObjectAddress_SetAddress(PyObject *, PyObject *, PyObject *);}
static PyObject *meth_wxRichTextObjectAddress_SetAddress(PyObject *sipSelf, PyObject *sipArgs, PyObject *sipKwds)
{
    PyObject *sipParseErr = SIP_NULLPTR;

    {
        const  ::wxArrayInt* address;
        int addressState = 0;
         ::wxRichTextObjectAddress *sipCpp;

        static const char *sipKwdList[] = {
            sipName_address,
        };

        if (sipParseKwdArgs(&sipParseErr, sipArgs, sipKwds, sipKwdList, SIP_NULLPTR, "BJ1", &sipSelf, sipType_wxRichTextObjectAddress, &sipCpp, sipType_wxArrayInt,&address, &addressState))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp->SetAddress(*address);
            Py_END_ALLOW_THREADS
            sipReleaseType(const_cast< ::wxArrayInt *>(address),sipType_wxArrayInt,addressState);

            if (PyErr_Occurred())
                return 0;

            Py_INCREF(Py_None);
            return Py_None;
        }
    }

    sipNoMethod(sipParseErr, sipName_RichTextObjectAddress, sipName_SetAddress, SIP_NULLPTR);

    return SIP_NULLPTR;
}


/* Call the instance's destructor. */
extern "C" {static void release_wxRichTextObjectAddress(void *, int);}
static void release_wxRichTextObjectAddress(void *sipCppV, int)
{
    Py_BEGIN_ALLOW_THREADS

    delete reinterpret_cast< ::wxRichTextObjectAddress *>(sipCppV);

    Py_END_ALLOW_THREADS
}


extern "C" {static void *array_wxRichTextObjectAddress(Py_ssize_t);}
static void *array_wxRichTextObjectAddress(Py_ssize_t sipNrElem)
{
    return new  ::wxRichTextObjectAddress[sipNrElem];
}


extern "C" {static void assign_wxRichTextObjectAddress(void *, SIP_SSIZE_T, void *);}
static void assign_wxRichTextObjectAddress(void *sipDst, SIP_SSIZE_T sipDstIdx, void *sipSrc)
{
    reinterpret_cast< ::wxRichTextObjectAddress *>(sipDst)[sipDstIdx] = *reinterpret_cast< ::wxRichTextObjectAddress *>(sipSrc);
}


extern "C" {static void *copy_wxRichTextObjectAddress(const void *, SIP_SSIZE_T);}
static void *copy_wxRichTextObjectAddress(const void *sipSrc, SIP_SSIZE_T sipSrcIdx)
{
    return new  ::wxRichTextObjectAddress(reinterpret_cast<const  ::wxRichTextObjectAddress *>(sipSrc)[sipSrcIdx]);
}


extern "C" {static void dealloc_wxRichTextObjectAddress(sipSimpleWrapper *);}
static void dealloc_wxRichTextObjectAddress(sipSimpleWrapper *sipSelf)
{
    if (sipIsOwnedByPython(sipSelf))
    {
        release_wxRichTextObjectAddress(sipGetAddress(sipSelf), 0);
    }
}


extern "C" {static void *init_type_wxRichTextObjectAddress(sipSimpleWrapper *, PyObject *, PyObject *, PyObject **, PyObject **, PyObject **);}
static void *init_type_wxRichTextObjectAddress(sipSimpleWrapper *, PyObject *sipArgs, PyObject *sipKwds, PyObject **sipUnused, PyObject **, PyObject **sipParseErr)
{
     ::wxRichTextObjectAddress *sipCpp = SIP_NULLPTR;

    {
         ::wxRichTextParagraphLayoutBox* topLevelContainer;
         ::wxRichTextObject* obj;

        static const char *sipKwdList[] = {
            sipName_topLevelContainer,
            sipName_obj,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J8J8", sipType_wxRichTextParagraphLayoutBox, &topLevelContainer, sipType_wxRichTextObject, &obj))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextObjectAddress(topLevelContainer,obj);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, SIP_NULLPTR, sipUnused, ""))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextObjectAddress();
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    {
        const  ::wxRichTextObjectAddress* address;

        static const char *sipKwdList[] = {
            sipName_address,
        };

        if (sipParseKwdArgs(sipParseErr, sipArgs, sipKwds, sipKwdList, sipUnused, "J9", sipType_wxRichTextObjectAddress, &address))
        {
            PyErr_Clear();

            Py_BEGIN_ALLOW_THREADS
            sipCpp = new  ::wxRichTextObjectAddress(*address);
            Py_END_ALLOW_THREADS

            if (PyErr_Occurred())
            {
                delete sipCpp;
                return SIP_NULLPTR;
            }

            return sipCpp;
        }
    }

    return SIP_NULLPTR;
}


static PyMethodDef methods_wxRichTextObjectAddress[] = {
    {SIP_MLNAME_CAST(sipName_Copy), SIP_MLMETH_CAST(meth_wxRichTextObjectAddress_Copy), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextObjectAddress_Copy)},
    {SIP_MLNAME_CAST(sipName_Create), SIP_MLMETH_CAST(meth_wxRichTextObjectAddress_Create), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextObjectAddress_Create)},
    {SIP_MLNAME_CAST(sipName_GetAddress), meth_wxRichTextObjectAddress_GetAddress, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextObjectAddress_GetAddress)},
    {SIP_MLNAME_CAST(sipName_GetObject), SIP_MLMETH_CAST(meth_wxRichTextObjectAddress_GetObject), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextObjectAddress_GetObject)},
    {SIP_MLNAME_CAST(sipName_Init), meth_wxRichTextObjectAddress_Init, METH_VARARGS, SIP_MLDOC_CAST(doc_wxRichTextObjectAddress_Init)},
    {SIP_MLNAME_CAST(sipName_SetAddress), SIP_MLMETH_CAST(meth_wxRichTextObjectAddress_SetAddress), METH_VARARGS|METH_KEYWORDS, SIP_MLDOC_CAST(doc_wxRichTextObjectAddress_SetAddress)}
};

sipVariableDef variables_wxRichTextObjectAddress[] = {
    {PropertyVariable, sipName_Address, &methods_wxRichTextObjectAddress[2], &methods_wxRichTextObjectAddress[5], SIP_NULLPTR, SIP_NULLPTR},
};

PyDoc_STRVAR(doc_wxRichTextObjectAddress, "RichTextObjectAddress(topLevelContainer, obj)\n"
"RichTextObjectAddress()\n"
"RichTextObjectAddress(address)\n"
"\n"
"A class for specifying an object anywhere in an object hierarchy,\n"
"without using a pointer, necessary since wxRTC commands may delete and\n"
"recreate sub-objects so physical object addresses change.");


sipClassTypeDef sipTypeDef__richtext_wxRichTextObjectAddress = {
    {
        -1,
        SIP_NULLPTR,
        SIP_NULLPTR,
        SIP_TYPE_CLASS,
        sipNameNr_wxRichTextObjectAddress,
        {SIP_NULLPTR},
        SIP_NULLPTR
    },
    {
        sipNameNr_RichTextObjectAddress,
        {0, 0, 1},
        6, methods_wxRichTextObjectAddress,
        0, SIP_NULLPTR,
        1, variables_wxRichTextObjectAddress,
        {SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR, SIP_NULLPTR},
    },
    doc_wxRichTextObjectAddress,
    -1,
    -1,
    SIP_NULLPTR,
    SIP_NULLPTR,
    init_type_wxRichTextObjectAddress,
    SIP_NULLPTR,
    SIP_NULLPTR,
#if PY_MAJOR_VERSION >= 3
    SIP_NULLPTR,
    SIP_NULLPTR,
#else
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
#endif
    dealloc_wxRichTextObjectAddress,
    assign_wxRichTextObjectAddress,
    array_wxRichTextObjectAddress,
    copy_wxRichTextObjectAddress,
    release_wxRichTextObjectAddress,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR,
    SIP_NULLPTR
};
