/* libvalashared.h generated by valac 0.30.0.38-a55d, the Vala compiler, do not modify */


#ifndef __BACKENDS_VALA_LIBVALASHARED_H__
#define __BACKENDS_VALA_LIBVALASHARED_H__

#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib-object.h>
#include <gio/gio.h>

G_BEGIN_DECLS


#define TYPE_SOURCE_LOCATION (source_location_get_type ())
typedef struct _SourceLocation SourceLocation;

#define TYPE_SOURCE_RANGE (source_range_get_type ())
typedef struct _SourceRange SourceRange;

#define TYPE_FIXIT (fixit_get_type ())
typedef struct _Fixit Fixit;

#define TYPE_SEVERITY (severity_get_type ())

#define TYPE_DIAGNOSTIC (diagnostic_get_type ())
typedef struct _Diagnostic Diagnostic;

#define TYPE_REMOTE_DOCUMENT (remote_document_get_type ())
typedef struct _RemoteDocument RemoteDocument;

#define TYPE_OPEN_DOCUMENT (open_document_get_type ())
typedef struct _OpenDocument OpenDocument;

#define RPC_TYPE_PARSE (rpc_parse_get_type ())
typedef struct _RpcParse RpcParse;

#define RPC_TYPE_DOCUMENT (rpc_document_get_type ())
typedef struct _RpcDocument RpcDocument;

#define RPC_TYPE_REPLY (rpc_reply_get_type ())
typedef struct _RpcReply RpcReply;

#define TYPE_HASH_UTILS (hash_utils_get_type ())
#define HASH_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_HASH_UTILS, HashUtils))
#define HASH_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_HASH_UTILS, HashUtilsClass))
#define IS_HASH_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_HASH_UTILS))
#define IS_HASH_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_HASH_UTILS))
#define HASH_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_HASH_UTILS, HashUtilsClass))

typedef struct _HashUtils HashUtils;
typedef struct _HashUtilsClass HashUtilsClass;
typedef struct _HashUtilsPrivate HashUtilsPrivate;

#define HASH_UTILS_TYPE_FILE (hash_utils_file_get_type ())
#define HASH_UTILS_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), HASH_UTILS_TYPE_FILE, HashUtilsFile))
#define HASH_UTILS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), HASH_UTILS_TYPE_FILE, HashUtilsFileClass))
#define HASH_UTILS_IS_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), HASH_UTILS_TYPE_FILE))
#define HASH_UTILS_IS_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), HASH_UTILS_TYPE_FILE))
#define HASH_UTILS_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), HASH_UTILS_TYPE_FILE, HashUtilsFileClass))

typedef struct _HashUtilsFile HashUtilsFile;
typedef struct _HashUtilsFileClass HashUtilsFileClass;
typedef struct _HashUtilsFilePrivate HashUtilsFilePrivate;

struct _SourceLocation {
	gint64 line;
	gint64 column;
};

struct _SourceRange {
	gint64 file;
	SourceLocation start;
	SourceLocation end;
};

struct _Fixit {
	SourceRange location;
	gchar* replacement;
};

typedef enum  {
	SEVERITY_NONE,
	SEVERITY_INFO,
	SEVERITY_WARNING,
	SEVERITY_DEPRECATED,
	SEVERITY_ERROR,
	SEVERITY_FATAL
} Severity;

struct _Diagnostic {
	guint32 severity;
	Fixit* fixits;
	gint fixits_length1;
	SourceRange* locations;
	gint locations_length1;
	gchar* message;
};

struct _RemoteDocument {
	gchar* path;
	char* remote_path;
};

struct _OpenDocument {
	gchar* path;
	gchar* data_path;
};

struct _RpcParse {
	gchar** args;
	gint args_length1;
	OpenDocument* documents;
	gint documents_length1;
};

struct _RpcDocument {
	gchar* path;
	Diagnostic* diagnostics;
	gint diagnostics_length1;
};

struct _RpcReply {
	RpcDocument* documents;
	gint documents_length1;
};

struct _HashUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HashUtilsPrivate * priv;
};

struct _HashUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (HashUtils *self);
};

struct _HashUtilsFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	HashUtilsFilePrivate * priv;
};

struct _HashUtilsFileClass {
	GTypeClass parent_class;
	void (*finalize) (HashUtilsFile *self);
};


GType source_location_get_type (void) G_GNUC_CONST;
SourceLocation* source_location_dup (const SourceLocation* self);
void source_location_free (SourceLocation* self);
gint source_location_compare_to (SourceLocation *self, SourceLocation* other);
GType source_range_get_type (void) G_GNUC_CONST;
SourceRange* source_range_dup (const SourceRange* self);
void source_range_free (SourceRange* self);
GType fixit_get_type (void) G_GNUC_CONST;
Fixit* fixit_dup (const Fixit* self);
void fixit_free (Fixit* self);
void fixit_copy (const Fixit* self, Fixit* dest);
void fixit_destroy (Fixit* self);
GType severity_get_type (void) G_GNUC_CONST;
GType diagnostic_get_type (void) G_GNUC_CONST;
Diagnostic* diagnostic_dup (const Diagnostic* self);
void diagnostic_free (Diagnostic* self);
void diagnostic_copy (const Diagnostic* self, Diagnostic* dest);
void diagnostic_destroy (Diagnostic* self);
GType remote_document_get_type (void) G_GNUC_CONST;
RemoteDocument* remote_document_dup (const RemoteDocument* self);
void remote_document_free (RemoteDocument* self);
void remote_document_copy (const RemoteDocument* self, RemoteDocument* dest);
void remote_document_destroy (RemoteDocument* self);
GType open_document_get_type (void) G_GNUC_CONST;
OpenDocument* open_document_dup (const OpenDocument* self);
void open_document_free (OpenDocument* self);
void open_document_copy (const OpenDocument* self, OpenDocument* dest);
void open_document_destroy (OpenDocument* self);
GType rpc_parse_get_type (void) G_GNUC_CONST;
RpcParse* rpc_parse_dup (const RpcParse* self);
void rpc_parse_free (RpcParse* self);
void rpc_parse_copy (const RpcParse* self, RpcParse* dest);
void rpc_parse_destroy (RpcParse* self);
GType rpc_document_get_type (void) G_GNUC_CONST;
RpcDocument* rpc_document_dup (const RpcDocument* self);
void rpc_document_free (RpcDocument* self);
void rpc_document_copy (const RpcDocument* self, RpcDocument* dest);
void rpc_document_destroy (RpcDocument* self);
GType rpc_reply_get_type (void) G_GNUC_CONST;
RpcReply* rpc_reply_dup (const RpcReply* self);
void rpc_reply_free (RpcReply* self);
void rpc_reply_copy (const RpcReply* self, RpcReply* dest);
void rpc_reply_destroy (RpcReply* self);
gpointer hash_utils_ref (gpointer instance);
void hash_utils_unref (gpointer instance);
GParamSpec* param_spec_hash_utils (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_hash_utils (GValue* value, gpointer v_object);
void value_take_hash_utils (GValue* value, gpointer v_object);
gpointer value_get_hash_utils (const GValue* value);
GType hash_utils_get_type (void) G_GNUC_CONST;
HashUtils* hash_utils_new (void);
HashUtils* hash_utils_construct (GType object_type);
gpointer hash_utils_file_ref (gpointer instance);
void hash_utils_file_unref (gpointer instance);
GParamSpec* hash_utils_param_spec_file (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void hash_utils_value_set_file (GValue* value, gpointer v_object);
void hash_utils_value_take_file (GValue* value, gpointer v_object);
gpointer hash_utils_value_get_file (const GValue* value);
GType hash_utils_file_get_type (void) G_GNUC_CONST;
guint hash_utils_file_hash (GFile* f);
gboolean hash_utils_file_equal (GFile* f1, GFile* f2);
HashUtilsFile* hash_utils_file_new (void);
HashUtilsFile* hash_utils_file_construct (GType object_type);


G_END_DECLS

#endif
