'\" t
.\" ** The above line should force tbl to be used as a preprocessor **
.\"
.\" Manual page in man(7) format with tbl(1) and groff_www(7)
.\" macros for fetchmail
.\"
.\" For license terms, see the file COPYING in this directory.
.\"
.\"
.\" Load www macros to process .URL requests, this requires groff:
.mso www.tmac
.\"
.TH fetchmail 1 2021-12-12 "fetchmail 6.4.28" "fetchmail reference manual"

.SH NAME
fetchmail \- fetch mail from a POP, IMAP, ETRN, or ODMR-capable server

.SH SYNOPSIS
\fBfetchmail\fP [\fIoption...\fP] [\fImailserver...\fP]
.br
\fBfetchmailconf\fP

.SH DESCRIPTION
\fBfetchmail\fP is a mail-retrieval and forwarding utility; it fetches
mail from remote mail servers and forwards it to your local (client)
machine's delivery system.  You can then handle the retrieved mail using
normal mail user agents such as \fBmutt\fP(1), \fBelm\fP(1) or
\fBMail\fP(1).  The \fBfetchmail\fP utility can be run in a daemon mode
to repeatedly poll one or more systems at a specified interval.
.PP
The \fBfetchmail\fP program can gather mail from servers supporting any
of the common mail-retrieval protocols: POP2 (legacy, to be removed from
future release), POP3, IMAP2bis, IMAP4, and IMAP4rev1.  It can also use
the ESMTP ETRN extension and ODMR.  (The RFCs describing all these
protocols are listed at the end of this manual page.)
.PP
While \fBfetchmail\fP is primarily intended to be used over on-demand
TCP/IP links (such as SLIP or PPP connections), it may also be useful as
a message transfer agent for sites which refuse for security reasons to
permit (sender-initiated) SMTP transactions with sendmail.

.SS SUPPORT, TROUBLESHOOTING
For troubleshooting, tracing and debugging, you need to increase
fetchmail's verbosity to actually see what happens. To do that, please
run \fBboth of the two following commands,
adding all of the options you'd normally use.\fP

.IP
.nf
env LC_ALL=C fetchmail \-V \-v \-\-nodetach \-\-nosyslog
.fi
.IP
(This command line prints in English how fetchmail understands your
configuration.)

.IP
.nf
env LC_ALL=C fetchmail \-vvv  \-\-nodetach \-\-nosyslog
.fi
.IP
(This command line actually runs fetchmail with verbose English output.)
.PP
Also see
.URL "https://fetchmail.sourceforge.io/fetchmail-FAQ.html#G3" "item #G3 in fetchmail's FAQ"
.PP
You can omit the LC_ALL=C part above if you want output in the local
language (if supported). However if you are posting to mailing lists,
please leave it in. The maintainers do not necessarily understand your
language, please use English.

.SH TLS (SSL) QUICKSTART
Your fetchmail distribution should have come with a README.SSL file, which see.
It is recommended to configure all polls with --ssl --sslproto tls1.2+
if supported by the server, which configures fetchmail along recent IETF
proposed standards and best current practices, RFC-8314, RFC-8996, RFC-8997.

.SH CONCEPTS
If \fBfetchmail\fP is used with a POP or an IMAP server (but not with
ETRN or ODMR), it has two fundamental modes of operation for each user
account from which it retrieves mail: \fIsingledrop\fP- and
\fImultidrop\fP-mode.
.IP "In singledrop-mode,"
\fBfetchmail\fP assumes that all messages in the user's account
(mailbox) are intended for a single recipient.  The identity of the
recipient will either default to the local user currently executing
\fBfetchmail\fP, or will need to be explicitly specified in the
configuration file.
.IP
\fBfetchmail\fP uses singledrop-mode when the fetchmailrc configuration
contains at most a single local user specification for a given server
account.
.IP "In multidrop-mode,"
\fBfetchmail\fP assumes that the mail server account actually contains
mail intended for any number of different recipients.  Therefore,
\fBfetchmail\fP must attempt to deduce the proper "envelope recipient"
from the mail headers of each message.  In this mode of operation,
\fBfetchmail\fP almost resembles a mail transfer agent (MTA).
.IP
Note that neither the POP nor IMAP protocols were intended for use in
this fashion, and hence envelope information is often not directly
available. The ISP must store the envelope information in some message
header \fBand\fP. The ISP must also store one copy of the message per
recipient. If either of the conditions is not fulfilled, this process is
unreliable, because \fBfetchmail\fP must then resort to guessing the
true envelope recipient(s) of a message. This usually fails for mailing
list messages and Bcc:d mail, or mail for multiple recipients in your
domain.
.IP
\fBfetchmail\fP uses multidrop-mode when more than one local user and/or
a wildcard is specified for a particular server account in the
configuration file.
.IP "In ETRN and ODMR modes,"
these considerations do not apply, as these protocols are based on SMTP,
which provides explicit envelope recipient information. These protocols
always support multiple recipients.
.PP
As each message is retrieved, \fBfetchmail\fP normally delivers it via
SMTP to port 25 on the machine it is running on (localhost), just as
though it were being passed in over a normal TCP/IP link.
\fBfetchmail\fP provides the SMTP server with an envelope recipient
derived in the manner described previously.  The mail will then be
delivered according to your MTA's rules (the Mail Transfer Agent is
usually \fBsendmail\fP(8), \fBexim\fP(8), or \fBpostfix\fP(8)).
Invoking your system's MDA (Mail Delivery Agent) is the duty of your
MTA.  All the delivery-control mechanisms (such as \fI.forward\fP files)
normally available through your system MTA and local delivery agents
will therefore be applied as usual.
.PP
If your fetchmail configuration sets a local MDA (see the \-\-mda
option), it will be used directly instead of talking SMTP to port 25.
.PP
If the program \fBfetchmailconf\fP is available, it will assist you in
setting up and editing a fetchmailrc configuration.  It runs under the X
window system and requires that the language Python and the Tk toolkit
(with Python bindings) be present on your system.  If you are first
setting up fetchmail for single-user mode, it is recommended that you
use Novice mode.  Expert mode provides complete control of fetchmail
configuration, including the multidrop features.  In either case,
the 'Autoprobe' button will tell you the most capable protocol a given
mail server supports, and warn you of potential problems with that
server.

.SH PREFACE ON THIS MANUAL
Fetchmail's run-time strings have been translated (localized) to some
languages, but the manual is only available in English.  In some
situations, for comparing output to manual, it may be helpful to
switch fetchmail to English output by overriding the locale variables,
for instance:

.IP
.nf
env LC_ALL=C fetchmail # add other options before the hash
.fi

.IP
.nf
env LANG=en fetchmail # other options before the hash
.fi
.PP
or similar. Details vary by operating system.

.SH GENERAL OPERATION
The behavior of \fBfetchmail\fP is controlled by command-line options and a
run control file, \fI~/.fetchmailrc\fP,
the syntax of which we describe in a later section (this file is what
the \fBfetchmailconf\fP program edits).  Command-line options override
\fI~/.fetchmailrc\fP declarations.
.PP
Each server name that you specify following the options on the command
line will be queried.  If you do not specify any servers on the command
line, each 'poll' entry in your \fI~/.fetchmailrc\fP file will be
queried, unless the idle option is used, which see.
.PP
To facilitate the use of \fBfetchmail\fP in scripts and pipelines, it
returns an appropriate exit code upon termination -- see EXIT CODES
below.
.PP
The following options modify the behavior of \fBfetchmail\fP.  It is
seldom necessary to specify any of these once you have a
working \fI.fetchmailrc\fP file set up.
.PP
Almost all options have a corresponding keyword which can be used to
declare them in a \fI.fetchmailrc\fP file.
.PP
Some special options are not covered here, but are documented instead
in sections on AUTHENTICATION and DAEMON MODE which follow.
.SS General Options
.TP
.B \-? | \-\-help
Displays option help.
.TP
.B \-V | \-\-version
Displays the version information for your copy of \fBfetchmail\fP.  No mail
fetch is performed.  Instead, for each server specified, all the option
information that would be computed if \fBfetchmail\fP were connecting to that
server is displayed.  Any non-printable characters in passwords or other string names
are shown as back-slashed C-like escape sequences.  This option is useful for
verifying that your options are set the way you want them.
.TP
.B \-c | \-\-check
Return a status code to indicate whether there is mail waiting,
without actually fetching or deleting mail (see EXIT CODES below).
This option turns off daemon mode (in which it would be useless).  It
does not play well with queries to multiple sites, and does not work
with ETRN or ODMR.  It will return a false positive if you leave read but
undeleted mail in your server mailbox and your fetch protocol cannot
tell kept messages from new ones.  This means it will work with IMAP,
not work with POP2, and may occasionally flake out under POP3.
.TP
.B \-s | \-\-silent
Silent mode.  Suppresses all progress/status messages that are
normally echoed to standard output during a fetch (but does not
suppress actual error messages).  The \-\-verbose option overrides this.
.TP
.B \-v | \-\-verbose
Verbose mode.  All control messages passed between \fBfetchmail\fP
and the mail server are echoed to stdout.  Overrides \-\-silent.
Doubling this option (\-v \-v) causes extra diagnostic information
to be printed.
.TP
.B \-\-nosoftbounce
(since v6.3.10, Keyword: set no softbounce, since v6.3.10)
.br
Hard bounce mode. All permanent delivery errors cause messages to be
deleted from the upstream server, see "no softbounce" below.
.TP
.B \-\-softbounce
(since v6.3.10, Keyword: set softbounce, since v6.3.10)
.br
Soft bounce mode. All permanent delivery errors cause messages to be
left on the upstream server if the protocol supports that.
.B This option is on by default to match historic fetchmail documentation,
and will be changed to hard bounce mode in the next fetchmail release.
.SS Disposal Options
.TP
.B \-a | \-\-all | (since v6.3.3) \-\-fetchall
(Keyword: fetchall, since v3.0)
.br
Retrieve both old (seen) and new messages from the mail server.  The
default is to fetch only messages the server has not marked seen.
Under POP3, this option also forces the use of RETR rather than TOP.
Note that POP2 retrieval behaves as though \-\-all is always on (see
RETRIEVAL FAILURE MODES below) and this option does not work with ETRN
or ODMR.  While the \-a and \-\-all command-line and fetchall rcfile
options have been supported for a long time, the \-\-fetchall
command-line option was added in v6.3.3.
.TP
.B \-k | \-\-keep
(Keyword: keep)
.br
Keep retrieved messages on the remote mail server.  Normally, messages
are deleted from the folder on the mail server after they have been retrieved.
Specifying the \fBkeep\fP option causes retrieved messages to remain in
your folder on the mail server.  This option does not work with ETRN or
ODMR. If used with POP3, it is recommended to also specify the \-\-uidl
option or uidl keyword.
.TP
.B \-K | \-\-nokeep
(Keyword: nokeep)
.br
Delete retrieved messages from the remote mail server.  This
option forces retrieved mail to be deleted.  It may be useful if
you have specified a default of \fBkeep\fP in your
\&\fI.fetchmailrc\fP.  This option is forced on with ETRN and ODMR.
.TP
.B \-F | \-\-flush
(Keyword: flush)
.br
POP3/IMAP only.  This is a dangerous option and can cause mail loss when
used improperly. It deletes old (seen) messages from the mail server
before retrieving new messages.  \fBWarning:\fP This can cause mail loss if
you check your mail with other clients than fetchmail, and cause
fetchmail to delete a message it had never fetched before.  It can also
cause mail loss if the mail server marks the message seen after
retrieval (IMAP2 servers). You should probably not use this option in your
configuration file. If you use it with POP3, you must use the 'uidl'
option. What you probably want is the default setting: if you do not
specify '\-k', then fetchmail will automatically delete messages after
successful delivery.
.TP
.B \-\-limitflush
POP3/IMAP only, since version 6.3.0.  Delete oversized messages from the
mail server before retrieving new messages. The size limit should be
separately specified with the \-\-limit option.  This option does not
work with ETRN or ODMR.
.SS Protocol and Query Options
.TP
.B \-p <proto> | \-\-proto <proto> | \-\-protocol <proto>
(Keyword: proto[col])
.br
Specify the protocol to use when communicating with the remote
mail server.  If no protocol is specified, the default is AUTO.
\fBproto\fP may be one of the following:
.RS
.IP AUTO
Tries IMAP, POP3, and POP2 (skipping any of these for which support
has not been compiled in).
.IP POP2
Post Office Protocol 2 (legacy, to be removed from future release)
.IP POP3
Post Office Protocol 3
.IP APOP
Use POP3 with old-fashioned MD5-challenge authentication.
Considered not resistant to man-in-the-middle attacks.
.IP RPOP
Use POP3 with RPOP authentication.
.IP KPOP
Use POP3 with Kerberos V4 authentication on port 1109.
.IP SDPS
Use POP3 with Demon Internet's SDPS extensions.
.IP IMAP
IMAP2bis, IMAP4, or IMAP4rev1 (\fBfetchmail\fP automatically detects their capabilities).
.IP ETRN
Use the ESMTP ETRN option.
.IP ODMR
Use the On-Demand Mail Relay ESMTP profile.
.RE
.PP
All these alternatives work in basically the same way (communicating
with standard server daemons to fetch mail already delivered to a
mailbox on the server) except ETRN and ODMR.  The ETRN mode
allows you to ask a compliant ESMTP server (such as BSD sendmail at
release 8.8.0 or higher) to immediately open a sender-SMTP connection
to your client machine and begin forwarding any items addressed to
your client machine in the server's queue of undelivered mail.   The
ODMR mode requires an ODMR-capable server and works similarly to
ETRN, except that it does not require the client machine to have
a static DNS.
.TP
.B \-U | \-\-uidl
(Keyword: uidl)
.br
Force UIDL use (effective only with POP3).  Force client-side tracking
of 'newness' of messages (UIDL stands for "unique ID listing" and is
described in RFC1939).  Use with 'keep' to use a mailbox as a baby
news drop for a group of users. The fact that seen messages are skipped
is logged, unless error logging is done through syslog while running in
daemon mode.  Note that fetchmail may automatically enable this option
depending on upstream server capabilities.  Note also that this option
may be removed and forced enabled in a future fetchmail version. See
also: \-\-idfile.
.TP
.B \-\-idle (since 6.3.3)
(Keyword: idle, since before 6.0.0)
.br
Enable IDLE use (effective only with IMAP). Note that this works with
only one account and one folder at a given time, other folders or
accounts will not be polled when idle is in effect!  While the idle rcfile
keyword had been supported for a long time, the \-\-idle command-line
option was added in version 6.3.3. IDLE use means that fetchmail tells
the IMAP server to send notice of new messages, so they can be retrieved
sooner than would be possible with regular polls.
.TP
.B \-P <portnumber> | \-\-service <servicename>
(Keyword: service) Since version 6.3.0.
.br
The service option permits you to specify a service name to connect to.
You can specify a decimal port number here, if your services database
lacks the required service-port assignments. See the FAQ item R12 and
the \-\-ssl documentation for details. This replaces the older \-\-port
option.
.P
Note that this does not magically switch between TLS-wrapped and STARTTLS
modes, if you specify a port number or service name here that is TLS-wrapped,
meaning it starts to negotiate TLS before sending application data in the clear,
you may need to specify \-\-ssl on the command line or ssl in your rcfile.
.TP
.B \-\-port <portnumber>
(Keyword: port)
.br
Obsolete version of \-\-service that does not take service names.
\fBNote:\fP this option may be removed from a future version.
.TP
.B \-\-principal <principal>
(Keyword: principal)
.br
The principal option permits you to specify a service principal for
mutual authentication.  This is applicable to POP3 or IMAP with Kerberos
4 authentication only.  It does not apply to Kerberos 5 or GSSAPI.  This
option may be removed in a future fetchmail version.
.TP
.B \-t <seconds> | \-\-timeout <seconds>
(Keyword: timeout)
.br
The timeout option allows you to set a server-non-response
timeout in seconds.  If a mail server does not send a greeting message
or respond to commands for the given number of seconds,
\fBfetchmail\fP will drop the connection to it.  Without such a timeout
\fBfetchmail\fP might hang until the TCP connection times out, trying to fetch
mail from a down host, which may be very long.
This would be particularly annoying for a \fBfetchmail\fP running in the
background.  There is a default timeout which fetchmail\~\-V will report.  If a
given connection receives too many timeouts in succession, fetchmail will
consider it wedged and stop retrying.  The calling user will be notified by
email if this happens.
.IP
Beginning with fetchmail 6.3.10, the SMTP client uses the recommended minimum
timeouts from RFC-5321 while waiting for the SMTP/LMTP server it is talking to.
You can raise the timeouts even more, but you cannot shorten them. This is to
avoid a painful situation where fetchmail has been configured with a short
timeout (a minute or less), ships a long message (many MBytes) to the local
MTA, which then takes longer than timeout to respond "OK", which it eventually
will; that would mean the mail gets delivered properly, but fetchmail cannot
notice it and will thus re-fetch this big message over and over again.
.TP
.B \-\-plugin <command>
(Keyword: plugin)
.br
The plugin option allows you to use an external program to establish the TCP
connection.  This is useful if you want to use ssh, or need some special
firewall setup.  The program will be looked up in $PATH and can optionally
be passed the host name and port as arguments using "%h" and "%p" respectively
(note that the interpolation logic is rather primitive, and these tokens must
be bounded by whitespace or beginning of string or end of string).
Fetchmail will write to the plugin's stdin and read from the plugin's
stdout.
.TP
.B \-\-plugout <command>
(Keyword: plugout)
.br
Identical to the plugin option above, but this one is used for the SMTP
connections.
.TP
.B \-r <name> | \-\-folder <name>
(Keyword: folder[s])
.br
Causes a specified non-default mail folder on the mail server (or
comma-separated list of folders) to be retrieved.  The syntax of the
folder name is server-dependent.  This option is not available under
POP3, ETRN, or ODMR.
.TP
.B \-\-tracepolls
(Keyword: tracepolls)
.br
Tell fetchmail to poll trace information in the form 'polling
account %s' and 'folder %s' to the Received line it generates,
where the %s parts are replaced by the user's remote name, the poll
label, and the folder (mailbox) where available (the Received header
also normally includes the server's true name).  This can be used to
facilitate mail filtering based on the account it is being received
from. The folder information is written only since version 6.3.4.
.TP
.B \-\-ssl
(Keyword: ssl)
.br
Causes the connection to the mail server to be encrypted via SSL, by
negotiating SSL directly after connecting (called SSL-wrapped mode, or
Implicit TLS by RFC-8314).  Please see the description of \-\-sslproto
below!  More information is available in the \fIREADME.SSL\fP file that
ships with fetchmail.
.IP
Note that even if this option is omitted, fetchmail may still negotiate
SSL in-band for POP3 or IMAP, through the STLS or STARTTLS feature.  You
can use the \-\-sslproto option to modify that behavior.
.IP
If no port is specified, the connection is attempted to the well known
port of the SSL version of the base protocol.  This is generally a
different port than the port used by the base protocol.  For IMAP, this
is port 143 for the clear protocol and port 993 for the SSL secured
protocol; for POP3, it is port 110 for the clear text and port 995 for
the encrypted variant.
.IP
If your system lacks the corresponding entries from /etc/services, see
the \-\-service option and specify the numeric port number as given in
the previous paragraph (unless your ISP had directed you to different
ports, which is uncommon however).
.TP
.B \-\-sslcert <name>
(Keyword: sslcert)
.br
For certificate-based client authentication.  Some SSL encrypted servers
require client side keys and certificates for authentication.  In most
cases, this is optional.  This specifies the location of the public key
certificate to be presented to the server at the time the SSL session is
established.  It is not required (but may be provided) if the server
does not require it.  It may be the same file as the private key
(combined key and certificate file) but this is not recommended. Also
see \-\-sslkey below.
.sp
\fBNOTE:\fP If you use client authentication, the user name is fetched
from the certificate's CommonName and overrides the name set with
\-\-user.
.TP
.B \-\-sslkey <name>
(Keyword: sslkey)
.br
Specifies the file name of the client side private SSL key.  Some SSL
encrypted servers require client side keys and certificates for
authentication.  In most cases, this is optional.  This specifies
the location of the private key used to sign transactions with the server
at the time the SSL session is established.  It is not required (but may
be provided) if the server does not require it. It may be the same file
as the public key (combined key and certificate file) but this is not
recommended.
.IP
If a password is required to unlock the key, it will be prompted for at
the time just prior to establishing the session to the server.  This can
cause some complications in daemon mode.
.IP
Also see \-\-sslcert above.
.TP
.B \-\-sslproto <value>
(Keyword: sslproto, NOTE: semantic changes since v6.4.0)
.br
This option has a dual use, out of historic fetchmail behaviour. It
controls both the SSL/TLS protocol version and, if \-\-ssl is not
specified, the STARTTLS behaviour (upgrading the protocol to an SSL or
TLS connection in-band). Some other options may however make TLS
mandatory.
.IP
Only if this option and \-\-ssl are both missing for a poll, there will
be opportunistic TLS for POP3 and IMAP, where fetchmail will attempt to
upgrade to TLSv1 or newer.
.IP
Recognized values for \-\-sslproto are given below. You should normally
choose one of the auto-negotiating options, i. e. '\fBtls1.2+\fP' or
\'\fBauto\fP' or one of the other options ending in a plus (\fB+\fP) character.
Note that depending on OpenSSL library version and configuration, some options
cause run-time errors because the requested SSL or TLS versions are not
supported by the particular installed OpenSSL library.
.RS
.IP '\fBTLS1.2+\fP'
(recommended). Since v6.4.0. Require TLS. Auto-negotiate TLSv1.2 or newer.
.IP '\fBauto\fP'
(default). Since v6.4.0. Require TLS. Auto-negotiate TLSv1 or newer, disable
SSLv3 downgrade.
(fetchmail 6.3.26 and older have auto-negotiated all protocols that
their OpenSSL library supported, including the broken SSLv3).
.IP "\fB''\fP, the empty string"
Disable STARTTLS. If \-\-ssl is given for the same server, log an error
and pretend that '\fBauto\fP' had been used instead.
.IP \&'\fBSSL23\fP'
see '\fBauto\fP'.
.IP \&'\fBSSL3\fP'
Require SSLv3 exactly. SSLv3 is broken, not supported on all systems, avoid it
if possible.  This will make fetchmail negotiate SSLv3 only, and is the
only way besides '\fBSSL3+\fP' to have fetchmail 6.4.0 or newer permit SSLv3.
.IP \&'\fBSSL3+\fP'
same as '\fBauto\fP', but permit SSLv3 as well. This is the only way
besides '\fBSSL3\fP' to have fetchmail 6.4.0 or newer permit SSLv3.
.IP \&'\fBTLS1\fP'
Require TLSv1. This does not negotiate TLSv1.1 or newer, and is
discouraged. Replace by TLS1+ unless the latter chokes your server.
.IP \&'\fBTLS1+\fP'
Since v6.4.0. See '\fBauto\fP'.
.IP \&'\fBTLS1.1\fP'
Since v6.4.0. Require TLS v1.1 exactly.
.IP \&'\fBTLS1.1+\fP'
Since v6.4.0. Require TLS. Auto-negotiate TLSv1.1 or newer.
.IP \&'\fBTLS1.2\fP'
Since v6.4.0. Require TLS v1.2 exactly.
.IP \&'\fBTLS1.3\fP'
Since v6.4.0. Require TLS v1.3 exactly.
.IP '\fBTLS1.3+\fP'
Since v6.4.0. Require TLS. Auto-negotiate TLSv1.3 or newer.
.IP "Unrecognized parameters"
are treated the same as '\fBauto\fP'.
.RE
.IP
NOTE: you should hardly ever need to use anything other than '' (to
force an unencrypted connection) or 'auto' (to enforce TLS).
.TP
.B \-\-sslcertck
(Keyword: sslcertck, default enabled since v6.4.0)
.br
.B \-\-sslcertck causes fetchmail to require that SSL/TLS be used and
disconnect unless it can successfully negotiate SSL or TLS, or if it
cannot successfully verify and validate the certificate and follow it to
a trust anchor (or trusted root certificate). The trust anchors are
given as a set of local trusted certificates (see the \fBsslcertfile\fP
and \fBsslcertpath\fP options). If the server certificate cannot be
obtained or is not signed by one of the trusted ones (directly or
indirectly), fetchmail will disconnect, regardless of the
\fBsslfingerprint\fP option.
.TP
.B \-\-nosslcertck
(Keyword: no sslcertck, only in v6.4.X)
.br
The opposite of \-\-sslcertck, this is a discouraged option. It permits
fetchmail to continue connecting even if the server certificate failed
the verification checks.  Should only be used together with
\-\-sslfingerprint.
.TP
.B \-\-sslcertfile <file>
(Keyword: sslcertfile, since v6.3.17)
.br
Sets the file fetchmail uses to look up local certificates.  The default is
empty.  This can be given in addition to \fB\-\-sslcertpath\fP below, and
certificates specified in \fB\-\-sslcertfile\fP will be processed before those
in \fB\-\-sslcertpath\fP.  The option can be used in addition to
\fB\-\-sslcertpath\fP.
.IP
The file is a text file. It contains the concatenation of trusted CA
certificates in PEM format.
.IP
Note that using this option will suppress loading the default SSL trusted CA
certificates file unless you set the environment variable
\fBFETCHMAIL_INCLUDE_DEFAULT_X509_CA_CERTS\fP to a non-empty value.
.TP
.B \-\-sslcertpath <directory>
(Keyword: sslcertpath)
.br
Sets the directory fetchmail uses to look up local certificates. The default is
your OpenSSL default directory. The directory must be hashed the way OpenSSL
expects it - every time you add or modify a certificate in the directory, you
need to use the \fBc_rehash\fP tool (which comes with OpenSSL in the tools/
sub-directory). Also, after OpenSSL upgrades, you may need to run
\fBc_rehash\fP.
.IP
This can be given in addition to \fB\-\-sslcertfile\fP above, which see for
precedence rules.
.IP
Note that using this option will suppress adding the default SSL trusted CA
certificates directory unless you set the environment variable
\fBFETCHMAIL_INCLUDE_DEFAULT_X509_CA_CERTS\fP to a non-empty value.
.TP
.B \-\-sslcommonname <common name>
(Keyword: sslcommonname; since v6.3.9)
.br
Use of this option is discouraged. Before using it, contact the
administrator of your upstream server and ask for a proper SSL
certificate to be used. If that cannot be attained, this option can be
used to specify the name (CommonName) that fetchmail expects on the
server certificate.  A correctly configured server will have this set to
the host name by which it is reached, and by default fetchmail will
expect as much. Use this option when the CommonName is set to some other
value, to avoid the "Server CommonName mismatch" warning, and only if
the upstream server's operator cannot be made to use proper certificates.
.TP
.B \-\-sslfingerprint <fingerprint>
(Keyword: sslfingerprint)
.br
Specify the fingerprint of the server key (an MD5 hash of the key) in
hexadecimal notation with colons separating groups of two digits. The letter
hex digits must be in upper case. This is the format
that fetchmail uses to report the fingerprint when an SSL connection
is established. When this is specified, fetchmail will compare the server key
fingerprint with the given one, and the connection will fail if they do not
match, regardless of the \fBsslcertck\fP setting. The connection will
also fail if fetchmail cannot obtain an SSL certificate from the server.
This can be used to prevent man-in-the-middle attacks, but the finger
print from the server must be obtained or verified over a secure
channel, and certainly not over the same Internet connection that
fetchmail would use.
.IP
Using this option will prevent printing certificate verification errors
as long as \-\-nosslcertck is in effect.
.IP
To obtain the fingerprint of a certificate stored in the file cert.pem,
try:
.sp
.nf
	openssl x509 \-in cert.pem \-noout \-md5 \-fingerprint
.fi
.sp
For details, see
.BR x509 (1ssl).
.SS Delivery Control Options
.TP
.B \-S <hosts> | \-\-smtphost <hosts>
(Keyword: smtp[host])
.br
Specify a hunt list of hosts to forward mail to (one or more
host names, comma-separated). Hosts are tried in list order; the first
one that is up becomes the forwarding target for the current run.  If
this option is not specified, 'localhost' is used as the default.
Each host name may have a port number following the host name.  The
port number is separated from the host name by a slash; the default
port is "smtp".  If you specify an absolute path name (beginning with
a /), it will be interpreted as the name of a UNIX socket accepting
LMTP connections (such as is supported by the Cyrus IMAP daemon)
Example:
.sp
.nf
	\-\-smtphost server1,server2/2525,server3,/var/imap/socket/lmtp
.fi
.sp
This option can be used with ODMR, and will make fetchmail a relay
between the ODMR server and SMTP or LMTP receiver.
.IP
WARNING: if you use address numeric IP addresses here, be sure to use
\-\-smtpaddress or \-\-smtpname (either of which see) with a valid SMTP
address literal!
.TP
.B \-\-fetchdomains <hosts>
(Keyword: fetchdomains)
.br
In ETRN or ODMR mode, this option specifies the list of domains the
server should ship mail for once the connection is turned around.  The
default is the FQDN of the machine running \fBfetchmail\fP.
.TP
.B \-D <domain> | \-\-smtpaddress <domain>
(Keyword: smtpaddress)
.br
Specify the domain to be appended to addresses in RCPT TO lines shipped
to SMTP. When this is not specified, the name of the SMTP server (as
specified by \-\-smtphost) is used for SMTP/LMTP and 'localhost' is used
for UNIX socket/BSMTP.
.IP
NOTE: if you intend to use numeric addresses, or so-called address
literals per the SMTP standard, write them in proper SMTP syntax, for
instance \-\-smtpaddress "[192.0.2.6]" or \-\-smtpaddress
"[IPv6:2001:DB8::6]".
.TP
.B \-\-smtpname <user@domain>
(Keyword: smtpname)
.br
Specify the domain and user to be put in RCPT TO lines shipped to SMTP.
The default user is the current local user. Please also see the NOTE
about \-\-smtpaddress and address literals above.
.TP
.B \-Z <nnn> | \-\-antispam <nnn[, nnn]...>
(Keyword: antispam)
.br
Specifies the list of numeric SMTP errors that are to be interpreted
as a spam-block response from the listener.  A value of \-1 disables
this option.  For the command-line option, the list values should
be comma-separated.  Note that the antispam values only apply to "MAIL
FROM" responses in the SMTP/LMTP dialogue, but several MTAs (Postfix in
its default configuration, qmail) defer the anti-spam response code
until after the RCPT TO. \-\-antispam does not work in these
circumstances.  Also see \-\-softbounce (default) and its inverse.
.TP
.B \-m <command> | \-\-mda <command>
(Keyword: mda)
.br
This option lets \fBfetchmail\fP use a Message or Local Delivery Agent
(MDA or LDA) directly, rather than forward via SMTP or LMTP.
.IP
To avoid losing mail, use this option only with MDAs like maildrop or
MTAs like sendmail that exit with a nonzero status on disk-full and other
delivery errors; the nonzero status tells fetchmail that delivery failed
and prevents the message from being deleted on the server.
.IP
If \fBfetchmail\fP is running as root, it sets its user id while
delivering mail through an MDA as follows:  First, the FETCHMAILUSER,
LOGNAME, and USER environment variables are checked in this order. The
value of the first variable from his list that is defined (even if it is
empty!) is looked up in the system user database. If none of the
variables is defined, fetchmail will use the real user id it was started
with. If one of the variables was defined, but the user stated there
is not found, fetchmail continues running as root, without checking
remaining variables on the list.  Practically, this means that if you
run fetchmail as root (not recommended), it is most useful to define the
FETCHMAILUSER environment variable to set the user that the MDA should
run as. Some MDAs (such as maildrop) are designed to be setuid root and
setuid to the recipient's user id, so you do not lose functionality this
way even when running fetchmail as unprivileged user.  Check the MDA's
manual for details.

Some possible MDAs are "/usr/sbin/sendmail \-i \-f %F \-\- %T"
(\fBNote:\fP
some several older or vendor sendmail versions mistake \-\- for an
address, rather than an indicator to mark the end of the option arguments),
"/usr/bin/deliver" and "/usr/bin/maildrop \-d %T".  Local delivery
addresses will be inserted into the MDA command wherever you place a
%T; the mail message's From address will be inserted where you place
an %F.

\fBDo NOT enclose the %F or %T string in single quotes!\fP
For both %T and %F, fetchmail encloses the addresses in single quotes
('), after removing any single quotes they may contain, before the MDA
command is passed to the shell.

\fBDo NOT use an MDA invocation that dispatches on the contents of
To/Cc/Bcc,\fP like "sendmail \-i \-t" or "qmail-inject", it will create
mail loops and bring the just wrath of many postmasters down upon your
head.  This is one of the most frequent configuration errors!

Also, do \fInot\fP try to combine multidrop mode with an MDA such
as maildrop that can only accept one address, unless your upstream
stores one copy of the message per recipient and transports the envelope
recipient in a header; you will lose mail.

The well-known
.BR procmail (1)
package is very hard to configure properly, it has a very nasty "fall
through to the next rule" behavior on delivery errors (even temporary
ones, such as out of disk space if another user's mail daemon copies the
mailbox around to purge old messages), so your mail will end up in the
wrong mailbox sooner or later. The proper procmail configuration is
outside the scope of this document. Using
.BR maildrop (1)
is usually much easier, and many users find the filter syntax used by
maildrop easier to understand.

Finally, we strongly advise that you do \fBnot\fP use qmail-inject.  The
command line interface is non-standard without providing benefits for
typical use, and fetchmail makes no attempts to accommodate
qmail-inject's deviations from the standard. Some of qmail-inject's
command-line and environment options are actually dangerous and can
cause broken threads, non-detected duplicate messages and forwarding
loops.

.TP
.B \-\-lmtp
(Keyword: lmtp)
.br
Cause delivery via LMTP (Local Mail Transfer Protocol).  A service
host and port \fBmust\fP be explicitly specified on each host in the
smtphost hunt list (see above) if this option is selected; the default
port 25 will (in accordance with RFC 2033) not be accepted.
.TP
.B \-\-bsmtp <filename>
(Keyword: bsmtp)
.br
Append fetched mail to a BSMTP file.  This simply contains the SMTP
commands that would normally be generated by fetchmail when passing
mail to an SMTP listener daemon.

An argument of '\-' causes the SMTP batch to be written to standard
output, which is of limited use: this only makes sense for debugging,
because fetchmail's regular output is interspersed on the same channel,
so this is not suitable for mail delivery. This special mode may be
removed in a later release.

Note that fetchmail's reconstruction of MAIL FROM and RCPT TO lines is
not guaranteed correct; the caveats discussed under THE USE AND ABUSE OF
MULTIDROP MAILBOXES below apply.  This mode has precedence before
\-\-mda and SMTP/LMTP.
.TP
.B \-\-bad\-header {reject|accept}
(Keyword: bad\-header; since v6.3.15)
.br
Specify how fetchmail is supposed to treat messages with bad headers,
i. e. headers with bad syntax. Traditionally, fetchmail has rejected such
messages, but some distributors modified fetchmail to accept them. You can now
configure fetchmail's behaviour per server.

.SS Resource Limit Control Options
.TP
.B \-l <maxbytes> | \-\-limit <maxbytes>
(Keyword: limit)
.br
Takes a maximum octet size argument, where 0 is the
default and also the special value designating "no limit".
If nonzero, messages larger than this size will not be fetched and will
be left on the server (in foreground sessions, the progress messages
will note that they are "oversized").  If the fetch protocol permits (in
particular, under IMAP or POP3 without the fetchall option) the message
will not be marked seen.
.sp
An explicit \-\-limit of 0 overrides any limits set in your
run control file. This option is intended for those needing to
strictly control fetch time due to expensive and variable phone rates.
.sp
Combined with \-\-limitflush, it can be used to delete oversized
messages waiting on a server.  In daemon mode, oversize notifications
are mailed to the calling user (see the \-\-warnings option). This
option does not work with ETRN or ODMR.
.TP
.B \-w <interval> | \-\-warnings <interval>
(Keyword: warnings)
.br
Takes an interval in seconds.  When you call \fBfetchmail\fP
with a 'limit' option in daemon mode, this controls the interval at
which warnings about oversized messages are mailed to the calling user
(or the user specified by the 'postmaster' option).  One such
notification is always mailed at the end of the first poll that
the oversized message is detected.  Thereafter, re-notification is
suppressed until after the warning interval elapses (it will take
place at the end of the first following poll).
.TP
.B \-b <count> | \-\-batchlimit <count>
(Keyword: batchlimit)
.br
Specify the maximum number of messages that will be shipped to an SMTP
listener before the connection is deliberately torn down and rebuilt
(defaults to 0, meaning no limit).  An explicit \-\-batchlimit of 0
overrides any limits set in your run control file.  While
\fBsendmail\fP(8) normally initiates delivery of a message immediately
after receiving the message terminator, some SMTP listeners are not so
prompt.  MTAs like \fBsmail\fP(8) may wait till the
delivery socket is shut down to deliver.  This may produce annoying
delays when \fBfetchmail\fP is processing very large batches.  Setting
the batch limit to some nonzero size will prevent these delays.  This
option does not work with ETRN or ODMR.
.TP
.B \-B <number> | \-\-fetchlimit <number>
(Keyword: fetchlimit)
.br
Limit the number of messages accepted from a given server in a single
poll.  By default there is no limit. An explicit \-\-fetchlimit of 0
overrides any limits set in your run control file.
This option does not work with ETRN or ODMR.
.TP
.B \-\-fetchsizelimit <number>
(Keyword: fetchsizelimit)
.br
Limit the number of sizes of messages accepted from a given server in
a single transaction.  This option is useful in reducing the delay in
downloading the first mail when there are too many mails in the
mailbox.  By default, the limit is 100.  If set to 0, sizes of all
messages are downloaded at the start.
This option does not work with ETRN or ODMR.  For POP3, the only valid
non-zero value is 1.
.TP
.B \-\-fastuidl <number>
(Keyword: fastuidl)
.br
Do a binary instead of linear search for the first unseen UID. Binary
search avoids downloading the UIDs of all mails. This saves time
(especially in daemon mode) where downloading the same set of UIDs in
each poll is a waste of bandwidth. The number 'n' indicates how rarely
a linear search should be done. In daemon mode, linear search is used
once followed by binary searches in 'n-1' polls if 'n' is greater than
1; binary search is always used if 'n' is 1; linear search is always
used if 'n' is 0. In non-daemon mode, binary search is used if 'n' is
1; otherwise linear search is used. The default value of 'n' is 4.
This option works with POP3 only.
.TP
.B \-e <count> | \-\-expunge <count>
(Keyword: expunge)
.br
Arrange for deletions to be made final after a given number of
messages.  Under POP2 or POP3, fetchmail cannot make deletions final
without sending QUIT and ending the session -- with this option on,
fetchmail will break a long mail retrieval session into multiple
sub-sessions, sending QUIT after each sub-session. This is a good
defense against line drops on POP3 servers.  Under IMAP,
\fBfetchmail\fP normally issues an EXPUNGE command after each deletion
in order to force the deletion to be done immediately.  This is safest
when your connection to the server is flaky and expensive, as it avoids
re-sending duplicate mail after a line hit.  However, on large
mailboxes the overhead of re-indexing after every message can slam the
server pretty hard, so if your connection is reliable it is good to do
expunges less frequently.  Also note that some servers enforce a delay
of a few seconds after each quit, so fetchmail may not be able to get
back in immediately after an expunge -- you may see "lock busy" errors
if this happens. If you specify this option to an integer N,
it tells \fBfetchmail\fP to only issue expunges on every Nth delete.  An
argument of zero suppresses expunges entirely (so no expunges at all
will be done until the end of run).  This option does not work with ETRN
or ODMR.

.SS Authentication Options
.TP
.B \-u <name> | \-\-user <name> | \-\-username <name>
(Keyword: user[name])
.br
Specifies the user identification to be used when logging in to the mail server.
The appropriate user identification is both server and user-dependent.
The default is your login name on the client machine that is running
\fBfetchmail\fP.
See USER AUTHENTICATION below for a complete description.
.TP
.B \-I <specification> | \-\-interface <specification>
(Keyword: interface)
.br
Require that a specific interface device be up and have a specific local
or remote IPv4 (IPv6 is not supported by this option yet) address (or
range) before polling.  Frequently \fBfetchmail\fP
is used over a transient point-to-point TCP/IP link established directly
to a mail server via SLIP or PPP.  That is a relatively secure channel.
But when other TCP/IP routes to the mail server exist (e.g., when the link
is connected to an alternate ISP), your username and password may be
vulnerable to snooping (especially when daemon mode automatically polls
for mail, shipping a clear password over the net at predictable
intervals).  The \-\-interface option may be used to prevent this.  When
the specified link is not up or is not connected to a matching IP
address, polling will be skipped.  The format is:
.sp
.nf
	interface/iii.iii.iii.iii[/mmm.mmm.mmm.mmm]
.fi
.sp
The field before the first slash is the interface name (i.e., sl0, ppp0
etc.).  The field before the second slash is the acceptable IP address.
The field after the second slash is a mask which specifies a range of
IP addresses to accept.  If no mask is present 255.255.255.255 is
assumed (i.e., an exact match).  This option is currently only supported
under Linux and FreeBSD. Please see the \fBmonitor\fP section for below
for FreeBSD specific information.
.sp
Note that this option may be removed from a future fetchmail version.
.TP
.B \-M <interface> | \-\-monitor <interface>
(Keyword: monitor)
.br
Daemon mode can cause transient links which are automatically taken down
after a period of inactivity (e.g., PPP links) to remain up
indefinitely.  This option identifies a system TCP/IP interface to be
monitored for activity.  After each poll interval, if the link is up but
no other activity has occurred on the link, then the poll will be
skipped.  However, when fetchmail is woken up by a signal, the
monitor check is skipped and the poll goes through unconditionally.
This option is currently only supported under Linux and FreeBSD.
For the \fBmonitor\fP and \fBinterface\fP options to work for non root
users under FreeBSD, the fetchmail binary must be installed setgid kmem.
This would be a security hole, but fetchmail runs with the effective GID
set to that of the kmem group \fIonly\fP when interface data is being
collected.
.sp
Note that this option may be removed from a future fetchmail version.
.TP
.B \-\-auth <type>
(Keyword: auth[enticate])
.br
This option permits you to specify an authentication type (see USER
AUTHENTICATION below for details).  The possible values are \fBany\fP,
\&\fBpassword\fP, \fBkerberos_v5\fP, \fBkerberos\fP (or, for
excruciating exactness, \fBkerberos_v4\fP), \fBgssapi\fP,
\fBcram\-md5\fP, \fBotp\fP, \fBntlm\fP, \fBmsn\fP (only for POP3),
\fBexternal\fP (only IMAP) and \fBssh\fP.
When \fBany\fP (the default) is specified, fetchmail tries
first methods that do not require a password (EXTERNAL, GSSAPI, KERBEROS\ IV,
KERBEROS\ 5); then it looks for methods that mask your password
(CRAM-MD5, NTLM, X\-OTP - note that MSN is only supported for POP3, but not
auto-probed); and only if the server does not
support any of those will it ship your password unencrypted.  Other values
may be used to force various authentication methods:
\fBssh\fP suppresses authentication and is thus useful for IMAP PREAUTH
(if you are using a secure \-\-plugin, for instance, a properly configured
ssh, you may also need to set \-\-sslproto\ '' or, in the rcfile, sslproto\ '',
in order to avoid fetchmail negotiating STARTTLS over SSH).
\fBexternal\fP suppresses authentication and is thus useful for IMAP EXTERNAL.
Any value other than \fBpassword\fP, \fBcram\-md5\fP, \fBntlm\fP,
\&\fBmsn\fP or \fBotp\fP suppresses fetchmail's normal inquiry for a
password.  Specify \fBssh\fP when you are using an end-to-end secure
connection such as an ssh tunnel (in this case you may also want to specify
\&\fB\-\-sslproto\ ''\fP, which see); specify \fBexternal\fP when you use
TLS with client authentication and specify \fBgssapi\fP or
\&\fBkerberos_v4\fP if you are using a protocol variant that employs
GSSAPI or K4.  Choosing KPOP protocol automatically selects Kerberos
authentication.  This option does not work with ETRN.  GSSAPI service names are
in line with RFC-2743 and IANA registrations, see
.URL https://www.iana.org/assignments/gssapi-service-names/ "Generic Security Service Application Program Interface (GSSAPI)/Kerberos/Simple Authentication and Security Layer (SASL) Service Names" .
.SS Miscellaneous Options
.TP
.B \-f <pathname> | \-\-fetchmailrc <pathname>
Specify a non-default name for the \fI~/.fetchmailrc\fP
run control file.  The pathname argument must be either "-" (a single
dash, meaning to read the configuration from standard input) or a
filename.  Unless the \-\-version option is also on, a named file
argument must have permissions no more open than 0700 (u=rwx,g=,o=) or
else be /dev/null.
.TP
.B \-i <pathname> | \-\-idfile <pathname>
(Keyword: idfile)
.br
Specify an alternate name for the .fetchids file used to save message
UIDs. NOTE: since fetchmail 6.3.0, write access to the directory
containing the idfile is required, as fetchmail writes a temporary file
and renames it into the place of the real idfile only if the temporary
file has been written successfully. This avoids the truncation of
idfiles when running out of disk space.
.TP
.B \--pidfile <pathname>
(Keyword: pidfile; since fetchmail v6.3.4)
.br
Override the default location of the PID file that is used as a lock file.
Default: see "ENVIRONMENT" below. Note that many places in the code and
documentation, the term "lock file" is used.  This file contains the process ID
of the running fetchmail on the first line and potentially the daemon interval
on a second line.
.TP
.B \-n | \-\-norewrite
(Keyword: no rewrite)
.br
Normally, \fBfetchmail\fP edits RFC-822 address headers (To, From, Cc,
Bcc, and Reply\-To) in fetched mail so that any mail IDs local to the
server are expanded to full addresses (@ and the mail server host name are
appended).  This enables replies on the client to get addressed
correctly (otherwise your mailer might think they should be addressed to
local users on the client machine!).  This option disables the rewrite.
(This option is provided to pacify people who are paranoid about having
an MTA edit mail headers and want to know they can prevent it, but it is
generally not a good idea to actually turn off rewrite.)
When using ETRN or ODMR, the rewrite option is ineffective.
.TP
.B \-E <line> | \-\-envelope <line>
(Keyword: envelope; Multidrop only)
.br
In the configuration file, an enhanced syntax is used:
.br
\fBenvelope [<count>] <line>\fP
.sp
This option changes the header \fBfetchmail\fP assumes will carry a copy
of the mail's envelope address.  Normally this is 'X\-Envelope\-To'.
Other typically found headers to carry envelope information are
\&'X\-Original\-To' and 'Delivered\-To'.  Now, since these headers are
not standardized, practice varies. See the discussion of multidrop
address handling below.  As a special case, 'envelope "Received"'
enables parsing of sendmail-style Received lines.  This is the default,
but discouraged because it is not fully reliable.

Note that fetchmail expects the Received-line to be in a specific
format: It must contain "by \fIhost\fP for \fIaddress\fP", where
\fIhost\fP must match one of the mail server names that fetchmail
recognizes for the account in question.
.sp
The optional count argument (only available in the configuration file)
determines how many header lines of this kind are skipped. A count of 1
means: skip the first, take the second. A count of 2 means: skip the
first and second, take the third, and so on.
.TP
.B \-Q <prefix> | \-\-qvirtual <prefix>
(Keyword: qvirtual; Multidrop only)
.br
The string prefix assigned to this option will be removed from the user
name found in the header specified with the \fIenvelope\fP option
(\fIbefore\fP doing multidrop name mapping or localdomain checking,
if either is applicable). This option is useful if you are using
\fBfetchmail\fP to collect the mail for an entire domain and your ISP
(or your mail redirection provider) is using qmail.
One of the basic features of qmail is the \fIDelivered\-To:\fP
message header.  Whenever qmail delivers a message to a local mailbox
it puts the username and host name of the envelope recipient on this
line.  The major reason for this is to prevent mail loops.  To set up
qmail to batch mail for a disconnected site the ISP-mailhost will have
normally put that site in its 'Virtualhosts' control file so it will
add a prefix to all mail addresses for this site. This results in mail
.\" The \&@\& tries to stop HTML converters from making a mailto: URL here:
sent to 'username\&@\&userhost.userdom.dom.com' having a
\fIDelivered\-To:\fR line of the form:
.IP
Delivered\-To: mbox\-userstr\-username\&@\&userhost.example.com
.IP
The ISP can make the 'mbox\-userstr\-' prefix anything they choose
but a string matching the user host name is likely.
By using the option 'envelope Delivered\-To:' you can make fetchmail reliably
identify the original envelope recipient, but you have to strip the
\&'mbox\-userstr\-' prefix to deliver to the correct user.
This is what this option is for.
.TP
.B \-\-configdump
Parse the \fI~/.fetchmailrc\fP file, interpret any command-line options
specified, and dump a configuration report to standard output.  The
configuration report is a data structure assignment in the language
Python.  This option is meant to be used with an interactive
\fI~/.fetchmailrc\fP editor like \fBfetchmailconf\fP, written in Python.
.TP
.B \-y | \-\-yydebug
Enables parser debugging, this option is meant to be used by developers
only.

.SS Removed Options
.TP
.B \-T | \-\-netsec
Removed before version 6.3.0, the required underlying inet6_apps library
had been discontinued and is no longer available.

.SH USER AUTHENTICATION AND ENCRYPTION
All modes except ETRN require authentication of the client to the server.
Normal user authentication in \fBfetchmail\fP is very much like the
authentication mechanism of
.BR ftp (1).
The correct user-id and password depend upon the underlying security
system at the mail server.
.PP
If the mail server is a Unix machine on which you have an ordinary user
account, your regular login name and password are used with
.BR fetchmail .
If you use the same login name on both the server and the client machines,
you needn't worry about specifying a user-id with the
.B \-u
option -- the default behavior is to use your login name on the
client machine as the user-id on the server machine.  If you use a
different login name on the server machine, specify that login name
with the
.B \-u
option.  E.g., if your login name is 'jsmith' on a machine named 'mailgrunt',
you would start \fBfetchmail\fP as follows:
.IP
fetchmail \-u jsmith mailgrunt
.PP
The default behavior of \fBfetchmail\fP is to prompt you for your
mail server password before the connection is established.  This is the
safest way to use \fBfetchmail\fP and ensures that your password will
not be compromised.  You may also specify your password in your
\fI~/.fetchmailrc\fP file.  This is convenient when using
\fBfetchmail\fP in daemon mode or with scripts.

.SS Using netrc files
If you do not specify a password, and \fBfetchmail\fP cannot extract one
from your \fI~/.fetchmailrc\fP file, it will look for a \fI~/.netrc\fP
file in your home directory before requesting one interactively; if an
entry matching the mail server is found in that file, the password will
be used.  Fetchmail first looks for a match on poll name; if it finds none,
it checks for a match on via name.  See the
.BR ftp (1)
man page for details of the syntax of the \fI~/.netrc\fP
file.  To show a practical example, a .netrc might look like
this:
.IP
.nf
machine hermes.example.org
login joe
password topsecret
.fi
.PP
You can repeat this block with different user information if you need to
provide more than one password.
.PP
This feature may allow you to avoid duplicating password
information in more than one file.
.PP
On mail servers that do not provide ordinary user accounts, your user-id and
password are usually assigned by the server administrator when you apply for
a mailbox on the server.  Contact your server administrator if you do not know
the correct user-id and password for your mailbox account.

.SS Secure Socket Layers (SSL) and Transport Layer Security (TLS)
All retrieval protocols can use SSL or TLS wrapping for the
transport. Additionally, POP3 and IMAP retrieval can also negotiate
SSL/TLS by means of STARTTLS (or STLS).
.PP
You can access TLS-encrypted services by specifying the options starting
with \-\-ssl, such as \-\-ssl, \-\-sslproto, \-\-sslcertck, and others.
You can also do this using the corresponding user options in the .fetchmailrc
file.  Some services, such as POP3 and IMAP, have
different well known ports defined for the SSL encrypted services.  The
encrypted ports will be selected automatically when SSL is enabled and
no explicit port is specified.   Also, the \-\-sslcertck command line or
sslcertck run control file option should be used to force strict
certificate checking with older fetchmail versions - see below.
.PP
If TLS or SSL is not configured, fetchmail will usually still try to use
STARTTLS somewhat opportunistically. In practice, is it still mandatory
because \-\-sslcertck is a default setting and implicitly requires STARTTLS.
.PP
STARTTLS can be enforced by using \-\-sslproto\~auto and
defeated by using \-\-sslproto\~''.
STARTTLS connections use the same port as the unencrypted version of the
protocol and negotiate TLS via special command. The \-\-sslcertck
command line or sslcertck run control file option should be used to
force strict certificate checking - see below.
.PP
.B \-\-sslcertck is recommended:
When connecting to an SSL or TLS encrypted server, the
server presents a certificate to the client for validation.  The
certificate is checked to verify that the common name in the certificate
matches the name of the server being contacted and that the effective
and expiration dates in the certificate indicate that it is currently
valid.  If any of these checks fail, a warning message is printed, but
the connection continues.  The server certificate does not need to be
signed by any specific Certifying Authority and may be a "self-signed"
certificate. If the \-\-sslcertck command line option or sslcertck run
control file option is used, fetchmail will instead abort if any of
these checks fail, because it must assume that there is a
man-in-the-middle attack in this scenario, hence fetchmail must not
expose clear-text passwords. Use of the sslcertck or \-\-sslcertck option
is therefore advised; it has become the default in fetchmail 6.4.0.
.PP
Some SSL encrypted servers may request a client side certificate.  A client
side public SSL certificate and private SSL key may be specified.  If
requested by the server, the client certificate is sent to the server for
validation.  Some servers may require a valid client certificate and may
refuse connections if a certificate is not provided or if the certificate
is not valid.  Some servers may require client side certificates be signed
by a recognized Certifying Authority.  The format for the key files and
the certificate files is that required by the underlying SSL libraries
(OpenSSL in the general case).
.PP
A word of care about the use of SSL: While above mentioned
setup with self-signed server certificates retrieved over the wires
can protect you from a passive eavesdropper, it does not help against an
active attacker. It is clearly an improvement over sending the
passwords in clear, but you should be aware that a man-in-the-middle
attack is trivially possible (in particular with tools such as
.URL "https://monkey.org/~dugsong/dsniff/" "dsniff" ,
).  Use of strict certificate checking with a certification authority
recognized by server and client, or perhaps of an SSH tunnel (see below
for some examples) is preferable if you care seriously about the
security of your mailbox and passwords.

.SH POP3 VARIANTS
Early versions of POP3 (RFC1081, RFC1225) supported a crude form of
independent authentication using the \fI.rhosts\fP file on the
mail server side.  Under this RPOP variant, a fixed per-user ID
equivalent to a password was sent in clear over a link to a reserved
port, with the command RPOP rather than PASS to alert the server that it
should do special checking.  RPOP is supported by \fBfetchmail\fP
(you can specify 'protocol RPOP' to have the program send 'RPOP'
rather than 'PASS') but its use is strongly discouraged, and support
will be removed from a future fetchmail version.  This
facility was vulnerable to spoofing and was withdrawn in RFC1460.
.PP
RFC1460 introduced APOP authentication.  In this variant of POP3,
you register an APOP password on your server host (on some servers, the
program to do this is called \fBpopauth\fP(8)).  You put the same
password in your \fI~/.fetchmailrc\fP file.  Each time \fBfetchmail\fP
logs in, it sends an MD5 hash of your password and the server greeting
time to the server, which can verify it by checking its authorization
database.

\fBNote that APOP is no longer considered resistant against
man-in-the-middle attacks.\fP

.SS RETR or TOP
\fBfetchmail\fP makes some efforts to make the server believe messages
had not been retrieved, by using the TOP command with a large number of
lines when possible.  TOP is a command that retrieves the full header
and a \fBfetchmail\fP-specified amount of body lines. It is optional and
therefore not implemented by all servers, and some are known to
implement it improperly. On many servers however, the RETR command which
retrieves the full message with header and body, sets the "seen" flag
(for instance, in a web interface), whereas the TOP command does not do
that.
.PP
\fBfetchmail\fP will always use the RETR command if "fetchall" is set.
\fBfetchmail\fP will also use the RETR command if "keep" is set and
"uidl" is unset.  Finally, \fBfetchmail\fP will use the RETR command on
Maillennium POP3/PROXY servers (used by Comcast) to avoid a deliberate
TOP misinterpretation in this server that causes message corruption.
.PP
In all other cases, \fBfetchmail\fP will use the TOP command. This
implies that in "keep" setups, "uidl" must be set if "TOP" is desired.
.PP
\fBNote\fP that this description is true for the current version of
fetchmail, but the behavior may change in future versions. In
particular, fetchmail may prefer the RETR command because the TOP
command causes much grief on some servers and is only optional.
.SH ALTERNATE AUTHENTICATION FORMS/METHODS
If your \fBfetchmail\fP was built with Kerberos support and you specify
Kerberos authentication (either with \-\-auth or the \fI.fetchmailrc\fP
option \fBauthenticate kerberos_v4\fP) it will try to get a Kerberos
ticket from the mail server at the start of each query.  Note: if
either the pollname or via name is 'hesiod', fetchmail will try to use
Hesiod to look up the mail server.
.PP
If you use POP3 or IMAP with GSSAPI authentication, \fBfetchmail\fP will
expect the server to have RFC1731- or RFC1734-conforming GSSAPI
capability, and will use it.  Currently this has only been tested over
Kerberos\ 5, so you are expected to already have a ticket-granting
ticket. You may pass a username different from your principal name
using the standard \fB\-\-user\fP command or by the \fI.fetchmailrc\fP
option \fBuser\fP.
.PP
If your IMAP daemon returns the PREAUTH response in its greeting line,
fetchmail will notice this and skip the normal authentication step.
This can be useful, e.g., if you start imapd explicitly using ssh.
In this case you can declare the authentication value 'ssh' on that
site entry to stop \fI.fetchmail\fP from asking you for a password
when it starts up.
.PP
If you use client authentication with \fITLS1\fP and your IMAP daemon
returns the \fIAUTH=EXTERNAL\fP response, fetchmail will notice this
and will use the authentication shortcut and will not send the
passphrase. In this case you can declare the authentication value 'external'
 on that site to stop \fBfetchmail\fP from asking you for a password
when it starts up.
.PP
If you are using POP3, and the server issues a one-time-password
challenge conforming to RFC1938, \fBfetchmail\fP will use your
password as a pass phrase to generate the required response. This
avoids sending secrets over the net unencrypted.
.PP
Compuserve's RPA authentication is supported. If you
compile in the support, \fBfetchmail\fP will try to perform an RPA pass-phrase
authentication instead of sending over the password unencrypted if it
detects "@compuserve.com" in the host name.
.PP
If you are using IMAP, Microsoft's NTLM authentication (used by Microsoft
Exchange) is supported. If you compile in the support, \fBfetchmail\fP
will try to perform an NTLM authentication (instead of sending over the
password unencrypted) whenever the server returns AUTH=NTLM in its
capability response. Specify a user option value that looks like
\&'user@domain': the part to the left of the @ will be passed as the
username and the part to the right as the NTLM domain.

.SS ESMTP AUTH
\fBfetchmail\fP also supports authentication to the ESMTP server on the
client side according to RFC 2554.  You can specify a name/password pair
to be used with the keywords 'esmtpname' and 'esmtppassword'; the former
defaults to the username of the calling user.

.SH DAEMON MODE
.SS Introducing the daemon mode
In daemon mode, \fBfetchmail\fP puts itself into the background and runs
forever, querying each specified host and then sleeping for a given
polling interval.
.SS Starting the daemon mode
There are several ways to make fetchmail work in daemon mode. On the
command line, \fB\-\-daemon\ <interval>\fP or \fB\-d\ <interval>\fP
option runs \fBfetchmail\fP in daemon mode.  You must specify a numeric
argument which is a polling interval (time to wait after completing a
whole poll cycle with the last server and before starting the next poll
cycle with the first server) in seconds.
.PP
Example: simply invoking
.IP
fetchmail \-d 900
.PP
will, therefore, poll all the hosts described in your \fI~/.fetchmailrc\fP
file (except those explicitly excluded with the 'skip' verb) a bit less
often than once every 15 minutes (exactly: 15 minutes + time that the
poll takes).
.PP
It is also possible to set a polling interval
in your \fI~/.fetchmailrc\fP file by saying 'set\ daemon\ <interval>',
where <interval> is an integer number of seconds.  If you do this,
fetchmail will always start in daemon mode unless you override it with
the command-line option \-\-daemon 0 or \-d0.
.PP
Only one daemon process is permitted per user; in daemon mode,
\fBfetchmail\fP sets up a per-user lock file to guarantee this.
(You can however cheat and set the FETCHMAILHOME environment variable to
overcome this setting, but in that case, it is your responsibility to
make sure you are not polling the same server with two processes at the
same time.)
.SS Awakening the background daemon
Normally, calling fetchmail with a daemon in the background sends a
wake-up signal to the daemon and quits without output. The background
daemon then starts its next poll cycle immediately.  The wake-up signal,
SIGUSR1, can also be sent manually. The wake-up action also clears any
\&'wedged' flags indicating that connections have wedged due to failed
authentication or multiple timeouts.
.SS Terminating the background daemon
The option
.B \-q
or
.B \-\-quit
will kill a running daemon process instead of waking it up (if there
is no such process, \fBfetchmail\fP will notify you).
If the \-\-quit option appears last on the command line, \fBfetchmail\fP
will kill the running daemon process and then quit. Otherwise,
\fBfetchmail\fP will first kill a running daemon process and then
continue running with the other options.
.SS Useful options for daemon mode
The
.B \-L <filename>
or
.B \-\-logfile <filename>
option (keyword: set logfile) is only effective when fetchmail is
detached and in daemon mode. Note that \fBthe logfile must exist
before\fP fetchmail is run, you can use the
.BR touch (1)
command with the filename as its sole argument to create it.
.br
This option allows you to redirect status messages
into a specified logfile (follow the option with the logfile name).  The
logfile is opened for append, so previous messages are not deleted.  This
is primarily useful for debugging configurations. Note that fetchmail
does not detect if the logfile is rotated, the logfile is only opened
once when fetchmail starts. You need to restart fetchmail after rotating
the logfile and before compressing it (if applicable).
.PP
The
.B \-\-syslog
option (keyword: set syslog) allows you to redirect status and error
messages emitted to the
.BR syslog (3)
system daemon if available.
Messages are logged with an id of \fBfetchmail\fP, the facility \fBLOG_MAIL\fP,
and priorities \fBLOG_ERR\fP, \fBLOG_ALERT\fP or \fBLOG_INFO\fP.
This option is intended for logging status and error messages which
indicate the status of the daemon and the results while fetching mail
from the server(s).
Error messages for command line options and parsing the \fI.fetchmailrc\fP
file are still written to stderr, or to the specified log file.
The
.B \-\-nosyslog
option turns off use of
.BR syslog (3),
assuming it is turned on in the \fI~/.fetchmailrc\fP file.
This option is overridden, in certain situations, by \fB\-\-logfile\fP (which
see).
.PP
The
.B \-N
or
.B \-\-nodetach
option suppresses backgrounding and detachment of the daemon process
from its control terminal.  This is useful for debugging or when
fetchmail runs as the child of a supervisor process such as
.BR init (8)
or Gerrit Pape's
.BR runit (8).
Note that this also causes the logfile option to be ignored.
.PP
Note that while running in daemon mode polling a POP2 or IMAP2bis server,
transient errors (such as DNS failures or sendmail delivery refusals)
may force the fetchall option on for the duration of the next polling
cycle.  This is a robustness feature.  It means that if a message is
fetched (and thus marked seen by the mail server) but not delivered
locally due to some transient error, it will be re-fetched during the
next poll cycle.  (The IMAP logic does not delete messages until
they're delivered, so this problem does not arise.)
.PP
If you touch or change the \fI~/.fetchmailrc\fP file while fetchmail is
running in daemon mode, this will be detected at the beginning of the
next poll cycle.  When a changed \fI~/.fetchmailrc\fP is detected,
fetchmail rereads it and restarts from scratch (using exec(2); no state
information is retained in the new instance).  Note that if fetchmail
needs to query for passwords, of that if you break the
\fI~/.fetchmailrc\fP file's syntax, the new instance will softly and
silently vanish away on startup.

.SH ADMINISTRATIVE OPTIONS
The
.B \-\-postmaster <name>
option (keyword: set postmaster) specifies the last-resort username to
which multidrop mail is to be forwarded if no matching local recipient
can be found. It is also used as destination of undeliverable mail if
the 'bouncemail' global option is off and additionally for spam-blocked
mail if the 'bouncemail' global option is off and the 'spambounce'
global option is on. This option defaults to the user who invoked
\fBfetchmail\fP.
If the invoking user is root, then the default of this option is
the user 'postmaster'.  Setting postmaster to the empty string causes
such mail as described above to be discarded - this however is usually a
bad idea.
See also the description of the 'FETCHMAILUSER' environment variable in
the ENVIRONMENT section below.
.PP
The
.B \-\-nobounce
behaves like the "set no bouncemail" global option, which see.
.PP
The
.B \-\-invisible
option (keyword: set invisible) tries to make fetchmail invisible.
Normally, fetchmail behaves like any other MTA would -- it generates a
Received header into each message describing its place in the chain of
transmission, and tells the MTA it forwards to that the mail came from
the machine fetchmail itself is running on.  If the invisible option
is on, the Received header is suppressed and fetchmail tries to spoof
the MTA it forwards to into thinking it came directly from the
mail server host.
.PP
The
.B \-\-showdots
option (keyword: set showdots) forces fetchmail to show progress dots
even if the output goes to a file or fetchmail is not in verbose mode.
Fetchmail shows the dots by default when run in \-\-verbose mode
\fIand\fP output goes to console. This option is ignored in \-\-silent mode.
.PP
By specifying the
.B \-\-tracepolls
option, you can ask fetchmail to add information to the Received
header on the form "polling {label} account {user}", where {label} is
the account label (from the specified rcfile, normally ~/.fetchmailrc)
and {user} is the username which is used to log on to the mail
server. This header can be used to make filtering email where no
useful header information is available and you want mail from
different accounts sorted into different mailboxes (this could, for
example, occur if you have an account on the same server running a
mailing list, and are subscribed to the list using that account). The
default is not adding any such header.  In
.IR .fetchmailrc ,
this is called 'tracepolls'.

.SH RETRIEVAL FAILURE MODES
The protocols \fBfetchmail\fP uses to talk to mail servers are next to
bulletproof.  In normal operation forwarding to port 25, no message is
ever deleted (or even marked for deletion) on the host until the SMTP
listener on the client side has acknowledged to \fBfetchmail\fP that
the message has been either accepted for delivery or rejected due to a
spam block.
.PP
When forwarding to an MDA, however, there is more possibility
of error.  Some MDAs are 'safe' and reliably return a nonzero status
on any delivery error, even one due to temporary resource limits.
The
.BR maildrop (1)
program is like this; so are most programs designed as mail transport
agents, such as
.BR sendmail (1),
including the sendmail wrapper of Postfix and
.BR exim (1).
These programs give back a reliable positive acknowledgement and
can be used with the mda option with no risk of mail loss.  Unsafe
MDAs, though, may return 0 even on delivery failure.  If this
happens, you will lose mail.
.PP
The normal mode of \fBfetchmail\fP is to try to download only 'new'
messages, leaving untouched (and undeleted) messages you have already
read directly on the server (or fetched with a previous \fIfetchmail
\-\-keep\fP).  But you may find that messages you have already read on the
server are being fetched (and deleted) even when you do not specify
\-\-all.  There are several reasons this can happen.
.PP
One could be that you are using POP2.  The POP2 protocol includes no
representation of 'new' or 'old' state in messages, so \fBfetchmail\fP
must treat all messages as new all the time.  But POP2 is obsolete, so
this is unlikely.
.PP
A potential POP3 problem might be servers that insert messages
in the middle of mailboxes (some VMS implementations of mail are
rumored to do this).  The \fBfetchmail\fP code assumes that new
messages are appended to the end of the mailbox; when this is not true
it may treat some old messages as new and vice versa.  Using UIDL whilst
setting fastuidl 0 might fix this, otherwise, consider switching to IMAP.
.PP
Yet another POP3 problem is that if they cannot make temporary files in the
user's home directory, some POP3 servers will hand back an
undocumented response that causes fetchmail to spuriously report "No
mail".
.PP
The IMAP code uses the presence or absence of the server flag \eSeen
to decide whether or not a message is new.  This is not the right thing
to do, fetchmail should check the UIDVALIDITY and use UID, but it
does not do that yet. Under Unix, it counts on your IMAP server to notice
the BSD-style Status flags set by mail user agents and set the \eSeen
flag from them when appropriate.  All Unix IMAP servers we know of do
this, though it is not specified by the IMAP RFCs.  If you ever trip over
a server that does not, the symptom will be that messages you have
already read on your host will look new to the server.  In this
(unlikely) case, only messages you fetched with \fIfetchmail \-\-keep\fP
will be both undeleted and marked old.
.PP
In ETRN and ODMR modes, \fBfetchmail\fP does not actually retrieve messages;
instead, it asks the server's SMTP listener to start a queue flush
to the client via SMTP.  Therefore it sends only undelivered messages.

.SH SPAM FILTERING
Many SMTP listeners allow administrators to set up 'spam filters' that
block unsolicited email from specified domains.  A MAIL FROM or DATA line that
triggers this feature will elicit an SMTP response which
(unfortunately) varies according to the listener.
.PP
Newer versions of
\fBsendmail\fP
return an error code of 571.
.PP
According to RFC2821, the correct thing to return in this situation is
550 "Requested action not taken: mailbox unavailable" (the draft adds
"[E.g., mailbox not found, no access, or command rejected for policy
reasons].").
.PP
Older versions of the
\fBexim\fP
MTA return 501 "Syntax error in parameters or arguments".
.PP
The
\fBpostfix\fP
MTA runs 554 as an antispam response.
.PP
\fBZmailer\fP
may reject code with a 500 response (followed by an enhanced status
code that contains more information).
.PP
Return codes which
\fBfetchmail\fP
treats as antispam responses and discards
the message can be set with the 'antispam' option.  This is one of the
\fIonly\fP
three circumstance under which fetchmail ever discards mail (the others
are the 552 and 553 errors described below, and the suppression of
multi-dropped messages with a message-ID already seen).
.PP
If
\fBfetchmail\fP
is fetching from an IMAP server, the antispam response will be detected and
the message rejected immediately after the headers have been fetched,
without reading the message body.  Thus, you will not pay for downloading
spam message bodies.
.PP
By default, the list of antispam responses is empty.
.PP
If the \fIspambounce\fP global option is on, mail that is spam-blocked
triggers an RFC1892/RFC1894 bounce message informing the originator that
we do not accept mail from it. See also BUGS.

.SH SMTP/ESMTP ERROR HANDLING
Besides the spam-blocking described above, fetchmail takes special
actions \(em that may be modified by the \-\-softbounce option \(em on
the following SMTP/ESMTP error response codes
.TP 5
452 (insufficient system storage)
Leave the message in the server mailbox for later retrieval.
.TP 5
552 (message exceeds fixed maximum message size)
Delete the message from the server.  Send bounce-mail to the
originator.
.TP 5
553 (invalid sending domain)
Delete the message from the server.  Do not even try to send
bounce-mail to the originator.
.PP
Other errors greater or equal to 500 trigger bounce mail back to the
originator, unless suppressed by \-\-softbounce. See also BUGS.

.SH THE RUN CONTROL FILE
The preferred way to set up fetchmail is to write a
\&\fI.fetchmailrc\fP file in your home directory (you may do this
directly, with a text editor, or indirectly via \fBfetchmailconf\fP).
When there is a conflict between the command-line arguments and the
arguments in this file, the command-line arguments take precedence.
.PP
To protect the security of your passwords,
your \fI~/.fetchmailrc\fP may not normally have more than 0700 (u=rwx,g=,o=) permissions;
\fBfetchmail\fP
will complain and exit otherwise (this check is suppressed when
\-\-version is on).
.PP
You may read the \fI.fetchmailrc\fP file as a list of commands to
be executed when
\fBfetchmail\fP
is called with no arguments.
.SS Run Control Syntax
Comments begin with a '#' and extend through the end of the line.
Otherwise the file consists of a series of server entries or global
option statements in a free-format, token-oriented syntax.
.PP
There are four kinds of tokens: grammar keywords, numbers
(i.e., decimal digit sequences), unquoted strings, and quoted strings.
A quoted string is bounded by double quotes and may contain
whitespace (and quoted digits are treated as a string).  Note that
quoted strings will also contain line feed characters if they run across
two or more lines, unless you use a backslash to join lines (see below).
An unquoted string is any whitespace-delimited token that is neither
numeric, string quoted nor contains the special characters ',', ';',
\&':', or '='.
.PP
Any amount of whitespace separates tokens in server entries, but is
otherwise ignored. You may use backslash escape sequences (\en for LF,
\&\et for HT, \eb for BS, \er for CR, \e\fInnn\fP for decimal (where
nnn cannot start with a 0), \e0\fIooo\fP for octal, and \ex\fIhh\fP for
hex) to embed non-printable characters or string delimiters in strings.
In quoted strings, a backslash at the very end of a line will cause the
backslash itself and the line feed (LF or NL, new line) character to be
ignored, so that you can wrap long strings. Without the backslash at the
line end, the line feed character would become part of the string.
.PP
\fBWarning:\fP
while these resemble C-style escape sequences, they are not the same.
fetchmail only supports these eight styles. C supports more escape
sequences that consist of backslash (\e) and a single character, but
does not support decimal codes and does not require the leading 0 in
octal notation.  Example: fetchmail interprets \e233 the same as \exE9
(Latin small letter e with acute), where C would interpret \e233 as
octal 0233 = \ex9B (CSI, control sequence introducer).
.PP
Each server entry consists of one of the keywords 'poll' or 'skip',
followed by a server name, followed by server options, followed by any
number of user (or username) descriptions, followed by user options.
Note: the most common cause of syntax errors is mixing up user and
server options or putting user options before the user descriptions.
.PP
For backward compatibility, the word 'server' is a synonym for 'poll'.
.PP
You can use the noise keywords 'and', 'with',
\&'has', 'wants', and 'options' anywhere in an entry to make
it resemble English.  They are ignored, but can make entries much
easier to read at a glance.  The punctuation characters ':', ';' and
\&',' are also ignored.
.SS Poll versus Skip
The 'poll' verb tells fetchmail to query this host when it is run with
no arguments.  The 'skip' verb tells
\fBfetchmail\fP
not to poll this host unless it is explicitly named on the command
line.  (The 'skip' verb allows you to experiment with test entries
safely, or easily disable entries for hosts that are temporarily down.)
.SS Keyword/Option Summary
Here are the legal options.  Keyword suffixes enclosed in
square brackets are optional.  Those corresponding to short command-line
options are followed by '\-' and the appropriate option letter.  If
option is only relevant to a single mode of operation, it is noted as
\&'s' or 'm' for singledrop- or multidrop-mode, respectively.

Here are the legal global options:

.TS
l l l lw34.
Keyword  	Opt	Mode	Function
_
set daemon  	\-d	\&	T{
Set a background poll interval in seconds.
T}
set postmaster  	\&	\&	T{
Give the name of the last-resort mail recipient (default: user running
fetchmail, "postmaster" if run by the root user)
T}
set    bouncemail	\&	\&	T{
Direct error mail to the sender (default)
T}
set no bouncemail	\&	\&	T{
Direct error mail to the local postmaster (as per the 'postmaster'
global option above).
T}
set no spambounce	\&	\&	T{
Do not bounce spam-blocked mail (default).
T}
set    spambounce	\&	\&	T{
Bounce blocked spam-blocked mail (as per the 'antispam' user option)
back to the destination as indicated by the 'bouncemail' global option.
Warning: Do not use this to bounce spam back to the sender - most spam
is sent with false sender address and thus this option hurts innocent
bystanders.
T}
set no softbounce	\&	\&	T{
Delete permanently undeliverable mail. It is recommended to use this
option if the configuration has been thoroughly tested.
T}
set    softbounce	\&	\&	T{
Keep permanently undeliverable mail as though a temporary error had
occurred (default).
T}
set logfile  	\-L	\&	T{
Name of a file to append error and status messages to.  Only effective
in daemon mode and if fetchmail detaches.  If effective, overrides \fBset
syslog\fP.
T}
set pidfile  	\-p	\&	T{
Name of the PID file.
T}
set idfile  	\-i	\&	T{
Name of the file to store UID lists in.
T}
set    syslog	\&	\&	T{
Do error logging through syslog(3). May be overridden by \fBset
logfile\fP.
T}
set no syslog  	\&	\&	T{
Turn off error logging through syslog(3). (default)
T}
set properties 	\&	\&	T{
String value that is ignored by fetchmail (may be used by extension
scripts).
T}
.TE

Here are the legal server options:

.TS
l l l lw34.
Keyword  	Opt	Mode	Function
_
via      	\&	\&	T{
Specify DNS name of mail server, overriding poll name
T}
proto[col]	\-p	\&	T{
Specify protocol (case insensitive):
POP2, POP3, IMAP, APOP, KPOP
T}
local[domains]	\&	m	T{
Specify domain(s) to be regarded as local
T}
port    	\&	\&	T{
Specify TCP/IP service port (obsolete, use 'service' instead).
T}
service 	\-P	\&	T{
Specify service name (a numeric value is also allowed and
considered a TCP/IP port number).
T}
auth[enticate]	\&	\&	T{
Set authentication type (default 'any')
T}
timeout  	\-t	\&	T{
Server inactivity timeout in seconds (default 300)
T}
envelope	\-E	m	T{
Specify envelope-address header name
T}
no envelope	\&	m	T{
Disable looking for envelope address
T}
qvirtual	\-Q	m	T{
Qmail virtual domain prefix to remove from user name
T}
aka      	\&	m	T{
Specify alternate DNS names of mail server
T}
interface	\-I	\&	T{
specify IP interface(s) that must be up for server poll to take place
T}
monitor   	\-M	\&	T{
Specify IP address to monitor for activity
T}
plugin   	\&	\&	T{
Specify command through which to make server connections.
T}
plugout   	\&	\&	T{
Specify command through which to make listener connections.
T}
dns     	\&	m	T{
Enable DNS lookup for multidrop (default)
T}
no dns   	\&	m	T{
Disable DNS lookup for multidrop
T}
checkalias	\&	m	T{
Do comparison by IP address for multidrop
T}
no checkalias	\&	m	T{
Do comparison by name for multidrop (default)
T}
uidl    	\-U	\&	T{
Force POP3 to use client-side UIDLs (recommended)
T}
no uidl   	\&	\&	T{
Turn off POP3 use of client-side UIDLs (default)
T}
interval   	\&	\&	T{
Only check this site every N poll cycles; N is a numeric argument.
T}
tracepolls	\&	\&	T{
Add poll tracing information to the Received header
T}
principal   	\&	\&	T{
Set Kerberos principal (only useful with IMAP and kerberos)
T}
esmtpname   	\&	\&	T{
Set name for RFC2554 authentication to the ESMTP server.
T}
esmtppassword	\&	\&	T{
Set password for RFC2554 authentication to the ESMTP server.
T}
bad-header	\&	\&	T{
How to treat messages with a bad header. Can be reject (default) or accept.
T}
.TE

Here are the legal user descriptions and options:

.TS
l l l lw34.
Keyword  	Opt	Mode	Function
_
user[name]	\-u	\&	T{
This is the user description and must come first after server
description and after possible server options, and before user options.

It sets the remote user name if by itself or followed by 'there', or the
local user name if followed by 'here'.
T}
is      	\&	\&	T{
Connect local and remote user names
T}
to      	\&	\&	T{
Connect local and remote user names
T}
pass[word]	\&	\&	T{
Specify remote account password
T}
ssl     	\&	\&	T{
Connect to server over the specified base protocol using SSL encryption
T}
sslcert 	\&	\&	T{
Specify file for \fBclient side\fP public SSL certificate
T}
sslcertck	\&	\&	T{
Enable strict certificate checking and abort connection on failure.
Default only since fetchmail v6.4.0.
T}
no sslcertck	\&	\&	T{
Disable strict certificate checking and permit connections to continue
on failed verification. Discouraged. Should only be used together with
sslfingerprint.
T}
sslcertfile	\&	\&	T{
Specify file with trusted CA certificates
T}
sslcertpath	\&	\&	T{
Specify c_rehash-ed directory with trusted CA certificates.
T}
sslfingerprint	<HASH> \&	\&	T{
Specify the expected server certificate finger print from an MD5 hash. Fetchmail will
disconnect and log an error if it does not match.
T}
sslkey  	\&	\&	T{
Specify file for \fBclient side\fP private SSL key
T}
sslproto	\&	\&	T{
Force ssl protocol for connection
T}
folder  	\-r	\&	T{
Specify remote folder to query
T}
smtphost	\-S	\&	T{
Specify smtp host(s) to forward to
T}
fetchdomains	\&	m	T{
Specify domains for which mail should be fetched
T}
smtpaddress	\-D	\&	T{
Specify the domain to be put in RCPT TO lines
T}
smtpname	\&	\&	T{
Specify the user and domain to be put in RCPT TO lines
T}
antispam	\-Z	\&	T{
Specify what SMTP returns are interpreted as spam-policy blocks
T}
mda     	\-m	\&	T{
Specify MDA for local delivery
T}
bsmtp   	\&	\&	T{
Specify BSMTP batch file to append to
T}
preconnect	\&	\&	T{
Command to be executed before each connection
T}
postconnect	\&	\&	T{
Command to be executed after each connection
T}
keep     	\-k	\&	T{
Do not delete seen messages from server (for POP3, uidl is recommended)
T}
flush   	\-F	\&	T{
Flush all seen messages before querying (DANGEROUS)
T}
limitflush   	\&	\&	T{
Flush all oversized messages before querying
T}
fetchall	\-a	\&	T{
Fetch all messages whether seen or not
T}
rewrite    	\&	\&	T{
Rewrite destination addresses for reply (default)
T}
stripcr  	\&	\&	T{
Strip carriage returns from ends of lines
T}
forcecr  	\&	\&	T{
Force carriage returns at ends of lines
T}
pass8bits	\&	\&	T{
Force BODY=8BITMIME to ESMTP listener
T}
dropstatus	\&	\&	T{
Strip Status and X-Mozilla-Status lines out of incoming mail
T}
dropdelivered	\&	\&	T{
Strip Delivered-To lines out of incoming mail
T}
mimedecode	\&	\&	T{
Convert quoted-printable to 8-bit in MIME messages
T}
idle     	\&	\&	T{
Idle waiting for new messages after each poll (IMAP only)
T}
no keep  	\-K	\&	T{
Delete seen messages from server (default)
T}
no flush	\&	\&	T{
Do not flush all seen messages before querying (default)
T}
no fetchall	\&	\&	T{
Retrieve only new messages (default)
T}
no rewrite	\&	\&	T{
Do not rewrite headers
T}
no stripcr	\&	\&	T{
Do not strip carriage returns (default)
T}
no forcecr	\&	\&	T{
Do not force carriage returns at EOL (default)
T}
no pass8bits	\&	\&	T{
Do not force BODY=8BITMIME to ESMTP listener (default)
T}
no dropstatus	\&	\&	T{
Do not drop Status headers (default)
T}
no dropdelivered	\&	\&	T{
Do not drop Delivered\-To headers (default)
T}
no mimedecode	\&	\&	T{
Do not convert quoted-printable to 8-bit in MIME messages (default)
T}
no idle     	\&	\&	T{
Do not idle waiting for new messages after each poll (IMAP only)
T}
limit   	\-l	\&	T{
Set message size limit
T}
warnings   	\-w	\&	T{
Set message size warning interval
T}
batchlimit	\-b	\&	T{
Max # messages to forward in single connect
T}
fetchlimit	\-B	\&	T{
Max # messages to fetch in single connect
T}
fetchsizelimit	\&	\&	T{
Max # message sizes to fetch in single transaction
T}
fastuidl	\&	\&	T{
Use binary search for first unseen message (POP3 only)
T}
expunge 	\-e	\&	T{
Perform an expunge on every #th message (IMAP and POP3 only)
T}
properties  	\&	\&	T{
String value is ignored by fetchmail (may be used by extension scripts)
T}
.TE
.PP
All user options must begin with a user description (user or username
option) and \fIfollow\fP all server descriptions and options.
.PP
In the .fetchmailrc file, the 'envelope' string argument may be
preceded by a whitespace-separated number.  This number, if specified,
is the number of such headers to skip over (that is, an argument of 1
selects the second header of the given type).  This is sometimes useful
for ignoring bogus envelope headers created by an ISP's local delivery
agent or internal forwards (through mail inspection systems, for
instance).
.SS Keywords Not Corresponding To Option Switches
The 'folder' and 'smtphost' options (unlike their command-line
equivalents) can take a space- or comma-separated list of names
following them.
.PP
All options correspond to the obvious command-line arguments, except
the following: 'via', 'interval', 'aka', 'is', 'to', 'dns'/'no dns',
\&'checkalias'/'no checkalias', 'password', 'preconnect', 'postconnect',
\&'localdomains', 'stripcr'/'no stripcr', 'forcecr'/'no forcecr',
\&'pass8bits'/'no pass8bits' 'dropstatus/no dropstatus',
\&'dropdelivered/no dropdelivered', 'mimedecode/no mimedecode', 'no idle',
and 'no envelope'.
.PP
The 'via' option is for if you want to have more
than one configuration pointing at the same site.  If it is present,
the string argument will be taken as the actual DNS name of the
mail server host to query.
This will override the argument of poll, which can then simply be a
distinct label for the configuration (e.g., what you would give on the
command line to explicitly query this host).
.PP
The 'interval' option (which takes a numeric argument) allows you to poll a
server less frequently than the basic poll interval.  If you say
\&'interval N' the server this option is attached to will only be
queried every N poll intervals.
.SS Singledrop versus Multidrop options
Please ensure you read the section titled
\fBTHE USE AND ABUSE OF MULTIDROP MAILBOXES \fP
if you intend to use multidrop mode.
.PP
The 'is' or 'to' keywords associate the following local (client)
name(s) (or server-name to client-name mappings separated by =) with
the mail server user name in the entry.  If an is/to list has '*' as
its last name, unrecognized names are simply passed through. Note that
until \fBfetchmail\fP version 6.3.4 inclusively, these lists could only
contain local parts of user names (fetchmail would only look at the part
before the @ sign). \fBfetchmail\fP versions 6.3.5 and
newer support full addresses on the left hand side of these mappings,
and they take precedence over any 'localdomains', 'aka', 'via' or
similar mappings.
.PP
A single local name can be used to support redirecting your mail when
your username on the client machine is different from your name on the
mail server.  When there is only a single local name, mail is forwarded
to that local username regardless of the message's Received, To, Cc,
and Bcc headers.  In this case,
\fBfetchmail\fP
never does DNS lookups.
.PP
When there is more than one local name (or name mapping),
\fBfetchmail\fP looks at the envelope header, if configured, and
otherwise at the Received, To, Cc, and Bcc headers of retrieved mail
(this is 'multidrop mode').  It looks for addresses with host name parts
that match your poll name or your 'via', 'aka' or 'localdomains'
options, and usually also for host name parts which DNS tells it are
aliases of the mail server.  See the discussion of 'dns', 'checkalias',
\&'localdomains', and 'aka' for details on how matching addresses are
handled.
.PP
If \fBfetchmail\fP cannot match any mail server usernames or
localdomain addresses, the mail will be bounced.
Normally it will be bounced to the sender, but if the 'bouncemail'
global option is off, the mail will go to the local postmaster instead.
(see the 'postmaster' global option). See also BUGS.
.PP
The 'dns' option (normally on) controls the way addresses from
multidrop mailboxes are checked.  On, it enables logic to check each
host address that does not match an 'aka' or 'localdomains' declaration
by looking it up with DNS.  When a mail server username is recognized
attached to a matching host name part, its local mapping is added to
the list of local recipients.
.PP
The 'checkalias' option (normally off) extends the lookups performed
by the 'dns' keyword in multidrop mode, providing a way to cope with
remote MTAs that identify themselves using their canonical name, while
they're polled using an alias.
When such a server is polled, checks to extract the envelope address
fail, and \fBfetchmail\fP reverts to delivery using the To/Cc/Bcc
headers (See below \&'Header versus Envelope addresses').
Specifying this option instructs \fBfetchmail\fP to retrieve all the IP
addresses associated with both the poll name and the name used by the
remote MTA and to do a comparison of the IP addresses.  This comes in
handy in situations where the remote server undergoes frequent canonical
name changes, that would otherwise require modifications to the rcfile.
\&'checkalias' has no effect if \&'no dns' is specified in the rcfile.
.PP
The 'aka' option is for use with multidrop mailboxes.  It allows you
to pre-declare a list of DNS aliases for a server.  This is an
optimization hack that allows you to trade space for speed.  When
\fBfetchmail\fP, while processing a multidrop mailbox, grovels through
message headers looking for names of the mail server, pre-declaring
common ones can save it from having to do DNS lookups.  Note: the names
you give as arguments to 'aka' are matched as suffixes -- if you specify
(say) 'aka netaxs.com', this will match not just a host name netaxs.com,
but any host name that ends with '.netaxs.com'; such as (say)
pop3.netaxs.com and mail.netaxs.com.
.PP
The 'localdomains' option allows you to declare a list of domains
which fetchmail should consider local.  When fetchmail is parsing
address lines in multidrop modes, and a trailing segment of a host
name matches a declared local domain, that address is passed through
to the listener or MDA unaltered (local-name mappings are \fInot\fP
applied).
.PP
If you are using 'localdomains', you may also need to specify 'no
envelope', which disables \fBfetchmail\fP's normal attempt to deduce
an envelope address from the Received line or X-Envelope-To header or
whatever header has been previously set by 'envelope'.  If you set 'no
envelope' in the defaults entry it is possible to undo that in
individual entries by using 'envelope <string>'.  As a special case,
\&'envelope "Received"' restores the default parsing of
Received lines.
.PP
The \fBpassword\fP option requires a string argument, which is the password
to be used with the entry's server.
.PP
The 'preconnect' keyword allows you to specify a shell command to be
executed just before each time
\fBfetchmail\fP
establishes a mail server connection.  This may be useful if you are
attempting to set up secure POP connections with the aid of
.BR ssh (1).
If the command returns a nonzero status, the poll of that mail server
will be aborted.
.PP
Similarly, the 'postconnect' keyword similarly allows you to specify a
shell command to be executed just after each time a mail server
connection is taken down.
.PP
The 'forcecr' option controls whether lines terminated by LF only are
given CRLF termination before forwarding.  Strictly speaking RFC821
requires this, but few MTAs enforce the requirement so this option
is normally off (only one such MTA, qmail, is in significant use at
time of writing).
.PP
The 'stripcr' option controls whether carriage returns are stripped
out of retrieved mail before it is forwarded.  It is normally not
necessary to set this, because it defaults to 'on' (CR stripping
enabled) when there is an MDA declared but 'off' (CR stripping
disabled) when forwarding is via SMTP.  If 'stripcr' and 'forcecr' are
both on, 'stripcr' will override.
.PP
The 'pass8bits' option exists to cope with Microsoft mail programs that
stupidly slap a "Content-Transfer-Encoding: 7bit" on everything.  With
this option off (the default) and such a header present,
\fBfetchmail\fP
declares BODY=7BIT to an ESMTP-capable listener; this causes problems for
messages actually using 8-bit ISO or KOI-8 character sets, which will
be garbled by having the high bits of all characters stripped.  If
\&'pass8bits' is on,
\fBfetchmail\fP
is forced to declare BODY=8BITMIME to any ESMTP-capable listener.  If
the listener is 8-bit-clean (as all the major ones now are) the right
thing will probably result.
.PP
The 'dropstatus' option controls whether nonempty Status and
X-Mozilla-Status lines are retained in fetched mail (the default) or
discarded.  Retaining them allows your MUA to see what messages (if
any) were marked seen on the server.  On the other hand, it can
confuse some new-mail notifiers, which assume that anything with a
Status line in it has been seen.  (Note: the empty Status lines
inserted by some buggy POP servers are unconditionally discarded.)
.PP
The 'dropdelivered' option controls whether Delivered\-To headers will
be kept in fetched mail (the default) or discarded. These headers are
added by qmail and Postfix mail servers in order to avoid mail loops but
may get in your way if you try to "mirror" a mail server within the same
domain. Use with caution.
.PP
The 'mimedecode' option controls whether MIME messages using the
quoted-printable encoding are automatically converted into pure 8-bit
data. If you are delivering mail to an ESMTP-capable, 8-bit-clean
listener (that includes all of the major MTAs like sendmail), then
this will automatically convert quoted-printable message headers and
data into 8-bit data, making it easier to understand when reading
mail. If your e-mail programs know how to deal with MIME messages,
then this option is not needed.  The mimedecode option is off by
default, because doing RFC2047 conversion on headers throws away
character-set information and can lead to bad results if the encoding
of the headers differs from the body encoding.
.PP
The 'idle' option is intended to be used with IMAP servers supporting
the RFC2177 IDLE command extension, but does not strictly require it.
If it is enabled, and fetchmail detects that IDLE is supported, an
IDLE will be issued at the end of each poll.  This will tell the IMAP
server to hold the connection open and notify the client when new mail
is available.  If IDLE is not supported, fetchmail will simulate it by
periodically issuing NOOP. If you need to poll a link frequently, IDLE
can save bandwidth by eliminating TCP/IP connects and LOGIN/LOGOUT
sequences. On the other hand, an IDLE connection will eat almost all
of your fetchmail's time, because it will never drop the connection
and allow other polls to occur unless the server times out the IDLE.
It also does not work with multiple folders; only the first folder will
ever be polled.
.PP
The 'properties' option is an extension mechanism.  It takes a string
argument, which is ignored by fetchmail itself.  The string argument may be
used to store configuration information for scripts which require it.
In particular, the output of '\-\-configdump' option will make properties
associated with a user entry readily available to a Python script.
.SS Miscellaneous Run Control Options
The words 'here' and 'there' have useful English-like
significance.  Normally 'user eric is esr' would mean that
mail for the remote user 'eric' is to be delivered to 'esr',
but you can make this clearer by saying 'user eric there is esr here',
or reverse it by saying 'user esr here is eric there'
.PP
Legal protocol identifiers for use with the 'protocol' keyword are:
.sp
.nf
    auto (or AUTO) (legacy, to be removed from future release)
    pop2 (or POP2) (legacy, to be removed from future release)
    pop3 (or POP3)
    sdps (or SDPS)
    imap (or IMAP)
    apop (or APOP)
    kpop (or KPOP)
.fi
.sp
.PP
Legal authentication types are 'any', 'password', 'kerberos',
\&'kerberos_v4', 'kerberos_v5' and 'gssapi', 'cram\-md5', 'otp', 'msn'
(only for POP3), 'ntlm', 'ssh', 'external' (only IMAP).
The 'password' type specifies
authentication by normal transmission of a password (the password may be
plain text or subject to protocol-specific encryption as in CRAM-MD5);
\&'kerberos' tells \fBfetchmail\fP to try to get a Kerberos ticket at the
start of each query instead, and send an arbitrary string as the
password; and 'gssapi' tells fetchmail to use GSSAPI authentication.
See the description of the 'auth' keyword for more.
.PP
Specifying 'kpop' sets POP3 protocol over port 1109 with Kerberos V4
authentication.  These defaults may be overridden by later options.
.PP
There are some global option statements: 'set logfile'
followed by a string sets the same global specified by \-\-logfile.  A
command-line \-\-logfile option will override this. Note that \-\-logfile is
only effective if fetchmail detaches itself from the terminal and the
logfile already exists before fetchmail is run, and it overrides
\-\-syslog in this case.  Also,
\&'set daemon' sets the poll interval as \-\-daemon does.  This can be
overridden by a command-line \-\-daemon option; in particular \-\-daemon\~0
can be used to force foreground operation. The 'set postmaster'
statement sets the address to which multidrop mail defaults if there are
no local matches.  Finally, 'set syslog' sends log messages to
syslogd(8).

.SH DEBUGGING FETCHMAIL
.SS Fetchmail crashing
There are various ways in that fetchmail may "crash", i. e. stop
operation suddenly and unexpectedly. A "crash" usually refers to an
error condition that the software did not handle by itself. A well-known
failure mode is the "segmentation fault" or "signal 11" or "SIGSEGV" or
just "segfault" for short. These can be caused by hardware or by software
problems. Software-induced segfaults can usually be reproduced easily
and in the same place, whereas hardware-induced segfaults can go away if
the computer is rebooted, or powered off for a few hours, and can happen
in random locations even if you use the software the same way.

For solving hardware-induced segfaults, find the faulty component and repair or
replace it.
.URL https://www.bitwizard.nl/sig11/ "The Sig11 FAQ"
may help you with details.

For solving software-induced segfaults, the developers may need a "stack
backtrace".

.SS Enabling fetchmail core dumps
By default, fetchmail suppresses core dumps as these might contain
passwords and other sensitive information. For debugging fetchmail
crashes, obtaining a "stack backtrace" from a core dump is often the
quickest way to solve the problem, and when posting your problem on a
mailing list, the developers may ask you for a "backtrace".

1. To get useful backtraces, fetchmail needs to be installed without
getting stripped of its compilation symbols.  Unfortunately, most
binary packages that are installed are stripped, and core files from
symbol-stripped programs are worthless. So you may need to recompile
fetchmail. On many systems, you can type
.sp
.nf
        file `which fetchmail`
.fi
.sp
to find out if fetchmail was symbol-stripped or not. If yours was
unstripped, fine, proceed, if it was stripped, you need to recompile the
source code first. You do not usually need to install fetchmail in order
to debug it.

2. The shell environment that starts fetchmail needs to enable core
dumps. The key is the "maximum core (file) size" that can usually be
configured with a tool named "limit" or "ulimit". See the documentation
for your shell for details. In the popular bash shell, "ulimit \-Sc
unlimited" will allow the core dump.

3. You need to tell fetchmail, too, to allow core dumps. To do
this, run fetchmail with the \fB\-d0 \-v\fP options.  It is often easier
to also add \fB\-\-nosyslog \-N\fP as well.

Finally, you need to reproduce the crash. You can just start fetchmail
from the directory where you compiled it by typing \fB./fetchmail\fP,
so the complete command line will start with \fB./fetchmail \-Nvd0
\&\-\-nosyslog\fP and perhaps list your other options.

After the crash, run your debugger to obtain the core dump.  The
debugger will often be GNU GDB, you can then type (adjust paths as
necessary) \fBgdb ./fetchmail fetchmail.core\fP and then, after GDB
has started up and read all its files, type \fBbacktrace full\fP, save
the output (copy & paste will do, the backtrace will be read by a human)
and then type \fBquit\fP to leave gdb.
\fBNote:\fP
on some systems, the core
files have different names, they might contain a number instead of the
program name, or number and name, but it will usually have "core" as
part of their name.

.SH INTERACTION WITH RFC 822
When trying to determine the originating address of a message,
fetchmail looks through headers in the following order:
.sp
.nf
        Return-Path:
        Resent-Sender: (ignored if it does not contain an @ or !)
        Sender: (ignored if it does not contain an @ or !)
        Resent-From:
        From:
        Reply-To:
        Apparently-From:
.fi
.sp
The originating address is used for logging, and to set the MAIL FROM
address when forwarding to SMTP.  This order is intended to cope
gracefully with receiving mailing list messages in multidrop mode. The
intent is that if a local address does not exist, the bounce message
will not be returned blindly to the author or to the list itself, but
rather to the list manager (which is less annoying).

In multidrop mode, destination headers are processed as follows:
First, fetchmail looks for the header specified by the 'envelope' option
in order to determine the local recipient address. If the mail is
addressed to more than one recipient, the Received line will not contain
any information regarding recipient addresses.

Then fetchmail looks for the Resent-To:, Resent-Cc:, and Resent-Bcc:
lines.  If they exist, they should contain the final recipients and
have precedence over their To:/Cc:/Bcc: counterparts.  If the Resent\-*
lines do not exist, the To:, Cc:, Bcc: and Apparently-To: lines are
looked for. (The presence of a Resent\-To: is taken to imply that the
person referred by the To: address has already received the original
copy of the mail.)

.SH CONFIGURATION EXAMPLES
Note that although there are password declarations in a good many
of the examples below, this is mainly for illustrative purposes.
We recommend stashing account/password pairs in your $HOME/.netrc
file, where they can be used not just by fetchmail but by ftp(1) and
other programs.

The basic format is:

.IP
poll \fISERVERNAME\fP protocol \fIPROTOCOL\fP username \fINAME\fP
password \fIPASSWORD\fP

.PP
Example:

.IP
.nf
poll pop.provider.net protocol pop3 username "jsmith" password "secret1"
.fi

.PP
Or, using some abbreviations:

.IP
.nf
poll pop.provider.net proto pop3 user "jsmith" password "secret1"
.fi

.PP
Multiple servers may be listed:

.IP
.nf
poll pop.provider.net proto pop3 user "jsmith" pass "secret1"
poll other.provider.net proto pop2 user "John.Smith" pass "My^Hat"
.fi

.PP
Here's the same version with more whitespace and some noise words:

.IP
.nf
poll pop.provider.net proto pop3
     user "jsmith", with password secret1, is "jsmith" here;
poll other.provider.net proto pop2:
     user "John.Smith", with password "My^Hat", is "John.Smith" here;
.fi

.PP
If you need to include whitespace in a parameter string or start the
latter with a number, enclose the string in double quotes.  Thus:

.IP
.nf
poll mail.provider.net with proto pop3:
     user "jsmith" there has password "4u but u cannot krak this"
     is jws here and wants mda "/bin/mail"
.fi

.PP
You may have an initial server description headed by the keyword
\&'defaults' instead of 'poll' followed by a name.  Such a record
is interpreted as defaults for all queries to use. It may be overwritten
by individual server descriptions.  So, you could write:

.IP
.nf
defaults proto pop3
     user "jsmith"
poll pop.provider.net
     pass "secret1"
poll mail.provider.net
     user "jjsmith" there has password "secret2"
.fi

.PP
It is possible to specify more than one user per server.
The 'user' keyword leads off a user description, and every user specification
in a multi-user entry must include it.  Here's an example:

.IP
.nf
poll pop.provider.net proto pop3 port 3111
     user "jsmith" with pass "secret1" is "smith" here
     user jones with pass "secret2" is "jjones" here keep
.fi

.PP
This associates the local username 'smith' with the pop.provider.net
username 'jsmith' and the local username 'jjones' with the
pop.provider.net username 'jones'.  Mail for 'jones' is kept on the
server after download.

.PP
Here's what a simple retrieval configuration for a multidrop mailbox
looks like:

.IP
.nf
poll pop.provider.net:
     user maildrop with pass secret1 to golux 'hurkle'='happy' snark here
.fi

.PP
This says that the mailbox of account 'maildrop' on the server is a
multidrop box, and that messages in it should be parsed for the
server user names 'golux', 'hurkle', and 'snark'.  It further
specifies that 'golux' and 'snark' have the same name on the
client as on the server, but mail for server user 'hurkle' should be
delivered to client user 'happy'.

.PP
\fBNote\fP that \fBfetchmail,\fP until version 6.3.4, did NOT allow full
user@domain specifications here, these would never match.
\fIFetchmail\fP 6.3.5 and newer support user@domain specifications on
the left-hand side of a user mapping.

.PP
Here's an example of another kind of multidrop connection:

.IP
.nf
poll pop.provider.net localdomains loonytoons.org toons.org
     envelope X-Envelope-To
     user maildrop with pass secret1 to * here
.fi

.PP
This also says that the mailbox of account 'maildrop' on the server is
a multidrop box.  It tells fetchmail that any address in the
loonytoons.org or toons.org domains (including sub-domain addresses like
\&'joe@daffy.loonytoons.org') should be passed through to the local SMTP
listener without modification.  Be careful of mail loops if you do this!

.PP
Here's an example configuration using ssh and the plugin option.  The
queries are made directly on the stdin and stdout of imapd via ssh.
Note that in this setup, IMAP authentication can be skipped.

.IP
.nf
poll mailhost.net with proto imap:
     plugin "ssh %h /usr/sbin/imapd" auth ssh;
     user esr is esr here
.fi

.SH THE USE AND ABUSE OF MULTIDROP MAILBOXES
Use the multiple-local-recipients feature with caution -- it can bite.
All multidrop features are ineffective in ETRN and ODMR modes.

Also, note that in multidrop mode duplicate mails may be suppressed.
A piece of mail is considered duplicate if it does not have a discernible
envelope recipient address, has the same header as
the message immediately preceding and more than one addressee.  Such
runs of messages may be generated when copies of a message addressed
to multiple users are delivered to a multidrop box. (To be precise,
fetchmail 6.2.5 through 6.4.X use an MD5 hash of the raw message header,
and only fetchmail 6.4.16+ document this properly.
Fetchmail 5.0.8 (1999-09-14) through 6.2.4 used only the Message-ID header.
5.0.7 and older did not suppress duplicates.)

Note that this duplication killer code checking the entire header is
very restrictive and may not suppress many duplicates in practice - for
instance, if some X-Original-To or Delivered-To header differs.  This is
intentional and correct in such situations: wherever envelope information is
available, it should be used for reliable delivery of mailing list and blind
carbon copy (Bcc) messages. See the subsection Duplicate suppression below
for suggestions.

.SS Header versus Envelope addresses
The fundamental problem is that by having your mail server toss several
peoples' mail in a single maildrop box, you may have thrown away
potentially vital information about who each piece of mail was
actually addressed to (the 'envelope address', as opposed to the
header addresses in the RFC822 To/Cc headers - the Bcc is not available
at the receiving end).  This 'envelope address' is the address you need
in order to reroute mail properly.
.PP
Sometimes
\fBfetchmail\fP
can deduce the envelope address.  If the mail server MTA is
\fBsendmail\fP
and the item of mail had just one recipient, the MTA will have written
a 'by/for' clause that gives the envelope addressee into its Received
header. But this does not work reliably for other MTAs, nor if there is
more than one recipient.  By default, \fBfetchmail\fP looks for
envelope addresses in these lines; you can restore this default with
\&\-E "Received" or 'envelope Received'.
.PP
\fBAs a better alternative,\fP
some SMTP listeners and/or mail servers insert a header
in each message containing a copy of the envelope addresses.  This
header (when it exists) is often 'X\-Original\-To', 'Delivered\-To' or
\&'X\-Envelope\-To'.  Fetchmail's assumption about this can be changed with
the \-E or 'envelope' option.  Note that writing an envelope header of
this kind exposes the names of recipients (including blind-copy
recipients) to all receivers of the messages, so the upstream must store
one copy of the message per recipient to avoid becoming a privacy problem.
.PP
Postfix, since version 2.0, writes an X\-Original\-To: header which
contains a copy of the envelope as it was received.
.PP
Qmail and Postfix generally write a 'Delivered\-To' header upon
delivering the message to the mail spool and use it to avoid mail loops.
Qmail virtual domains however will prefix the user name with a string
that normally matches the user's domain. To remove this prefix you can
use the \-Q or 'qvirtual' option.
.PP
Sometimes, unfortunately, neither of these methods works.  That is the
point when you should contact your ISP and ask them to provide such an
envelope header, and you should not use multidrop in this situation.
When they all fail, fetchmail must fall back on the contents of To/Cc
headers (Bcc headers are not available - see below) to try to determine
recipient addressees -- and these are unreliable.
In particular, mailing-list software often ships mail with only
the list broadcast address in the To: header.
.PP
\fBNote that a future version of \fBfetchmail\fP may remove To/Cc parsing!\fP
.PP
When
\fBfetchmail\fP
cannot deduce a recipient address that is local, and the intended
recipient address was anyone other than fetchmail's invoking user,
\fBmail will get lost.\fP
This is what makes the multidrop feature risky without proper envelope
information.
.PP
A related problem is that when you blind-copy a mail message, the Bcc
information is carried \fIonly\fP as envelope address (it is removed from
the headers by the sending mail server, so fetchmail can see it only if
there is an X\-Envelope\-To header).  Thus, blind-copying to someone who
gets mail over a fetchmail multidrop link will fail unless the
mail server host routinely writes X\-Envelope\-To or an equivalent header
into messages in your maildrop.
.PP
\fBIn conclusion, mailing lists and Bcc'd mail can only work if the
server you are fetching from\fP
.IP (1)
\fBstores one copy of the message per recipient in your domain and\fP
.IP (2)
\fBrecords the envelope information in a special header (X\-Original\-To,
Delivered\-To, X\-Envelope\-To).\fP

.SS Good Ways To Use Multidrop Mailboxes
Multiple local names can be used to administer a mailing list from the
client side of a \fBfetchmail\fP collection.  Suppose your name is
\&'esr', and you want to both pick up your own mail and maintain a mailing
list called (say) "fetchmail-friends", and you want to keep the alias
list on your client machine.
.PP
On your server, you can alias 'fetchmail\-friends' to 'esr'; then, in
your \fI.fetchmailrc\fP, declare 'to esr fetchmail\-friends here'.
Then, when mail including 'fetchmail\-friends' as a local address
gets fetched, the list name will be appended to the list of
recipients your SMTP listener sees.  Therefore it will undergo alias
expansion locally.  Be sure to include 'esr' in the local alias
expansion of fetchmail\-friends, or you'll never see mail sent only to
the list.  Also be sure that your listener has the "me-too" option set
(sendmail's \-oXm command-line option or OXm declaration) so your name
is not removed from alias expansions in messages you send.
.PP
This trick is not without its problems, however.  You'll begin to see
this when a message comes in that is addressed only to a mailing list
you do \fInot\fP have declared as a local name.  Each such message
will feature an 'X\-Fetchmail\-Warning' header which is generated
because fetchmail cannot find a valid local name in the recipient
addresses.  Such messages default (as was described above) to being
sent to the local user running \fBfetchmail\fP, but the program has no
way to know that this is actually the right thing.

.SS Bad Ways To Abuse Multidrop Mailboxes
Multidrop mailboxes and
\fBfetchmail\fP
serving multiple users in daemon mode do not mix.  The problem, again, is
mail from mailing lists, which typically does not have an individual
recipient address on it.   Unless
\fBfetchmail\fP
can deduce an envelope address, such mail will only go to the account
running fetchmail (probably root).  Also, blind-copied users are very
likely never to see their mail at all.
.PP
If you are tempted to use \fBfetchmail\fP
to retrieve mail for multiple users from a single mail drop via POP or
IMAP, think again (and reread the section on header and envelope
addresses above).  It would be smarter to just let the mail sit in the
mail server's queue and use fetchmail's ETRN or ODMR modes to trigger
SMTP sends periodically (of course, this means you have to poll more
frequently than the mail server's expiry period).  If you cannot arrange
this, try setting up a UUCP feed.
.PP
If you absolutely \fImust\fP use multidrop for this purpose, make sure
your mail server writes an envelope-address header that fetchmail can
see.  Otherwise you \fIwill\fP lose mail and it \fIwill\fP come back
to haunt you.

.SS Speeding Up Multidrop Checking
Normally, when multiple users are declared
\fBfetchmail\fP
extracts recipient addresses as described above and checks each host
part with DNS to see if it is an alias of the mail server.  If so, the
name mappings described in the "to ... here" declaration are done and
the mail locally delivered.
.PP
This is a convenient but also slow method.  To speed
it up, pre-declare mail server aliases with 'aka'; these are checked
before DNS lookups are done.  If you are certain your aka list contains
\fBall\fP
DNS aliases of the mail server (and all MX names pointing at it - note
this may change in a future version)
you can declare 'no dns' to suppress DNS lookups entirely and
\fIonly\fP match against the aka list.

.SS Duplicate suppression on multidrop
If fetchmail's duplicate suppression code does not kick in for your
multidrop mail account, other options is using sieve, or for instance
Courier's maildrop package (and in particular, its reformail program
with the -D option) as the delivery agent (either from fetchmail,
or from your local mail server that fetchmail injects into).

.SH SOCKS
Support for socks4/5 is a \fBcompile time\fP configuration option. Once
compiled in, fetchmail will always use the socks libraries and
configuration on your system, there are no run-time switches in
fetchmail - but you can still configure SOCKS: you can specify which
SOCKS configuration file is used in the \fBSOCKS_CONF\fP environment
variable.

For instance, if you wanted to bypass the SOCKS proxy altogether and
have fetchmail connect directly, you could just pass
SOCKS_CONF=/dev/null in the environment, for example (add your usual
command line options - if any - to the end of this line):

.nf
env SOCKS_CONF=/dev/null fetchmail
.fi

.SH EXIT CODES
To facilitate the use of
\fBfetchmail\fP
in shell scripts, an exit\ status code is returned to give an indication
of what occurred during a given connection.
.PP
The exit codes returned by
\fBfetchmail\fP
are as follows:
.IP 0
One or more messages were successfully retrieved (or, if the \-c option
was selected, were found waiting but not retrieved).
.IP 1
There was no mail awaiting retrieval.  (There may have been old mail still
on the server but not selected for retrieval.) If you do not want "no
mail" to be an error condition (for instance, for cron jobs), use a
POSIX-compliant shell and add

.nf
|| [ $? \-eq 1 ]
.fi

to the end of the fetchmail command line, note that this leaves 0
untouched, maps 1 to 0, and maps all other codes to 1. See also item #C8
in the FAQ.
.IP 2
An error was encountered when attempting to open a socket to retrieve
mail.  If you do not know what a socket is, do not worry about it --
just treat this as an 'unrecoverable error'.  This error can also be
because a protocol fetchmail wants to use is not listed in /etc/services.
.IP 3
The user authentication step failed.  This usually means that a bad
user-id, password, or APOP id was specified.  Or it may mean that you
tried to run fetchmail under circumstances where it did not have
standard input attached to a terminal and could not prompt for a
missing password.
.IP 4
Some sort of fatal protocol error was detected.
.IP 5
There was a syntax error in the arguments to
\fBfetchmail\fP, or a pre- or post-connect command failed.
.IP 6
The run control file had bad permissions.
.IP 7
There was an error condition reported by the server.  Can also
fire if \fBfetchmail\fP timed out while waiting for the server.
.IP 8
Client-side exclusion error.  This means
\fBfetchmail\fP
either found another copy of itself already running, or failed in such
a way that it is not sure whether another copy is running.
.IP 9
The user authentication step failed because the server responded "lock
busy".  Try again after a brief pause!  This error is not implemented
for all protocols, nor for all servers.  If not implemented for your
server, "3" will be returned instead, see above.  May be returned when
talking to qpopper or other servers that can respond with "lock busy"
or some similar text containing the word "lock".
.IP 10
The
\fBfetchmail\fP
run failed while trying to do an SMTP port open or transaction.
.IP 11
Fatal DNS error.  Fetchmail encountered an error while performing
a DNS lookup at startup and could not proceed.
.IP 12
BSMTP batch file could not be opened.
.IP 13
Poll terminated by a fetch limit (see the \-\-fetchlimit option).
.IP 14
Server busy indication.
.IP 23
Internal error.  You should see a message on standard error with
details.
.IP "24 - 26, 28, 29"
These are internal codes and should not appear externally.
.PP
When
\fBfetchmail\fP
queries more than one host, return status is 0 if \fIany\fP query
successfully retrieved mail. Otherwise the returned error status is
that of the last host queried.

.SH FILES
.TP 5
~/.fetchmailrc, $HOME/.fetchmailrc, $HOME_ETC/.fetchmailrc, $FETCHMAILHOME/fetchmailrc
default run control file (location can be overridden with environment variables)
.TP 5
~/.fetchids, $HOME/.fetchids, $HOME_ETC/.fetchids, $FETCHMAILHOME/.fetchids
default location of file recording last message UIDs seen per host.
(location can be overridden with environment variables)
.TP 5
~/.fetchmail.pid, $HOME/.fetchmail.pid, $HOME_ETC/.fetchmail.pid, $FETCHMAILHOME/fetchmail.pid
default location of lock file (sometimes called pidfile or PID file, see option
pidfile) to help prevent concurrent runs (non-root mode).
(location can be overridden with environment variables)
.TP 5
~/.netrc, $HOME/.netrc, $HOME_ETC/.netrc
your FTP run control file, which (if present) will be searched for
passwords as a last resort before prompting for one interactively.
(location can be overridden with environment variables)
.TP 5
/var/run/fetchmail.pid
lock file (pidfile) to help prevent concurrent runs (root mode, Linux systems).
.TP 5
/etc/fetchmail.pid
lock file (pidfile) to help prevent concurrent runs (root mode, systems without /var/run).

.SH ENVIRONMENT
Fetchmail's behavior can be altered by providing it with environment variables. Some may
alter the operation of libraries that fetchmail links against, for instance, OpenSSL.
Note that in daemon mode, you will need to quit the background daemon process
and start a new fetchmail daemon for environment changes to take effect.
.IP \fBFETCHMAILHOME\fP
If this environment variable is set to a valid and
existing directory name, fetchmail will read $FETCHMAILHOME/fetchmailrc
(the dot is missing in this case), $FETCHMAILHOME/.fetchids (keeping its dot) and
$FETCHMAILHOME/fetchmail.pid (without dot) rather than from the user's home
directory.  The .netrc file is always looked for in the invoking
user's home directory (or $HOME_ETC) regardless of FETCHMAILHOME's setting.

.IP \fBFETCHMAILUSER\fP
If this environment variable is set, it is used as the name of the
calling user (default local name) for purposes such as mailing error
notifications.  Otherwise, if either the LOGNAME or USER variable is
correctly set (e.g., the corresponding UID matches the session user ID)
then that name is used as the default local name.  Otherwise
\fBgetpwuid\fP(3) must be able to retrieve a password entry for the
session ID (this elaborate logic is designed to handle the case of
multiple names per user ID gracefully).

.IP \fBFETCHMAIL_DISABLE_CBC_IV_COUNTERMEASURE\fP
(since v6.3.22):
If this environment variable is set and not empty, fetchmail will disable
a countermeasure against an SSL CBC IV attack (by setting
SSL_OP_DONT_INSERT_EMPTY_FRAGMENTS).  This is a security risk, but may be
necessary for connecting to certain non-standards-conforming servers.
See fetchmail's NEWS file and fetchmail-SA-2012-01.txt for details.
Earlier fetchmail versions (v6.3.21 and older) used to disable this
countermeasure, but v6.3.22 no longer does that as a safety precaution.

.IP \fBFETCHMAIL_POP3_FORCE_RETR\fP
(since v6.3.9):
If this environment variable is defined at all (even if empty), fetchmail
will forgo the POP3 TOP command and always use RETR. This can be
used as a workaround when TOP does not work properly.

.IP \fBFETCHMAIL_INCLUDE_DEFAULT_X509_CA_CERTS\fP
(since v6.3.17):
If this environment variable is set and not empty, fetchmail will always load
the default X.509 trusted certificate locations for SSL/TLS CA certificates,
even if \fB\-\-sslcertfile\fP and \fB\-\-sslcertpath\fP are given.
The latter locations take precedence over the system default locations.
This is useful in case there are broken certificates in the system directories
and the user has no administrator privileges to remedy the problem.

.IP \fBFETCHMAIL_WOLFSSL_DEBUG\fP
(since v6.4.25):
If fetchmail is compiled and linked with wolfSSL, if wolfSSL was built with
\-\-enable\-debug, and if this environment variable is set and not empty,
then enable wolfSSL's debug mode. This will emit huge amounts of debug output
to stderr.

.IP \fBHOME\fP
(documented since 6.4.1):
This variable is normally set to the user's home directory. If it is set
to a different directory than what is in the password database, HOME takes
precedence.

.IP \fBHOME_ETC\fP
(documentation corrected to match behaviour of code since 6.4.1):
If the HOME_ETC variable is set, it will override fetchmail's idea of $HOME,
i. e. fetchmail will read .fetchmailrc, .fetchids, .fetchmail.pid and .netrc
from $HOME_ETC instead of $HOME (or if HOME is also unset,
from the passwd file's home directory location).

If HOME_ETC and FETCHMAILHOME are both set, FETCHMAILHOME takes precedence
and HOME_ETC will be ignored.

.IP \fBSOCKS_CONF\fP
(only if SOCKS support is compiled in) this variable is used by the
socks library to find out which configuration file it should read. Set
this to /dev/null to bypass the SOCKS proxy.

.IP \fBSSL_CERT_DIR\fP
(with truly OpenSSL 1.1.1 compatible library): overrides OpenSSL's idea
of the default trust directory or path (which contains individual certificate
files and hashed symlinks), see the SSL_CTX_set_default_verify_paths(3)
manual page for details, it may be in the openssl development package.
If using another library's OpenSSL compatibility interface, this may not work.
Since this variable only specifies a default value, the option \-\-sslcertpath
takes precedence if given.

.IP \fBSSL_CERT_FILE\fP
(with truly OpenSSL 1.1.1 compatible library): overrides OpenSSL's idea
of the default trust certificate bundle file (which contains a concatenation
of base64-encoded certificates in PEM format), see the
SSL_CTX_set_default_verify_paths(3) manual page
for details, it may be in the openssl development package.
If using another library's OpenSSL compatibility interface, this may not work.
Since this variable only specifies a default value, the option \-\-sslcertfile
takes precedence if given.

.SH SIGNALS
If a \fBfetchmail\fP daemon is running as root, SIGUSR1 wakes it up from its
sleep phase and forces a poll of all non-skipped servers. For compatibility
reasons, SIGHUP can also be used in 6.3.X but may not be available in future
fetchmail versions.
.PP
If \fBfetchmail\fP is running in daemon mode as non-root, use SIGUSR1 to wake
it (this is so SIGHUP due to logout can retain the default action of killing
it).
.PP
Running \fBfetchmail\fP in foreground while a background fetchmail is
running will do whichever of these is appropriate to wake it up.

.SH BUGS, LIMITATIONS, AND KNOWN PROBLEMS
Please check the \fBNEWS\fP file that shipped with fetchmail for more
known bugs than those listed here.
.PP
Fetchmail cannot handle user names that contain blanks after a "@"
character, for instance "demonstr@ti on". These are rather uncommon and
only hurt when using UID-based \-\-keep setups, so the 6.X.Y versions of
fetchmail will not be fixed.
.PP
Fetchmail cannot handle configurations where you have multiple accounts
that use the same server name and the same login. Any user@server
combination must be unique.
.PP
The assumptions that the DNS and in particular the checkalias options
make are not often sustainable. For instance, it has become uncommon for
an MX server to be a POP3 or IMAP server at the same time. Therefore the
MX lookups may go away in a future release.
.PP
The mda and plugin options interact badly.  In order to collect error
status from the MDA, fetchmail has to change its normal signal
handling so that dead plugin processes do not get reaped until the end
of the poll cycle.  This can cause resource starvation if too many
zombies accumulate.  So either do not deliver to a MDA using plugins or
risk being overrun by an army of undead.
.PP
The \-\-interface option does not support IPv6 and it is doubtful if it
ever will, since there is no portable way to query interface IPv6
addresses.
.PP
The RFC822 address parser used in multidrop mode chokes on some
@-addresses that are technically legal but bizarre.  Strange uses of
quoting and embedded comments are likely to confuse it.
.PP
In a message with multiple envelope headers, only the last one
processed will be visible to fetchmail.
.PP
Use of some of these protocols requires that the program send
unencrypted passwords over the TCP/IP connection to the mail server.
This creates a risk that name/password pairs might be snaffled with a
packet sniffer or more sophisticated monitoring software.  Under Linux
and FreeBSD, the \-\-interface option can be used to restrict polling to
availability of a specific interface device with a specific local or
remote IP address, but snooping is still possible if (a) either host
has a network device that can be opened in promiscuous mode, or (b)
the intervening network link can be tapped.  We recommend the use of
.BR ssh (1)
tunnelling to not only shroud your passwords but encrypt the entire
conversation.
.PP
Use of the %F or %T escapes in an mda option could open a security
hole, because they pass text manipulable by an attacker to a shell
command.  Potential shell characters are replaced by '_' before
execution.  The hole is further reduced by the fact that fetchmail
temporarily discards any set-uid privileges it may have while running the
MDA.  For maximum safety, however, do not use an mda command containing
%F or %T when fetchmail is run from the root account itself.
.PP
Fetchmail's method of sending bounces due to errors or spam-blocking and
spam bounces requires that port 25 of localhost be available for sending
mail via SMTP.
.PP
If you modify \fI~/.fetchmailrc\fP while a background instance is
running and break the syntax, the background instance will die silently.
Unfortunately, it cannot die noisily because we do not yet know whether
syslog should be enabled.  On some systems, fetchmail dies quietly even
if there is no syntax error; this seems to have something to do with
buggy terminal ioctl code in the kernel.
.PP
The \-f\~\- option (reading a configuration from stdin) is incompatible
with the plugin option.
.PP
The 'principal' option only handles Kerberos IV, not V.
.PP
Interactively entered passwords are truncated after 63 characters. If
you really need to use a longer password, you will have to use a
configuration file.
.PP
A backslash as the last character of a configuration file will be
flagged as a syntax error rather than ignored.
.PP
The BSMTP error handling is virtually nonexistent and may leave broken
messages behind.
.PP
Send comments, bug reports, gripes, and the like to the
.MTO "fetchmail-devel@lists.sourceforge.net" "fetchmail-devel list"

.PP
An
.URL "https://fetchmail.sourceforge.io/fetchmail-FAQ.html" "HTML FAQ"
is available at the fetchmail home page, it should also accompany your
installation.

.SH AUTHOR
Fetchmail is currently maintained by Matthias Andree and Rob Funk with
major assistance from Sunil Shetye (for code) and Rob MacGregor (for the
mailing lists).
.PP
Most of the code is from
.MTO esr@snark.thyrsus.com "Eric S. Raymond"
\&.  Too many other people to name here have contributed code and patches.
.PP
This program is descended from and replaces
.BR popclient ,
by
.MTO "ceharris@mal.com" "Carl Harris"
\&; the internals have become quite different, but some of its interface
design is directly traceable to that ancestral program.
.PP
This manual page has been improved by Matthias Andree, R.\ Hannes
Beinert, and H\['e]ctor Garc\['i]a.

.SH SEE ALSO
.BR README ,
.BR README.SSL ,
.BR README.SSL-SERVER ,
.URL "https://www.fetchmail.info/fetchmail-FAQ.html" "The Fetchmail FAQ" ,
.BR mutt (1),
.BR elm (1),
.BR mail (1),
.BR sendmail (8),
.BR popd (8),
.BR imapd (8),
.BR netrc (5).
.PP
.URL "https://www.fetchmail.info/" "The fetchmail home page."
.PP
.URL "https://fetchmail.sourceforge.io/" "The fetchmail home page (alternative URI)."
.PP
.URL "https://www.courier-mta.org/maildrop/" "The maildrop home page."
.SH APPLICABLE STANDARDS
Note that this list is just a collection of references and not a
statement as to the actual protocol conformance or requirements in
fetchmail.
.TP 5
SMTP/ESMTP:
RFC 821, RFC 2821, RFC 1869, RFC 1652, RFC 1870, RFC 1983, RFC 1985,
RFC 2554.
.TP 5
mail:
RFC 822, RFC 2822, RFC 1123, RFC 1892, RFC 1894.
.TP 5
POP2:
RFC 937
.TP 5
POP3:
RFC 1081, RFC 1225, RFC 1460, RFC 1725, RFC 1734, RFC 1939, RFC 1957,
RFC 2195, RFC 2449.
.TP 5
APOP:
RFC 1939.
.TP 5
RPOP:
RFC 1081, RFC 1225.
.TP 5
IMAP2/IMAP2BIS:
RFC 1176, RFC 1732.
.TP 5
IMAP4/IMAP4rev1:
RFC 1730, RFC 1731, RFC 1732, RFC 2060, RFC 2061, RFC 2195, RFC 2177,
RFC 2683.
.TP 5
ETRN:
RFC 1985.
.TP 5
ODMR/ATRN:
RFC 2645.
.TP 5
OTP:
RFC 1938.
.TP 5
LMTP:
RFC 2033.
.TP 5
GSSAPI:
RFC 1508, RFC 1734,
.URL https://www.iana.org/assignments/gssapi-service-names/ "Generic Security Service Application Program Interface (GSSAPI)/Kerberos/Simple Authentication and Security Layer (SASL) Service Names" .
.TP 5
TLS:
RFC 2595.
