/*
  This file is part of CDO. CDO is a collection of Operators to manipulate and analyse Climate model Data.

  Author: Uwe Schulzweida

*/

#include "process_int.h"
#include "cdo_zaxis.h"
#include <mpim_grid.h>

void
fld_field_init(Field &field, size_t nmiss, double missval, size_t ngp, double *array, double *w)
{
  field.size = ngp;
  field.nmiss = nmiss;
  field.missval = missval;
  if (array != nullptr)
    for (size_t i = 0; i < ngp; ++i) field.vec_d[i] = array[i];
  if (w != nullptr)
    for (size_t i = 0; i < ngp; ++i) field.weightv[i] = w[i];
}
/*
double *
fld_weights(int gridID, size_t ngp)
{
  static bool lwarn = true;
  double *weights = (double *) Malloc(ngp * sizeof(double));
  for (size_t i = 0; i < ngp; ++i) weights[i] = 1;

  if (ngp > 1)
    {
      int wstatus = gridWeights(gridID, weights);
      if (wstatus != 0 && lwarn)
        {
          lwarn = false;
          cdo_warning("Grid cell bounds not available, using constant grid cell area weights!");
        }
    }

  return weights;
}
*/

void
vert_weights(int zaxisID, size_t nlev, Varray<double> &weights)
{
  weights.resize(nlev);
  std::vector<double> thickness(nlev);
  for (size_t i = 0; i < nlev; ++i) weights[i] = 1;

  if (nlev > 1)
    {
      static bool lwarn = true;
      int wstatus = get_layer_thickness(1, 0, 0, zaxisID, nlev, thickness.data(), weights.data());
      if (wstatus == 0 && lwarn && nlev > 1)
        {
          lwarn = false;
          cdo_warning("Layer bounds not available, using constant vertical weights!");
        }
    }
}
