//
// "$Id: Fl_Help_Dialog.H 5643 2007-01-28 19:36:51Z mike $"
//
// Fl_Help_Dialog dialog for the Fast Light Tool Kit (FLTK).
//
// Copyright 1998-2005 by Bill Spitzak and others.
//
// This library is free software; you can redistribute it and/or
// modify it under the terms of the GNU Library General Public
// License as published by the Free Software Foundation; either
// version 2 of the License, or (at your option) any later version.
//
// This library is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
// Library General Public License for more details.
//
// You should have received a copy of the GNU Library General Public
// License along with this library; if not, write to the Free Software
// Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301
// USA.
//
// Please report all bugs and problems on the following page:
//
//     http://www.fltk.org/str.php
//

// generated by Fast Light User Interface Designer (fluid) version 1.0108

#ifndef Fl_Help_Dialog_H
#define Fl_Help_Dialog_H
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Help_View.H>

class FL_EXPORT Fl_Help_Dialog {
  int index_; 
  int max_; 
  int line_[100]; 
  char file_[100][256]; 
  int find_pos_; 
public:
  Fl_Help_Dialog();
private:
  Fl_Double_Window *window_;
  Fl_Button *back_;
  void cb_back__i(Fl_Button*, void*);
  static void cb_back_(Fl_Button*, void*);
  Fl_Button *forward_;
  void cb_forward__i(Fl_Button*, void*);
  static void cb_forward_(Fl_Button*, void*);
  Fl_Button *smaller_;
  void cb_smaller__i(Fl_Button*, void*);
  static void cb_smaller_(Fl_Button*, void*);
  Fl_Button *larger_;
  void cb_larger__i(Fl_Button*, void*);
  static void cb_larger_(Fl_Button*, void*);
  Fl_Input *find_;
  void cb_find__i(Fl_Input*, void*);
  static void cb_find_(Fl_Input*, void*);
  Fl_Help_View *view_;
  void cb_view__i(Fl_Help_View*, void*);
  static void cb_view_(Fl_Help_View*, void*);
public:
  ~Fl_Help_Dialog();
  int h();
  void hide();
  void load(const char *f);
  void position(int xx, int yy);
  void resize(int xx, int yy, int ww, int hh);
  void show();
  void show(int argc, char **argv);
  void textsize(uchar s);
  uchar textsize();
  void topline(const char *n);
  void topline(int n);
  void value(const char *f);
  const char * value() const;
  int visible();
  int w();
  int x();
  int y();
};
#endif

//
// End of "$Id: Fl_Help_Dialog.H 5643 2007-01-28 19:36:51Z mike $".
//
