/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright 2025, Beijing ESWIN Computing Technology Co., Ltd..
 * All rights reserved.
 *
 * Device Tree binding constants for EIC7700 reset controller.
 *
 * Authors:
 *	Yifeng Huang <huangyifeng@eswincomputing.com>
 *	Xuyang Dong <dongxuyang@eswincomputing.com>
 */

#ifndef __DT_ESWIN_EIC7700_RESET_H__
#define __DT_ESWIN_EIC7700_RESET_H__

#define EIC7700_RESET_NOC_NSP		0
#define EIC7700_RESET_NOC_CFG		1
#define EIC7700_RESET_RNOC_NSP		2
#define EIC7700_RESET_SNOC_TCU		3
#define EIC7700_RESET_SNOC_U84		4
#define EIC7700_RESET_SNOC_PCIE_XSR	5
#define EIC7700_RESET_SNOC_PCIE_XMR	6
#define EIC7700_RESET_SNOC_PCIE_PR	7
#define EIC7700_RESET_SNOC_NPU		8
#define EIC7700_RESET_SNOC_JTAG		9
#define EIC7700_RESET_SNOC_DSP		10
#define EIC7700_RESET_SNOC_DDRC1_P2	11
#define EIC7700_RESET_SNOC_DDRC1_P1	12
#define EIC7700_RESET_SNOC_DDRC0_P2	13
#define EIC7700_RESET_SNOC_DDRC0_P1	14
#define EIC7700_RESET_SNOC_D2D		15
#define EIC7700_RESET_SNOC_AON		16
#define EIC7700_RESET_GPU_AXI		17
#define EIC7700_RESET_GPU_CFG		18
#define EIC7700_RESET_GPU_GRAY		19
#define EIC7700_RESET_GPU_JONES		20
#define EIC7700_RESET_GPU_SPU		21
#define EIC7700_RESET_DSP_AXI		22
#define EIC7700_RESET_DSP_CFG		23
#define EIC7700_RESET_DSP_DIV4		24
#define EIC7700_RESET_DSP_DIV0		25
#define EIC7700_RESET_DSP_DIV1		26
#define EIC7700_RESET_DSP_DIV2		27
#define EIC7700_RESET_DSP_DIV3		28
#define EIC7700_RESET_D2D_AXI		29
#define EIC7700_RESET_D2D_CFG		30
#define EIC7700_RESET_D2D_PRST		31
#define EIC7700_RESET_D2D_RAW_PCS	32
#define EIC7700_RESET_D2D_RX		33
#define EIC7700_RESET_D2D_TX		34
#define EIC7700_RESET_D2D_CORE		35
#define EIC7700_RESET_DDR1_ARST		36
#define EIC7700_RESET_DDR1_TRACE	37
#define EIC7700_RESET_DDR0_ARST		38
#define EIC7700_RESET_DDR_CFG		39
#define EIC7700_RESET_DDR0_TRACE	40
#define EIC7700_RESET_DDR_CORE		41
#define EIC7700_RESET_DDR_PRST		42
#define EIC7700_RESET_TCU_AXI		43
#define EIC7700_RESET_TCU_CFG		44
#define EIC7700_RESET_TCU_TBU0		45
#define EIC7700_RESET_TCU_TBU1		46
#define EIC7700_RESET_TCU_TBU2		47
#define EIC7700_RESET_TCU_TBU3		48
#define EIC7700_RESET_TCU_TBU4		49
#define EIC7700_RESET_TCU_TBU5		50
#define EIC7700_RESET_TCU_TBU6		51
#define EIC7700_RESET_TCU_TBU7		52
#define EIC7700_RESET_TCU_TBU8		53
#define EIC7700_RESET_TCU_TBU9		54
#define EIC7700_RESET_TCU_TBU10		55
#define EIC7700_RESET_TCU_TBU11		56
#define EIC7700_RESET_TCU_TBU12		57
#define EIC7700_RESET_TCU_TBU13		58
#define EIC7700_RESET_TCU_TBU14		59
#define EIC7700_RESET_TCU_TBU15		60
#define EIC7700_RESET_TCU_TBU16		61
#define EIC7700_RESET_NPU_AXI		62
#define EIC7700_RESET_NPU_CFG		63
#define EIC7700_RESET_NPU_CORE		64
#define EIC7700_RESET_NPU_E31CORE	65
#define EIC7700_RESET_NPU_E31BUS	66
#define EIC7700_RESET_NPU_E31DBG	67
#define EIC7700_RESET_NPU_LLC		68
#define EIC7700_RESET_HSP_AXI		69
#define EIC7700_RESET_HSP_CFG		70
#define EIC7700_RESET_HSP_POR		71
#define EIC7700_RESET_MSHC0_PHY		72
#define EIC7700_RESET_MSHC1_PHY		73
#define EIC7700_RESET_MSHC2_PHY		74
#define EIC7700_RESET_MSHC0_TXRX	75
#define EIC7700_RESET_MSHC1_TXRX	76
#define EIC7700_RESET_MSHC2_TXRX	77
#define EIC7700_RESET_SATA_ASIC0	78
#define EIC7700_RESET_SATA_OOB		79
#define EIC7700_RESET_SATA_PMALIVE	80
#define EIC7700_RESET_SATA_RBC		81
#define EIC7700_RESET_DMA0		82
#define EIC7700_RESET_HSP_DMA		83
#define EIC7700_RESET_USB0_VAUX		84
#define EIC7700_RESET_USB1_VAUX		85
#define EIC7700_RESET_HSP_SD1_PRST	86
#define EIC7700_RESET_HSP_SD0_PRST	87
#define EIC7700_RESET_HSP_EMMC_PRST	88
#define EIC7700_RESET_HSP_DMA_PRST	89
#define EIC7700_RESET_HSP_SD1_ARST	90
#define EIC7700_RESET_HSP_SD0_ARST	91
#define EIC7700_RESET_HSP_EMMC_ARST	92
#define EIC7700_RESET_HSP_DMA_ARST	93
#define EIC7700_RESET_HSP_ETH1_ARST	94
#define EIC7700_RESET_HSP_ETH0_ARST	95
#define EIC7700_RESET_SATA_ARST		96
#define EIC7700_RESET_PCIE_CFG		97
#define EIC7700_RESET_PCIE_POWEUP	98
#define EIC7700_RESET_PCIE_PERST	99
#define EIC7700_RESET_I2C0		100
#define EIC7700_RESET_I2C1		101
#define EIC7700_RESET_I2C2		102
#define EIC7700_RESET_I2C3		103
#define EIC7700_RESET_I2C4		104
#define EIC7700_RESET_I2C5		105
#define EIC7700_RESET_I2C6		106
#define EIC7700_RESET_I2C7		107
#define EIC7700_RESET_I2C8		108
#define EIC7700_RESET_I2C9		109
#define EIC7700_RESET_FAN		110
#define EIC7700_RESET_PVT0		111
#define EIC7700_RESET_PVT1		112
#define EIC7700_RESET_MBOX0		113
#define EIC7700_RESET_MBOX1		114
#define EIC7700_RESET_MBOX2		115
#define EIC7700_RESET_MBOX3		116
#define EIC7700_RESET_MBOX4		117
#define EIC7700_RESET_MBOX5		118
#define EIC7700_RESET_MBOX6		119
#define EIC7700_RESET_MBOX7		120
#define EIC7700_RESET_MBOX8		121
#define EIC7700_RESET_MBOX9		122
#define EIC7700_RESET_MBOX10		123
#define EIC7700_RESET_MBOX11		124
#define EIC7700_RESET_MBOX12		125
#define EIC7700_RESET_MBOX13		126
#define EIC7700_RESET_MBOX14		127
#define EIC7700_RESET_MBOX15		128
#define EIC7700_RESET_UART0		129
#define EIC7700_RESET_UART1		130
#define EIC7700_RESET_UART2		131
#define EIC7700_RESET_UART3		132
#define EIC7700_RESET_UART4		133
#define EIC7700_RESET_GPIO0		134
#define EIC7700_RESET_GPIO1		135
#define EIC7700_RESET_TIMER		136
#define EIC7700_RESET_SSI0		137
#define EIC7700_RESET_SSI1		138
#define EIC7700_RESET_WDT0		139
#define EIC7700_RESET_WDT1		140
#define EIC7700_RESET_WDT2		141
#define EIC7700_RESET_WDT3		142
#define EIC7700_RESET_LSP_CFG		143
#define EIC7700_RESET_U84_CORE0		144
#define EIC7700_RESET_U84_CORE1		145
#define EIC7700_RESET_U84_CORE2		146
#define EIC7700_RESET_U84_CORE3		147
#define EIC7700_RESET_U84_BUS		148
#define EIC7700_RESET_U84_DBG		149
#define EIC7700_RESET_U84_TRACECOM	150
#define EIC7700_RESET_U84_TRACE0	151
#define EIC7700_RESET_U84_TRACE1	152
#define EIC7700_RESET_U84_TRACE2	153
#define EIC7700_RESET_U84_TRACE3	154
#define EIC7700_RESET_SCPU_CORE		155
#define EIC7700_RESET_SCPU_BUS		156
#define EIC7700_RESET_SCPU_DBG		157
#define EIC7700_RESET_LPCPU_CORE	158
#define EIC7700_RESET_LPCPU_BUS		159
#define EIC7700_RESET_LPCPU_DBG		160
#define EIC7700_RESET_VC_CFG		161
#define EIC7700_RESET_VC_AXI		162
#define EIC7700_RESET_VC_MONCFG		163
#define EIC7700_RESET_JD_CFG		164
#define EIC7700_RESET_JD_AXI		165
#define EIC7700_RESET_JE_CFG		166
#define EIC7700_RESET_JE_AXI		167
#define EIC7700_RESET_VD_CFG		168
#define EIC7700_RESET_VD_AXI		169
#define EIC7700_RESET_VE_AXI		170
#define EIC7700_RESET_VE_CFG		171
#define EIC7700_RESET_G2D_CORE		172
#define EIC7700_RESET_G2D_CFG		173
#define EIC7700_RESET_G2D_AXI		174
#define EIC7700_RESET_VI_AXI		175
#define EIC7700_RESET_VI_CFG		176
#define EIC7700_RESET_VI_DWE		177
#define EIC7700_RESET_DVP		178
#define EIC7700_RESET_ISP0		179
#define EIC7700_RESET_ISP1		180
#define EIC7700_RESET_SHUTTR0		181
#define EIC7700_RESET_SHUTTR1		182
#define EIC7700_RESET_SHUTTR2		183
#define EIC7700_RESET_SHUTTR3		184
#define EIC7700_RESET_SHUTTR4		185
#define EIC7700_RESET_SHUTTR5		186
#define EIC7700_RESET_VO_MIPI		187
#define EIC7700_RESET_VO_PRST		188
#define EIC7700_RESET_VO_HDMI_PRST	189
#define EIC7700_RESET_VO_HDMI_PHY	190
#define EIC7700_RESET_VO_HDMI		191
#define EIC7700_RESET_VO_I2S		192
#define EIC7700_RESET_VO_I2S_PRST	193
#define EIC7700_RESET_VO_AXI		194
#define EIC7700_RESET_VO_CFG		195
#define EIC7700_RESET_VO_DC		196
#define EIC7700_RESET_VO_DC_PRST	197
#define EIC7700_RESET_BOOTSPI_HRST	198
#define EIC7700_RESET_BOOTSPI		199
#define EIC7700_RESET_ANO1		200
#define EIC7700_RESET_ANO0		201
#define EIC7700_RESET_DMA1_ARST		202
#define EIC7700_RESET_DMA1_HRST		203
#define EIC7700_RESET_FPRT		204
#define EIC7700_RESET_HBLOCK		205
#define EIC7700_RESET_SECSR		206
#define EIC7700_RESET_OTP		207
#define EIC7700_RESET_PKA		208
#define EIC7700_RESET_SPACC		209
#define EIC7700_RESET_TRNG		210
#define EIC7700_RESET_TIMER0_0		211
#define EIC7700_RESET_TIMER0_1		212
#define EIC7700_RESET_TIMER0_2		213
#define EIC7700_RESET_TIMER0_3		214
#define EIC7700_RESET_TIMER0_4		215
#define EIC7700_RESET_TIMER0_5		216
#define EIC7700_RESET_TIMER0_6		217
#define EIC7700_RESET_TIMER0_7		218
#define EIC7700_RESET_TIMER0_N		219
#define EIC7700_RESET_TIMER1_0		220
#define EIC7700_RESET_TIMER1_1		221
#define EIC7700_RESET_TIMER1_2		222
#define EIC7700_RESET_TIMER1_3		223
#define EIC7700_RESET_TIMER1_4		224
#define EIC7700_RESET_TIMER1_5		225
#define EIC7700_RESET_TIMER1_6		226
#define EIC7700_RESET_TIMER1_7		227
#define EIC7700_RESET_TIMER1_N		228
#define EIC7700_RESET_TIMER2_0		229
#define EIC7700_RESET_TIMER2_1		230
#define EIC7700_RESET_TIMER2_2		231
#define EIC7700_RESET_TIMER2_3		232
#define EIC7700_RESET_TIMER2_4		233
#define EIC7700_RESET_TIMER2_5		234
#define EIC7700_RESET_TIMER2_6		235
#define EIC7700_RESET_TIMER2_7		236
#define EIC7700_RESET_TIMER2_N		237
#define EIC7700_RESET_TIMER3_0		238
#define EIC7700_RESET_TIMER3_1		239
#define EIC7700_RESET_TIMER3_2		240
#define EIC7700_RESET_TIMER3_3		241
#define EIC7700_RESET_TIMER3_4		242
#define EIC7700_RESET_TIMER3_5		243
#define EIC7700_RESET_TIMER3_6		244
#define EIC7700_RESET_TIMER3_7		245
#define EIC7700_RESET_TIMER3_N		246
#define EIC7700_RESET_RTC		247
#define EIC7700_RESET_MNOC_SNOC_NSP	248
#define EIC7700_RESET_MNOC_VC		249
#define EIC7700_RESET_MNOC_CFG		250
#define EIC7700_RESET_MNOC_HSP		251
#define EIC7700_RESET_MNOC_GPU		252
#define EIC7700_RESET_MNOC_DDRC1_P3	253
#define EIC7700_RESET_MNOC_DDRC0_P3	254
#define EIC7700_RESET_RNOC_VO		255
#define EIC7700_RESET_RNOC_VI		256
#define EIC7700_RESET_RNOC_SNOC_NSP	257
#define EIC7700_RESET_RNOC_CFG		258
#define EIC7700_RESET_MNOC_DDRC1_P4	259
#define EIC7700_RESET_MNOC_DDRC0_P4	260
#define EIC7700_RESET_CNOC_VO_CFG	261
#define EIC7700_RESET_CNOC_VI_CFG	262
#define EIC7700_RESET_CNOC_VC_CFG	263
#define EIC7700_RESET_CNOC_TCU_CFG	264
#define EIC7700_RESET_CNOC_PCIE_CFG	265
#define EIC7700_RESET_CNOC_NPU_CFG	266
#define EIC7700_RESET_CNOC_LSP_CFG	267
#define EIC7700_RESET_CNOC_HSP_CFG	268
#define EIC7700_RESET_CNOC_GPU_CFG	269
#define EIC7700_RESET_CNOC_DSPT_CFG	270
#define EIC7700_RESET_CNOC_DDRT1_CFG	271
#define EIC7700_RESET_CNOC_DDRT0_CFG	272
#define EIC7700_RESET_CNOC_D2D_CFG	273
#define EIC7700_RESET_CNOC_CFG		274
#define EIC7700_RESET_CNOC_CLMM_CFG	275
#define EIC7700_RESET_CNOC_AON_CFG	276
#define EIC7700_RESET_LNOC_CFG		277
#define EIC7700_RESET_LNOC_NPU_LLC	278
#define EIC7700_RESET_LNOC_DDRC1_P0	279
#define EIC7700_RESET_LNOC_DDRC0_P0	280

#endif /* __DT_ESWIN_EIC7700_RESET_H__ */
