# SchedulerStats
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-3)</span>

Provides functions that expose statistics about the current scheduler. All
methods will return '0' if the runtime used the program wasn't compiled with
runtime statistics turned on.


```pony
primitive val SchedulerStats
```

## Constructors

### create
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-3)</span>


```pony
new val create()
: SchedulerStats val^
```

#### Returns

* [SchedulerStats](runtime_info-SchedulerStats.md) val^

---

## Public Functions

### total_mem_allocated
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-10)</span>


Returns the total memory currently allocated by the current scheduler thread
(note: this is an approximate value and it can be negative as it represents
only a partial view across all the scheduler threads)


```pony
fun box total_mem_allocated(
  auth: SchedulerStatsAuth val)
: I64 val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [I64](builtin-I64.md) val

---

### total_mem_used
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-20)</span>


Returns the total memory currently used by the current scheduler thread
(note: this is an approximate value and it can be negative as it represents
only a partial view across all the scheduler threads)


```pony
fun box total_mem_used(
  auth: SchedulerStatsAuth val)
: I64 val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [I64](builtin-I64.md) val

---

### created_actors_counter
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-30)</span>


Returns the number of actors created by the current schedule thread
(note: this is an approximate value and it can be negative as it represents
only a partial view across all the scheduler threads)


```pony
fun box created_actors_counter(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### destroyed_actors_counter
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-40)</span>


Returns the number of actors destroyed by the current schedule thread


```pony
fun box destroyed_actors_counter(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### actor_app_cpu
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-48)</span>


Returns the amount of cpu the current scheduler has used to process actor app messages


```pony
fun box actor_app_cpu(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### actor_gc_mark_cpu
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-56)</span>


Returns the amount of cpu the current scheduler has used for mark phase to garbage collect actor heaps


```pony
fun box actor_gc_mark_cpu(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### actor_gc_sweep_cpu
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-64)</span>


Returns the amount of cpu the current scheduler has used for sweep phase to garbage collect actor heaps


```pony
fun box actor_gc_sweep_cpu(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### actor_system_cpu
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-72)</span>


Returns the amount of cpu the current scheduler has used to process actor system messages


```pony
fun box actor_system_cpu(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### msg_cpu
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-80)</span>


Returns the amount of cpu the current scheduler has used to process scheduler system messages


```pony
fun box msg_cpu(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### misc_cpu
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-88)</span>


Returns the amount of cpu the current scheduler has used while waiting to do work


```pony
fun box misc_cpu(
  auth: SchedulerStatsAuth val)
: USize val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [USize](builtin-USize.md) val

---

### mem_used_inflight_messages
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-96)</span>


Returns the number of memory used by inflight messages created by the current
scheduler thread (note: this is an approximate value and it can be negative if
the current thread receives more messages than it sends)


```pony
fun box mem_used_inflight_messages(
  auth: SchedulerStatsAuth val)
: I64 val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [I64](builtin-I64.md) val

---

### mem_allocated_inflight_messages
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-106)</span>


Returns the number of memory allocated by inflight messages created by the current
scheduler thread (note: this is an approximate value and it can be negative if
the current thread receives more messages than it sends)


```pony
fun box mem_allocated_inflight_messages(
  auth: SchedulerStatsAuth val)
: I64 val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [I64](builtin-I64.md) val

---

### num_inflight_messages
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-116)</span>


Returns the number of inflight messages by the current scheduler thread
(note: this is an approximate value and it can be negative if
the current thread receives more messages than it sends)


```pony
fun box num_inflight_messages(
  auth: SchedulerStatsAuth val)
: I64 val
```
#### Parameters

*   auth: [SchedulerStatsAuth](runtime_info-SchedulerStatsAuth.md) val

#### Returns

* [I64](builtin-I64.md) val

---

### eq
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-10)</span>


```pony
fun box eq(
  that: SchedulerStats val)
: Bool val
```
#### Parameters

*   that: [SchedulerStats](runtime_info-SchedulerStats.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/runtime_info/scheduler_stats.md#L-0-10)</span>


```pony
fun box ne(
  that: SchedulerStats val)
: Bool val
```
#### Parameters

*   that: [SchedulerStats](runtime_info-SchedulerStats.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

