/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.security.alias;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class CredentialProvider {
    public static final String CLEAR_TEXT_FALLBACK = "hadoop.security.credential.clear-text-fallback";

    public boolean isTransient() {
        return false;
    }

    public abstract void flush() throws IOException;

    public abstract CredentialEntry getCredentialEntry(String var1) throws IOException;

    public abstract List<String> getAliases() throws IOException;

    public abstract CredentialEntry createCredentialEntry(String var1, char[] var2) throws IOException;

    public abstract void deleteCredentialEntry(String var1) throws IOException;

    public boolean needsPassword() throws IOException {
        return false;
    }

    public String noPasswordWarning() {
        return null;
    }

    public String noPasswordError() {
        return null;
    }

    public static class CredentialEntry {
        private final String alias;
        private final char[] credential;

        protected CredentialEntry(String alias, char[] credential) {
            this.alias = alias;
            this.credential = credential;
        }

        public String getAlias() {
            return this.alias;
        }

        public char[] getCredential() {
            return this.credential;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("alias(").append(this.alias).append(")=");
            if (this.credential == null) {
                buf.append("null");
            } else {
                for (char c : this.credential) {
                    buf.append(c);
                }
            }
            return buf.toString();
        }
    }
}

