/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;

public class ByteBufferMarkableInputStream
extends InputStream {
    private final ByteBuffer bb;

    public ByteBufferMarkableInputStream(ByteBuffer buffer) {
        this.bb = Objects.requireNonNull(buffer);
    }

    @Override
    public int read() throws IOException {
        return this.bb.hasRemaining() ? this.bb.get() & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (!this.bb.hasRemaining()) {
            return -1;
        }
        len = Math.min(len, this.bb.remaining());
        this.bb.get(b, off, len);
        return len;
    }

    @Override
    public int available() {
        return this.bb.remaining();
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readlimit) {
        this.bb.mark();
    }

    @Override
    public void reset() {
        this.bb.reset();
    }

    @Override
    public long skip(long n) {
        if (n >= (long)this.bb.remaining()) {
            int result = this.bb.remaining();
            this.bb.position(this.bb.limit());
            return result;
        }
        this.bb.position(this.bb.position() + (int)n);
        return n;
    }
}

