"use strict";
// Copyright Amazon.com Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: Apache-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.concatBuffers = void 0;
function concatBuffers(...inputBuffers) {
    const neededLength = inputBuffers.reduce((sum, buff) => sum + buff.byteLength, 0);
    const outputBuffer = new Uint8Array(neededLength);
    let offset = 0;
    inputBuffers.forEach((buff) => {
        if (ArrayBuffer.isView(buff)) {
            const { buffer, byteOffset, byteLength } = buff;
            outputBuffer.set(new Uint8Array(buffer, byteOffset, byteLength), offset);
        }
        else {
            outputBuffer.set(new Uint8Array(buff), offset);
        }
        offset += buff.byteLength;
    });
    return outputBuffer;
}
exports.concatBuffers = concatBuffers;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uY2F0X2J1ZmZlcnMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi8uLi9zcmMvY29uY2F0X2J1ZmZlcnMudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLG9FQUFvRTtBQUNwRSxzQ0FBc0M7OztBQUl0QyxTQUFnQixhQUFhLENBQzNCLEdBQUcsWUFBOEM7SUFFakQsTUFBTSxZQUFZLEdBQUcsWUFBWSxDQUFDLE1BQU0sQ0FDdEMsQ0FBQyxHQUFHLEVBQUUsSUFBSSxFQUFFLEVBQUUsQ0FBQyxHQUFHLEdBQUcsSUFBSSxDQUFDLFVBQVUsRUFDcEMsQ0FBQyxDQUNGLENBQUE7SUFDRCxNQUFNLFlBQVksR0FBRyxJQUFJLFVBQVUsQ0FBQyxZQUFZLENBQUMsQ0FBQTtJQUNqRCxJQUFJLE1BQU0sR0FBRyxDQUFDLENBQUE7SUFFZCxZQUFZLENBQUMsT0FBTyxDQUFDLENBQUMsSUFBSSxFQUFFLEVBQUU7UUFDNUIsSUFBSSxXQUFXLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxFQUFFO1lBQzVCLE1BQU0sRUFBRSxNQUFNLEVBQUUsVUFBVSxFQUFFLFVBQVUsRUFBRSxHQUFHLElBQUksQ0FBQTtZQUMvQyxZQUFZLENBQUMsR0FBRyxDQUFDLElBQUksVUFBVSxDQUFDLE1BQU0sRUFBRSxVQUFVLEVBQUUsVUFBVSxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUE7U0FDekU7YUFBTTtZQUNMLFlBQVksQ0FBQyxHQUFHLENBQUMsSUFBSSxVQUFVLENBQUMsSUFBSSxDQUFDLEVBQUUsTUFBTSxDQUFDLENBQUE7U0FDL0M7UUFDRCxNQUFNLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQTtJQUMzQixDQUFDLENBQUMsQ0FBQTtJQUVGLE9BQU8sWUFBWSxDQUFBO0FBQ3JCLENBQUM7QUFyQkQsc0NBcUJDIn0=