/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.search.pipeline;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.opensearch.common.metrics.OperationMetrics;
import org.opensearch.search.pipeline.Processor;
import org.opensearch.search.pipeline.SearchPipelineStats;

class SystemGeneratedProcessorMetrics {
    private final Map<Processor.ProcessorType, Map<String, FactoryMetrics>> factoryMetrics = new ConcurrentHashMap<Processor.ProcessorType, Map<String, FactoryMetrics>>();
    private final Map<Processor.ProcessorType, Map<String, OperationMetrics>> processorMetrics = new ConcurrentHashMap<Processor.ProcessorType, Map<String, OperationMetrics>>();

    SystemGeneratedProcessorMetrics() {
        for (Processor.ProcessorType type : Processor.ProcessorType.values()) {
            this.factoryMetrics.put(type, new ConcurrentHashMap());
            this.processorMetrics.put(type, new ConcurrentHashMap());
        }
    }

    void beforeEvaluation(String factoryType, Processor.ProcessorType processorType) {
        this.getOrCreateFactoryMetrics((String)factoryType, (Processor.ProcessorType)processorType).evaluation.before();
    }

    void afterEvaluation(String factoryType, Processor.ProcessorType processorType, long timeInNanos) {
        this.getOrCreateFactoryMetrics((String)factoryType, (Processor.ProcessorType)processorType).evaluation.after(timeInNanos);
    }

    void onEvaluationFailure(String factoryType, Processor.ProcessorType processorType) {
        this.getOrCreateFactoryMetrics((String)factoryType, (Processor.ProcessorType)processorType).evaluation.failed();
    }

    void beforeGeneration(String factoryType, Processor.ProcessorType processorType) {
        this.getOrCreateFactoryMetrics((String)factoryType, (Processor.ProcessorType)processorType).generation.before();
    }

    void afterGeneration(String factoryType, Processor.ProcessorType processorType, long timeInNanos) {
        this.getOrCreateFactoryMetrics((String)factoryType, (Processor.ProcessorType)processorType).generation.after(timeInNanos);
    }

    void onGenerationFailure(String factoryType, Processor.ProcessorType processorType) {
        this.getOrCreateFactoryMetrics((String)factoryType, (Processor.ProcessorType)processorType).generation.failed();
    }

    void beforeProcess(String processorKey, Processor.ProcessorType processorType) {
        this.getOrCreateProcessorMetrics(processorKey, processorType).before();
    }

    void afterProcess(String processorKey, Processor.ProcessorType processorType, long timeInNanos) {
        this.getOrCreateProcessorMetrics(processorKey, processorType).after(timeInNanos);
    }

    void onProcessFailure(String processorKey, Processor.ProcessorType processorType) {
        this.getOrCreateProcessorMetrics(processorKey, processorType).failed();
    }

    private FactoryMetrics getOrCreateFactoryMetrics(String factoryType, Processor.ProcessorType processorType) {
        return this.factoryMetrics.computeIfAbsent(processorType, k -> new HashMap()).computeIfAbsent(factoryType, k -> new FactoryMetrics(this));
    }

    private OperationMetrics getOrCreateProcessorMetrics(String processorKey, Processor.ProcessorType processorType) {
        return this.processorMetrics.computeIfAbsent(processorType, k -> new HashMap()).computeIfAbsent(processorKey, k -> new OperationMetrics());
    }

    SearchPipelineStats.FactoryDetailStats getFactoryStats() {
        List<SearchPipelineStats.FactoryStats> requestProcessorFactoryStats = this.buildFactoryStats(Processor.ProcessorType.SEARCH_REQUEST);
        List<SearchPipelineStats.FactoryStats> responseProcessorFactoryStats = this.buildFactoryStats(Processor.ProcessorType.SEARCH_RESPONSE);
        return new SearchPipelineStats.FactoryDetailStats(requestProcessorFactoryStats, responseProcessorFactoryStats);
    }

    private List<SearchPipelineStats.FactoryStats> buildFactoryStats(Processor.ProcessorType type) {
        ArrayList<SearchPipelineStats.FactoryStats> stats = new ArrayList<SearchPipelineStats.FactoryStats>();
        this.factoryMetrics.get((Object)type).forEach((factoryType, metric) -> stats.add(new SearchPipelineStats.FactoryStats((String)factoryType, metric.evaluation.createStats(), metric.generation.createStats())));
        return stats;
    }

    SearchPipelineStats.PipelineDetailStats getProcessorStats() {
        List<SearchPipelineStats.ProcessorStats> requestProcessorStats = this.buildProcessorStats(Processor.ProcessorType.SEARCH_REQUEST);
        List<SearchPipelineStats.ProcessorStats> responseProcessorStats = this.buildProcessorStats(Processor.ProcessorType.SEARCH_RESPONSE);
        return new SearchPipelineStats.PipelineDetailStats(requestProcessorStats, responseProcessorStats);
    }

    private List<SearchPipelineStats.ProcessorStats> buildProcessorStats(Processor.ProcessorType type) {
        ArrayList<SearchPipelineStats.ProcessorStats> stats = new ArrayList<SearchPipelineStats.ProcessorStats>();
        this.processorMetrics.get((Object)type).forEach((processorType, metric) -> stats.add(new SearchPipelineStats.ProcessorStats((String)processorType, (String)processorType, metric.createStats())));
        return stats;
    }

    class FactoryMetrics {
        private final OperationMetrics evaluation = new OperationMetrics(TimeUnit.MICROSECONDS);
        private final OperationMetrics generation = new OperationMetrics(TimeUnit.MICROSECONDS);

        FactoryMetrics(SystemGeneratedProcessorMetrics this$0) {
        }

        public OperationMetrics evaluation() {
            return this.evaluation;
        }

        public OperationMetrics generation() {
            return this.generation;
        }
    }
}

