/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.lucene86;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.index.SortFieldProvider;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.Version;

public class Lucene86SegmentInfoFormat
extends SegmentInfoFormat {
    public static final String SI_EXTENSION = "si";
    static final String CODEC_NAME = "Lucene86SegmentInfo";
    static final int VERSION_START = 0;
    static final int VERSION_CURRENT = 0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SegmentInfo read(Directory dir, String segment, byte[] segmentID, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segment, (String)"", (String)SI_EXTENSION);
        try (ChecksumIndexInput input = EndiannessReverserUtil.openChecksumInput(dir, fileName, context);){
            Throwable priorE = null;
            SegmentInfo si = null;
            try {
                CodecUtil.checkIndexHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)0, (byte[])segmentID, (String)"");
                si = this.parseSegmentInfo(dir, (DataInput)input, segment, segmentID);
            }
            catch (Throwable exception) {
                priorE = exception;
            }
            finally {
                CodecUtil.checkFooter((ChecksumIndexInput)input, (Throwable)priorE);
            }
            SegmentInfo segmentInfo = si;
            return segmentInfo;
        }
    }

    private SegmentInfo parseSegmentInfo(Directory dir, DataInput input, String segment, byte[] segmentID) throws IOException {
        Sort indexSort;
        Version version = Version.fromBits((int)input.readInt(), (int)input.readInt(), (int)input.readInt());
        byte hasMinVersion = input.readByte();
        Version minVersion = switch (hasMinVersion) {
            case 0 -> null;
            case 1 -> Version.fromBits((int)input.readInt(), (int)input.readInt(), (int)input.readInt());
            default -> throw new CorruptIndexException("Illegal boolean value " + hasMinVersion, input);
        };
        int docCount = input.readInt();
        if (docCount < 0) {
            throw new CorruptIndexException("invalid docCount: " + docCount, input);
        }
        boolean isCompoundFile = input.readByte() == 1;
        Map diagnostics = input.readMapOfStrings();
        Set files = input.readSetOfStrings();
        Map attributes = input.readMapOfStrings();
        int numSortFields = input.readVInt();
        if (numSortFields > 0) {
            SortField[] sortFields = new SortField[numSortFields];
            for (int i = 0; i < numSortFields; ++i) {
                String name = input.readString();
                sortFields[i] = SortFieldProvider.forName((String)name).readSortField(input);
            }
            indexSort = new Sort(sortFields);
        } else {
            if (numSortFields < 0) {
                throw new CorruptIndexException("invalid index sort field count: " + numSortFields, input);
            }
            indexSort = null;
        }
        SegmentInfo si = new SegmentInfo(dir, version, minVersion, segment, docCount, isCompoundFile, false, null, diagnostics, segmentID, attributes, indexSort);
        si.setFiles((Collection)files);
        return si;
    }

    public void write(Directory dir, SegmentInfo si, IOContext ioContext) throws IOException {
        throw new UnsupportedOperationException("Old formats can't be used for writing");
    }
}

