/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.openpgp.KeyRingIterator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPMarker;
import org.bouncycastle.openpgp.PGPObjectFactory;
import org.bouncycastle.openpgp.PGPPadding;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Iterable;
import org.bouncycastle.util.Longs;
import org.bouncycastle.util.Strings;

public class PGPPublicKeyRingCollection
implements Iterable<PGPPublicKeyRing> {
    private Map<Long, PGPPublicKeyRing> pubRings = new HashMap<Long, PGPPublicKeyRing>();
    private List<Long> order = new ArrayList<Long>();

    private PGPPublicKeyRingCollection(Map<Long, PGPPublicKeyRing> pubRings, List<Long> order) {
        this.pubRings = pubRings;
        this.order = order;
    }

    public PGPPublicKeyRingCollection(byte[] encoding, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        this(new ByteArrayInputStream(encoding), fingerPrintCalculator);
    }

    public PGPPublicKeyRingCollection(InputStream in, KeyFingerPrintCalculator fingerPrintCalculator) throws IOException, PGPException {
        Object obj;
        PGPObjectFactory pgpFact = new PGPObjectFactory(in, fingerPrintCalculator);
        while ((obj = pgpFact.nextObject()) != null) {
            if (obj instanceof PGPMarker || obj instanceof PGPPadding) continue;
            if (!(obj instanceof PGPPublicKeyRing)) {
                throw new PGPException(obj.getClass().getName() + " found where PGPPublicKeyRing expected");
            }
            PGPPublicKeyRing pgpPub = (PGPPublicKeyRing)obj;
            Long key = Longs.valueOf((long)pgpPub.getPublicKey().getKeyID());
            this.pubRings.put(key, pgpPub);
            this.order.add(key);
        }
    }

    public PGPPublicKeyRingCollection(Collection<PGPPublicKeyRing> collection) {
        for (PGPPublicKeyRing pgpPub : collection) {
            Long key = Longs.valueOf((long)pgpPub.getPublicKey().getKeyID());
            this.pubRings.put(key, pgpPub);
            this.order.add(key);
        }
    }

    public int size() {
        return this.order.size();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings() {
        return this.pubRings.values().iterator();
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String userID) {
        return this.getKeyRings(userID, false, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String userID, boolean matchPartial) {
        return this.getKeyRings(userID, matchPartial, false);
    }

    public Iterator<PGPPublicKeyRing> getKeyRings(String userID, boolean matchPartial, boolean ignoreCase) {
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        ArrayList<PGPPublicKeyRing> rings = new ArrayList<PGPPublicKeyRing>();
        if (ignoreCase) {
            userID = Strings.toLowerCase((String)userID);
        }
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            Iterator<String> uIt = pubRing.getPublicKey().getUserIDs();
            while (uIt.hasNext()) {
                String next = uIt.next();
                if (ignoreCase) {
                    next = Strings.toLowerCase((String)next);
                }
                if (matchPartial) {
                    if (next.indexOf(userID) < 0) continue;
                    rings.add(pubRing);
                    continue;
                }
                if (!next.equals(userID)) continue;
                rings.add(pubRing);
            }
        }
        return rings.iterator();
    }

    public PGPPublicKey getPublicKey(long keyID) {
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            PGPPublicKey pub = pubRing.getPublicKey(keyID);
            if (pub == null) continue;
            return pub;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(long keyID) {
        Long id = Longs.valueOf((long)keyID);
        if (this.pubRings.containsKey(id)) {
            return this.pubRings.get(id);
        }
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            PGPPublicKey pub = pubRing.getPublicKey(keyID);
            if (pub == null) continue;
            return pubRing;
        }
        return null;
    }

    public PGPPublicKey getPublicKey(byte[] fingerprint) {
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            PGPPublicKey pub = pubRing.getPublicKey(fingerprint);
            if (pub == null) continue;
            return pub;
        }
        return null;
    }

    public PGPPublicKeyRing getPublicKeyRing(byte[] fingerprint) {
        Iterator<PGPPublicKeyRing> it = this.getKeyRings();
        while (it.hasNext()) {
            PGPPublicKeyRing pubRing = it.next();
            PGPPublicKey pub = pubRing.getPublicKey(fingerprint);
            if (pub == null) continue;
            return pubRing;
        }
        return null;
    }

    public Iterator<PGPPublicKey> getKeysWithSignaturesBy(long keyID) {
        ArrayList<PGPPublicKey> keysWithSigs = new ArrayList<PGPPublicKey>();
        Iterator<PGPPublicKeyRing> it = this.iterator();
        while (it.hasNext()) {
            PGPPublicKeyRing k = it.next();
            Iterator<PGPPublicKey> keyIt = k.getKeysWithSignaturesBy(keyID);
            while (keyIt.hasNext()) {
                keysWithSigs.add(keyIt.next());
            }
        }
        return keysWithSigs.iterator();
    }

    public boolean contains(long keyID) {
        return this.getPublicKey(keyID) != null;
    }

    public boolean contains(byte[] fingerprint) {
        return this.getPublicKey(fingerprint) != null;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream out = BCPGOutputStream.wrap(outStream);
        Iterator<Long> it = this.order.iterator();
        while (it.hasNext()) {
            PGPPublicKeyRing sr = this.pubRings.get(it.next());
            sr.encode(out);
        }
    }

    public static PGPPublicKeyRingCollection addPublicKeyRing(PGPPublicKeyRingCollection ringCollection, PGPPublicKeyRing publicKeyRing) {
        Long key = Longs.valueOf((long)publicKeyRing.getPublicKey().getKeyID());
        if (ringCollection.pubRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection already contains a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPPublicKeyRing> newPubRings = new HashMap<Long, PGPPublicKeyRing>(ringCollection.pubRings);
        ArrayList<Long> newOrder = new ArrayList<Long>(ringCollection.order);
        newPubRings.put(key, publicKeyRing);
        newOrder.add(key);
        return new PGPPublicKeyRingCollection(newPubRings, newOrder);
    }

    public static PGPPublicKeyRingCollection removePublicKeyRing(PGPPublicKeyRingCollection ringCollection, PGPPublicKeyRing publicKeyRing) {
        Long key = Longs.valueOf((long)publicKeyRing.getPublicKey().getKeyID());
        if (!ringCollection.pubRings.containsKey(key)) {
            throw new IllegalArgumentException("Collection does not contain a key with a keyID for the passed in ring.");
        }
        HashMap<Long, PGPPublicKeyRing> newPubRings = new HashMap<Long, PGPPublicKeyRing>(ringCollection.pubRings);
        ArrayList<Long> newOrder = new ArrayList<Long>(ringCollection.order);
        newPubRings.remove(key);
        for (int i = 0; i < newOrder.size(); ++i) {
            Long r = (Long)newOrder.get(i);
            if (r.longValue() != key.longValue()) continue;
            newOrder.remove(i);
            break;
        }
        return new PGPPublicKeyRingCollection(newPubRings, newOrder);
    }

    public Iterator<PGPPublicKeyRing> iterator() {
        return new KeyRingIterator<PGPPublicKeyRing>(this.order, this.pubRings);
    }
}

