/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.runtime.installer.frontend.components;

import com.install4j.api.Util;
import com.install4j.runtime.installer.frontend.GUIHelper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;

public class ProgressDisplay
extends JPanel {
    private JLabel lblStatus;
    private JLabel lblDetail;
    private JProgressBar progressBar;
    private GridBagConstraints gc;
    private int percentCompleted = 0;
    private int secondaryPercentCompleted = 0;
    private String lastDetailMessage;
    private boolean progressBarSizeWorkaround;

    public ProgressDisplay() {
        this.setupControls();
        this.setupComponent();
    }

    public void setStatusMessage(String statusMessage) {
        GUIHelper.invokeLater(() -> this.lblStatus.setText(statusMessage.length() == 0 ? " " : statusMessage));
    }

    public void setDetailMessage(String detailMessage) {
        this.lastDetailMessage = detailMessage;
        GUIHelper.invokeLater(() -> this.lblDetail.setText(detailMessage.length() == 0 ? " " : detailMessage));
    }

    public void setStatusVisible(boolean visible) {
        GUIHelper.invokeLater(() -> this.lblStatus.setVisible(visible));
    }

    public void setDetailVisible(boolean visible) {
        GUIHelper.invokeLater(() -> this.lblDetail.setVisible(visible));
    }

    public void setPercentCompleted(int percentCompleted) {
        if (this.percentCompleted == percentCompleted) {
            return;
        }
        this.percentCompleted = Math.min(percentCompleted, 100);
        GUIHelper.invokeLater(() -> this.progressBar.setValue(percentCompleted));
    }

    public int getPercentCompleted() {
        return this.percentCompleted;
    }

    public JProgressBar getProgressBar() {
        return this.progressBar;
    }

    private void setupControls() {
        this.lblStatus = new JLabel(" ");
        this.lblDetail = new JLabel(" ");
        this.progressBar = new JProgressBar(0, 0, 100);
        boolean bl = this.progressBarSizeWorkaround = Boolean.getBoolean("install4j.progressBarWorkaround") || Util.isWindows2012() || Util.isWindows2016();
        if (this.progressBarSizeWorkaround) {
            this.progressBar.setPreferredSize(new Dimension(100, 15));
            this.progressBar.setMinimumSize(new Dimension(100, 15));
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        GUIHelper.invokeLater(() -> this.setTextLinesEnabled(enabled));
    }

    public void setTextLinesEnabled(boolean enabled) {
        GUIHelper.invokeLater(() -> {
            this.lblStatus.setEnabled(enabled);
            this.lblDetail.setEnabled(enabled);
        });
    }

    private void setupComponent() {
        this.setLayout(new GridBagLayout());
        this.gc = new GridBagConstraints();
        this.gc.gridx = 0;
        this.gc.gridy = 0;
        this.gc.weightx = 1.0;
        this.gc.fill = 2;
        this.add((Component)this.lblStatus, this.gc);
        ++this.gc.gridy;
        this.add((Component)this.lblDetail, this.gc);
        ++this.gc.gridy;
        this.gc.insets.top = 3;
        this.gc.insets.bottom = 3;
        this.add((Component)this.progressBar, this.gc);
        ++this.gc.gridy;
    }

    public void setIndeterminateProgress(boolean indeterminateProgress) {
        GUIHelper.invokeLater(() -> this.setIndeterminateInternal(indeterminateProgress));
    }

    private void setIndeterminateInternal(boolean indeterminateProgress) {
        if (!this.progressBarSizeWorkaround) {
            this.progressBar.setPreferredSize(null);
            if (indeterminateProgress) {
                Dimension size = this.progressBar.getPreferredSize();
                --size.height;
                this.progressBar.setPreferredSize(size);
            }
            this.progressBar.invalidate();
            this.validate();
        }
        this.progressBar.setIndeterminate(indeterminateProgress);
    }

    public void activate() {
    }

    public void setSecondaryPercentCompleted(int percentCompleted) {
        if (this.secondaryPercentCompleted == percentCompleted || percentCompleted < 0) {
            return;
        }
        this.secondaryPercentCompleted = percentCompleted;
        GUIHelper.invokeLater(() -> {
            if (!this.lblDetail.isVisible()) {
                this.setDetailVisible(true);
            }
            StringBuilder buffer = new StringBuilder();
            if (this.lastDetailMessage != null && this.lastDetailMessage.trim().length() > 0) {
                buffer.append(this.lastDetailMessage);
                buffer.append(' ');
            }
            buffer.append("(");
            buffer.append(percentCompleted);
            buffer.append(" %)");
            this.lblDetail.setText(buffer.toString());
        });
    }
}

