/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.ResultsLogger;
import org.hibernate.sql.results.graph.Initializer;

public final class NavigablePathMapToInitializer {
    private HashMap<NavigablePath, InitializerHolder> map = null;

    public Initializer<?> get(NavigablePath navigablePath) {
        InitializerHolder h;
        if (this.map != null && navigablePath != null && (h = this.map.get(navigablePath)) != null) {
            return h.initializer;
        }
        return null;
    }

    public void put(NavigablePath navigablePath, Initializer<?> initializer) {
        Objects.requireNonNull(navigablePath);
        Objects.requireNonNull(initializer);
        if (this.map == null) {
            this.map = new HashMap();
        }
        this.map.put(navigablePath, new InitializerHolder(initializer));
    }

    public void logInitializers() {
        ResultsLogger logger2 = ResultsLogger.RESULTS_MESSAGE_LOGGER;
        if (!logger2.isDebugEnabled()) {
            return;
        }
        if (this.map == null) {
            logger2.debug("Initializer list is empty");
        } else {
            StringBuilder sb = new StringBuilder("Initializer list:\n");
            for (Map.Entry<NavigablePath, InitializerHolder> holderEntry : this.map.entrySet()) {
                NavigablePath navigablePath = holderEntry.getKey();
                Initializer<?> initializer = holderEntry.getValue().initializer;
                String formatted = String.format("  %s -> %s@%s (%s)", navigablePath, initializer, initializer.hashCode(), initializer.getInitializedPart());
                sb.append('\t');
                sb.append(formatted);
                sb.append('\n');
            }
            logger2.debug(sb.toString());
        }
    }

    private static final class InitializerHolder {
        final Initializer<?> initializer;

        private InitializerHolder(Initializer<?> init) {
            this.initializer = init;
        }
    }
}

