/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.Objects;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
public interface LogCleaningState {
    public static final LogCleaningInProgress LOG_CLEANING_IN_PROGRESS = new LogCleaningInProgress();
    public static final LogCleaningAborted LOG_CLEANING_ABORTED = new LogCleaningAborted();

    public static LogCleaningPaused logCleaningPaused(int pausedCount) {
        return new LogCleaningPaused(pausedCount);
    }

    public static final class LogCleaningPaused
    implements LogCleaningState {
        private final int pausedCount;

        private LogCleaningPaused(int pausedCount) {
            this.pausedCount = pausedCount;
        }

        public int pausedCount() {
            return this.pausedCount;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LogCleaningPaused that = (LogCleaningPaused)o;
            return this.pausedCount == that.pausedCount;
        }

        public int hashCode() {
            return Objects.hashCode(this.pausedCount);
        }

        public String toString() {
            return "LogCleaningPaused{pausedCount=" + this.pausedCount + "}";
        }
    }

    public static final class LogCleaningInProgress
    implements LogCleaningState {
        private LogCleaningInProgress() {
        }
    }

    public static final class LogCleaningAborted
    implements LogCleaningState {
        private LogCleaningAborted() {
        }
    }
}

