/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (https://www.swig.org).
 * Version 4.3.0
 *
 * Do not make changes to this file unless you know what you are doing - modify
 * the SWIG interface file instead.
 * ----------------------------------------------------------------------------- */

package org.itk.simple;
/**

Converts a label image to a label map and valuates the shape
attributes.


A convenient class that converts a label image to a label map and
valuates the shape attribute at once.

This implementation was taken from the Insight Journal paper: https://doi.org/10.54294/q6auw4


Gaetan Lehmann. Biologie du Developpement et de la Reproduction, INRA
de Jouy-en-Josas, France.

See:
 ShapeLabelObject , LabelShapeOpeningImageFilter , LabelStatisticsOpeningImageFilter

 itk::LabelImageToShapeLabelMapFilter for the Doxygen on the original ITK class.


C++ includes: sitkLabelShapeStatisticsImageFilter.h
*/
public class LabelShapeStatisticsImageFilter extends ImageFilter {
  private transient long swigCPtr;

  protected LabelShapeStatisticsImageFilter(long cPtr, boolean cMemoryOwn) {
    super(SimpleITKJNI.LabelShapeStatisticsImageFilter_SWIGUpcast(cPtr), cMemoryOwn);
    swigCPtr = cPtr;
  }

  protected static long getCPtr(LabelShapeStatisticsImageFilter obj) {
    return (obj == null) ? 0 : obj.swigCPtr;
  }

  protected static long swigRelease(LabelShapeStatisticsImageFilter obj) {
    long ptr = 0;
    if (obj != null) {
      if (!obj.swigCMemOwn)
        throw new RuntimeException("Cannot release ownership as memory is not owned");
      ptr = obj.swigCPtr;
      obj.swigCMemOwn = false;
      obj.delete();
    }
    return ptr;
  }

  @SuppressWarnings({"deprecation", "removal"})
  protected void finalize() {
    delete();
  }

  /**
virtual itk::simple::LabelShapeStatisticsImageFilter::~LabelShapeStatisticsImageFilter()

Destructor

*/
public  void delete() {
    if (swigCPtr != 0) {
      if (swigCMemOwn) {
        swigCMemOwn = false;
        SimpleITKJNI.delete_LabelShapeStatisticsImageFilter(swigCPtr);
      }
      swigCPtr = 0;
    }
    super.delete();
  }

  /**
itk::simple::LabelShapeStatisticsImageFilter::LabelShapeStatisticsImageFilter()

Default Constructor that takes no arguments and initializes default
parameters

*/
public  LabelShapeStatisticsImageFilter() {
    this(SimpleITKJNI.new_LabelShapeStatisticsImageFilter(), true);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::SetBackgroundValue(double BackgroundValue)

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  void setBackgroundValue(double BackgroundValue) {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_setBackgroundValue(swigCPtr, this, BackgroundValue);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetBackgroundValue() const

Set/Get the value used as "background" in the output image. Defaults
to NumericTraits&lt;PixelType&gt;::NonpositiveMin() .

*/
public  double getBackgroundValue() {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getBackgroundValue(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::SetComputeFeretDiameter(bool ComputeFeretDiameter)

Set/Get whether the maximum Feret diameter should be computed or not.
Default value is false, because of the high computation time required.

*/
public  void setComputeFeretDiameter(boolean ComputeFeretDiameter) {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_setComputeFeretDiameter(swigCPtr, this, ComputeFeretDiameter);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::ComputeFeretDiameterOn()

Set the value of ComputeFeretDiameter to true or false respectfully.

*/
public  void computeFeretDiameterOn() {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_computeFeretDiameterOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::ComputeFeretDiameterOff()
*/
public  void computeFeretDiameterOff() {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_computeFeretDiameterOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelShapeStatisticsImageFilter::GetComputeFeretDiameter() const

Set/Get whether the maximum Feret diameter should be computed or not.
Default value is false, because of the high computation time required.

*/
public  boolean getComputeFeretDiameter() {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getComputeFeretDiameter(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::SetComputePerimeter(bool ComputePerimeter)

Set/Get whether the perimeter should be computed or not. Default value
is false, because of the high computation time required.

*/
public  void setComputePerimeter(boolean ComputePerimeter) {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_setComputePerimeter(swigCPtr, this, ComputePerimeter);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::ComputePerimeterOn()

Set the value of ComputePerimeter to true or false respectfully.

*/
public  void computePerimeterOn() {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_computePerimeterOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::ComputePerimeterOff()
*/
public  void computePerimeterOff() {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_computePerimeterOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelShapeStatisticsImageFilter::GetComputePerimeter() const

Set/Get whether the perimeter should be computed or not. Default value
is false, because of the high computation time required.

*/
public  boolean getComputePerimeter() {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getComputePerimeter(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::SetComputeOrientedBoundingBox(bool ComputeOrientedBoundingBox)

Set/Get whether the oriented bounding box should be computed or not.
Default value is false because of potential memory consumption issues
with sparse labels.

*/
public  void setComputeOrientedBoundingBox(boolean ComputeOrientedBoundingBox) {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_setComputeOrientedBoundingBox(swigCPtr, this, ComputeOrientedBoundingBox);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::ComputeOrientedBoundingBoxOn()

Set the value of ComputeOrientedBoundingBox to true or false
respectfully.

*/
public  void computeOrientedBoundingBoxOn() {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_computeOrientedBoundingBoxOn(swigCPtr, this);
  }

  /**
Self&amp; itk::simple::LabelShapeStatisticsImageFilter::ComputeOrientedBoundingBoxOff()
*/
public  void computeOrientedBoundingBoxOff() {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_computeOrientedBoundingBoxOff(swigCPtr, this);
  }

  /**
bool itk::simple::LabelShapeStatisticsImageFilter::GetComputeOrientedBoundingBox() const

Set/Get whether the oriented bounding box should be computed or not.
Default value is false because of potential memory consumption issues
with sparse labels.

*/
public  boolean getComputeOrientedBoundingBox() {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getComputeOrientedBoundingBox(swigCPtr, this);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelShapeStatisticsImageFilter::GetBoundingBox(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getBoundingBox(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelShapeStatisticsImageFilter_getBoundingBox(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelShapeStatisticsImageFilter::GetRegion(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getRegion(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelShapeStatisticsImageFilter_getRegion(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetCentroid(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getCentroid(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getCentroid(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetElongation(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getElongation(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getElongation(swigCPtr, this, label);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentEllipsoidDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getEquivalentEllipsoidDiameter(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getEquivalentEllipsoidDiameter(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentSphericalPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getEquivalentSphericalPerimeter(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getEquivalentSphericalPerimeter(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetEquivalentSphericalRadius(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getEquivalentSphericalRadius(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getEquivalentSphericalRadius(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetFeretDiameter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFeretDiameter(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getFeretDiameter(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetFlatness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getFlatness(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getFlatness(swigCPtr, this, label);
  }

  /**
std::vector&lt;int64_t&gt; itk::simple::LabelShapeStatisticsImageFilter::GetLabels() const

This is a measurement. Its value is updated in the Execute methods, so
the value will only be valid after an execution.

*/
public  VectorInt64 getLabels() {
    return new VectorInt64(SimpleITKJNI.LabelShapeStatisticsImageFilter_getLabels(swigCPtr, this), true);
  }

  /**
uint64_t itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfPixels(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  java.math.BigInteger getNumberOfPixels(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getNumberOfPixels(swigCPtr, this, label);
  }

  /**
uint64_t itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfPixelsOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  java.math.BigInteger getNumberOfPixelsOnBorder(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getNumberOfPixelsOnBorder(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetPerimeter(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPerimeter(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getPerimeter(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetPerimeterOnBorder(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPerimeterOnBorder(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getPerimeterOnBorder(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetPerimeterOnBorderRatio(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPerimeterOnBorderRatio(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getPerimeterOnBorderRatio(swigCPtr, this, label);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetPhysicalSize(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getPhysicalSize(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getPhysicalSize(swigCPtr, this, label);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetPrincipalAxes(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getPrincipalAxes(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getPrincipalAxes(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetPrincipalMoments(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getPrincipalMoments(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getPrincipalMoments(swigCPtr, this, label), true);
  }

  /**
double itk::simple::LabelShapeStatisticsImageFilter::GetRoundness(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  double getRoundness(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getRoundness(swigCPtr, this, label);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetOrientedBoundingBoxSize(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getOrientedBoundingBoxSize(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getOrientedBoundingBoxSize(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetOrientedBoundingBoxOrigin(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getOrientedBoundingBoxOrigin(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getOrientedBoundingBoxOrigin(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetOrientedBoundingBoxDirection(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getOrientedBoundingBoxDirection(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getOrientedBoundingBoxDirection(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;double&gt; itk::simple::LabelShapeStatisticsImageFilter::GetOrientedBoundingBoxVertices(int64_t label) const

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorDouble getOrientedBoundingBoxVertices(long label) {
    return new VectorDouble(SimpleITKJNI.LabelShapeStatisticsImageFilter_getOrientedBoundingBoxVertices(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelShapeStatisticsImageFilter::GetIndexes(int64_t label) const

Get an array of indexes for pixels with the label value.

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getIndexes(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelShapeStatisticsImageFilter_getIndexes(swigCPtr, this, label), true);
  }

  /**
std::vector&lt;unsigned int&gt; itk::simple::LabelShapeStatisticsImageFilter::GetRLEIndexes(int64_t label) const

Get an array of run-length encoding (RLE) indexes for pixels with the
label value. The array is the index of a starting line, followed by
the length repeated. The length of the array is divisible by the
image's dimension + 1. For example for a 2D image the array [ 2, 3, 2]
would encode the two indexes [2,3] and [3,3].

This is an active measurement. It may be accessed while the filter is
being executing in command call-backs and can be accessed after
execution.

*/
public  VectorUInt32 getRLEIndexes(long label) {
    return new VectorUInt32(SimpleITKJNI.LabelShapeStatisticsImageFilter_getRLEIndexes(swigCPtr, this, label), true);
  }

  /**
std::string itk::simple::LabelShapeStatisticsImageFilter::GetName() const

Name of this class

*/
public  String getName() {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getName(swigCPtr, this);
  }

  /**
std::string itk::simple::LabelShapeStatisticsImageFilter::ToString() const

Print ourselves out

*/
public  String toString() {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_toString(swigCPtr, this);
  }

  /**
void itk::simple::LabelShapeStatisticsImageFilter::Execute(const Image &amp;image1)

Execute the filter on the input image

*/
public  void execute(Image image1) {
    SimpleITKJNI.LabelShapeStatisticsImageFilter_execute(swigCPtr, this, Image.getCPtr(image1), image1);
  }

  /**
bool itk::simple::LabelShapeStatisticsImageFilter::HasLabel(int64_t label)

Does the specified label exist? Can only be called after a call a call
to Update().

*/
public  boolean hasLabel(long label) {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_hasLabel(swigCPtr, this, label);
  }

  /**
uint64_t itk::simple::LabelShapeStatisticsImageFilter::GetNumberOfLabels()

Return the number of labels after execution.

*/
public  java.math.BigInteger getNumberOfLabels() {
    return SimpleITKJNI.LabelShapeStatisticsImageFilter_getNumberOfLabels(swigCPtr, this);
  }

}
