/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.weather;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;

public class SingleForecast {
    private String _date = null;
    private String _dayDescKey = null;
    private String _timeFrom = null;
    private String _timeTo = null;
    private String _imageName = null;
    private String _desc = null;
    private String _tempString = null;
    private String _humidity = null;
    private String _windDesc = null;
    private static SimpleDateFormat DATE_FORMATTER = new SimpleDateFormat("yyyy-MM-dd");

    public void setTime(String string, String string2, String string3) {
        this._date = string;
        if (string2 != null && string2.length() > 10 && string3 != null && string3.length() > 10) {
            this._date = string2.substring(0, 10);
            this._timeFrom = string2.substring(11, 16);
            this._timeTo = string3.substring(11, 16);
        }
        this._dayDescKey = SingleForecast.getDayDescriptionKey(this._date);
    }

    public void setSymbol(String string, String string2, String string3) {
        this._imageName = SingleForecast.getIconName(string, string2);
        this._desc = string3;
    }

    public void setTemps(String string, String string2) {
        String string3 = null;
        String string4 = null;
        try {
            string3 = "" + Math.round(Double.parseDouble(string));
        }
        catch (Exception exception) {}
        try {
            string4 = "" + Math.round(Double.parseDouble(string2));
        }
        catch (Exception exception) {}
        this._tempString = string3;
        if (string3 != null && string4 != null) {
            if (!string3.equals(string4)) {
                if (string3.charAt(0) == '-' && string4.charAt(0) != '-' && string4.charAt(0) != '0') {
                    string4 = "+" + string4;
                }
                this._tempString = String.valueOf(string3) + " &mdash; " + string4;
            }
        } else if (string4 != null) {
            this._tempString = string4;
        }
    }

    public void setHumidity(String string) {
        this._humidity = string;
    }

    public void setWindDesc(String string) {
        this._windDesc = string;
    }

    public static String getIconName(String string, String string2) {
        boolean bl = string2 == null || string2.length() != 3 || string2.charAt(2) != 'n';
        int n = string == null || string.equals("") ? 48 : (int)string.charAt(0);
        String string3 = null;
        switch (n) {
            case 50: {
                return "storm";
            }
            case 51: {
                return "lightrain";
            }
            case 53: {
                string3 = "rain";
                if (string.equals("500")) {
                    string3 = "lightrain";
                    break;
                }
                if (!string.equals("511")) break;
                string3 = "hail";
                break;
            }
            case 54: {
                return "snow";
            }
            case 55: {
                return "fog";
            }
            case 56: {
                String string4 = string3 = bl ? "clouds-day" : "clouds-night";
                if (string.equals("800")) {
                    string3 = bl ? "clear-day" : "clear-night";
                    break;
                }
                if (!string.equals("804")) break;
                string3 = "clouds";
                break;
            }
            case 57: {
                string3 = "extreme";
                if (!string.equals("906")) break;
                string3 = "hail";
            }
        }
        return string3;
    }

    private static String getDayDescriptionKey(String string) {
        if (string == null || string.length() != 10) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        String string2 = DATE_FORMATTER.format(calendar.getTime());
        if (string.equals(string2)) {
            return "today";
        }
        calendar.add(5, 1);
        String string3 = DATE_FORMATTER.format(calendar.getTime());
        if (string.equals(string3)) {
            return "tomorrow";
        }
        try {
            calendar.setTime(DATE_FORMATTER.parse(string));
            switch (calendar.get(7)) {
                case 2: {
                    return "monday";
                }
                case 3: {
                    return "tuesday";
                }
                case 4: {
                    return "wednesday";
                }
                case 5: {
                    return "thursday";
                }
                case 6: {
                    return "friday";
                }
                case 7: {
                    return "saturday";
                }
                case 1: {
                    return "sunday";
                }
            }
        }
        catch (ParseException parseException) {}
        return "other";
    }

    public boolean hasTimes() {
        return this._timeFrom != null && this._timeTo != null;
    }

    public String getTemps() {
        return this._tempString;
    }

    public String getDate() {
        return this._date;
    }

    public String getTimeFrom() {
        return this._timeFrom;
    }

    public String getTimeTo() {
        return this._timeTo;
    }

    public String getDayDesc() {
        return this._dayDescKey;
    }

    public String getImageName() {
        return this._imageName;
    }

    public String getDescription() {
        return this._desc;
    }

    public String getHumidity() {
        return this._humidity;
    }

    public String getWindDescription() {
        return this._windDesc;
    }
}

