/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.job;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.util.Caching;
import ghidra.graph.GDirectedGraph;
import ghidra.graph.VisualGraph;
import ghidra.graph.job.AbstractGraphVisibilityTransitionJob;
import ghidra.graph.viewer.GraphViewer;
import ghidra.graph.viewer.VisualEdge;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.layout.CalculateLayoutLocationsTask;
import ghidra.graph.viewer.layout.LayoutListener;
import ghidra.graph.viewer.layout.LayoutPositions;
import ghidra.graph.viewer.layout.VisualGraphLayout;
import ghidra.util.SystemUtilities;
import ghidra.util.task.TaskLauncher;
import java.awt.geom.Point2D;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jdesktop.animation.timing.Animator;

public abstract class AbstractGraphTransitionJob<V extends VisualVertex, E extends VisualEdge<V>>
extends AbstractGraphVisibilityTransitionJob<V, E> {
    protected final VisualGraphLayout<V, E> graphLayout;
    protected Map<V, TransitionPoints> vertexLocations = new HashMap<V, TransitionPoints>();
    protected Map<E, List<ArticulationTransitionPoints>> edgeArticulationLocations = new HashMap<E, List<ArticulationTransitionPoints>>();
    protected Map<E, List<Point2D>> finalEdgeArticulations = new HashMap<E, List<Point2D>>();

    protected AbstractGraphTransitionJob(GraphViewer<V, E> viewer, boolean useAnimation) {
        super(viewer, useAnimation);
        this.graphLayout = viewer.getVisualGraphLayout();
    }

    protected abstract void initializeVertexLocations();

    @Override
    public boolean canShortcut() {
        return false;
    }

    @Override
    public void shortcut() {
        throw new UnsupportedOperationException("Cannot shortcut this job: " + String.valueOf(this));
    }

    @Override
    protected Animator createAnimator() {
        this.initializeVertexLocations();
        this.clearLocationCache();
        return super.createAnimator();
    }

    @Override
    protected void finished() {
        this.clearLocationCache();
        this.installFinalEdgeArticulations();
        super.finished();
    }

    @Override
    public void setPercentComplete(double percentComplete) {
        this.updateNewVertexPositions(percentComplete);
        super.setPercentComplete(percentComplete);
    }

    protected void updatePointFromPercentComplete(TransitionPoints transitionPoints, double percentComplete, Point2D updatePoint) {
        double startX = transitionPoints.startPoint.getX();
        double destinationX = transitionPoints.destinationPoint.getX();
        double deltaX = (destinationX - startX) * percentComplete;
        double startY = transitionPoints.startPoint.getY();
        double destinationY = transitionPoints.destinationPoint.getY();
        double deltaY = (destinationY - startY) * percentComplete;
        double newX = transitionPoints.startPoint.getX() + deltaX;
        double newY = transitionPoints.startPoint.getY() + deltaY;
        updatePoint.setLocation(newX, newY);
    }

    protected void installFinalEdgeArticulations() {
        Collection edges = this.graph.getEdges();
        for (VisualEdge edge : edges) {
            List<Point2D> articulations = this.finalEdgeArticulations.get(edge);
            if (articulations == null) {
                articulations = Collections.emptyList();
            }
            edge.setArticulationPoints(articulations);
        }
    }

    private void updateNewVertexPositions(double percentComplete) {
        Set<Map.Entry<V, TransitionPoints>> entrySet = this.vertexLocations.entrySet();
        for (Map.Entry<V, TransitionPoints> entry : entrySet) {
            Point2D.Double newVertexLocation = new Point2D.Double();
            this.updatePointFromPercentComplete(entry.getValue(), percentComplete, newVertexLocation);
            this.clearLocationCache();
            VisualVertex newVertex = (VisualVertex)entry.getKey();
            this.graphLayout.setLocation(newVertex, newVertexLocation, LayoutListener.ChangeType.TRANSIENT);
        }
        Set<Map.Entry<E, List<ArticulationTransitionPoints>>> edgeEntries = this.edgeArticulationLocations.entrySet();
        for (Map.Entry<E, List<ArticulationTransitionPoints>> entry : edgeEntries) {
            List<ArticulationTransitionPoints> transitions = entry.getValue();
            for (ArticulationTransitionPoints transitionPoint : transitions) {
                Point2D updatePoint = transitionPoint.pointToUpdate;
                this.updatePointFromPercentComplete(transitionPoint, percentComplete, updatePoint);
            }
        }
    }

    protected LayoutPositions<V, E> calculateDefaultLayoutLocations() {
        LayoutPositions positions = this.calculateDefaultLayoutLocations(Collections.emptySet());
        return positions;
    }

    protected LayoutPositions<V, E> getCurrentLayoutLocations() {
        return LayoutPositions.getCurrentPositions(this.graph, this.graphLayout);
    }

    protected Point2D toLocation(V v) {
        return (Point2D)this.graphLayout.apply(v);
    }

    protected void clearLocationCache() {
        Layout jungLayout = this.viewer.getGraphLayout();
        ((Caching)jungLayout).clear();
    }

    public LayoutPositions<V, E> calculateDefaultLayoutLocations(Set<V> verticesToIgnore) {
        VisualGraphLayout layout = this.graph.getLayout();
        GDirectedGraph newGraph = this.graph.copy();
        newGraph.removeVertices(verticesToIgnore);
        this.ensureVerticesComponentsCreated((VisualGraph<V, E>)newGraph);
        CalculateLayoutLocationsTask task = new CalculateLayoutLocationsTask(newGraph, layout);
        new TaskLauncher(task, null, 2000);
        return task.getLocations();
    }

    private void ensureVerticesComponentsCreated(VisualGraph<V, E> g) {
        SystemUtilities.assertThisIsTheSwingThread((String)"Cannot create vertex components off the Swing thread");
        Collection vertices = g.getVertices();
        for (VisualVertex v : vertices) {
            v.getComponent();
        }
    }

    protected class TransitionPoints {
        public Point2D startPoint;
        public Point2D destinationPoint;

        public TransitionPoints(AbstractGraphTransitionJob this$0, Point2D startPoint, Point2D destinationPoint) {
            if (startPoint == null) {
                throw new IllegalArgumentException("Start point cannot be null");
            }
            if (destinationPoint == null) {
                throw new IllegalArgumentException("Destination point cannot be null");
            }
            this.startPoint = startPoint;
            this.destinationPoint = destinationPoint;
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[start=" + String.valueOf(this.startPoint) + ", dest=" + String.valueOf(this.destinationPoint) + "]";
        }
    }

    protected class ArticulationTransitionPoints
    extends TransitionPoints {
        public Point2D pointToUpdate;

        public ArticulationTransitionPoints(AbstractGraphTransitionJob this$0, Point2D currentEdgePoint, Point2D destinationPoint) {
            super(this$0, (Point2D)currentEdgePoint.clone(), destinationPoint);
            this.pointToUpdate = currentEdgePoint;
        }
    }
}

