/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.cli.streams;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.pe.cli.CliStreamHeader;
import ghidra.app.util.bin.format.pe.cli.streams.CliAbstractStream;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CliStreamStrings
extends CliAbstractStream {
    private List<Integer> stringIndexes = new ArrayList<Integer>();
    private List<Integer> stringSizes = new ArrayList<Integer>();

    public static String getName() {
        return "#Strings";
    }

    public CliStreamStrings(CliStreamHeader header, long offset, int rva, BinaryReader reader) throws IOException {
        super(header, offset, rva, reader);
    }

    @Override
    public boolean parse() throws IOException {
        this.reader.setPointerIndex(this.offset);
        int stringLength = 0;
        int prevOffset = 0;
        for (int bytesRead = 0; bytesRead < this.header.getSize(); ++bytesRead) {
            int currentByte = this.reader.readNextUnsignedByte();
            ++stringLength;
            if (currentByte != 0) continue;
            this.stringIndexes.add(prevOffset);
            prevOffset = bytesRead;
            this.stringSizes.add(stringLength);
            stringLength = 0;
        }
        return true;
    }

    public String getString(int index) {
        if (this.stringIndexes.size() == 0 || this.stringSizes.size() == 0) {
            return null;
        }
        int lastIndex = this.stringIndexes.get(this.stringIndexes.size() - 1);
        int lastSize = this.stringSizes.get(this.stringSizes.size() - 1);
        if (index < 0 || index >= lastIndex + lastSize) {
            return null;
        }
        int stringLength = 0;
        int stringLengthIndex = Collections.binarySearch(this.stringIndexes, index);
        if (stringLengthIndex >= 0) {
            stringLength = this.stringSizes.get(stringLengthIndex);
        } else {
            stringLengthIndex = -stringLengthIndex - 1 - 1;
            stringLength = this.stringSizes.get(stringLengthIndex) - (index - this.stringIndexes.get(stringLengthIndex));
        }
        try {
            return new String(this.reader.readByteArray(this.offset + (long)index, stringLength - 1), StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(new CategoryPath("/PE/CLI/Streams"), this.header.getName(), 0);
        for (int i = 0; i < this.stringSizes.size(); ++i) {
            struct.add(UTF8, this.stringSizes.get(i).intValue(), "[" + Integer.toHexString(this.stringIndexes.get(i)) + "]", null);
        }
        return struct;
    }
}

