/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.util.Msg;

public class PeUtils {
    public static Address getMarkupAddress(Program program, boolean isBinary, NTHeader ntHeader, int offset) {
        AddressSpace space = program.getAddressFactory().getDefaultAddressSpace();
        if (isBinary) {
            int ptr = ntHeader.rvaToPointer(offset);
            if (ptr < 0 && offset > 0) {
                Msg.error(PeUtils.class, (Object)("Invalid RVA " + Integer.toHexString(offset)));
                return space.getAddress((long)offset);
            }
            return space.getAddress((long)ptr);
        }
        return space.getAddress((long)offset + ntHeader.getOptionalHeader().getImageBase());
    }

    public static Data createData(Program program, Address addr, DataType datatype, MessageLog log) {
        Data existingData = program.getListing().getDefinedDataAt(addr);
        if (existingData != null) {
            DataType existingDataType = existingData.getDataType();
            if (existingDataType.isEquivalent(datatype)) {
                return existingData;
            }
            if (existingData.isPointer() && datatype instanceof Pointer && existingData.getLength() == datatype.getLength()) {
                return existingData;
            }
        }
        try {
            program.getListing().createData(addr, datatype);
            return program.getListing().getDefinedDataAt(addr);
        }
        catch (CodeUnitInsertionException e) {
            log.appendMsg("[" + program.getName() + "]: failed to create " + datatype.getDisplayName() + " at " + String.valueOf(addr) + ": " + e.getMessage());
        }
        catch (Exception e) {
            log.appendMsg(e.getMessage());
        }
        return null;
    }

    public static void createData(Program program, Address addr, DataType datatype, int datatypeLength, MessageLog log) {
        try {
            program.getListing().createData(addr, datatype, datatypeLength);
        }
        catch (Exception e) {
            log.appendMsg(e.getMessage());
        }
    }
}

