/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.omf.omf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.omf.Omf2or4;
import ghidra.app.util.bin.format.omf.OmfException;
import ghidra.app.util.bin.format.omf.OmfUtils;
import ghidra.app.util.bin.format.omf.omf.OmfData;
import ghidra.app.util.bin.format.omf.omf.OmfRecordTypes;
import ghidra.program.model.data.DataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;

public class OmfIteratedData
extends OmfData {
    public static final int MAX_ITERATED_FILL = 0x100000;
    private DataBlock[] datablock;

    public OmfIteratedData(BinaryReader reader) throws IOException {
        super(reader);
    }

    @Override
    public void parseData() throws IOException, OmfException {
        boolean hasBigFields = this.hasBigFields();
        this.segmentIndex = OmfUtils.readIndex(this.dataReader);
        this.dataOffset = OmfUtils.readInt2Or4(this.dataReader, hasBigFields);
        ArrayList<DataBlock> blocklist = new ArrayList<DataBlock>();
        while (this.dataReader.getPointerIndex() < this.dataEnd) {
            DataBlock block = DataBlock.read(this.dataReader, hasBigFields);
            blocklist.add(block);
        }
        this.datablock = new DataBlock[blocklist.size()];
        blocklist.toArray(this.datablock);
    }

    @Override
    public boolean isAllZeroes() {
        for (int i = 0; i < this.datablock.length; ++i) {
            if (this.datablock[i].isAllZeroes()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getLength() {
        int length = 0;
        for (DataBlock block : this.datablock) {
            length += block.getLength();
        }
        return length;
    }

    @Override
    public byte[] getByteArray(BinaryReader reader) throws IOException {
        int length = this.getLength();
        if (length > 0x100000) {
            throw new IOException("Iterated data-block is too big");
        }
        byte[] buffer = new byte[length];
        int pos = 0;
        for (DataBlock block : this.datablock) {
            pos = block.fillBuffer(buffer, pos);
        }
        return buffer;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        return OmfUtils.toOmfRecordDataType(this, OmfRecordTypes.getName(this.recordType));
    }

    public static class DataBlock {
        private Omf2or4 repeatCount;
        private int blockCount;
        private byte[] simpleBlock = null;
        private DataBlock[] nestedBlock = null;

        public static DataBlock read(BinaryReader reader, boolean hasBigFields) throws IOException {
            DataBlock subblock = new DataBlock();
            subblock.repeatCount = OmfUtils.readInt2Or4(reader, hasBigFields);
            subblock.blockCount = reader.readNextUnsignedShort();
            if (subblock.blockCount == 0) {
                int size = reader.readNextByte() & 0xFF;
                subblock.simpleBlock = new byte[size];
                for (int i = 0; i < size; ++i) {
                    subblock.simpleBlock[i] = reader.readNextByte();
                }
            } else {
                subblock.nestedBlock = new DataBlock[subblock.blockCount];
                for (int i = 0; i < subblock.blockCount; ++i) {
                    subblock.nestedBlock[i] = DataBlock.read(reader, hasBigFields);
                }
            }
            return subblock;
        }

        public int fillBuffer(byte[] buffer, int pos) {
            for (int i = 0; i < (int)this.repeatCount.value(); ++i) {
                if (this.simpleBlock != null) {
                    byte[] byArray = this.simpleBlock;
                    int n = byArray.length;
                    for (int j = 0; j < n; ++j) {
                        byte element;
                        buffer[pos] = element = byArray[j];
                        ++pos;
                    }
                    continue;
                }
                if (this.nestedBlock == null) continue;
                for (DataBlock block : this.nestedBlock) {
                    pos = block.fillBuffer(buffer, pos);
                }
            }
            return pos;
        }

        public int getLength() {
            int length = 0;
            if (this.simpleBlock != null) {
                length = this.simpleBlock.length;
            } else if (this.nestedBlock != null) {
                for (DataBlock block : this.nestedBlock) {
                    length += block.getLength();
                }
            }
            return length * (int)this.repeatCount.value();
        }

        public boolean isAllZeroes() {
            if (this.simpleBlock != null) {
                for (byte element : this.simpleBlock) {
                    if (element == 0) continue;
                    return false;
                }
            }
            if (this.nestedBlock != null) {
                for (int i = 0; i < this.nestedBlock.length; ++i) {
                    if (this.nestedBlock[i].isAllZeroes()) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

