/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.ne;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.ne.EntryTableBundle;
import java.io.IOException;

public class EntryPoint {
    public static final byte EXPORTED = 1;
    public static final byte GLOBAL = 2;
    private byte flagword;
    private short instruction;
    private byte segment;
    private short offset;
    private EntryTableBundle etb;

    EntryPoint(BinaryReader reader, EntryTableBundle etb) throws IOException {
        this.etb = etb;
        this.flagword = reader.readNextByte();
        if (etb.isMoveable()) {
            this.instruction = reader.readNextShort();
            this.segment = reader.readNextByte();
        }
        this.offset = reader.readNextShort();
    }

    public byte getFlagword() {
        return this.flagword;
    }

    public short getInstruction() {
        if (!this.etb.isMoveable()) {
            throw new RuntimeException("Entry point is not moveable!");
        }
        return this.instruction;
    }

    public byte getSegment() {
        if (!this.etb.isMoveable()) {
            throw new RuntimeException("Entry point is not moveable!");
        }
        return this.segment;
    }

    public short getOffset() {
        return this.offset;
    }
}

