/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.golang.structmapping;

import ghidra.app.util.bin.format.golang.structmapping.DataTypeMapper;
import ghidra.app.util.bin.format.golang.structmapping.Signedness;
import ghidra.app.util.bin.format.golang.structmapping.StructureMapping;
import ghidra.program.model.data.AbstractIntegerDataType;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CharDataType;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.data.WideChar16DataType;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ReflectionHelper {
    private static final Set<Class<?>> NUM_CLASSES = Set.of(Long.class, Long.TYPE, Integer.class, Integer.TYPE, Short.class, Short.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE);
    private static final Map<Class<?>, Integer> SIZEOF_NUM_CLASSES = Map.ofEntries(Map.entry(Long.class, 8), Map.entry(Long.TYPE, 8), Map.entry(Integer.class, 4), Map.entry(Integer.TYPE, 4), Map.entry(Short.class, 2), Map.entry(Short.TYPE, 2), Map.entry(Byte.class, 1), Map.entry(Byte.TYPE, 1), Map.entry(Character.class, 2), Map.entry(Character.TYPE, 2));
    private static final Map<Class<?>, String> DEFAULT_DATATYPE_NAME = Map.ofEntries(Map.entry(Long.class, "long"), Map.entry(Long.TYPE, "long"), Map.entry(Integer.class, "int"), Map.entry(Integer.TYPE, "int"), Map.entry(Short.class, "word"), Map.entry(Short.TYPE, "word"), Map.entry(Byte.class, "byte"), Map.entry(Byte.TYPE, "byte"), Map.entry(Character.class, "wchar"), Map.entry(Character.TYPE, "wchar"));
    private static final Map<Class<?>, Class<?>> PRIMITIVE_WRAPPER_CLASSES = Map.ofEntries(Map.entry(Long.TYPE, Long.class), Map.entry(Integer.TYPE, Integer.class), Map.entry(Short.TYPE, Short.class), Map.entry(Byte.TYPE, Byte.class), Map.entry(Character.TYPE, Character.class));

    public static boolean isPrimitiveType(Class<?> clazz) {
        return NUM_CLASSES.contains(clazz);
    }

    public static Class<?> getPrimitiveWrapper(Class<?> primitiveType) {
        Class<?> wrapperClass = PRIMITIVE_WRAPPER_CLASSES.get(primitiveType);
        if (wrapperClass == null) {
            throw new IllegalArgumentException();
        }
        return wrapperClass;
    }

    public static void assignField(Field field, Object obj, Object value) throws IOException {
        Class<?> fieldType = field.getType();
        try {
            if (fieldType.isPrimitive() && NUM_CLASSES.contains(value.getClass())) {
                field.set(obj, value);
            } else {
                if (!fieldType.isInstance(value)) {
                    throw new IOException("Bad conversion from %s to %s.%s:%s".formatted(value.getClass().getSimpleName(), obj.getClass().getSimpleName(), field.getName(), fieldType.getSimpleName()));
                }
                field.set(obj, value);
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }

    public static DataType getArrayOutputDataType(Object array_value, Class<?> fieldType, int length, Signedness signedness, DataTypeMapper dataTypeMapper) {
        int arrayLen = array_value != null ? Array.getLength(array_value) : 0;
        Class<?> elementType = fieldType.getComponentType();
        DataType elementDT = ReflectionHelper.getPrimitiveOutputDataType(elementType, length, signedness, dataTypeMapper);
        return new ArrayDataType(elementDT, arrayLen, -1, dataTypeMapper.getDTM());
    }

    public static DataType getPrimitiveOutputDataType(Class<?> fieldType, int length, Signedness signedness, DataTypeMapper dataTypeMapper) {
        DataType dt;
        boolean isChar = fieldType == Character.class || fieldType == Character.TYPE;
        DataTypeManager dtm = dataTypeMapper.getDTM();
        if (length == -1) {
            length = ReflectionHelper.getPrimitiveSizeof(fieldType);
        }
        if (signedness == Signedness.Unspecified) {
            signedness = isChar ? Signedness.Unsigned : Signedness.Signed;
        }
        String defaultDtName = DEFAULT_DATATYPE_NAME.get(fieldType);
        if (isChar && length == 1) {
            defaultDtName = "char";
        }
        if ((dt = dataTypeMapper.getType(defaultDtName, DataType.class)) == null && isChar) {
            switch (length) {
                case 1: {
                    CharDataType charDataType = CharDataType.dataType;
                    break;
                }
                case 2: {
                    CharDataType charDataType = WideChar16DataType.dataType;
                    break;
                }
                default: {
                    CharDataType charDataType = dt = null;
                }
            }
        }
        if (dt == null || !ReflectionHelper.matches(dt, length, signedness)) {
            dt = signedness == Signedness.Signed ? AbstractIntegerDataType.getSignedDataType((int)length, (DataTypeManager)dtm) : AbstractIntegerDataType.getSignedDataType((int)length, (DataTypeManager)dtm);
        }
        return dt;
    }

    private static boolean matches(DataType dt, int length, Signedness signedness) {
        AbstractIntegerDataType intDT;
        return (length == -1 || length == dt.getLength()) && (signedness == Signedness.Unspecified || dt instanceof AbstractIntegerDataType && signedness == Signedness.Signed == (intDT = (AbstractIntegerDataType)dt).isSigned());
    }

    public static int getPrimitiveSizeof(Class<?> fieldType) {
        return SIZEOF_NUM_CLASSES.getOrDefault(fieldType, 1);
    }

    public static boolean hasStructureMapping(Class<?> clazz) {
        return clazz.getAnnotation(StructureMapping.class) != null;
    }

    public static Signedness getDataTypeSignedness(DataType dt) {
        if (dt instanceof TypeDef) {
            TypeDef typedefDT = (TypeDef)dt;
            dt = typedefDT.getBaseDataType();
        }
        if (dt instanceof AbstractIntegerDataType) {
            AbstractIntegerDataType intDT = (AbstractIntegerDataType)dt;
            return intDT.isSigned() ? Signedness.Signed : Signedness.Unsigned;
        }
        return Signedness.Signed;
    }

    public static Method getCommentMethod(Class<?> clazz, String commentGetterName, String defaultGetterName) {
        Method commentGetter;
        if (commentGetterName.isBlank()) {
            commentGetterName = defaultGetterName;
        }
        if ((commentGetter = ReflectionHelper.requireGetter(clazz, commentGetterName)) == null) {
            throw new IllegalArgumentException("Missing getter %s for %s".formatted(commentGetterName, clazz));
        }
        return commentGetter;
    }

    public static Method requireGetter(Class<?> clazz, String getterName) {
        Method method = ReflectionHelper.findGetter(clazz, getterName);
        if (method == null) {
            throw new IllegalArgumentException("Missing getter %s for %s".formatted(getterName, clazz));
        }
        return method;
    }

    public static Method findGetter(Class<?> structClass, String getterName) {
        Method getter = ReflectionHelper.getMethod(structClass, getterName, new Class[0]);
        if (getter == null) {
            String getGetterName = "get%s%s".formatted(getterName.substring(0, 1).toUpperCase(), getterName.substring(1));
            getter = ReflectionHelper.getMethod(structClass, getGetterName, new Class[0]);
        }
        return getter;
    }

    public static Method findSetter(String fieldName, String setterNameOverride, Class<?> structClass, Class<?> valueClass) {
        Method setter = ReflectionHelper.getMethod(structClass, setterNameOverride, valueClass);
        if (setter == null) {
            String setSetterName = "set%s%s".formatted(fieldName.substring(0, 1).toUpperCase(), fieldName.substring(1));
            setter = ReflectionHelper.getMethod(structClass, setSetterName, valueClass);
        }
        return setter;
    }

    public static <T> Constructor<T> getCtor(Class<T> clazz, Class<?> ... paramTypes) {
        try {
            return clazz.getDeclaredConstructor(paramTypes);
        }
        catch (NoSuchMethodException | SecurityException exception) {
            return null;
        }
    }

    static Method getMethod(Class<?> clazz, String methodName, Class<?> ... paramTypes) {
        if (methodName != null && !methodName.isBlank()) {
            try {
                return clazz.getDeclaredMethod(methodName, paramTypes);
            }
            catch (NoSuchMethodException | SecurityException exception) {
                try {
                    return clazz.getMethod(methodName, paramTypes);
                }
                catch (NoSuchMethodException | SecurityException exception2) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static void invokeMethods(List<Method> methods, Object obj, Object ... params) throws IOException {
        for (Method method : methods) {
            try {
                method.invoke(obj, params);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new IOException(e);
            }
        }
    }

    public static <T, CTX> T createInstance(Class<T> targetClass, CTX optionalContext) throws IllegalArgumentException {
        try {
            Constructor<T> ctor;
            if (optionalContext != null && (ctor = ReflectionHelper.getCtor(targetClass, optionalContext.getClass())) != null) {
                ctor.setAccessible(true);
                return ctor.newInstance(optionalContext);
            }
            ctor = ReflectionHelper.getCtor(targetClass, new Class[0]);
            if (ctor != null) {
                ctor.setAccessible(true);
                return ctor.newInstance(new Object[0]);
            }
            throw new IllegalArgumentException("Missing ctor for " + targetClass.getSimpleName());
        }
        catch (IllegalAccessException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> T callCtor(Constructor<T> ctor, Object ... params) throws IllegalArgumentException {
        try {
            return ctor.newInstance(params);
        }
        catch (IllegalAccessException | InstantiationException | SecurityException | InvocationTargetException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static <T> Object callGetter(Method getterMethod, T obj) throws IOException {
        return ReflectionHelper.callGetter(getterMethod, obj, Object.class);
    }

    public static <T, R> R callGetter(Method getterMethod, T obj, Class<R> expectedType) throws IOException {
        try {
            Object getterValue = getterMethod.invoke(obj, new Object[0]);
            if (getterValue == null || expectedType.isInstance(getterValue)) {
                return expectedType.cast(getterValue);
            }
            return null;
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public static <T> void callSetter(Object obj, Method setterMethod, T value) throws IOException {
        try {
            setterMethod.invoke(obj, value);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IOException(e);
        }
    }

    public static List<Method> getMarkedMethods(Class<?> targetClass, Class<? extends Annotation> annotationClass, List<Method> methods, boolean includeParentClasses, Class<?> ... paramClasses) {
        if (methods == null) {
            methods = new ArrayList<Method>();
        }
        if (includeParentClasses && targetClass.getSuperclass() != null) {
            ReflectionHelper.getMarkedMethods(targetClass.getSuperclass(), annotationClass, methods, includeParentClasses, paramClasses);
        }
        block0: for (Method method : targetClass.getDeclaredMethods()) {
            Class<?>[] parameterTypes;
            if (method.getParameterCount() != paramClasses.length || method.getAnnotation(annotationClass) == null || (parameterTypes = method.getParameterTypes()).length != paramClasses.length) continue;
            for (int i = 0; i < parameterTypes.length; ++i) {
                Class<?> methodParamClass = parameterTypes[i];
                if (!methodParamClass.isAssignableFrom(paramClasses[i])) continue block0;
            }
            method.setAccessible(true);
            methods.add(method);
        }
        return methods;
    }

    public static <T extends Annotation> List<T> getAnnotations(Class<?> targetClass, Class<T> annotationClass, List<T> result) {
        T annotation;
        if (result == null) {
            result = new ArrayList<T>();
        }
        if ((annotation = targetClass.getAnnotation(annotationClass)) != null) {
            result.add(annotation);
        }
        if (targetClass.getSuperclass() != null) {
            ReflectionHelper.getAnnotations(targetClass.getSuperclass(), annotationClass, result);
        }
        return result;
    }

    public static <R> R getFieldValue(Object obj, Field field, Class<R> expectedType) throws IOException {
        try {
            Object val = field.get(obj);
            if (val != null && !expectedType.isInstance(val)) {
                throw new IOException("Unexpected field value type: " + String.valueOf(val.getClass()) + " in " + String.valueOf(field));
            }
            return expectedType.cast(val);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            throw new IOException(e);
        }
    }
}

