/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import generic.concurrent.ConcurrentQ;
import generic.concurrent.ConcurrentQBuilder;
import generic.concurrent.GThreadPool;
import generic.concurrent.QCallback;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.services.Analyzer;
import ghidra.app.services.AnalyzerType;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSetViewAdapter;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Set;

public abstract class AbstractAnalyzer
implements Analyzer {
    private final String name;
    private final AnalyzerType type;
    private final String description;
    private boolean defaultEnablement = false;
    private boolean supportsOneTimeAnalysis;
    private boolean isPrototype = false;
    private AnalysisPriority priority = AnalysisPriority.LOW_PRIORITY;
    protected static final AddressSetView EMPTY_ADDRESS_SET = new AddressSetViewAdapter();

    protected AbstractAnalyzer(String name, String description, AnalyzerType type) {
        this.name = name;
        this.type = type;
        this.description = description;
    }

    protected void setPriority(AnalysisPriority priority) {
        this.priority = priority;
    }

    protected void setDefaultEnablement(boolean b) {
        this.defaultEnablement = b;
    }

    protected void setSupportsOneTimeAnalysis() {
        this.supportsOneTimeAnalysis = true;
    }

    protected void setSupportsOneTimeAnalysis(boolean supportsOneTimeAnalysis) {
        this.supportsOneTimeAnalysis = supportsOneTimeAnalysis;
    }

    protected void setPrototype() {
        this.isPrototype = true;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final AnalyzerType getAnalysisType() {
        return this.type;
    }

    @Override
    public boolean getDefaultEnablement(Program program) {
        return this.defaultEnablement;
    }

    @Override
    public final boolean supportsOneTimeAnalysis() {
        return this.supportsOneTimeAnalysis;
    }

    @Override
    public final String getDescription() {
        return this.description == null ? "No Description" : this.description;
    }

    @Override
    public final AnalysisPriority getPriority() {
        return this.priority;
    }

    @Override
    public boolean removed(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) throws CancelledException {
        return false;
    }

    @Override
    public boolean canAnalyze(Program program) {
        return true;
    }

    @Override
    public void optionsChanged(Options options, Program program) {
    }

    @Override
    public void analysisEnded(Program program) {
    }

    @Override
    public final boolean isPrototype() {
        return this.isPrototype;
    }

    @Override
    public void registerOptions(Options options, Program program) {
    }

    public AddressSetView analyzeLocation(Program program, Address start, AddressSetView set, TaskMonitor monitor) throws CancelledException {
        return EMPTY_ADDRESS_SET;
    }

    protected AddressSetView runParallelAddressAnalysis(final Program program, Set<Address> locations, final AddressSetView restrictedSet, int maxThreads, TaskMonitor monitor) throws CancelledException, InterruptedException, Exception {
        monitor.checkCancelled();
        final AddressSet analyzedSet = new AddressSet();
        if (locations.isEmpty()) {
            return analyzedSet;
        }
        GThreadPool pool = AutoAnalysisManager.getSharedAnalsysThreadPool();
        monitor.setMaximum((long)locations.size());
        QCallback<Address, AddressSetView> callback = new QCallback<Address, AddressSetView>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public AddressSetView process(Address loc, TaskMonitor taskMonitor) {
                AddressSet addressSet = analyzedSet;
                synchronized (addressSet) {
                    if (analyzedSet.contains(loc)) {
                        taskMonitor.incrementProgress(1L);
                        return EMPTY_ADDRESS_SET;
                    }
                }
                try {
                    AddressSetView result = AbstractAnalyzer.this.analyzeLocation(program, loc, restrictedSet, taskMonitor);
                    AddressSet addressSet2 = analyzedSet;
                    synchronized (addressSet2) {
                        analyzedSet.add(result);
                    }
                    taskMonitor.incrementProgress(1L);
                    return result;
                }
                catch (CancelledException e) {
                    return null;
                }
            }
        };
        if (maxThreads > pool.getMaxThreadCount()) {
            maxThreads = pool.getMaxThreadCount();
        }
        if (maxThreads < 1) {
            maxThreads = 1;
        }
        ConcurrentQ queue = new ConcurrentQBuilder().setThreadPool(pool).setMaxInProgress(maxThreads).setMonitor(monitor).build((QCallback)callback);
        queue.add(locations);
        queue.waitUntilDone();
        return analyzedSet;
    }
}

