/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symboltree.nodes;

import docking.widgets.tree.GTreeNode;
import generic.theme.GIcon;
import ghidra.app.plugin.core.symboltree.SymbolCategory;
import ghidra.app.plugin.core.symboltree.nodes.ClassSymbolNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolCategoryNode;
import ghidra.app.plugin.core.symboltree.nodes.SymbolNode;
import ghidra.app.util.NamespaceUtils;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolIterator;
import ghidra.program.model.symbol.SymbolType;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.awt.datatransfer.DataFlavor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;

public class ClassCategoryNode
extends SymbolCategoryNode {
    public static final Icon OPEN_FOLDER_CLASSES_ICON = new GIcon("icon.plugin.symboltree.node.category.classes.open");
    public static final Icon CLOSED_FOLDER_CLASSES_ICON = new GIcon("icon.plugin.symboltree.node.category.classes.closed");

    public ClassCategoryNode(Program program) {
        super(SymbolCategory.CLASS_CATEGORY, program);
    }

    public Icon getIcon(boolean expanded) {
        return expanded ? OPEN_FOLDER_CLASSES_ICON : CLOSED_FOLDER_CLASSES_ICON;
    }

    @Override
    public String getToolTip() {
        return "Symbols for Classes";
    }

    @Override
    public DataFlavor getNodeDataFlavor() {
        return null;
    }

    @Override
    protected boolean supportsSymbol(Symbol symbol) {
        SymbolType symbolType = symbol.getSymbolType();
        if (symbolType == this.symbolCategory.getSymbolType()) {
            return true;
        }
        for (Namespace parentNamespace = symbol.getParentNamespace(); parentNamespace != null && parentNamespace != this.globalNamespace; parentNamespace = parentNamespace.getParentNamespace()) {
            if (!(parentNamespace instanceof GhidraClass)) continue;
            return true;
        }
        return false;
    }

    @Override
    public GTreeNode findSymbolTreeNode(SymbolNode key, boolean loadChildren, TaskMonitor monitor) {
        if (!this.isLoaded() && !loadChildren || monitor.isCancelled()) {
            return null;
        }
        Symbol symbol = key.getSymbol();
        Namespace parentNs = symbol.getParentNamespace();
        if (parentNs == this.globalNamespace) {
            return this.findNode((GTreeNode)this, key, loadChildren, monitor);
        }
        Map<GTreeNode, List<Namespace>> classNodes = this.getAllClassNodes(symbol, parentNs, loadChildren, monitor);
        if (classNodes.isEmpty()) {
            return null;
        }
        ArrayList<GTreeNode> keys = new ArrayList<GTreeNode>(classNodes.keySet());
        Collections.sort(keys);
        GTreeNode classNode = (GTreeNode)keys.get(0);
        List<Namespace> parentPath = classNodes.get(classNode);
        GTreeNode symbolParent = this.getNamespaceNode(classNode, parentPath, loadChildren, monitor);
        return this.findNode(symbolParent, key, loadChildren, monitor);
    }

    @Override
    public void symbolRemoved(Symbol symbol, Namespace oldNamespace, TaskMonitor monitor) {
        if (!this.isLoaded()) {
            return;
        }
        if (!this.supportsSymbol(symbol)) {
            return;
        }
        SymbolNode key = SymbolNode.createKeyNode(symbol, symbol.getName(), this.program);
        Namespace parentNs = symbol.getParentNamespace();
        if (parentNs == this.globalNamespace) {
            GTreeNode symbolNode = this.findNode((GTreeNode)this, key, false, monitor);
            if (symbolNode != null) {
                this.removeNode(symbolNode);
            }
            return;
        }
        Map<GTreeNode, List<Namespace>> classNodes = this.getAllClassNodes(symbol, oldNamespace, monitor);
        this.removeSymbol(key, classNodes, monitor);
    }

    @Override
    public void symbolRemoved(Symbol symbol, String oldName, TaskMonitor monitor) {
        if (!this.isLoaded()) {
            return;
        }
        if (!this.supportsSymbol(symbol)) {
            return;
        }
        SymbolNode key = SymbolNode.createKeyNode(symbol, oldName, this.program);
        Namespace parentNs = symbol.getParentNamespace();
        if (parentNs == this.globalNamespace) {
            GTreeNode symbolNode = this.findNode((GTreeNode)this, key, false, monitor);
            if (symbolNode != null) {
                this.removeNode(symbolNode);
            }
            return;
        }
        Map<GTreeNode, List<Namespace>> classNodes = this.getAllClassNodes(symbol, parentNs, monitor);
        this.removeSymbol(key, classNodes, monitor);
    }

    private void removeSymbol(SymbolNode key, Map<GTreeNode, List<Namespace>> classNodes, TaskMonitor monitor) {
        Set<Map.Entry<GTreeNode, List<Namespace>>> entries = classNodes.entrySet();
        for (Map.Entry<GTreeNode, List<Namespace>> entry : entries) {
            if (monitor.isCancelled()) {
                return;
            }
            GTreeNode classNode = entry.getKey();
            List<Namespace> parentPath = entry.getValue();
            GTreeNode symbolParent = this.getNamespaceNode(classNode, parentPath, false, monitor);
            GTreeNode symbolNode = this.findNode(symbolParent, key, false, monitor);
            if (symbolParent == null) continue;
            symbolParent.removeNode(symbolNode);
        }
    }

    @Override
    public SymbolNode symbolAdded(Symbol symbol, TaskMonitor monitor) {
        if (!this.isLoaded()) {
            return null;
        }
        if (!this.supportsSymbol(symbol)) {
            return null;
        }
        if (symbol.getSymbolType() == this.symbolCategory.getSymbolType()) {
            this.doAddSymbol(symbol, (GTreeNode)this);
        }
        SymbolNode lastNode = null;
        Namespace parentNs = symbol.getParentNamespace();
        Map<GTreeNode, List<Namespace>> classNodes = this.getAllClassNodes(symbol, parentNs, monitor);
        Set<Map.Entry<GTreeNode, List<Namespace>>> entries = classNodes.entrySet();
        for (Map.Entry<GTreeNode, List<Namespace>> entry : entries) {
            List<Namespace> parentPath;
            GTreeNode classNode = entry.getKey();
            GTreeNode symbolParent = this.getNamespaceNode(classNode, parentPath = entry.getValue(), false, monitor);
            if (symbolParent == null) continue;
            lastNode = this.doAddSymbol(symbol, symbolParent);
        }
        return lastNode;
    }

    private Map<GTreeNode, List<Namespace>> getAllClassNodes(Symbol symbol, Namespace parentNs, TaskMonitor monitor) {
        return this.getAllClassNodes(symbol, parentNs, false, monitor);
    }

    private Map<GTreeNode, List<Namespace>> getAllClassNodes(Symbol symbol, Namespace parentNs, boolean loadChildren, TaskMonitor monitor) {
        List parents = NamespaceUtils.getNamespaceParts((Namespace)parentNs);
        HashMap<GTreeNode, List<Namespace>> classByPath = new HashMap<GTreeNode, List<Namespace>>();
        this.findAllClassNodes((GTreeNode)this, parents, classByPath, loadChildren, monitor);
        return classByPath;
    }

    private void findAllClassNodes(GTreeNode searchNode, List<Namespace> namespaces, Map<GTreeNode, List<Namespace>> results, boolean loadChildren, TaskMonitor monitor) {
        if (!searchNode.isLoaded() && !loadChildren || monitor.isCancelled()) {
            return;
        }
        if (namespaces.isEmpty()) {
            return;
        }
        GhidraClass namespace = this.getNextClass(namespaces);
        if (namespace == null) {
            return;
        }
        Symbol nsSymbol = namespace.getSymbol();
        SymbolNode key = SymbolNode.createKeyNode(nsSymbol, nsSymbol.getName(), this.program);
        GTreeNode namespaceNode = this.findNode(searchNode, key, loadChildren, monitor);
        if (namespaceNode == null) {
            return;
        }
        if (namespaceNode instanceof ClassSymbolNode) {
            ArrayList<Namespace> currentPath = new ArrayList<Namespace>(namespaces);
            currentPath.add(0, (Namespace)namespace);
            results.put(namespaceNode, currentPath);
        }
        this.findAllClassNodes(searchNode, namespaces, results, loadChildren, monitor);
    }

    private GhidraClass getNextClass(List<Namespace> namespaces) {
        while (namespaces.size() > 0) {
            Namespace ns = namespaces.remove(0);
            if (!(ns instanceof GhidraClass)) continue;
            return (GhidraClass)ns;
        }
        return null;
    }

    @Override
    protected List<GTreeNode> getSymbols(SymbolType type, TaskMonitor monitor) throws CancelledException {
        ArrayList<GTreeNode> list = new ArrayList<GTreeNode>();
        monitor.initialize((long)this.symbolTable.getNumSymbols());
        SymbolType symbolType = this.symbolCategory.getSymbolType();
        SymbolIterator it = this.symbolTable.getDefinedSymbols();
        while (it.hasNext()) {
            Symbol s = it.next();
            if (s != null && s.getSymbolType() == symbolType) {
                monitor.checkCancelled();
                list.add((GTreeNode)SymbolNode.createNode(s, this.program));
            }
            monitor.incrementProgress(1L);
        }
        Collections.sort(list, this.getChildrenComparator());
        return list;
    }
}

