/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.tree;

import docking.DockingUtils;
import docking.action.DockingAction;
import docking.actions.KeyBindingUtils;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeLazyNode;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import docking.widgets.tree.internal.DefaultGTreeDataTransformer;
import docking.widgets.tree.support.GTreeRenderer;
import generic.theme.GIcon;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypeSyncState;
import ghidra.app.plugin.core.datamgr.DataTypeSynchronizer;
import ghidra.app.plugin.core.datamgr.DataTypesProvider;
import ghidra.app.plugin.core.datamgr.archive.DataTypeManagerHandler;
import ghidra.app.plugin.core.datamgr.archive.FileArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ArchiveRootNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.CenterVerticalIcon;
import ghidra.app.plugin.core.datamgr.tree.DataTypeDragNDropHandler;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.app.plugin.core.datamgr.tree.DomainFileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.DtBackgroundIcon;
import ghidra.app.plugin.core.datamgr.tree.DtFilterState;
import ghidra.app.plugin.core.datamgr.tree.FileArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.ProjectArchiveNode;
import ghidra.framework.model.DomainFile;
import ghidra.framework.model.DomainFolder;
import ghidra.framework.model.DomainFolderChangeListener;
import ghidra.framework.model.DomainFolderListenerAdapter;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectData;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.SourceArchive;
import ghidra.program.model.listing.Program;
import ghidra.util.FilterTransformer;
import ghidra.util.UniversalID;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.TreePath;
import resources.MultiIcon;
import resources.icons.TranslateIcon;

public class DataTypeArchiveGTree
extends GTree {
    private static Icon LOCAL_DELTA_ICON = new GIcon("icon.plugin.datatypes.tree.change.local");
    private static Icon SOURCE_DELTA_ICON = new GIcon("icon.plugin.datatypes.tree.change.source");
    private static Icon CONFLICT_ICON = new GIcon("icon.plugin.datatypes.tree.conflict");
    private static Icon MISSING_ICON = new GIcon("icon.plugin.datatypes.tree.missing");
    private DataTypeManagerPlugin plugin;
    private GTreeNode armedNode;
    private MyFolderListener folderListener;
    private DataTypeTreeExpansionListener cleanupListener = new DataTypeTreeExpansionListener();

    public DataTypeArchiveGTree(DataTypeManagerPlugin dataTypeManagerPlugin) {
        super((GTreeNode)new ArchiveRootNode(dataTypeManagerPlugin.getDataTypeManagerHandler()));
        ProjectData projectData;
        this.plugin = dataTypeManagerPlugin;
        this.setDragNDropHandler(new DataTypeDragNDropHandler(this.plugin, this));
        DataTypeTreeRenderer renderer = new DataTypeTreeRenderer();
        this.setRowHeight(this.getHeight(this.getViewRoot(), renderer));
        this.setCellRenderer(renderer);
        Project project = this.plugin.getTool().getProject();
        if (project != null && (projectData = project.getProjectData()) != null) {
            this.folderListener = new MyFolderListener();
            projectData.addDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        }
        this.addTreeExpansionListener(this.cleanupListener);
        this.setAccessibleNamePrefix("Data Type Manager");
        this.initializeKeyEvents();
    }

    private void initializeKeyEvents() {
        int ctrl = DockingUtils.CONTROL_KEY_MODIFIER_MASK;
        JTree jTree = this.getJTree();
        KeyBindingUtils.clearKeyBinding((JComponent)jTree, (KeyStroke)KeyStroke.getKeyStroke(67, ctrl));
        KeyBindingUtils.clearKeyBinding((JComponent)jTree, (KeyStroke)KeyStroke.getKeyStroke(86, ctrl));
        KeyBindingUtils.clearKeyBinding((JComponent)jTree, (KeyStroke)KeyStroke.getKeyStroke(88, ctrl));
    }

    private int getHeight(GTreeNode rootNode, DataTypeTreeRenderer renderer) {
        Component c = renderer.getTreeCellRendererComponent(this.getJTree(), rootNode, false, false, false, 0, false);
        Dimension size = c.getPreferredSize();
        return size.height;
    }

    public void expandedStateRestored(TaskMonitor monitor) {
        GTreeNode rootNode = this.getViewRoot();
        if (rootNode == null) {
            return;
        }
        monitor.setMessage("Recycling unused tree nodes");
        monitor.initialize((long)rootNode.getLeafCount());
        this.reclaimClosedNodes(rootNode, monitor);
    }

    private void reclaimClosedNodes(GTreeNode node, TaskMonitor monitor) {
        if (monitor.isCancelled()) {
            return;
        }
        if (!this.isExpanded(node.getTreePath())) {
            int leafCount = node.getLeafCount();
            if (node instanceof GTreeLazyNode) {
                ((GTreeLazyNode)node).unloadChildren();
            }
            monitor.incrementProgress((long)leafCount);
            return;
        }
        List children = node.getChildren();
        for (GTreeNode child : children) {
            if (!(child instanceof CategoryNode)) continue;
            this.reclaimClosedNodes(child, monitor);
        }
    }

    protected boolean isAddToPopup(DockingAction action) {
        String name;
        switch (name = action.getName()) {
            case "Tree Expand All": 
            case "Tree Expand Node": 
            case "Tree Collapse Node": {
                return false;
            }
        }
        return true;
    }

    public void dispose() {
        ((ArchiveRootNode)this.getModelRoot()).dispose();
        PluginTool tool = this.plugin.getTool();
        if (tool == null) {
            return;
        }
        Project project = tool.getProject();
        if (project == null) {
            return;
        }
        ProjectData projectData = project.getProjectData();
        if (projectData != null) {
            projectData.removeDomainFolderChangeListener((DomainFolderChangeListener)this.folderListener);
        }
        super.dispose();
    }

    public void setFilterState(DtFilterState filterState) {
        ArchiveRootNode root = (ArchiveRootNode)this.getModelRoot();
        root.setFilterState(filterState);
        this.reloadTree();
    }

    public void updateDataTransformer(DataTypesProvider provider) {
        boolean includeMembers = provider.isIncludeDataMembersInSearch();
        boolean filterOnNameOnly = provider.isFilterOnNameOnly();
        DefaultDtTreeDataTransformer transformer = includeMembers ? new DataTypeTransformer(this, filterOnNameOnly) : new DefaultDtTreeDataTransformer(this, filterOnNameOnly);
        this.setDataTransformer((FilterTransformer)transformer);
        this.reloadTree();
    }

    public void updateFilterForChoosingDataType() {
        boolean filterOnNameOnly = true;
        boolean includeMembers = false;
        DefaultDtTreeDataTransformer transformer = includeMembers ? new DataTypeTransformer(this, filterOnNameOnly) : new DefaultDtTreeDataTransformer(this, filterOnNameOnly);
        this.setDataTransformer((FilterTransformer)transformer);
        this.reloadTree();
    }

    public Program getProgram() {
        return this.plugin.getProgram();
    }

    private void reloadTree() {
        GTreeState treeState = this.getTreeState();
        ArchiveRootNode rootNode = (ArchiveRootNode)this.getModelRoot();
        rootNode.unloadChildren();
        this.updateModelFilter();
        this.restoreTreeState(treeState);
    }

    public void setNodeEditable(GTreeNode node) {
        this.armedNode = node;
    }

    public boolean isPathEditable(TreePath path) {
        boolean isArmed = path.getLastPathComponent() == this.armedNode;
        this.armedNode = null;
        if (isArmed) {
            return super.isPathEditable(path);
        }
        return false;
    }

    public String getToolTipText(MouseEvent event) {
        Point point = event.getPoint();
        GTreeNode node = this.getNodeForLocation(point.x, point.y);
        String customTip = this.getToolTipTextForNode(node);
        if (customTip != null) {
            return customTip;
        }
        return super.getToolTipText(event);
    }

    private String getToolTipTextForNode(GTreeNode node) {
        SourceArchive sourceArchive;
        if (!(node instanceof DataTypeNode)) {
            return null;
        }
        DataTypeNode dataTypeNode = (DataTypeNode)node;
        DataType dataType = dataTypeNode.getDataType();
        if (!this.hasOtherSourceArchive(dataType, sourceArchive = dataType.getSourceArchive())) {
            return null;
        }
        DataTypeManagerHandler handler = this.plugin.getDataTypeManagerHandler();
        DataTypeSyncState status = DataTypeSynchronizer.getSyncStatus(handler, dataType);
        switch (status) {
            case CONFLICT: 
            case UPDATE: 
            case COMMIT: {
                return DataTypeSynchronizer.getDiffToolTip(handler, dataType);
            }
        }
        return null;
    }

    private boolean hasOtherSourceArchive(DataType dataType, SourceArchive sourceArchive) {
        if (sourceArchive == null) {
            return false;
        }
        if (sourceArchive.getArchiveType().isBuiltIn()) {
            return false;
        }
        UniversalID localID = dataType.getDataTypeManager().getUniversalID();
        return !sourceArchive.getSourceArchiveID().equals((Object)localID);
    }

    private class DataTypeTreeExpansionListener
    implements TreeExpansionListener {
        private DataTypeTreeExpansionListener() {
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (DataTypeArchiveGTree.this.isFiltered()) {
                return;
            }
            TreePath path = event.getPath();
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (node instanceof CategoryNode) {
                CategoryNode categoryNode = (CategoryNode)node;
                categoryNode.setChildren(null);
            }
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
        }
    }

    private class DataTypeTreeRenderer
    extends GTreeRenderer {
        private static final int ICON_HEIGHT = 18;

        private DataTypeTreeRenderer() {
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean focus) {
            DomainFileArchiveNode node;
            String info;
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, focus);
            if (!label.isOpaque()) {
                label.setBackground(isSelected ? this.getBackgroundSelectionColor() : this.getBackgroundNonSelectionColor());
            }
            MultiIcon multiIcon = new MultiIcon((Icon)new DtBackgroundIcon());
            Icon icon = this.getIcon();
            multiIcon.addIcon((Icon)new CenterVerticalIcon(icon, 18));
            if (value instanceof DataTypeNode) {
                String displayText = ((DataTypeNode)((Object)value)).getDisplayText();
                label.setText(displayText);
            } else if (value instanceof DomainFileArchiveNode && (info = (node = (DomainFileArchiveNode)((Object)value)).getDomainObjectInfo()).length() > 0) {
                label.setText(label.getText() + info);
            }
            this.decorateWithArchiveCharacteristics(value, label, multiIcon);
            if (value instanceof ArchiveNode) {
                this.updateIconForChangeIndicator((ArchiveNode)((Object)value), multiIcon);
            }
            this.setIcon((Icon)multiIcon);
            return label;
        }

        private void decorateWithArchiveCharacteristics(Object value, JLabel label, MultiIcon multiIcon) {
            SourceArchive sourceArchive;
            if (value instanceof FileArchiveNode) {
                FileArchiveNode archiveNode = (FileArchiveNode)((Object)value);
                FileArchive archive = (FileArchive)archiveNode.getArchive();
                if (archive.isChanged()) {
                    label.setText(label.getText() + " *");
                }
                return;
            }
            if (!(value instanceof DataTypeNode)) {
                return;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)((Object)value);
            DataType dataType = dataTypeNode.getDataType();
            if (!DataTypeArchiveGTree.this.hasOtherSourceArchive(dataType, sourceArchive = dataType.getSourceArchive())) {
                return;
            }
            DataTypeManagerHandler handler = DataTypeArchiveGTree.this.plugin.getDataTypeManagerHandler();
            DataTypeSyncState status = DataTypeSynchronizer.getSyncStatus(handler, dataType);
            switch (status) {
                case CONFLICT: {
                    multiIcon.addIcon((Icon)new TranslateIcon(CONFLICT_ICON, 10, 5));
                    break;
                }
                case UPDATE: {
                    multiIcon.addIcon((Icon)new TranslateIcon(SOURCE_DELTA_ICON, 14, 5));
                    break;
                }
                case COMMIT: {
                    multiIcon.addIcon((Icon)new TranslateIcon(LOCAL_DELTA_ICON, 14, 5));
                    break;
                }
                case ORPHAN: {
                    multiIcon.addIcon((Icon)new TranslateIcon(MISSING_ICON, 10, 4));
                    break;
                }
            }
        }

        private void updateIconForChangeIndicator(ArchiveNode node, MultiIcon multiIcon) {
            DataTypeManager dtm = node.getArchive().getDataTypeManager();
            if (dtm == null) {
                return;
            }
            List sourceArchives = dtm.getSourceArchives();
            if (sourceArchives.isEmpty()) {
                return;
            }
            boolean hasLocalChanges = this.checkForLocalChanges(sourceArchives);
            boolean hasUpdatesAvailable = this.checkforUpdates(sourceArchives);
            if (hasLocalChanges && hasUpdatesAvailable) {
                multiIcon.addIcon((Icon)new TranslateIcon(CONFLICT_ICON, 6, 9));
            } else if (hasLocalChanges) {
                multiIcon.addIcon((Icon)new TranslateIcon(LOCAL_DELTA_ICON, 6, 9));
            } else if (hasUpdatesAvailable) {
                multiIcon.addIcon((Icon)new TranslateIcon(SOURCE_DELTA_ICON, 6, 9));
            }
        }

        private boolean checkforUpdates(List<SourceArchive> sourceArchives) {
            for (SourceArchive sourceArchive : sourceArchives) {
                DataTypeManager sourceDTM = DataTypeArchiveGTree.this.plugin.getDataTypeManagerHandler().getDataTypeManager(sourceArchive);
                if (sourceDTM == null || sourceArchive.getLastSyncTime() == sourceDTM.getLastChangeTimeForMyManager()) continue;
                return true;
            }
            return false;
        }

        private boolean checkForLocalChanges(List<SourceArchive> sourceArchives) {
            for (SourceArchive sourceArchive : sourceArchives) {
                if (!sourceArchive.isDirty()) continue;
                return true;
            }
            return false;
        }
    }

    private class MyFolderListener
    extends DomainFolderListenerAdapter {
        private MyFolderListener() {
        }

        public void domainFileStatusChanged(DomainFile file, boolean fileIDset) {
            List archiveNodes = DataTypeArchiveGTree.this.getModelRoot().getChildren();
            for (GTreeNode treeNode : archiveNodes) {
                ProjectArchiveNode projectArchiveNode;
                DomainFile nodesDomainFile;
                if (!(treeNode instanceof ProjectArchiveNode) || !file.equals((Object)(nodesDomainFile = (projectArchiveNode = (ProjectArchiveNode)treeNode).getDomainFile()))) continue;
                projectArchiveNode.nodeChanged();
                return;
            }
        }

        public void domainFileRemoved(DomainFolder parentFolder, String name, String fileID) {
        }
    }

    private class DataTypeTransformer
    extends DefaultDtTreeDataTransformer {
        DataTypeTransformer(DataTypeArchiveGTree dataTypeArchiveGTree, boolean filterOnNameOnly) {
            super(dataTypeArchiveGTree, filterOnNameOnly);
        }

        public List<String> transform(GTreeNode node) {
            List results = super.transform(node);
            if (!(node instanceof DataTypeNode)) {
                return results;
            }
            DataTypeNode dataTypeNode = (DataTypeNode)node;
            DataType dataType = dataTypeNode.getDataType();
            if (dataType instanceof Enum) {
                this.addEnumStrings((Enum)dataType, results);
            } else if (dataType instanceof Composite) {
                this.addCompositeStrings((Composite)dataType, results);
            } else if (dataType instanceof FunctionDefinition) {
                this.addFunctionDefinitionStrings((FunctionDefinition)dataType, results);
            }
            return results;
        }

        private void addFunctionDefinitionStrings(FunctionDefinition function, List<String> results) {
            results.add(function.getPrototypeString());
        }

        private void addCompositeStrings(Composite composite, List<String> results) {
            DataTypeComponent[] components;
            for (DataTypeComponent component : components = composite.getDefinedComponents()) {
                String fieldName = component.getFieldName();
                if (fieldName != null) {
                    results.add(fieldName);
                }
                DataType compDataType = component.getDataType();
                results.add(compDataType.getName());
            }
        }

        private void addEnumStrings(Enum enumm, List<String> results) {
            for (String valueName : enumm.getNames()) {
                results.add(valueName);
            }
            for (long value : enumm.getValues()) {
                results.add(Long.toString(value));
                results.add("0x" + Long.toHexString(value));
            }
        }
    }

    private class DefaultDtTreeDataTransformer
    extends DefaultGTreeDataTransformer {
        private boolean filterOnNameOnly;

        DefaultDtTreeDataTransformer(DataTypeArchiveGTree dataTypeArchiveGTree, boolean filterOnNameOnly) {
            this.filterOnNameOnly = filterOnNameOnly;
        }

        protected String toString(GTreeNode node) {
            if (this.filterOnNameOnly) {
                return node.getName();
            }
            return super.toString(node);
        }
    }
}

