/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.actions;

import docking.ActionContext;
import docking.action.DockingAction;
import docking.action.MenuData;
import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import ghidra.app.plugin.core.datamgr.DataTypeManagerPlugin;
import ghidra.app.plugin.core.datamgr.DataTypesActionContext;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.Enum;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Program;
import ghidra.program.model.mem.Memory;
import ghidra.program.model.symbol.SourceType;
import ghidra.program.model.symbol.Symbol;
import ghidra.program.model.symbol.SymbolTable;
import ghidra.program.model.symbol.SymbolUtilities;
import ghidra.util.Msg;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import javax.swing.tree.TreePath;

public class ApplyEnumsAsLabelsAction
extends DockingAction {
    private final DataTypeManagerPlugin plugin;

    public ApplyEnumsAsLabelsAction(DataTypeManagerPlugin plugin) {
        super("Create Labels From Enums", plugin.getName());
        this.plugin = plugin;
        this.setPopupMenuData(new MenuData(new String[]{"Create Labels From Enums"}, null, "VeryLast"));
        this.setEnabled(true);
    }

    public boolean isEnabledForContext(ActionContext context) {
        TreePath[] selectionPaths;
        if (!(context instanceof DataTypesActionContext)) {
            return false;
        }
        Object contextObject = context.getContextObject();
        GTree gtree = (GTree)contextObject;
        for (TreePath path : selectionPaths = gtree.getSelectionPaths()) {
            GTreeNode node = (GTreeNode)path.getLastPathComponent();
            if (!this.isValidNode(node)) continue;
            return true;
        }
        return false;
    }

    private boolean isValidNode(GTreeNode node) {
        DataType dataType;
        return node instanceof DataTypeNode && (dataType = ((DataTypeNode)node).getDataType()) instanceof Enum;
    }

    public void actionPerformed(ActionContext context) {
        DataTypesActionContext dtActionContext = (DataTypesActionContext)context;
        GTree gTree = (GTree)dtActionContext.getContextObject();
        Program program = dtActionContext.getProgram();
        if (program == null) {
            Msg.showError((Object)((Object)this), (Component)gTree, (String)"Create Labels From Enums Failed", (Object)"A suitable program must be open and activated before\ncreate labels from enums may be performed.");
            return;
        }
        ApplySelectedEnumsTask applySelectedEnumsTask = new ApplySelectedEnumsTask(gTree, program);
        new TaskLauncher((Task)applySelectedEnumsTask, (Component)gTree);
    }

    private class ApplySelectedEnumsTask
    extends Task {
        private final Program program;
        private final GTree gTree;

        ApplySelectedEnumsTask(GTree gTree, Program program) {
            super("Create Labels From Selected Enum Data Types", true, false, true);
            this.gTree = gTree;
            this.program = program;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(TaskMonitor monitor) {
            Object message;
            ProgramBasedDataTypeManager dataTypeManager = this.program.getDataTypeManager();
            int totalLabelsCreated = 0;
            boolean someAlreadyExisted = false;
            boolean failedToCreateSome = false;
            int transactionID = -1;
            boolean commit = false;
            try {
                TreePath[] selectionPaths;
                transactionID = dataTypeManager.startTransaction("Create Labels From Selected Enum Data Types");
                for (TreePath path : selectionPaths = this.gTree.getSelectionPaths()) {
                    DataTypeNode dtNode;
                    DataType dataType;
                    GTreeNode node = (GTreeNode)path.getLastPathComponent();
                    if (!(node instanceof DataTypeNode) || !((dataType = (dtNode = (DataTypeNode)node).getDataType()) instanceof Enum)) continue;
                    Enum enumDt = (Enum)dataType;
                    CreateLabelResult result = this.createLabels(enumDt);
                    totalLabelsCreated += result.numberCreated;
                    someAlreadyExisted |= result.someAlreadyExisted;
                    failedToCreateSome |= result.failedToCreateSomeLabels;
                }
                commit = true;
            }
            finally {
                dataTypeManager.endTransaction(transactionID, commit);
            }
            if (failedToCreateSome) {
                Msg.showWarn((Object)((Object)this), (Component)this.gTree, (String)"Couldn't Create Some Labels", (Object)"One or more labels couldn't be created from the Enum values.\nSee user log in system console for more info.");
            }
            Object object = message = totalLabelsCreated > 0 ? "Labels created: " + totalLabelsCreated + "." : "Couldn't create any labels for the selected data types.";
            if (someAlreadyExisted) {
                message = (String)message + " Some labels already exist.";
            }
            ApplyEnumsAsLabelsAction.this.plugin.getTool().setStatusInfo((String)message);
        }

        private CreateLabelResult createLabels(Enum enumDt) {
            long[] values = enumDt.getValues();
            SymbolTable symbolTable = this.program.getSymbolTable();
            CreateLabelResult result = new CreateLabelResult(this);
            for (long value : values) {
                String addressString;
                String labelName = enumDt.getName(value);
                labelName = SymbolUtilities.replaceInvalidChars((String)labelName, (boolean)true);
                AddressFactory addressFactory = this.program.getAddressFactory();
                Address address = addressFactory.getAddress(addressString = Long.toHexString(value));
                if (address == null) continue;
                Memory memory = this.program.getMemory();
                if (!memory.contains(address)) {
                    Msg.warn((Object)((Object)this), (Object)("Couldn't create label for \"" + labelName + "\" at " + addressString + "."));
                    result.failedToCreateSomeLabels = true;
                    continue;
                }
                try {
                    Symbol symbol = symbolTable.getGlobalSymbol(labelName, address);
                    if (symbol == null) {
                        symbolTable.createLabel(address, labelName, SourceType.USER_DEFINED);
                        ++result.numberCreated;
                        continue;
                    }
                    result.someAlreadyExisted = true;
                }
                catch (InvalidInputException e) {
                    Msg.warn((Object)((Object)this), (Object)("Couldn't create label for \"" + labelName + "\" at " + addressString + ".\n" + e.getMessage()));
                    result.failedToCreateSomeLabels = true;
                }
            }
            return result;
        }

        private class CreateLabelResult {
            int numberCreated;
            boolean someAlreadyExisted;
            boolean failedToCreateSomeLabels;

            private CreateLabelResult(ApplySelectedEnumsTask applySelectedEnumsTask) {
            }
        }
    }
}

