/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.classtype;

import java.util.HashMap;
import java.util.Map;

public enum Access {
    UNKNOWN("UNKNOWN_ACCESS", -1),
    BLANK("", 0),
    PUBLIC("public", 1),
    PROTECTED("protected", 2),
    PRIVATE("private", 3);

    private static final Map<Integer, Access> BY_VALUE;
    private final String label;
    private final int value;

    public String getString() {
        return this.label;
    }

    public String toString() {
        return this.label;
    }

    public int getValue() {
        return this.value;
    }

    public static Access fromValue(int val) {
        return BY_VALUE.getOrDefault(val, UNKNOWN);
    }

    private Access(String label, int value) {
        this.label = label;
        this.value = value;
    }

    public Access mergeRestrictive(Access other) {
        if (this.value > other.value) {
            return this;
        }
        return other;
    }

    public Access mergePermissive(Access other) {
        if (this.value < other.value) {
            if (this == UNKNOWN) {
                return other;
            }
            return this;
        }
        return other;
    }

    static {
        BY_VALUE = new HashMap<Integer, Access>();
        for (Access val : Access.values()) {
            BY_VALUE.put(val.value, val);
        }
    }
}

