/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pdb2.pdbreader.symbol;

import ghidra.app.util.bin.format.pdb2.pdbreader.AbstractPdb;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbByteReader;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordCategory;
import ghidra.app.util.bin.format.pdb2.pdbreader.RecordNumber;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;

public class HeapAllocationSiteMsSymbol
extends AbstractMsSymbol {
    public static final int PDB_ID = 4446;
    private long callSiteOffset;
    private int callSiteSection;
    private int lengthOfHeapAllocationCallInstruction;
    private RecordNumber functionSignatureTypeRecordNumber;

    public HeapAllocationSiteMsSymbol(AbstractPdb pdb, PdbByteReader reader) throws PdbException {
        super(pdb, reader);
        this.callSiteOffset = reader.parseVarSizedOffset(32);
        this.callSiteSection = pdb.parseSegment(reader);
        this.lengthOfHeapAllocationCallInstruction = reader.parseUnsignedShortVal();
        this.functionSignatureTypeRecordNumber = RecordNumber.parse(pdb, reader, RecordCategory.TYPE, 32);
    }

    @Override
    public int getPdbId() {
        return 4446;
    }

    @Override
    public void emit(StringBuilder builder) {
        builder.append(String.format("%s: [%04X:%08X], instruction length = %d, type = %s\n", this.getSymbolTypeName(), this.callSiteSection, this.callSiteOffset, this.lengthOfHeapAllocationCallInstruction, this.pdb.getTypeRecord(this.functionSignatureTypeRecordNumber)));
    }

    @Override
    protected String getSymbolTypeName() {
        return "HEAPALLOCSITE";
    }
}

