/*
 * Decompiled with CFR 0.152.
 */
package ghidra.graph.visualization.mouse;

import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import org.jungrapht.visualization.VisualizationViewer;
import org.jungrapht.visualization.control.GraphElementAccessor;
import org.jungrapht.visualization.control.TransformSupport;
import org.jungrapht.visualization.layout.model.LayoutModel;
import org.jungrapht.visualization.selection.ShapePickSupport;

public class JgtUtils {
    private static final String PICK_AREA_SIZE_PROPERTY = "jungrapht.pickAreaSize";

    public static <V, E> E getEdge(MouseEvent e, VisualizationViewer<V, E> viewer) {
        if (e == null) {
            return null;
        }
        Rectangle2D footprintRectangle = JgtUtils.getFootprint(e);
        LayoutModel layoutModel = viewer.getVisualizationModel().getLayoutModel();
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        if (pickSupport == null) {
            return null;
        }
        if (pickSupport instanceof ShapePickSupport) {
            ShapePickSupport shapePickSupport = (ShapePickSupport)pickSupport;
            return (E)shapePickSupport.getEdge(layoutModel, footprintRectangle);
        }
        TransformSupport transformSupport = viewer.getTransformSupport();
        Point2D layoutPoint = transformSupport.inverseTransform(viewer, (Point2D)e.getPoint());
        return (E)pickSupport.getEdge(layoutModel, layoutPoint.getX(), layoutPoint.getY());
    }

    public static <V, E> V getVertex(MouseEvent e, VisualizationViewer<V, E> viewer) {
        if (e == null) {
            return null;
        }
        Rectangle2D footprintRectangle = JgtUtils.getFootprint(e);
        LayoutModel layoutModel = viewer.getVisualizationModel().getLayoutModel();
        GraphElementAccessor pickSupport = viewer.getPickSupport();
        if (pickSupport == null) {
            return null;
        }
        if (pickSupport instanceof ShapePickSupport) {
            ShapePickSupport shapePickSupport = (ShapePickSupport)pickSupport;
            return (V)shapePickSupport.getVertex(layoutModel, footprintRectangle);
        }
        TransformSupport transformSupport = viewer.getTransformSupport();
        Point2D layoutPoint = transformSupport.inverseTransform(viewer, (Point2D)e.getPoint());
        return (V)pickSupport.getVertex(layoutModel, layoutPoint.getX(), layoutPoint.getY());
    }

    private static Rectangle2D getFootprint(MouseEvent e) {
        int pickSize = Integer.getInteger(PICK_AREA_SIZE_PROPERTY, 4);
        return new Rectangle2D.Float((float)e.getPoint().x - (float)pickSize / 2.0f, (float)e.getPoint().y - (float)pickSize / 2.0f, pickSize, pickSize);
    }
}

