/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.decompile.actions;

import docking.action.KeyBindingData;
import docking.action.MenuData;
import ghidra.app.decompiler.ClangFieldToken;
import ghidra.app.decompiler.ClangReturnType;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.plugin.core.decompile.DecompilerActionContext;
import ghidra.app.plugin.core.decompile.actions.AbstractDecompilerAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.ProgramBasedDataTypeManager;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.HighFunctionDBUtil;
import ghidra.program.model.pcode.HighSymbol;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.UndefinedFunction;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import java.awt.Component;

public class RetypeGlobalAction
extends AbstractDecompilerAction {
    public RetypeGlobalAction() {
        super("Retype Global");
        this.setHelpLocation(new HelpLocation("DecompilePlugin", "ActionRetypeGlobal"));
        this.setPopupMenuData(new MenuData(new String[]{"Retype Global"}, "Decompile"));
        this.setKeyBindingData(new KeyBindingData(76, 128));
    }

    @Override
    protected boolean isEnabledForDecompilerContext(DecompilerActionContext context) {
        Function function = context.getFunction();
        if (function == null || function instanceof UndefinedFunction) {
            return false;
        }
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        if (tokenAtCursor == null) {
            return false;
        }
        if (tokenAtCursor instanceof ClangFieldToken) {
            return false;
        }
        if (tokenAtCursor.Parent() instanceof ClangReturnType) {
            return false;
        }
        if (!tokenAtCursor.isVariableRef()) {
            return false;
        }
        HighSymbol highSymbol = tokenAtCursor.getHighSymbol(context.getHighFunction());
        if (highSymbol == null) {
            return false;
        }
        return highSymbol.isGlobal();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void decompilerActionPerformed(DecompilerActionContext context) {
        Program program = context.getProgram();
        PluginTool tool = context.getTool();
        ClangToken tokenAtCursor = context.getTokenAtCursor();
        DataType dataType = null;
        HighSymbol highSymbol = tokenAtCursor.getHighSymbol(context.getHighFunction());
        if (highSymbol == null) {
            return;
        }
        dataType = RetypeGlobalAction.chooseDataType(tool, program, highSymbol.getDataType());
        if (dataType == null) {
            return;
        }
        ProgramBasedDataTypeManager dataTypeManager = program.getDataTypeManager();
        boolean successfulMod = false;
        int transaction = program.startTransaction("Retype Global");
        try {
            if (dataType.getDataTypeManager() != dataTypeManager) {
                dataType = dataTypeManager.resolve(dataType, null);
            }
            HighFunctionDBUtil.updateDBVariable((HighSymbol)highSymbol, null, (DataType)dataType, (SourceType)SourceType.USER_DEFINED);
            successfulMod = true;
        }
        catch (DuplicateNameException e) {
            throw new AssertException("Unexpected exception", (Throwable)e);
        }
        catch (InvalidInputException e) {
            Msg.showError((Object)((Object)this), (Component)tool.getToolFrame(), (String)"Retype Failed", (Object)("Failed to re-type variable '" + highSymbol.getName() + "': " + e.getMessage()));
        }
        finally {
            program.endTransaction(transaction, successfulMod);
        }
    }
}

