/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.signature;

import ghidra.app.decompiler.signature.DebugSignature;
import ghidra.program.model.lang.Language;
import ghidra.program.model.pcode.AttributeId;
import ghidra.program.model.pcode.Decoder;
import ghidra.program.model.pcode.DecoderException;
import ghidra.program.model.pcode.ElementId;

public class CopySignature
extends DebugSignature {
    public int index;

    @Override
    public void decode(Decoder decoder) throws DecoderException {
        int el = decoder.openElement(ElementId.ELEM_COPYSIG);
        this.hash = (int)decoder.readUnsignedInteger(AttributeId.ATTRIB_HASH);
        this.index = (int)decoder.readSignedInteger(AttributeId.ATTRIB_INDEX);
        decoder.closeElement(el);
    }

    @Override
    public void printRaw(Language language, StringBuffer buf) {
        buf.append(Integer.toHexString(this.hash));
        buf.append(" - Copies in block ");
        buf.append(this.index);
    }
}

