/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.classfinder;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface ExtensionPointProperties {
    public static final int DEFAULT_PRIORITY = 1;
    public static final boolean DEFAULT_EXCLUDE = false;

    public int priority() default 1;

    public boolean exclude() default false;

    public static class Util {
        public static boolean isExcluded(Class<?> c) {
            ExtensionPointProperties properties = c.getAnnotation(ExtensionPointProperties.class);
            return properties != null ? properties.exclude() : false;
        }

        public static int getPriority(Class<?> c) {
            ExtensionPointProperties properties = c.getAnnotation(ExtensionPointProperties.class);
            return properties != null ? properties.priority() : 1;
        }
    }
}

