/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.dump.mdmp;

import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.dump.DumpFileReader;
import ghidra.file.formats.dump.mdmp.UnloadedModule;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;

public class UnloadedModuleListStream
implements StructConverter {
    public static final String NAME = "MINIDUMP_UNLOADED_MODULE_LIST";
    private int sizeOfHeader;
    private int sizeOfEntry;
    private int numberOfEntries;
    private UnloadedModule[] entries;
    private DumpFileReader reader;
    private long index;

    UnloadedModuleListStream(DumpFileReader reader, long index) throws IOException {
        this.reader = reader;
        this.index = index;
        this.parse();
    }

    private void parse() throws IOException {
        this.reader.setPointerIndex(this.index);
        this.setSizeOfHeader(this.reader.readNextInt());
        this.setSizeOfEntry(this.reader.readNextInt());
        this.setNumberOfEntriess(this.reader.readNextInt());
        this.entries = new UnloadedModule[this.numberOfEntries];
        for (int i = 0; i < this.numberOfEntries; ++i) {
            this.setEntry(new UnloadedModule(this.reader, this.reader.getPointerIndex()), i);
        }
    }

    public DataType toDataType() throws DuplicateNameException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, 4, "SizeOfHeader", null);
        struct.add(DWORD, 4, "SizeOfDescriptor", null);
        struct.add(DWORD, 4, "NumberOfHandles", null);
        DataType t = this.entries[0].toDataType();
        ArrayDataType a = new ArrayDataType(t, this.numberOfEntries, t.getLength());
        struct.add((DataType)a, a.getLength(), "Handles", null);
        struct.setCategoryPath(new CategoryPath("/MDMP"));
        return struct;
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }

    public void setNumberOfEntriess(int numberOfEntries) {
        this.numberOfEntries = numberOfEntries;
    }

    public UnloadedModule getEntry(int idx) {
        return this.entries[idx];
    }

    public void setEntry(UnloadedModule entry, int index) {
        this.entries[index] = entry;
    }

    public void setSizeOfHeader(int sizeOfHeader) {
        this.sizeOfHeader = sizeOfHeader;
    }

    public int getSizeOfHeader() {
        return this.sizeOfHeader;
    }

    public void setSizeOfEntry(int sizeOfEntry) {
        this.sizeOfEntry = sizeOfEntry;
    }

    public int getSizeOfEntry() {
        return this.sizeOfEntry;
    }
}

