/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.file.formats.android.vdex.UnsupportedVdexVersionException;
import ghidra.file.formats.android.vdex.VdexConstants;
import ghidra.file.formats.android.vdex.VdexHeader;
import ghidra.file.formats.android.vdex.headers.VdexHeader_006;
import ghidra.file.formats.android.vdex.headers.VdexHeader_010;
import ghidra.file.formats.android.vdex.headers.VdexHeader_019;
import ghidra.file.formats.android.vdex.headers.VdexHeader_021;
import ghidra.file.formats.android.vdex.headers.VdexHeader_027;
import java.io.IOException;

public final class VdexHeaderFactory {
    public static VdexHeader getVdexHeader(BinaryReader reader) throws IOException, UnsupportedVdexVersionException {
        String magic = reader.readAsciiString(0L, "vdex".length());
        String version = reader.readAsciiString(4L, 4);
        if (magic.equals("vdex") && VdexConstants.isSupportedVersion(version)) {
            if (version.equals("006")) {
                return new VdexHeader_006(reader);
            }
            if (version.equals("010")) {
                return new VdexHeader_010(reader);
            }
            if (version.equals("019")) {
                return new VdexHeader_019(reader);
            }
            if (version.equals("021")) {
                return new VdexHeader_021(reader);
            }
            if (version.equals("027")) {
                return new VdexHeader_027(reader);
            }
        }
        throw new UnsupportedVdexVersionException(magic, version);
    }
}

