/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.vdex;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.file.formats.android.dex.format.DexHeader;
import ghidra.file.formats.android.vdex.VdexStringTable;
import ghidra.file.formats.android.vdex.sections.DexSectionHeader_002;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public abstract class VdexHeader
implements StructConverter {
    protected String magic_;
    protected VdexStringTable stringTable;
    protected List<Long> dexHeaderStartsList = new ArrayList<Long>();
    protected List<DexHeader> dexHeaderList = new ArrayList<DexHeader>();

    protected VdexHeader(BinaryReader reader) throws IOException {
        this.magic_ = new String(reader.readNextByteArray("vdex".length()));
    }

    public final String getMagic() {
        return this.magic_;
    }

    public abstract String getVersion();

    public abstract void parse(BinaryReader var1, TaskMonitor var2) throws IOException, CancelledException;

    public final long getDexStartOffset(int index) {
        return this.dexHeaderStartsList.get(index);
    }

    public abstract int getVerifierDepsSize();

    public abstract int getQuickeningInfoSize();

    public abstract int[] getDexChecksums();

    public final List<DexHeader> getDexHeaderList() {
        return this.dexHeaderList;
    }

    public final VdexStringTable getStringTable() {
        return this.stringTable;
    }

    public abstract boolean isDexHeaderEmbeddedInDataType();

    public abstract DexSectionHeader_002 getDexSectionHeader_002();

    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType structure = new StructureDataType(this.magic_ + "_" + this.getVersion(), 0);
        structure.add(STRING, 4, "magic_", null);
        structure.setCategoryPath(new CategoryPath("/vdex"));
        return structure;
    }
}

