/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.values;

import docking.widgets.combobox.GComboBox;
import docking.widgets.values.AbstractValue;
import javax.swing.JComponent;

public class ChoiceValue
extends AbstractValue<String> {
    private String[] choices;
    private GComboBox<String> combo;

    ChoiceValue(String name, String defaultValue, String ... choices) {
        super(name, defaultValue);
        this.choices = choices;
        if (defaultValue != null && !this.isValidChoice(defaultValue)) {
            throw new IllegalArgumentException("Default value is not one of the valid choices!");
        }
    }

    @Override
    public JComponent getComponent() {
        if (this.combo == null) {
            this.combo = new GComboBox<String>(this.choices);
        }
        return this.combo;
    }

    @Override
    protected void updateValueFromComponent() {
        this.setValue((String)this.combo.getSelectedItem());
    }

    @Override
    protected void updateComponentFromValue() {
        this.combo.setSelectedItem(this.getValue());
    }

    @Override
    protected String fromString(String valueString) {
        if (valueString == null) {
            return null;
        }
        if (this.isValidChoice(valueString)) {
            return valueString;
        }
        throw new IllegalArgumentException(valueString + " is not a valid choice!");
    }

    private boolean isValidChoice(String valueString) {
        for (String choice : this.choices) {
            if (!choice.equals(valueString)) continue;
            return true;
        }
        return false;
    }
}

